/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graph.utils;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.ExposedObject;
import com.dataiku.dip.coremodel.NodePosition;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.ContinuousActivitiesPersistentStateDAO;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.dao.StreamingEndpointsDAO;
import com.dataiku.dip.dataflow.FlowGraph;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowImplicitRecipe;
import com.dataiku.dip.dataflow.graph.FlowLabelingTask;
import com.dataiku.dip.dataflow.graph.FlowManagedFolder;
import com.dataiku.dip.dataflow.graph.FlowModelEvaluationStore;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.FlowRetrievableKnowledge;
import com.dataiku.dip.dataflow.graph.FlowRunnable;
import com.dataiku.dip.dataflow.graph.FlowSavedModel;
import com.dataiku.dip.dataflow.graph.FlowStreamingEndpoint;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.dataflow.graph.utils.FlowExposedObjects;
import com.dataiku.dip.dataflow.graph.utils.GraphIds;
import com.dataiku.dip.dataflow.graph.utils.GraphSerializerCommon;
import com.dataiku.dip.dataflow.kernel.master.BuildState;
import com.dataiku.dip.dataflow.streaming.ContinuousActivitiesManager;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.datasets.dynamic.VariablesExpansionLoopConfig;
import com.dataiku.dip.discussions.DiscussionsCacheService;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeDAO;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.mec.ModelEvaluationStoresCRUDService;
import com.dataiku.dip.recipes.ParamsWithVariablesExpansionLoopConfig;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.shaker.ShakerRecipeMeta;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.NeverBuiltComputablesCacheService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class GraphSerializer<GRAPH extends FlowGraph>
extends GraphSerializerCommon {
    @Autowired
    protected DatasetsDAO datasetsDAO;
    @Autowired
    protected ManagedFolderDAO managedFolderDAO;
    @Autowired
    protected ModelEvaluationStoresCRUDService modelEvaluationStoresCRUDService;
    @Autowired
    protected SavedModelsDAO savedModelDAO;
    @Autowired
    protected StreamingEndpointsDAO streamingEndpointsDAO;
    @Autowired
    protected RetrievableKnowledgeDAO retrievableKnowledgeDAO;
    @Autowired
    protected ProjectsService projectsService;
    @Autowired
    protected NeverBuiltComputablesCacheService neverBuiltComputablesCacheService;
    @Autowired
    protected DiscussionsCacheService discussionsCacheService;
    @Autowired
    protected PermissionsService permissionsService;
    private static final int SHORT_DESC_MAX_SIZE = 140;
    private Map<String, SerializedNode> computableNodes = new HashMap<String, SerializedNode>();
    private Set<String> allFilteredDatasets = new HashSet<String>();
    private Set<String> allFilteredManagedFolders = new HashSet<String>();
    private Set<String> allFilteredSavedModels = new HashSet<String>();
    private Set<String> allFilteredModelEvaluationStores = new HashSet<String>();
    private Set<String> allFilteredStreamingEndpoint = new HashSet<String>();
    private Set<String> allFilteredRetrievableModel = new HashSet<String>();
    protected GRAPH graph;
    Map<ITaggingService.TaggableType, Set<String>> matchingElementsByType = new HashMap<ITaggingService.TaggableType, Set<String>>();
    protected StringBuilder headSB = new StringBuilder();
    protected StringBuilder mainSB = new StringBuilder();
    protected StringBuilder sourcesSB = new StringBuilder();
    protected StringBuilder standaloneSB = new StringBuilder();
    protected StringBuilder sinksSB = new StringBuilder();
    protected String projectKey;
    protected SerializedProject projectSettings;
    private boolean makeClusters;
    protected boolean anchorSourcesSinks;
    protected SerializedProject.FlowDisplaySettings flowDisplaySettings;
    protected boolean computeSvg = true;
    private String tailportForce;
    private String runnableOutputConnectionWeight;
    private Map<String, String> computableClusters = new HashMap<String, String>();
    private Set<String> sinkClusters = new HashSet<String>();
    protected AuthCtx authCtx;
    private Map<String, ProjectsService.UIProject> accessibleProjects = new HashMap<String, ProjectsService.UIProject>();
    protected BuildState buildState;
    protected ContinuousActivitiesManager.ContinuousActivitiesCurrentState continuousActivitiesCurrentState;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.flow.graph");

    public GraphSerializer(GRAPH graph, String projectKey, AuthCtx authCtx) throws IOException {
        SpringUtils.getInstance().autowire((Object)this);
        this.graph = graph;
        this.projectKey = projectKey;
        if (StringUtils.isNotBlank((String)projectKey)) {
            this.projectSettings = this.projectsService.getMandatoryUnsafe(projectKey);
        }
        this.authCtx = authCtx;
    }

    @Override
    protected String getCacheKeyPrefix() {
        return this.projectKey;
    }

    public void setDisplaySettings(boolean anchor, SerializedProject.FlowDisplaySettings flowDisplaySettings) {
        this.anchorSourcesSinks = anchor;
        this.flowDisplaySettings = flowDisplaySettings;
        this.tailportForce = this.projectSettings.getDkuPropertiesAsParams(false).getParam("dku.flow.graph.tailportForce", null);
        this.runnableOutputConnectionWeight = this.projectSettings.getDkuPropertiesAsParams(false).getParam("dku.flow.graph.runnableOutputConnectionWeight", null);
    }

    public void setSvg(boolean svg) {
        this.computeSvg = svg;
    }

    public void setBuildState(BuildState bs) {
        this.buildState = bs;
    }

    public void setContinuousActivitiesCurrentState(ContinuousActivitiesManager.ContinuousActivitiesCurrentState cs2) {
        this.continuousActivitiesCurrentState = cs2;
    }

    private StringBuilder sbForNode(FlowRunnable runnable) {
        if (FlowGraph.isSource(runnable)) {
            return this.sourcesSB;
        }
        if (FlowGraph.isSink(runnable)) {
            return this.sinksSB;
        }
        return this.mainSB;
    }

    private StringBuilder sbForNode(FlowComputable dataset) {
        if (FlowGraph.isSource(dataset)) {
            return this.sourcesSB;
        }
        if (FlowGraph.isSink(dataset)) {
            return this.sinksSB;
        }
        return this.mainSB;
    }

    private ProjectsService.UIProject getUIProjectCached(String projectKey) throws Exception {
        if (!this.accessibleProjects.containsKey(projectKey)) {
            ProjectsService.UIProject projectSummary = null;
            if (this.projectsService.projectExists(projectKey)) {
                if (this.permissionsService.hasAnyProjectAccess(this.authCtx, projectKey)) {
                    projectSummary = this.projectsService.getSummary(this.authCtx, projectKey, false);
                }
            } else {
                logger.warn((Object)("Invalid reference to a non-existing project key: " + projectKey));
            }
            this.accessibleProjects.put(projectKey, projectSummary);
        }
        return this.accessibleProjects.get(projectKey);
    }

    private boolean isForbiddenObject(AnyLoc loc, ITaggingService.TaggableType type, String contextProjectKey) throws IOException {
        return !this.projectsService.isObjectAvailableInProject(new SmartObjectRef(loc.getProjectKey(), type, loc.getId()), contextProjectKey);
    }

    private SerializedNode computeNodeForLabelingTask(FlowLabelingTask labelingTask) {
        AnyLoc loc = new AnyLoc(labelingTask.getProjectKey(), labelingTask.getId());
        SerializedNode labelingTaskNode = new SerializedNode();
        labelingTaskNode.id = this.getID(labelingTask);
        labelingTaskNode.realId = this.getRealID(labelingTask);
        labelingTaskNode.name = labelingTask.getId();
        labelingTaskNode.description = labelingTask.getName() + " (" + labelingTask.getId() + ")";
        labelingTaskNode.shortDesc = StringUtils.isNotBlank((String)labelingTask.getLabelingTask().shortDesc) ? StringUtils.substring((String)labelingTask.getLabelingTask().shortDesc, (int)0, (int)140) : null;
        labelingTaskNode.discussionsFullIds = this.discussionsCacheService.getDiscussionsFullIds(new TaggableObjectsService.TaggableObjectRef(labelingTask.getLabelingTask()), false);
        labelingTaskNode.customFields = labelingTask.getLabelingTask().customFields;
        labelingTaskNode.projectKey = labelingTask.getProjectKey();
        labelingTaskNode.nodeType = NodeType.LABELING_TASK;
        labelingTaskNode.isSource = FlowGraph.isSource(labelingTask);
        labelingTaskNode.isSink = FlowGraph.isSink(labelingTask);
        labelingTaskNode.tags = labelingTask.getLabelingTask().tags;
        labelingTaskNode.continuous = false;
        this.setOwnerZone(labelingTaskNode, labelingTask.getLabelingTask());
        if (!this.isSameZone(labelingTaskNode)) {
            this.addUsedZone(labelingTaskNode);
        }
        this.fillNodeBuildFields(labelingTaskNode, loc);
        int idx = this.labelsRemapping.size();
        GraphSerializerCommon.NodeRemapping nr = new GraphSerializerCommon.NodeRemapping();
        nr.id = labelingTaskNode.id;
        nr.name = labelingTaskNode.name;
        nr.label = labelingTaskNode.name;
        nr.description = labelingTaskNode.description;
        nr.type = "LABELING_TASK";
        this.labelsRemapping.add(nr);
        String nodeWidth = "0.7";
        String nodeHeight = "0.7";
        this.sbForNode(labelingTask).append(String.format("%s [id=\"%d\", shape=circle,fixedsize=true, width=%s,height=%s, label=\"%s\"];\n", labelingTaskNode.id, idx, nodeWidth, nodeHeight, labelingTaskNode.id));
        return labelingTaskNode;
    }

    private SerializedNode computeNodeForRunnable(FlowRunnable runnable) {
        if (runnable instanceof FlowRecipe) {
            return this.computeNodeForRecipe((FlowRecipe)runnable);
        }
        if (runnable instanceof FlowLabelingTask) {
            return this.computeNodeForLabelingTask((FlowLabelingTask)runnable);
        }
        throw new NotImplementedException("Unsupported runnable");
    }

    private SerializedNode computeNodeForRecipe(FlowRecipe recipe) {
        ParamsWithVariablesExpansionLoopConfig params;
        VariablesExpansionLoopConfig veLoopConfig;
        SerializedNode recipeNode = new SerializedNode();
        recipeNode.id = this.getID(recipe);
        recipeNode.realId = this.getRealID(recipe);
        recipeNode.name = recipe.getName();
        recipeNode.description = recipe.getName();
        recipeNode.shortDesc = StringUtils.isNotBlank((String)recipe.getModel().shortDesc) ? StringUtils.substring((String)recipe.getModel().shortDesc, (int)0, (int)140) : null;
        recipeNode.discussionsFullIds = this.discussionsCacheService.getDiscussionsFullIds(new TaggableObjectsService.TaggableObjectRef(recipe.getProjectKey(), ITaggingService.TaggableType.RECIPE, recipe.getName()), false);
        recipeNode.customFields = recipe.getModel().customFields;
        recipeNode.projectKey = recipe.getProjectKey();
        recipeNode.nodeType = NodeType.RECIPE;
        recipeNode.isSource = FlowGraph.isSource(recipe);
        recipeNode.isSink = FlowGraph.isSink(recipe);
        recipeNode.tags = recipe.getModel().tags;
        recipeNode.recipeType = recipe.getModel().type;
        boolean bl = recipeNode.continuous = RecipeRegistry.hasMeta(recipe.getModel()) && RecipeRegistry.getMeta(recipe.getModel()).isContinuous();
        if (recipe.getModel().params instanceof ParamsWithVariablesExpansionLoopConfig && (veLoopConfig = (params = (ParamsWithVariablesExpansionLoopConfig)((Object)recipe.getModel().params)).getVariablesExpansionLoopConfig()).isEnabled()) {
            recipeNode.veLoopDatasetRef = veLoopConfig.datasetRef;
        }
        if (ShakerRecipeMeta.META.getType().equals(recipe.getModel().type) && recipe.getModel().getInputsForRole("reference").size() > 0) {
            recipeNode.referenceDatasetRef = recipe.getModel().getInputsForRole((String)"reference").get((int)0).ref;
        }
        this.setOwnerZone(recipeNode, recipe.getModel());
        if (!this.isSameZone(recipeNode)) {
            this.addUsedZone(recipeNode);
        }
        this.fillNodeBuildFields(recipeNode, new AnyLoc(recipe.getProjectKey(), recipe.getName()));
        int idx = this.labelsRemapping.size();
        GraphSerializerCommon.NodeRemapping nr = new GraphSerializerCommon.NodeRemapping();
        nr.id = recipeNode.id;
        nr.name = recipeNode.name;
        nr.label = recipeNode.name;
        nr.description = recipeNode.description;
        nr.type = "RECIPE";
        this.labelsRemapping.add(nr);
        String nodeWidth = "0.7";
        String nodeHeight = "0.7";
        this.sbForNode(recipe).append(String.format("%s [id=\"%d\", shape=circle,fixedsize=true, width=%s,height=%s, label=\"%s\"];\n", recipeNode.id, idx, nodeWidth, nodeHeight, recipeNode.id));
        return recipeNode;
    }

    protected void setOwnerZone(SerializedNode node, TaggableObjectsService.TaggableObject taggableObject) {
    }

    protected boolean isSameZone(SerializedNode node) {
        return true;
    }

    protected void addUsedZone(SerializedNode node) {
    }

    private void fillNodeBuildFields(SerializedNode node, AnyLoc loc) {
        BuildState.DatasetBuildState dbs;
        if (this.buildState != null && (dbs = this.buildState.getDatasetBuildState(loc.getProjectKey(), loc.getId())) != null) {
            node.aboutToBeBuilt = dbs.aboutToBeBuilt.size() > 0;
            boolean bl = node.beingBuilt = dbs.beingBuilt.size() > 0;
        }
        if (this.continuousActivitiesCurrentState != null) {
            for (ContinuousActivitiesManager.ContinuousActivityCurrentState ps2 : this.continuousActivitiesCurrentState.activities) {
                if (!ps2.projectKey.equals(loc.getProjectKey()) || !ps2.recipeId.equals(loc.getId())) continue;
                if (ps2.mainLoopState != null && ps2.mainLoopState.futureInfo != null) {
                    node.beingBuilt = ps2.desiredState == ContinuousActivitiesPersistentStateDAO.DesiredState.STARTED;
                    node.continuousActivityDone = node.beingBuilt && ps2.mainLoopState.futureInfo.hasResult;
                    continue;
                }
                node.beingBuilt = false;
                node.continuousActivityDone = false;
            }
        }
    }

    private SerializedNode computeNodeForComputable(FlowComputable computable) throws Exception {
        AnyLoc loc = AnyLoc.resolveFull(computable.getFullId());
        switch (computable.getType()) {
            case DATASET: {
                FlowDataset flowDataset = (FlowDataset)computable;
                String id = this.getID(flowDataset);
                SerializedNode datasetNode = this.computableNodes.get(id);
                if (datasetNode == null) {
                    datasetNode = new SerializedNode();
                    SerializedDataset dataset = flowDataset.getSerializedMandatoryUnsafe(this.datasetsDAO);
                    datasetNode.id = id;
                    datasetNode.realId = this.getRealID(flowDataset);
                    datasetNode.name = loc.getId();
                    datasetNode.projectKey = loc.getProjectKey();
                    datasetNode.tags = dataset.tags;
                    this.setOwnerZone(datasetNode, dataset);
                    String nodeWidth = "1";
                    String nodeHeight = "1";
                    if (!this.isSameZone(datasetNode)) {
                        this.addUsedZone(datasetNode);
                    }
                    if (loc.getProjectKey().equals(this.projectKey)) {
                        datasetNode.nodeType = NodeType.LOCAL_DATASET;
                        for (ExposedObject ec : this.projectSettings.exposedObjects.objects) {
                            if (ec == null || StringUtils.isBlank((String)ec.localName)) {
                                logger.warn((Object)("Invalid element exposed in " + this.projectKey));
                                continue;
                            }
                            if (ec.type != ITaggingService.TaggableType.DATASET || !ec.localName.equals(loc.getId())) continue;
                            datasetNode.isExposed = true;
                            if (ec.rules == null) continue;
                            for (ExposedObject.Rule r : ec.rules) {
                                ProjectsService.UIProject prj;
                                if (r == null || !StringUtils.isNotBlank((String)r.targetProject) || (prj = this.getUIProjectCached(r.targetProject)) == null) continue;
                                datasetNode.accessibleTargetProjects.add(prj);
                            }
                        }
                    } else {
                        datasetNode.nodeType = NodeType.FOREIGN_DATASET;
                        datasetNode.forbiddenForeignProject = this.getUIProjectCached(loc.getProjectKey()) == null;
                        datasetNode.isForbiddenObject = this.isForbiddenObject(loc, computable.getType().toTaggableType(), this.projectKey);
                    }
                    datasetNode.description = loc.getSmartName(this.projectKey);
                    datasetNode.shortDesc = StringUtils.isNotBlank((String)dataset.shortDesc) ? StringUtils.substring((String)dataset.shortDesc, (int)0, (int)140) : null;
                    datasetNode.discussionsFullIds = this.discussionsCacheService.getDiscussionsFullIds(new TaggableObjectsService.TaggableObjectRef(dataset), false);
                    datasetNode.customFields = dataset.customFields;
                    datasetNode.datasetType = dataset.type;
                    datasetNode.managed = dataset.managed;
                    datasetNode.partitioned = dataset.isPartitioned();
                    datasetNode.featureGroup = dataset.featureGroup;
                    if (dataset.flowOptions.virtualizable) {
                        datasetNode.virtualizable = dataset.flowOptions.virtualizable;
                    }
                    if (!"JobsDB".equals(dataset.type) && !"ExperimentsDB".equals(dataset.type) && this.neverBuiltComputablesCacheService.contains(new TaggableObjectsService.TaggableObjectRef(dataset))) {
                        datasetNode.neverBuilt = true;
                    }
                    this.computableNodes.put(datasetNode.id, datasetNode);
                    this.fillNodeBuildFields(datasetNode, loc);
                    int idx = this.labelsRemapping.size();
                    GraphSerializerCommon.NodeRemapping nr = new GraphSerializerCommon.NodeRemapping();
                    nr.id = datasetNode.id;
                    nr.name = datasetNode.name;
                    nr.label = datasetNode.name;
                    nr.type = String.valueOf((Object)datasetNode.nodeType);
                    nr.description = datasetNode.description;
                    this.labelsRemapping.add(nr);
                    this.computableClusters.put(datasetNode.id, String.format("subgraph cluster_%s { %s; label=\"%s\"; labelloc=\"b\"; style=dotted; fontsize=37.0 }\n", datasetNode.id, datasetNode.id, idx));
                    this.sbForNode(flowDataset).append(String.format("%s [id=\"%d\", shape=box, margin= \"0.31,0.31\",  fixedsize=true,width=%s,height=%s, label=\"%s\"];\n", datasetNode.id, idx, nodeWidth, nodeHeight, datasetNode.id));
                    datasetNode.isSource = FlowGraph.isSource(computable);
                    datasetNode.isSink = FlowGraph.isSink(computable);
                    VariablesExpansionLoopConfig veLoopConfig = DatasetUtils.getDatasetVeLoopConfig(dataset.getParams());
                    if (veLoopConfig != null && veLoopConfig.isEnabled()) {
                        datasetNode.veLoopDatasetRef = veLoopConfig.datasetRef;
                    }
                }
                return datasetNode;
            }
            case SAVED_MODEL: {
                FlowSavedModel fsm = (FlowSavedModel)computable;
                String nodeId = this.getID(fsm);
                SerializedNode node = this.computableNodes.get(nodeId);
                if (node == null) {
                    PredictionMLTask.PredictionType predictionType;
                    SavedModel sm = fsm.getSavedModel();
                    node = new SerializedNode();
                    node.id = nodeId;
                    node.realId = this.getRealID(fsm);
                    node.name = sm.id;
                    node.description = (String)(loc.getProjectKey().equals(this.projectKey) ? "" : loc.getProjectKey() + ".") + sm.name;
                    node.shortDesc = StringUtils.isNotBlank((String)sm.shortDesc) ? StringUtils.substring((String)sm.shortDesc, (int)0, (int)140) : null;
                    node.discussionsFullIds = this.discussionsCacheService.getDiscussionsFullIds(new TaggableObjectsService.TaggableObjectRef(loc.getProjectKey(), ITaggingService.TaggableType.SAVED_MODEL, sm.id), false);
                    node.projectKey = loc.getProjectKey();
                    node.savedModelType = sm.savedModelType.toString();
                    if (sm.savedModelType == SavedModel.SavedModelType.MLFLOW_PYFUNC) {
                        node.externalSavedModelType = "mlflow";
                    } else if (sm.proxyModelConfiguration != null && sm.savedModelType == SavedModel.SavedModelType.PROXY_MODEL) {
                        node.externalSavedModelType = sm.proxyModelConfiguration.protocol;
                    }
                    if (sm.getType() == MLTask.MLTaskType.PREDICTION && (predictionType = ((PredictionMLTask)sm.miniTask).predictionType) != null) {
                        node.predictionType = predictionType.toString();
                    }
                    if (sm.miniTask != null) {
                        node.backendType = sm.miniTask.backendType.toString();
                        node.taskType = sm.miniTask.taskType.toString();
                    }
                    node.partitioned = sm.isPartitioned();
                    node.tags = sm.tags;
                    this.setOwnerZone(node, sm);
                    if (!this.isSameZone(node)) {
                        this.addUsedZone(node);
                    }
                    String nodeWidth = "1";
                    String nodeHeight = "1";
                    if (loc.getProjectKey().equals(this.projectKey)) {
                        node.nodeType = NodeType.LOCAL_SAVEDMODEL;
                        for (ExposedObject ec : this.projectSettings.exposedObjects.objects) {
                            if (ec == null || StringUtils.isBlank((String)ec.localName)) {
                                logger.warn((Object)("Invalid element exposed in " + this.projectKey));
                                continue;
                            }
                            if (ec.type != ITaggingService.TaggableType.SAVED_MODEL || !ec.localName.equals(loc.getId())) continue;
                            node.isExposed = true;
                            if (ec.rules == null) continue;
                            for (ExposedObject.Rule r : ec.rules) {
                                ProjectsService.UIProject prj;
                                if (r == null || !StringUtils.isNotBlank((String)r.targetProject) || (prj = this.getUIProjectCached(r.targetProject)) == null) continue;
                                node.accessibleTargetProjects.add(prj);
                            }
                        }
                    } else {
                        node.nodeType = NodeType.FOREIGN_SAVEDMODEL;
                        node.forbiddenForeignProject = this.getUIProjectCached(loc.getProjectKey()) == null;
                        node.isForbiddenObject = this.isForbiddenObject(loc, computable.getType().toTaggableType(), this.projectKey);
                    }
                    this.computableNodes.put(node.id, node);
                    this.fillNodeBuildFields(node, loc);
                    int idx = this.labelsRemapping.size();
                    GraphSerializerCommon.NodeRemapping nr = new GraphSerializerCommon.NodeRemapping();
                    nr.id = node.id;
                    nr.name = node.name;
                    nr.label = sm.name;
                    nr.type = String.valueOf((Object)node.nodeType);
                    nr.description = node.description;
                    this.labelsRemapping.add(nr);
                    this.computableClusters.put(node.id, String.format("subgraph cluster_%s { %s; label=\"%s\"; labelloc=\"b\"; style=dotted; fontsize=37.0 }\n", node.id, node.id, idx));
                    this.sbForNode(fsm).append(String.format("%s [id=\"%d\", shape=diamond,  fixedsize=true,width=%s,height=%S, label=\"%s\"];\n", node.id, idx, nodeWidth, nodeHeight, node.id));
                    node.isSource = FlowGraph.isSource(computable);
                    node.isSink = FlowGraph.isSink(computable);
                }
                return node;
            }
            case MODEL_EVALUATION_STORE: {
                FlowModelEvaluationStore fmes = (FlowModelEvaluationStore)computable;
                String nodeId = this.getID(fmes);
                SerializedNode node = this.computableNodes.get(nodeId);
                if (node == null) {
                    ModelEvaluationStore mes = fmes.getModelEvaluationStore();
                    node = new SerializedNode();
                    node.id = nodeId;
                    node.realId = this.getRealID(fmes);
                    node.name = mes.id;
                    node.description = (String)(loc.getProjectKey().equals(this.projectKey) ? "" : loc.getProjectKey() + ".") + mes.name;
                    node.shortDesc = StringUtils.isNotBlank((String)mes.shortDesc) ? StringUtils.substring((String)mes.shortDesc, (int)0, (int)140) : null;
                    node.discussionsFullIds = this.discussionsCacheService.getDiscussionsFullIds(new TaggableObjectsService.TaggableObjectRef(loc.getProjectKey(), ITaggingService.TaggableType.MODEL_EVALUATION_STORE, mes.id), false);
                    node.projectKey = loc.getProjectKey();
                    node.mesType = mes.getSubtype();
                    node.partitioned = mes.isPartitioned();
                    node.tags = mes.tags;
                    node.mesFlavor = mes.mesFlavor.toString();
                    this.setOwnerZone(node, mes);
                    if (!this.isSameZone(node)) {
                        this.addUsedZone(node);
                    }
                    String nodeWidth = "1";
                    String nodeHeight = "1";
                    if (loc.getProjectKey().equals(this.projectKey)) {
                        node.nodeType = mes.mesFlavor.isGenAi() ? NodeType.LOCAL_GENAIEVALUATIONSTORE : NodeType.LOCAL_MODELEVALUATIONSTORE;
                        for (ExposedObject ec : this.projectSettings.exposedObjects.objects) {
                            if (ec == null || StringUtils.isBlank((String)ec.localName)) {
                                logger.warn((Object)("Invalid element exposed in " + this.projectKey));
                                continue;
                            }
                            if (ec.type != ITaggingService.TaggableType.MODEL_EVALUATION_STORE || !ec.localName.equals(loc.getId())) continue;
                            node.isExposed = true;
                            if (ec.rules == null) continue;
                            for (ExposedObject.Rule r : ec.rules) {
                                ProjectsService.UIProject prj;
                                if (r == null || !StringUtils.isNotBlank((String)r.targetProject) || (prj = this.getUIProjectCached(r.targetProject)) == null) continue;
                                node.accessibleTargetProjects.add(prj);
                            }
                        }
                    } else {
                        node.nodeType = mes.mesFlavor.isGenAi() ? NodeType.FOREIGN_GENAIEVALUATIONSTORE : NodeType.FOREIGN_MODELEVALUATIONSTORE;
                        node.forbiddenForeignProject = this.getUIProjectCached(loc.getProjectKey()) == null;
                        node.isForbiddenObject = this.isForbiddenObject(loc, computable.getType().toTaggableType(), this.projectKey);
                    }
                    this.computableNodes.put(node.id, node);
                    this.fillNodeBuildFields(node, loc);
                    int idx = this.labelsRemapping.size();
                    GraphSerializerCommon.NodeRemapping nr = new GraphSerializerCommon.NodeRemapping();
                    nr.id = node.id;
                    nr.name = node.name;
                    nr.label = mes.name;
                    nr.type = String.valueOf((Object)node.nodeType);
                    nr.description = node.description;
                    this.labelsRemapping.add(nr);
                    this.computableClusters.put(node.id, String.format("subgraph cluster_%s { %s; label=\"%s\"; labelloc=\"b\"; style=dotted; fontsize=37.0 }\n", node.id, node.id, idx));
                    this.sbForNode(fmes).append(String.format("%s [id=\"%d\", shape=diamond,  fixedsize=true,width=%s,height=%S, label=\"%s\"];\n", node.id, idx, nodeWidth, nodeHeight, node.id));
                    node.isSource = FlowGraph.isSource(computable);
                    node.isSink = FlowGraph.isSink(computable);
                }
                return node;
            }
            case RETRIEVABLE_KNOWLEDGE: {
                FlowRetrievableKnowledge frk = (FlowRetrievableKnowledge)computable;
                String nodeId = this.getID(frk);
                SerializedNode node = this.computableNodes.get(nodeId);
                if (node == null) {
                    RetrievableKnowledge rk = frk.getRetrievableKnowledge();
                    node = new SerializedNode();
                    node.id = nodeId;
                    node.realId = this.getRealID(frk);
                    node.name = rk.id;
                    node.description = (String)(loc.getProjectKey().equals(this.projectKey) ? "" : loc.getProjectKey() + ".") + rk.name;
                    node.shortDesc = StringUtils.isNotBlank((String)rk.shortDesc) ? StringUtils.substring((String)rk.shortDesc, (int)0, (int)140) : null;
                    node.discussionsFullIds = this.discussionsCacheService.getDiscussionsFullIds(new TaggableObjectsService.TaggableObjectRef(loc.getProjectKey(), ITaggingService.TaggableType.MODEL_EVALUATION_STORE, rk.id), false);
                    node.projectKey = loc.getProjectKey();
                    node.mesType = rk.getSubtype();
                    node.partitioned = false;
                    node.tags = rk.tags;
                    this.setOwnerZone(node, rk);
                    if (!this.isSameZone(node)) {
                        this.addUsedZone(node);
                    }
                    String nodeWidth = "1";
                    String nodeHeight = "1";
                    if (loc.getProjectKey().equals(this.projectKey)) {
                        node.nodeType = NodeType.LOCAL_RETRIEVABLE_KNOWLEDGE;
                        for (ExposedObject ec : this.projectSettings.exposedObjects.objects) {
                            if (ec == null || StringUtils.isBlank((String)ec.localName)) {
                                logger.warn((Object)("Invalid element exposed in " + this.projectKey));
                                continue;
                            }
                            if (ec.type != ITaggingService.TaggableType.RETRIEVABLE_KNOWLEDGE || !ec.localName.equals(loc.getId())) continue;
                            node.isExposed = true;
                            if (ec.rules == null) continue;
                            for (ExposedObject.Rule r : ec.rules) {
                                ProjectsService.UIProject prj;
                                if (r == null || !StringUtils.isNotBlank((String)r.targetProject) || (prj = this.getUIProjectCached(r.targetProject)) == null) continue;
                                node.accessibleTargetProjects.add(prj);
                            }
                        }
                    } else {
                        node.nodeType = NodeType.FOREIGN_RETRIEVABLE_KNOWLEDGE;
                        node.forbiddenForeignProject = this.getUIProjectCached(loc.getProjectKey()) == null;
                        node.isForbiddenObject = this.isForbiddenObject(loc, computable.getType().toTaggableType(), this.projectKey);
                    }
                    if (this.neverBuiltComputablesCacheService.contains(new TaggableObjectsService.TaggableObjectRef(rk))) {
                        node.neverBuilt = true;
                    }
                    this.computableNodes.put(node.id, node);
                    this.fillNodeBuildFields(node, loc);
                    int idx = this.labelsRemapping.size();
                    GraphSerializerCommon.NodeRemapping nr = new GraphSerializerCommon.NodeRemapping();
                    nr.id = node.id;
                    nr.name = node.name;
                    nr.label = rk.name;
                    nr.type = String.valueOf((Object)node.nodeType);
                    nr.description = node.description;
                    this.labelsRemapping.add(nr);
                    this.computableClusters.put(node.id, String.format("subgraph cluster_%s { %s; label=\"%s\"; labelloc=\"b\"; style=dotted; fontsize=37.0 }\n", node.id, node.id, idx));
                    this.sbForNode(frk).append(String.format("%s [id=\"%d\", shape=box,  fixedsize=true,width=%s,height=%S, label=\"%s\"];\n", node.id, idx, nodeWidth, nodeHeight, node.id));
                    node.isSource = FlowGraph.isSource(computable);
                    node.isSink = FlowGraph.isSink(computable);
                }
                return node;
            }
            case MANAGED_FOLDER: {
                FlowManagedFolder fodb = (FlowManagedFolder)computable;
                String nodeId = this.getID(fodb);
                SerializedNode node = this.computableNodes.get(nodeId);
                if (node == null) {
                    ManagedFolder odb = fodb.getManagedFolder();
                    node = new SerializedNode();
                    node.id = nodeId;
                    node.realId = this.getRealID(fodb);
                    node.name = loc.getId();
                    node.folderType = odb.type;
                    node.description = (String)(loc.getProjectKey().equals(this.projectKey) ? "" : loc.getProjectKey() + ".") + odb.name;
                    node.shortDesc = StringUtils.isNotBlank((String)odb.shortDesc) ? StringUtils.substring((String)odb.shortDesc, (int)0, (int)140) : null;
                    node.discussionsFullIds = this.discussionsCacheService.getDiscussionsFullIds(new TaggableObjectsService.TaggableObjectRef(loc.getProjectKey(), ITaggingService.TaggableType.MANAGED_FOLDER, loc.getId()), false);
                    node.projectKey = loc.getProjectKey();
                    node.tags = odb.tags;
                    this.setOwnerZone(node, odb);
                    if (!this.isSameZone(node)) {
                        this.addUsedZone(node);
                    }
                    String nodeWidth = "0.8";
                    String nodeHeight = "0.8";
                    if (loc.getProjectKey().equals(this.projectKey)) {
                        node.nodeType = NodeType.LOCAL_MANAGED_FOLDER;
                        for (ExposedObject ec : this.projectSettings.exposedObjects.objects) {
                            if (ec == null || StringUtils.isBlank((String)ec.localName)) {
                                logger.warn((Object)("Invalid element exposed in " + this.projectKey));
                                continue;
                            }
                            if (ec.type != ITaggingService.TaggableType.MANAGED_FOLDER || !ec.localName.equals(loc.getId())) continue;
                            node.isExposed = true;
                            if (ec.rules == null) continue;
                            for (ExposedObject.Rule r : ec.rules) {
                                ProjectsService.UIProject prj;
                                if (r == null || !StringUtils.isNotBlank((String)r.targetProject) || (prj = this.getUIProjectCached(r.targetProject)) == null) continue;
                                node.accessibleTargetProjects.add(prj);
                            }
                        }
                    } else {
                        node.nodeType = NodeType.FOREIGN_MANAGED_FOLDER;
                        node.forbiddenForeignProject = this.getUIProjectCached(loc.getProjectKey()) == null;
                        node.isForbiddenObject = this.isForbiddenObject(loc, computable.getType().toTaggableType(), this.projectKey);
                    }
                    this.computableNodes.put(node.id, node);
                    this.fillNodeBuildFields(node, loc);
                    int idx = this.labelsRemapping.size();
                    GraphSerializerCommon.NodeRemapping nr = new GraphSerializerCommon.NodeRemapping();
                    nr.id = node.id;
                    nr.name = node.name;
                    nr.label = odb.name;
                    nr.type = String.valueOf((Object)node.nodeType);
                    nr.description = node.description;
                    this.labelsRemapping.add(nr);
                    this.computableClusters.put(node.id, String.format("subgraph cluster_%s { %s; label=\"%s\"; labelloc=\"b\"; style=dotted; fontsize=37.0 }\n", node.id, node.id, idx));
                    this.sbForNode(fodb).append(String.format("%s [id=\"%d\", shape=box,  fixedsize=true,width=%s,height=%S, label=\"%s\"];\n", node.id, idx, nodeWidth, nodeHeight, node.id));
                    node.isSource = FlowGraph.isSource(computable);
                    node.isSink = FlowGraph.isSink(computable);
                }
                return node;
            }
            case STREAMING_ENDPOINT: {
                FlowStreamingEndpoint fse = (FlowStreamingEndpoint)computable;
                String nodeId = this.getID(fse);
                SerializedNode node = this.computableNodes.get(nodeId);
                if (node == null) {
                    StreamingEndpoint se = fse.getStreamingEndpoint();
                    node = new SerializedNode();
                    node.id = nodeId;
                    node.name = loc.getId();
                    node.realId = this.getRealID(fse);
                    node.description = (String)(loc.getProjectKey().equals(this.projectKey) ? "" : loc.getProjectKey() + ".") + se.id;
                    node.shortDesc = StringUtils.isNotBlank((String)se.shortDesc) ? StringUtils.substring((String)se.shortDesc, (int)0, (int)140) : null;
                    node.projectKey = loc.getProjectKey();
                    node.streamingEndpointType = se.type;
                    node.tags = se.tags;
                    this.setOwnerZone(node, se);
                    if (!this.isSameZone(node)) {
                        this.addUsedZone(node);
                    }
                    String nodeWidth = "0.8";
                    String nodeHeight = "0.8";
                    if (loc.getProjectKey().equals(this.projectKey)) {
                        node.nodeType = NodeType.LOCAL_STREAMING_ENDPOINT;
                        for (ExposedObject ec : this.projectSettings.exposedObjects.objects) {
                            if (ec == null || StringUtils.isBlank((String)ec.localName)) {
                                logger.warn((Object)("Invalid element exposed in " + this.projectKey));
                                continue;
                            }
                            if (ec.type != ITaggingService.TaggableType.STREAMING_ENDPOINT || !ec.localName.equals(loc.getId())) continue;
                            node.isExposed = true;
                        }
                    } else {
                        node.nodeType = NodeType.FOREIGN_STREAMING_ENDPOINT;
                        node.isForbiddenObject = this.isForbiddenObject(loc, computable.getType().toTaggableType(), this.projectKey);
                    }
                    this.computableNodes.put(node.id, node);
                    this.fillNodeBuildFields(node, loc);
                    int idx = this.labelsRemapping.size();
                    GraphSerializerCommon.NodeRemapping nr = new GraphSerializerCommon.NodeRemapping();
                    nr.id = node.id;
                    nr.name = node.name;
                    nr.label = se.id;
                    nr.type = String.valueOf((Object)node.nodeType);
                    nr.description = node.description;
                    this.labelsRemapping.add(nr);
                    this.computableClusters.put(node.id, String.format("subgraph cluster_%s { %s; label=\"%s\"; labelloc=\"b\"; style=dotted; fontsize=37.0 }\n", node.id, node.id, idx));
                    this.sbForNode(fse).append(String.format("%s [id=\"%d\", shape=box,  fixedsize=true,width=%s,height=%S, label=\"%s\"];\n", node.id, idx, nodeWidth, nodeHeight, node.id));
                    node.isSource = FlowGraph.isSource(computable);
                    node.isSink = FlowGraph.isSink(computable);
                }
                return node;
            }
        }
        throw new NotImplementedException();
    }

    protected String getID(GraphNode node) {
        return node.getGraphId();
    }

    protected String getRealID(GraphNode node) {
        return node.getGraphId();
    }

    protected void addConnection(SerializedNode inNode, SerializedNode outNode, String roleName, boolean dottedConnection, String ... extraAttrs) {
        int idx = this.labelsRemapping.size();
        GraphSerializerCommon.EdgeRemapping er = new GraphSerializerCommon.EdgeRemapping();
        er.from = inNode.id;
        er.to = outNode.id;
        this.labelsRemapping.add(er);
        ArrayList<Object> extraStyles = new ArrayList<Object>();
        if (dottedConnection) {
            extraStyles.add("style=dotted");
        }
        if (outNode.nodeType == NodeType.LOCAL_DATASET || outNode.nodeType == NodeType.FOREIGN_DATASET) {
            extraStyles.add("headport=w");
        }
        if (this.tailportForce != null && this.flowDisplaySettings.respectTraversalOrder && (inNode.nodeType == NodeType.LOCAL_DATASET || inNode.nodeType == NodeType.FOREIGN_DATASET) && outNode.nodeType == NodeType.RECIPE) {
            extraStyles.add("tailport=" + this.tailportForce);
        }
        if (Objects.equals(outNode.veLoopDatasetRef, inNode.description) || Objects.equals(outNode.referenceDatasetRef, inNode.description)) {
            extraStyles.add("class=\"repeated\"");
        }
        extraStyles.addAll(Arrays.asList(extraAttrs));
        Object extraStyle = "";
        if (!extraStyles.isEmpty()) {
            extraStyle = (String)extraStyle + "," + StringUtils.join(extraStyles, (String)",");
        }
        this.mainSB.append(String.format("%s -> %s [arrowhead=dot,arrowsize=0.5,label=\"%d\"%s];\n", inNode.id, outNode.id, idx, extraStyle));
    }

    protected SerializedGraph createSerializedGraph() {
        return new SerializedGraph();
    }

    /*
     * WARNING - void declaration
     */
    public Callable<SerializedGraph> serialize() throws Exception {
        void var9_52;
        void var9_49;
        TaggableObjectsService.TaggableObject se;
        SerializedNode node;
        this.headSB.append("digraph g {\n  newrank=true;rankdir = LR; splines = true;\n  node [fillcolor=white];\n");
        final SerializedGraph serializedGraph = this.createSerializedGraph();
        List<SerializedDataset> datasetList = this.getAllDatasets();
        List<ManagedFolder> managedFolderList = this.getAllManagedFolders();
        List<ModelEvaluationStore> modelEvaluationStoreList = this.getAllModelEvaluationStores();
        List<SavedModel> savedModelList = this.getAllSavedModels();
        List<StreamingEndpoint> streamingEndpointList = this.getAllStreamingEndpoints();
        List<RetrievableKnowledge> retrievableKnowledgeList = this.getAllRetrievableKnowledge();
        for (SerializedDataset serializedDataset : datasetList) {
            if (!this.shouldElementBeOnGraph(serializedDataset)) continue;
            this.allFilteredDatasets.add(serializedDataset.getFullId());
        }
        for (ManagedFolder managedFolder : managedFolderList) {
            if (!this.shouldElementBeOnGraph(managedFolder)) continue;
            this.allFilteredManagedFolders.add(managedFolder.projectKey + "." + managedFolder.id);
        }
        for (SavedModel savedModel : savedModelList) {
            if (!this.shouldElementBeOnGraph(savedModel)) continue;
            this.allFilteredSavedModels.add(savedModel.projectKey + "." + savedModel.id);
        }
        for (ModelEvaluationStore modelEvaluationStore : modelEvaluationStoreList) {
            if (!this.shouldElementBeOnGraph(modelEvaluationStore)) continue;
            this.allFilteredModelEvaluationStores.add(modelEvaluationStore.projectKey + "." + modelEvaluationStore.id);
        }
        for (StreamingEndpoint streamingEndpoint : streamingEndpointList) {
            if (!this.shouldElementBeOnGraph(streamingEndpoint)) continue;
            this.allFilteredStreamingEndpoint.add(streamingEndpoint.projectKey + "." + streamingEndpoint.id);
        }
        for (RetrievableKnowledge retrievableKnowledge : retrievableKnowledgeList) {
            if (!this.shouldElementBeOnGraph(retrievableKnowledge)) continue;
            this.allFilteredRetrievableModel.add(retrievableKnowledge.projectKey + "." + retrievableKnowledge.id);
        }
        if (this.flowDisplaySettings.respectTraversalOrder) {
            String algorithmStr = this.projectSettings.getDkuPropertiesAsParams(false).getParam("dku.flow.graph.traversalOrderAlgorithm");
            FlowGraph.TraversalOrderAlgorithm traversalOrderAlgorithm = algorithmStr != null ? FlowGraph.TraversalOrderAlgorithm.valueOf(algorithmStr) : FlowGraph.TraversalOrderAlgorithm.FORWARD_ONLY;
            List<GraphNode> list = ((FlowGraph)this.graph).getNodesInTraversalOrder(traversalOrderAlgorithm);
            HashSet<String> hashSet = new HashSet<String>();
            PredicateThrowingIOException<FlowRunnable> keepRunnable = runnable -> {
                boolean recipeMatches;
                if (runnable instanceof FlowRecipe) {
                    recipeMatches = this.shouldElementBeOnGraph(((FlowRecipe)runnable).getModel());
                } else if (runnable instanceof FlowLabelingTask) {
                    recipeMatches = this.shouldElementBeOnGraph(((FlowLabelingTask)runnable).getLabelingTask());
                } else if (runnable instanceof FlowImplicitRecipe) {
                    recipeMatches = false;
                } else {
                    throw new NotImplementedException("Unsupported runnable");
                }
                boolean attachedDatasetsMatch = false;
                if (!recipeMatches) {
                    attachedDatasetsMatch = this.hasMatchingDataset(runnable.getSources());
                    attachedDatasetsMatch |= this.hasMatchingDataset(runnable.getTargets());
                }
                return recipeMatches || attachedDatasetsMatch;
            };
            for (GraphNode node2 : list) {
                FlowRunnable runnable2;
                boolean drawRunnable;
                if (!(node2 instanceof FlowRunnable) || !(drawRunnable = keepRunnable.test(runnable2 = (FlowRunnable)node2))) continue;
                if (!(runnable2 instanceof FlowImplicitRecipe)) {
                    hashSet.add(runnable2.getFullId());
                }
                hashSet.addAll(runnable2.getPredecessors().stream().map(GraphNode::getFullId).collect(Collectors.toList()));
                hashSet.addAll(runnable2.getSuccessors().stream().map(GraphNode::getFullId).collect(Collectors.toList()));
            }
            for (GraphNode node2 : list) {
                if (!hashSet.contains(node2.getFullId())) continue;
                if (node2 instanceof FlowRunnable) {
                    this.computeNodeForRunnable((FlowRunnable)node2);
                    continue;
                }
                if (node2 instanceof FlowComputable) {
                    this.computeNodeForComputable((FlowComputable)node2);
                    continue;
                }
                logger.warn((Object)("Unknown type: " + String.valueOf(node2.getClass())));
            }
        }
        for (FlowLabelingTask flowLabelingTask : ((FlowGraph)this.graph).labelingTasks) {
            this.serializeFlowRunnable(serializedGraph, flowLabelingTask);
        }
        for (FlowRecipe flowRecipe : ((FlowGraph)this.graph).recipes) {
            this.serializeFlowRunnable(serializedGraph, flowRecipe);
        }
        logger.trace(() -> "Graph has " + ((FlowGraph)this.graph).implicitRecipes.size() + " implicit recipes");
        for (FlowImplicitRecipe flowImplicitRecipe : ((FlowGraph)this.graph).implicitRecipes) {
            boolean bl;
            void var10_60;
            Object sds;
            boolean bl2 = false;
            if (flowImplicitRecipe.getSuccessor().getType() == FlowComputable.FCType.DATASET) {
                DatasetLocUtils.DatasetLoc datasetLoc = DatasetLocUtils.resolveFull(flowImplicitRecipe.getSuccessor().getFullId());
                sds = (SerializedDataset)this.datasetsDAO.getOrNullUnsafe(datasetLoc);
                if (sds != null) {
                    boolean bl3 = bl2 | this.shouldElementBeOnGraph((TaggableObjectsService.TaggableObject)sds);
                }
            } else {
                boolean bl4 = true;
            }
            if (flowImplicitRecipe.getSuccessor().getType() == FlowComputable.FCType.DATASET) {
                DatasetLocUtils.DatasetLoc datasetLoc = DatasetLocUtils.resolveFull(flowImplicitRecipe.getSuccessor().getFullId());
                sds = (SerializedDataset)this.datasetsDAO.getOrNullUnsafe(datasetLoc);
                if (sds != null) {
                    void var10_57;
                    int n = var10_57 | this.shouldElementBeOnGraph((TaggableObjectsService.TaggableObject)sds);
                }
            } else {
                boolean bl5 = true;
            }
            logger.trace(() -> "Process implicit recipe predecessor=" + flowImplicitRecipe.getPredecessor().getFullId() + " (" + String.valueOf((Object)flowImplicitRecipe.getPredecessor().getType()) + ") successor=" + flowImplicitRecipe.getSuccessor().getFullId() + " (" + String.valueOf((Object)flowImplicitRecipe.getSuccessor().getType()) + ")");
            if (var10_60 == false) {
                logger.trace((Object)"Cancelled, does not match");
                continue;
            }
            boolean bl6 = true;
            for (FlowComputable target : flowImplicitRecipe.getTargets()) {
                SerializedNode datasetNode = this.computeNodeForComputable(target);
                bl = bl && datasetNode.isSink;
            }
            FlowComputable target = flowImplicitRecipe.getSuccessor();
            FlowComputable source = flowImplicitRecipe.getPredecessor();
            SerializedNode targetNode = this.computeNodeForComputable(target);
            SerializedNode sourceNode = this.computeNodeForComputable(source);
            String id = targetNode.id;
            logger.debugV("Implicit recipe has source=%s target=%s tid=%s", new Object[]{source.getFullId(), target.getFullId(), id});
            sourceNode.isHiddenLinkSource = true;
            targetNode.isHiddenLinkTarget = true;
            this.addConnection(sourceNode, targetNode, flowImplicitRecipe.roleName, true, new String[0]);
            targetNode.predecessors.add(sourceNode.id);
            sourceNode.successors.add(targetNode.id);
            serializedGraph.datasetsKeptForRecipe.add(target.getFullId());
            serializedGraph.datasetsKeptForRecipe.add(source.getFullId());
            if (this.makeClusters && this.computableClusters.containsKey(id)) {
                StringBuilder sbForCluster = bl ? this.sinksSB : this.mainSB;
                sbForCluster.append(this.computableClusters.get(id));
                this.computableClusters.remove(id);
            }
            if (!this.makeClusters) continue;
            StringBuilder sbForCluster = this.mainSB;
            sbForCluster.append("    style=filled; fillcolor=yellow;\n");
            sbForCluster.append("}\n");
        }
        for (FlowDataset flowDataset : ((FlowGraph)this.graph).datasets.values()) {
            datasetList.add(flowDataset.getSerializedMandatoryUnsafe(this.datasetsDAO));
        }
        FlowExposedObjects flowExposedObjects = this.getAllExposedObjects();
        ArrayList<SerializedDataset> arrayList = new ArrayList<SerializedDataset>();
        for (SerializedDataset serializedDataset : datasetList) {
            if (this.computableNodes.containsKey(GraphIds.forDataset(serializedDataset.projectKey, serializedDataset.name))) continue;
            arrayList.add(serializedDataset);
        }
        for (AnyLoc anyLoc : flowExposedObjects.allExposedDatasets) {
            SerializedDataset sd = (SerializedDataset)this.datasetsDAO.getOrNullUnsafe(anyLoc);
            if (sd == null || this.computableNodes.containsKey(GraphIds.forDataset(sd.projectKey, sd.name))) continue;
            arrayList.add(sd);
        }
        Collections.sort(arrayList, new Comparator<SerializedDataset>(){

            @Override
            public int compare(SerializedDataset o1, SerializedDataset o2) {
                return o1.name.compareToIgnoreCase(o2.name);
            }
        });
        for (SerializedDataset serializedDataset : arrayList) {
            if (!this.shouldElementBeOnGraph(serializedDataset)) continue;
            node = this.computeNodeForComputable(new FlowDataset(Dataset.fromSerializedUnsafe(serializedDataset.projectKey + "." + serializedDataset.name, serializedDataset)));
            this.computableNodes.put(node.id, node);
        }
        ArrayList<ManagedFolder> arrayList2 = new ArrayList<ManagedFolder>();
        for (ManagedFolder managedFolder : managedFolderList) {
            if (this.computableNodes.containsKey(GraphIds.forManagedFolder(managedFolder.projectKey, managedFolder.id))) continue;
            arrayList2.add(managedFolder);
        }
        for (AnyLoc anyLoc : flowExposedObjects.allExposedManagedFolders) {
            ManagedFolder odb = (ManagedFolder)this.managedFolderDAO.getOrNullUnsafe(anyLoc.getProjectKey(), anyLoc.getId());
            if (odb == null || this.computableNodes.containsKey(GraphIds.forManagedFolder(odb.projectKey, odb.id))) continue;
            arrayList2.add(odb);
        }
        for (ManagedFolder managedFolder : arrayList2) {
            if (!this.shouldElementBeOnGraph(managedFolder)) continue;
            node = this.computeNodeForComputable(new FlowManagedFolder(managedFolder));
            this.computableNodes.put(node.id, node);
        }
        ArrayList<ModelEvaluationStore> arrayList3 = new ArrayList<ModelEvaluationStore>();
        for (ModelEvaluationStore modelEvaluationStore : modelEvaluationStoreList) {
            if (this.computableNodes.containsKey(GraphIds.forModelEvaluationStore(modelEvaluationStore.projectKey, modelEvaluationStore.id))) continue;
            arrayList3.add(modelEvaluationStore);
        }
        for (AnyLoc anyLoc : flowExposedObjects.allExposedModelEvaluationStores) {
            ModelEvaluationStore mes = this.modelEvaluationStoresCRUDService.getOrNullUnsafe(anyLoc.getProjectKey(), anyLoc.getId());
            if (mes == null || this.computableNodes.containsKey(GraphIds.forModelEvaluationStore(mes.projectKey, mes.id))) continue;
            arrayList3.add(mes);
        }
        for (ModelEvaluationStore modelEvaluationStore : arrayList3) {
            if (!this.shouldElementBeOnGraph(modelEvaluationStore)) continue;
            node = this.computeNodeForComputable(new FlowModelEvaluationStore(modelEvaluationStore));
            this.computableNodes.put(node.id, node);
        }
        ArrayList<SavedModel> arrayList4 = new ArrayList<SavedModel>();
        for (SavedModel savedModel : savedModelList) {
            if (this.computableNodes.containsKey(GraphIds.forSavedModel(savedModel.projectKey, savedModel.id))) continue;
            arrayList4.add(savedModel);
        }
        for (AnyLoc anyLoc : flowExposedObjects.allExposedSavedModels) {
            SavedModel sm = (SavedModel)this.savedModelDAO.getOrNullUnsafe(anyLoc.getProjectKey(), anyLoc.getId());
            if (sm == null || this.computableNodes.containsKey(GraphIds.forSavedModel(sm.projectKey, sm.id))) continue;
            arrayList4.add(sm);
        }
        for (SavedModel savedModel : arrayList4) {
            if (!this.shouldElementBeOnGraph(savedModel)) continue;
            node = this.computeNodeForComputable(new FlowSavedModel(savedModel));
            this.computableNodes.put(node.id, node);
        }
        ArrayList<StreamingEndpoint> arrayList5 = new ArrayList<StreamingEndpoint>();
        for (StreamingEndpoint streamingEndpoint : streamingEndpointList) {
            if (this.computableNodes.containsKey(GraphIds.forStreamingEndpoint(streamingEndpoint.projectKey, streamingEndpoint.id))) continue;
            arrayList5.add(streamingEndpoint);
        }
        for (AnyLoc anyLoc : flowExposedObjects.allExposedStreamingEndpoints) {
            se = (StreamingEndpoint)this.streamingEndpointsDAO.getOrNullUnsafe(anyLoc.getProjectKey(), anyLoc.getId());
            if (se == null || this.computableNodes.containsKey(GraphIds.forStreamingEndpoint(se.projectKey, se.id))) continue;
            arrayList5.add((StreamingEndpoint)se);
        }
        for (StreamingEndpoint streamingEndpoint : arrayList5) {
            if (!this.shouldElementBeOnGraph(streamingEndpoint)) continue;
            node = this.computeNodeForComputable(new FlowStreamingEndpoint(streamingEndpoint));
            this.computableNodes.put(node.id, node);
        }
        ArrayList<TaggableObjectsService.TaggableObject> arrayList6 = new ArrayList<TaggableObjectsService.TaggableObject>();
        for (RetrievableKnowledge retrievableKnowledge : retrievableKnowledgeList) {
            if (this.computableNodes.containsKey(GraphIds.forRetrievableKnowledge(retrievableKnowledge.projectKey, retrievableKnowledge.id))) continue;
            arrayList6.add(retrievableKnowledge);
        }
        for (AnyLoc anyLoc : flowExposedObjects.allExposedRetrievableKnowledge) {
            se = (RetrievableKnowledge)this.retrievableKnowledgeDAO.getOrNullUnsafe(anyLoc.getProjectKey(), anyLoc.getId());
            if (se == null || this.computableNodes.containsKey(GraphIds.forRetrievableKnowledge(((RetrievableKnowledge)se).projectKey, ((RetrievableKnowledge)se).id))) continue;
            arrayList6.add(se);
        }
        for (RetrievableKnowledge retrievableKnowledge : arrayList6) {
            if (!this.shouldElementBeOnGraph(retrievableKnowledge)) continue;
            node = this.computeNodeForComputable(new FlowRetrievableKnowledge(retrievableKnowledge));
            this.computableNodes.put(node.id, node);
        }
        for (String string : this.computableClusters.values()) {
            this.mainSB.append(string);
        }
        for (SerializedNode serializedNode : this.computableNodes.values()) {
            SerializedDataset serializedDataset;
            if (serializedNode.nodeType != NodeType.LOCAL_DATASET || !this.shouldElementBeOnGraph(serializedDataset = (SerializedDataset)this.datasetsDAO.getOrNullUnsafe(serializedNode.projectKey, serializedNode.name))) continue;
            serializedGraph.datasetsKeptForRecipe.remove(serializedNode.name);
        }
        for (SerializedNode serializedNode : this.computableNodes.values()) {
            if (!serializedGraph.datasetsKeptForRecipe.contains(serializedNode.name)) continue;
            serializedNode.keptForConsistency = true;
        }
        for (Map.Entry<ITaggingService.TaggableType, Set<String>> entry : this.matchingElementsByType.entrySet()) {
            serializedGraph.includedObjectsByType.put(entry.getKey(), entry.getValue().size());
        }
        serializedGraph.nodes.putAll(this.computableNodes);
        for (SerializedNode serializedNode : this.computableNodes.values()) {
            serializedGraph.realNodes.put(serializedNode.realId, serializedNode);
        }
        if (!this.computeSvg) {
            return new Callable<SerializedGraph>(){

                @Override
                public SerializedGraph call() throws Exception {
                    return serializedGraph;
                }
            };
        }
        String string = this.headSB.toString() + "\n" + this.mainSB.toString() + "\n";
        if (!this.anchorSourcesSinks && !this.makeClusters) {
            String string2 = string + this.sourcesSB.toString() + "\n" + this.sinksSB.toString() + "\n" + this.standaloneSB.toString() + "\n";
        } else if (!this.anchorSourcesSinks && this.makeClusters) {
            void var9_45;
            String string4 = string + this.sourcesSB.toString() + "\n" + this.sinksSB.toString() + "\n" + this.standaloneSB.toString() + "\n";
            string4 = string4 + "{rank=source; ";
            for (SerializedNode serializedNode : serializedGraph.nodes.values()) {
                if (!serializedNode.isSource) continue;
                String string5 = (String)var9_45 + "  " + serializedNode.id;
            }
            String string6 = (String)var9_45 + "}\n";
        } else if (this.anchorSourcesSinks) {
            String string7 = string + "subgraph sources {\n  rank=source;\n" + this.sourcesSB.toString() + "}\nsubgraph sinks {\n  rank=sink;\n" + this.sinksSB.toString() + "}\nsubgraph standalone {\n" + this.standaloneSB.toString() + "}\n";
        }
        String string8 = (String)var9_49 + "}";
        if (serializedGraph.nodes.size() == 0) {
            String string9 = string8.replace("newrank=true;", "");
        }
        void var10_91 = var9_52;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Output graphviz:\n" + (String)var9_52));
        }
        return new Callable<SerializedGraph>(){
            final /* synthetic */ String val$finalGraphviz;
            {
                this.val$finalGraphviz = string;
            }

            @Override
            public SerializedGraph call() throws Exception {
                TransactionContext.assertNoAttachedTransaction();
                serializedGraph.svg = GraphSerializer.this.cleanSVGCache(this.val$finalGraphviz, "dot", true, true);
                GraphSerializer.this.enrichGraph(serializedGraph);
                return serializedGraph;
            }
        };
    }

    private void serializeFlowRunnable(SerializedGraph serializedGraph, FlowRunnable runnable) throws Exception {
        SerializedNode datasetNode;
        boolean recipeMatches;
        if (runnable instanceof FlowRecipe) {
            recipeMatches = this.shouldElementBeOnGraph(((FlowRecipe)runnable).getModel());
        } else if (runnable instanceof FlowLabelingTask) {
            recipeMatches = this.shouldElementBeOnGraph(((FlowLabelingTask)runnable).getLabelingTask());
        } else {
            throw new NotImplementedException("Unsupported runnable");
        }
        boolean attachedDatasetsMatch = false;
        if (!recipeMatches) {
            attachedDatasetsMatch = this.hasMatchingDataset(runnable.getSources());
            attachedDatasetsMatch |= this.hasMatchingDataset(runnable.getTargets());
        }
        if (!recipeMatches && !attachedDatasetsMatch) {
            return;
        }
        SerializedNode recipeNode = this.computeNodeForRunnable(runnable);
        recipeNode.keptForConsistency = !recipeMatches && attachedDatasetsMatch;
        for (FlowComputable.FlowComputableWithRole flowComputableWithRole : runnable.getSourcesWithRoles()) {
            SerializedNode datasetNode2 = this.computeNodeForComputable(flowComputableWithRole.computable);
            datasetNode2.successors.add(recipeNode.id);
            recipeNode.predecessors.add(datasetNode2.id);
            serializedGraph.datasetsKeptForRecipe.add(flowComputableWithRole.computable.getFullId());
            this.addConnection(datasetNode2, recipeNode, flowComputableWithRole.role, false, new String[0]);
        }
        boolean isSinkCluster = true;
        for (FlowComputable targetComputable : runnable.getTargets()) {
            datasetNode = this.computeNodeForComputable(targetComputable);
            isSinkCluster = isSinkCluster && datasetNode.isSink;
            datasetNode.predecessors.add(recipeNode.id);
            recipeNode.successors.add(datasetNode.id);
            serializedGraph.datasetsKeptForRecipe.add(targetComputable.getFullId());
        }
        serializedGraph.nodes.put(recipeNode.id, recipeNode);
        serializedGraph.realNodes.put(recipeNode.realId, recipeNode);
        if (this.makeClusters) {
            StringBuilder stringBuilder = this.mainSB;
            stringBuilder.append("subgraph cluster_recipe_").append(recipeNode.id).append("{\n");
            stringBuilder.append("  ").append(recipeNode.id).append(";\n");
        }
        if (isSinkCluster) {
            this.sinkClusters.add("cluster_recipe_" + recipeNode.id);
        }
        for (FlowComputable.FlowComputableWithRole targetDS : runnable.getTargetsWithRoles()) {
            datasetNode = this.computeNodeForComputable(targetDS.computable);
            String id = datasetNode.id;
            if (this.runnableOutputConnectionWeight != null) {
                this.addConnection(recipeNode, datasetNode, targetDS.role, runnable instanceof FlowLabelingTask, "weight=" + this.runnableOutputConnectionWeight);
            } else {
                this.addConnection(recipeNode, datasetNode, targetDS.role, runnable instanceof FlowLabelingTask, new String[0]);
            }
            if (!this.makeClusters || !this.computableClusters.containsKey(id)) continue;
            StringBuilder sbForCluster2 = isSinkCluster ? this.sinksSB : this.mainSB;
            sbForCluster2.append(this.computableClusters.get(id));
            this.computableClusters.remove(id);
        }
        if (this.makeClusters) {
            StringBuilder stringBuilder = this.mainSB;
            stringBuilder.append("    style=filled; fillcolor=yellow;\n");
            stringBuilder.append("}\n");
        }
    }

    protected List<StreamingEndpoint> getAllStreamingEndpoints() throws IOException {
        return this.streamingEndpointsDAO.listUnsafe(this.projectKey);
    }

    protected List<RetrievableKnowledge> getAllRetrievableKnowledge() throws IOException {
        return this.retrievableKnowledgeDAO.listUnsafe(this.projectKey);
    }

    protected List<SavedModel> getAllSavedModels() throws IOException {
        return this.savedModelDAO.listUnsafe(this.projectKey);
    }

    protected List<ModelEvaluationStore> getAllModelEvaluationStores() throws IOException {
        return this.modelEvaluationStoresCRUDService.listUnsafe(this.projectKey);
    }

    protected List<ManagedFolder> getAllManagedFolders() throws IOException {
        return this.managedFolderDAO.listUnsafe(this.projectKey);
    }

    protected List<SerializedDataset> getAllDatasets() throws IOException {
        return this.datasetsDAO.listUnsafe(this.projectKey);
    }

    protected FlowExposedObjects getAllExposedObjects() throws IOException {
        return new FlowExposedObjects(this.projectsService.getAllExposedObjects(this.projectKey));
    }

    protected void enrichGraph(SerializedGraph serializedGraph) {
        serializedGraph.hasProjectZones = false;
    }

    protected boolean shouldElementBeOnGraph(TaggableObjectsService.TaggableObject taggableObject) {
        ITaggingService.TaggableType type = taggableObject.getTaggableType();
        if (!this.matchingElementsByType.containsKey((Object)type)) {
            this.matchingElementsByType.put(type, new HashSet());
        }
        this.matchingElementsByType.get((Object)type).add(taggableObject.getFullId());
        return true;
    }

    private boolean hasMatchingDataset(List<FlowComputable> datasets) throws IOException {
        for (FlowComputable src : datasets) {
            DatasetLocUtils.DatasetLoc loc;
            SerializedDataset sds;
            boolean matches = false;
            if (src.getType() == FlowComputable.FCType.DATASET && (sds = (SerializedDataset)this.datasetsDAO.getOrNullUnsafe(loc = DatasetLocUtils.resolveFull(src.getFullId()))) != null) {
                matches = this.shouldElementBeOnGraph(sds);
            }
            if (!matches) continue;
            return true;
        }
        return false;
    }

    @UIModel
    public static class SerializedNode {
        public NodeType nodeType;
        public String id;
        public String name;
        public String description;
        public String shortDesc;
        public Set<String> discussionsFullIds;
        public JsonElement customFields;
        public String datasetType;
        public String recipeType;
        public String folderType;
        public String externalSavedModelType;
        public String predictionType;
        public String backendType;
        public String taskType;
        public String savedModelType;
        public String mesType;
        public String mesFlavor;
        public String streamingEndpointType;
        public boolean managed;
        public boolean continuous;
        public boolean featureGroup;
        public String projectKey;
        public boolean keptForConsistency;
        public Set<String> successors = new HashSet<String>();
        public Set<String> predecessors = new HashSet<String>();
        public List<String> tags;
        public Boolean partitioned;
        public boolean isSource;
        public boolean isSink;
        public boolean isHiddenLinkSource;
        public boolean isHiddenLinkTarget;
        public boolean beingBuilt;
        public boolean aboutToBeBuilt;
        public boolean continuousActivityDone;
        public boolean isExposed;
        public boolean forbiddenForeignProject;
        public boolean isForbiddenObject;
        public Set<ProjectsService.UIProject> accessibleTargetProjects = new HashSet<ProjectsService.UIProject>();
        public Boolean virtualizable;
        public Boolean neverBuilt;
        public String veLoopDatasetRef;
        public String referenceDatasetRef;
        public String ownerZone;
        public Set<String> usedByZones = new HashSet<String>();
        public String realId;
        public JsonElement customData;
        public NodePosition position;
    }

    public static enum NodeType {
        LOCAL_DATASET,
        FOREIGN_DATASET,
        LOCAL_SAVEDMODEL,
        FOREIGN_SAVEDMODEL,
        LOCAL_MODELEVALUATIONSTORE,
        FOREIGN_MODELEVALUATIONSTORE,
        LOCAL_GENAIEVALUATIONSTORE,
        FOREIGN_GENAIEVALUATIONSTORE,
        LOCAL_RETRIEVABLE_KNOWLEDGE,
        FOREIGN_RETRIEVABLE_KNOWLEDGE,
        LOCAL_MANAGED_FOLDER,
        FOREIGN_MANAGED_FOLDER,
        LOCAL_STREAMING_ENDPOINT,
        FOREIGN_STREAMING_ENDPOINT,
        RECIPE,
        LABELING_TASK,
        ZONE;

    }

    public static class SerializedGraph {
        public String svg = "";
        public Map<ITaggingService.TaggableType, Integer> includedObjectsByType = new HashMap<ITaggingService.TaggableType, Integer>();
        public Set<String> datasetsKeptForRecipe = new HashSet<String>();
        public Map<String, SerializedNode> nodes = new HashMap<String, SerializedNode>();
        public Map<String, SerializedNode> realNodes = new HashMap<String, SerializedNode>();
        public Map<String, Set<String>> realNodesZones = new HashMap<String, Set<String>>();
        public Map<String, Set<String>> zonesUsedByRealId = new HashMap<String, Set<String>>();
        public boolean hasZones = false;
        public boolean hasZoneSharedObjects = false;
        public boolean hasProjectZones = false;
        public int draftDatasets;
        public int inputDatasets;
        public boolean hasAnyNonConnectedNode;

        public void setInputAndDraftDatasets() {
            this.hasAnyNonConnectedNode = false;
            this.draftDatasets = 0;
            this.inputDatasets = 0;
            for (SerializedNode serializedNode : this.nodes.values()) {
                if (!serializedNode.successors.isEmpty() && serializedNode.predecessors.isEmpty() && (serializedNode.nodeType == NodeType.RECIPE || serializedNode.nodeType == NodeType.FOREIGN_MANAGED_FOLDER || serializedNode.nodeType == NodeType.LOCAL_MANAGED_FOLDER || this.datasetsKeptForRecipe.contains(serializedNode.projectKey + "." + serializedNode.name))) {
                    ++this.inputDatasets;
                }
                if (serializedNode.successors.isEmpty() && serializedNode.predecessors.isEmpty()) {
                    ++this.draftDatasets;
                    continue;
                }
                this.hasAnyNonConnectedNode = true;
            }
        }
    }

    @FunctionalInterface
    private static interface PredicateThrowingIOException<T> {
        public boolean test(T var1) throws IOException;
    }
}

