/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graph.utils;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.Zone;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dataflow.FlowZone;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.dataflow.graph.utils.FlowExposedObjects;
import com.dataiku.dip.dataflow.graph.utils.GraphIds;
import com.dataiku.dip.dataflow.graph.utils.GraphSerializer;
import com.dataiku.dip.dataflow.graph.utils.GraphSerializerCommon;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import se.fishtank.css.selectors.NodeSelectorException;
import se.fishtank.css.selectors.dom.DOMNodeSelector;

public class ZoneGraphSerializer
extends GraphSerializer {
    private final ZoneGraphSerializerObjectDependencies objectDependencies;
    private ZoneSerializedGraph zoneSerializedGraph;
    private final GraphSerializer<ProjectFlowGraph> projectFlowGraphGraphSerializer;
    private final Zone zone;
    double usedDatasetsMaxY = -1.7976931348623157E308;
    double usedDatasetsMinY = Double.MAX_VALUE;
    private double svgHeightPt;
    private double svgWidthPt;
    public static final double ZONE_MARGIN = 64.0;
    private static final double DRAFT_DATASETS_MARGIN_Y = 50.0;

    public ZoneGraphSerializer(GraphSerializer<ProjectFlowGraph> projectFlowGraphGraphSerializer, FlowZone zone, String projectKey, AuthCtx authCtx, ZoneGraphSerializerObjectDependencies objectDependencies) throws IOException {
        super(zone, projectKey, authCtx);
        this.projectFlowGraphGraphSerializer = projectFlowGraphGraphSerializer;
        this.zone = zone.getZone();
        this.objectDependencies = objectDependencies;
        this.setCache(projectFlowGraphGraphSerializer.cache);
        this.setDisplaySettings(projectFlowGraphGraphSerializer.anchorSourcesSinks, projectFlowGraphGraphSerializer.flowDisplaySettings);
        this.setBuildState(projectFlowGraphGraphSerializer.buildState);
        this.setContinuousActivitiesCurrentState(projectFlowGraphGraphSerializer.continuousActivitiesCurrentState);
        this.setSvg(projectFlowGraphGraphSerializer.computeSvg);
    }

    @Override
    protected String getID(GraphNode node) {
        return GraphIds.forZone(this.zone, super.getID(node));
    }

    @Override
    protected void cleanupBeginning(Document doc, DOMNodeSelector selector) {
        super.cleanupBeginning(doc, selector);
        Element svgNode = doc.getDocumentElement();
        this.svgHeightPt = 0.0;
        this.svgWidthPt = 0.0;
        String height = svgNode.getAttribute("height");
        String width = svgNode.getAttribute("width");
        if (StringUtils.isNotBlank((String)height)) {
            this.svgHeightPt = Double.parseDouble(height.substring(0, height.length() - 2));
        }
        if (StringUtils.isNotBlank((String)width)) {
            this.svgWidthPt = Double.parseDouble(width.substring(0, width.length() - 2));
        }
    }

    @Override
    protected void cleanupNodeText(Node nodeTextNode, String id, boolean replaceTextContent) throws NodeSelectorException {
        super.cleanupNodeText(nodeTextNode, id, replaceTextContent);
        Element parentNode = (Element)nodeTextNode.getParentNode();
        GraphSerializerCommon.NodeRemapping text = (GraphSerializerCommon.NodeRemapping)this.labelsRemapping.get(Integer.parseInt(id));
        String unescapeId = ZoneGraphSerializer.graphVizUnescape(text.id);
        String dataNodeId = ZoneGraphSerializer.graphVizEscape(unescapeId.substring(("zone_" + this.zone.getId() + "_").length()));
        parentNode.setAttribute("data-zone-id", ZoneGraphSerializer.graphVizEscape(this.zone.getId()));
        parentNode.setAttribute("data-node-id", dataNodeId);
    }

    @Override
    protected void cleanupEnding(Document doc, DOMNodeSelector selector) throws IOException, SAXException, NodeSelectorException {
        super.cleanupEnding(doc, selector);
        if (this.zoneSerializedGraph.draftDatasets > 0) {
            double datasetsPerColumn = Math.max(Math.max((double)this.zoneSerializedGraph.inputDatasets, Math.floor(Math.sqrt(this.zoneSerializedGraph.draftDatasets))), 1.0);
            double nbRows = Math.ceil((double)this.zoneSerializedGraph.draftDatasets * 1.0 / datasetsPerColumn);
            this.svgWidthPt = Math.max(this.svgWidthPt, nbRows * 180.0 - 64.0);
            double draftDatasetsHeight = ((double)this.zoneSerializedGraph.draftDatasets < datasetsPerColumn ? (double)this.zoneSerializedGraph.draftDatasets : datasetsPerColumn) * 180.0;
            double usedDatasetsHeight = 0.0;
            if (this.zoneSerializedGraph.inputDatasets > 0) {
                usedDatasetsHeight = this.computeUsedDatasetsHeight(selector) + 50.0;
            }
            this.svgHeightPt = draftDatasetsHeight + usedDatasetsHeight;
        } else {
            this.computeUsedDatasetsHeight(selector);
            if (Math.abs(this.usedDatasetsMaxY) < 64.0) {
                this.svgHeightPt += 64.0 - Math.abs(this.usedDatasetsMaxY);
            }
        }
        Element svgNode = doc.getDocumentElement();
        svgNode.setAttribute("width", this.svgWidthPt + 128.0 + "pt");
        svgNode.setAttribute("height", this.svgHeightPt + "pt");
        svgNode.removeAttribute("viewBox");
    }

    private double computeUsedDatasetsHeight(DOMNodeSelector selector) throws NodeSelectorException {
        Set edges = selector.querySelectorAll("g.edge > path");
        this.updateUsedDatasetYBoundariesFromNodes(edges, "d");
        Set nodes = selector.querySelectorAll("g.node > polygon");
        this.updateUsedDatasetYBoundariesFromNodes(nodes, "points");
        return this.usedDatasetsMaxY - this.usedDatasetsMinY + 64.0;
    }

    private void updateUsedDatasetYBoundariesFromNodes(Set<Node> nodes, String pointsAttribute) {
        nodes.stream().filter(Objects::nonNull).forEach(node -> {
            Node id;
            String nodeId;
            NamedNodeMap pathAttributes = node.getAttributes();
            if (pathAttributes == null) {
                return;
            }
            if (node.getNodeName().equals("polygon") && !this.zoneSerializedGraph.datasetsKeptForRecipe.contains(nodeId = StringUtils.split((String)GraphSerializerCommon.graphVizUnescape((id = node.getParentNode().getAttributes().getNamedItem("id")).getNodeValue()), (String)"_", (int)4)[3])) {
                return;
            }
            Node nodePointsAttribute = pathAttributes.getNamedItem(pointsAttribute);
            if (nodePointsAttribute == null) {
                return;
            }
            String attributeValue = nodePointsAttribute.getNodeValue();
            String[] points = attributeValue.split("[A-Za-z]| ");
            this.updateUsedDatasetYBoundariesFromPoints(points);
        });
    }

    private void updateUsedDatasetYBoundariesFromPoints(String[] points) {
        for (String point : points) {
            String[] xyCoord;
            if (StringUtils.isBlank((String)point) || (xyCoord = point.split(",")).length <= 1) continue;
            double yCoord = Double.parseDouble(xyCoord[1]);
            this.usedDatasetsMinY = Math.min(this.usedDatasetsMinY, yCoord);
            this.usedDatasetsMaxY = Math.max(this.usedDatasetsMaxY, yCoord);
        }
    }

    private String getZone() {
        return this.zone.getId();
    }

    @Override
    protected boolean isSameZone(GraphSerializer.SerializedNode node) {
        if (this.zone.getId().equals(Zone.DEFAULT_ZONE.getId()) && StringUtils.isBlank((String)node.ownerZone)) {
            node.ownerZone = Zone.DEFAULT_ZONE.getId();
        }
        return Objects.equals(node.ownerZone, this.getZone());
    }

    private boolean isSameZone(TaggableObjectsService.TaggableObject taggableObject) {
        Zone objectZone = ((ProjectFlowGraph)this.projectFlowGraphGraphSerializer.graph).getZone(taggableObject);
        if (this.zone.getId().equals(Zone.DEFAULT_ZONE.getId()) && objectZone == null) {
            return true;
        }
        return objectZone != null && Objects.equals(objectZone.getId(), this.getZone());
    }

    @Override
    protected void setOwnerZone(GraphSerializer.SerializedNode node, TaggableObjectsService.TaggableObject taggableObject) {
        Zone objectZone = ((ProjectFlowGraph)this.projectFlowGraphGraphSerializer.graph).getZone(taggableObject);
        node.ownerZone = objectZone == null ? Zone.DEFAULT_ZONE.getId() : objectZone.getId();
    }

    @Override
    protected void addUsedZone(GraphSerializer.SerializedNode node) {
        node.usedByZones.add(this.getZone());
        this.zoneSerializedGraph.externalObjects.add(node.realId);
    }

    @Override
    protected GraphSerializer.SerializedGraph createSerializedGraph() {
        this.zoneSerializedGraph = new ZoneSerializedGraph();
        this.zoneSerializedGraph.zone = this.getZone();
        this.zoneSerializedGraph.externalObjects = new ArrayList<String>();
        return this.zoneSerializedGraph;
    }

    private boolean isZoneSharedObject(TaggableObjectsService.TaggableObject taggableObject) {
        SmartObjectRef ref = SmartObjectRef.fromResolved(taggableObject.getTaggableType(), taggableObject.getProjectKey(), taggableObject.getId(), this.projectKey);
        return this.zone.getShared().contains(ref);
    }

    public Callable<ZoneSerializedGraph> serialize() throws Exception {
        Callable<GraphSerializer.SerializedGraph> callable = super.serialize();
        this.zoneSerializedGraph.setInputAndDraftDatasets();
        return callable;
    }

    @Override
    protected String getCacheKeyPrefix() {
        return this.projectKey + "_" + this.getZone();
    }

    @Override
    protected boolean shouldElementBeOnGraph(TaggableObjectsService.TaggableObject taggableObject) {
        if (this.isZoneSharedObject(taggableObject)) {
            return true;
        }
        if (!this.isSameZone(taggableObject)) {
            return false;
        }
        return super.shouldElementBeOnGraph(taggableObject);
    }

    @Override
    protected FlowExposedObjects getAllExposedObjects() throws IOException {
        return this.objectDependencies.allExposedObjects;
    }

    @Override
    public List<ManagedFolder> getAllManagedFolders() {
        return this.objectDependencies.allManagedFolders;
    }

    @Override
    public List<SavedModel> getAllSavedModels() {
        return this.objectDependencies.allSavedModels;
    }

    @Override
    public List<ModelEvaluationStore> getAllModelEvaluationStores() {
        return this.objectDependencies.allModelEvaluationStores;
    }

    @Override
    public List<SerializedDataset> getAllDatasets() {
        return this.objectDependencies.allDatasets;
    }

    @Override
    public List<StreamingEndpoint> getAllStreamingEndpoints() {
        return this.objectDependencies.allStreamingEndpoints;
    }

    public static class ZoneGraphSerializerObjectDependencies {
        public FlowExposedObjects allExposedObjects;
        public List<SerializedDataset> allDatasets;
        public List<ManagedFolder> allManagedFolders;
        public List<SavedModel> allSavedModels;
        public List<ModelEvaluationStore> allModelEvaluationStores;
        public List<StreamingEndpoint> allStreamingEndpoints;

        public ZoneGraphSerializerObjectDependencies(FlowExposedObjects allExposedObjects, List<SerializedDataset> allDatasets, List<ManagedFolder> allManagedFolders, List<SavedModel> allSavedModels, List<ModelEvaluationStore> allModelEvaluationStores, List<StreamingEndpoint> allStreamingEndpoints) {
            this.allExposedObjects = allExposedObjects;
            this.allDatasets = allDatasets;
            this.allManagedFolders = allManagedFolders;
            this.allSavedModels = allSavedModels;
            this.allModelEvaluationStores = allModelEvaluationStores;
            this.allStreamingEndpoints = allStreamingEndpoints;
        }
    }

    public static class ZoneSerializedGraph
    extends GraphSerializer.SerializedGraph {
        public String zone;
        @JSON.FileTransient
        public Set<SmartObjectRef> sharedObjects = new HashSet<SmartObjectRef>();
        @JSON.FileTransient
        public List<String> externalObjects = new ArrayList<String>();
    }
}

