/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graphtools;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowImplicitRecipe;
import com.dataiku.dip.dataflow.graph.FlowLabelingTask;
import com.dataiku.dip.dataflow.graph.FlowPartitionable;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.FlowRunnable;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.dataflow.graph.utils.GraphIds;
import com.dataiku.dip.dataflow.graphtools.AbstractFlowTool;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.recipes.RecipeSchemaService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsReadService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JF;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class PropagateSchemaTool
extends AbstractFlowTool.FlowTool {
    @Autowired
    private RecipeSchemaService recipeSchemaService;
    @Autowired
    private TaggableObjectsReadService taggableObjectsReadService;
    private List<AnyLoc> startingLocs = new ArrayList<AnyLoc>();
    private ProjectFlowGraph graph;
    private RecipeUpdateOptions recipeUpdateOptions;
    private Set<String> stopAt = Sets.newHashSet();
    private UpdateOptions currentUpdateOptions;
    private FutureProgressState mainProgressState = null;
    private Map<String, NodeState> stateByNode = new HashMap<String, NodeState>();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.flow.propagate");

    public PropagateSchemaTool(AuthCtx authCtx, String projectKey, JsonObject toolInitialData) throws IOException {
        super(authCtx, projectKey);
        if (toolInitialData.has("datasetName")) {
            Preconditions.checkArgument((boolean)toolInitialData.has("projectKey"), (Object)"Project key not specified");
            String datasetProjectKey = toolInitialData.get("projectKey").getAsString();
            Preconditions.checkArgument((toolInitialData.has("datasetName") && !toolInitialData.get("datasetName").isJsonNull() ? 1 : 0) != 0, (Object)"Dataset name not specified");
            String datasetName = toolInitialData.get("datasetName").getAsString();
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)datasetProjectKey), (Object)"Project key not specified");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)datasetName), (Object)"Dataset name not specified");
            this.startingLocs.add(new AnyLoc(datasetProjectKey, datasetName));
        } else {
            Preconditions.checkArgument((boolean)toolInitialData.has("sources"), (Object)"Sources not specified");
            Preconditions.checkArgument((boolean)toolInitialData.get("sources").isJsonArray(), (Object)"Sources is not an array");
            JsonArray sources = toolInitialData.get("sources").getAsJsonArray();
            for (JsonElement source : sources) {
                String sourcePkey = source.getAsJsonObject().get("projectKey").getAsString();
                String sourceLocalId = source.getAsJsonObject().get("id").getAsString();
                this.startingLocs.add(new AnyLoc(sourcePkey, sourceLocalId));
            }
        }
        logger.info((Object)("Propagate tool starting with initialData=" + JSON.prettyLog((Object)toolInitialData)));
        this.recipeUpdateOptions = toolInitialData.has("recipeUpdateOptions") ? (RecipeUpdateOptions)JSON.parse((JsonElement)toolInitialData.getAsJsonObject("recipeUpdateOptions"), RecipeUpdateOptions.class) : new RecipeUpdateOptions();
        if (toolInitialData.has("excludedRecipes")) {
            JsonArray excludedRecipes = toolInitialData.getAsJsonArray("excludedRecipes");
            for (JsonElement item : excludedRecipes) {
                this.stopAt.add(item.getAsString());
            }
        }
        this.initialMark();
    }

    public GraphNode getNode(String id) {
        return this.graph.getNode(id);
    }

    public List<AnyLoc> getStartingLocs() {
        return this.startingLocs;
    }

    private RecipeSchemaService.RecipeSchemaAutoupdateResult checkRecipe(String recipeName) throws Exception {
        JsonObject recipeOptions = null;
        try (Transaction t = this.transactionService.beginRead();){
            SerializedRecipe sr = (SerializedRecipe)this.recipesDAO.getMandatory(this.projectKey, recipeName);
            logger.info((Object)("Checking recipe " + recipeName + " of type " + sr.type));
            if (this.recipeUpdateOptions.byName.containsKey(sr.name)) {
                recipeOptions = this.recipeUpdateOptions.byName.get(sr.name);
            } else if (this.recipeUpdateOptions.byType.containsKey(sr.type)) {
                recipeOptions = this.recipeUpdateOptions.byType.get(sr.type);
            }
        }
        return this.recipeSchemaService.checkRecipe(this.authCtx, this.projectKey, recipeName, this.currentUpdateOptions.performExpensive, recipeOptions);
    }

    private DatasetNeedsToBeRebuiltData datasetNeedsToBeRebuiltBeforeNextRecipe(FlowDataset dataset) {
        DatasetNeedsToBeRebuiltData d = new DatasetNeedsToBeRebuiltData();
        for (GraphNode graphNode : dataset.getSuccessors()) {
            if (!(graphNode instanceof FlowRecipe)) continue;
            FlowRecipe successorRecipe = (FlowRecipe)graphNode;
            switch (successorRecipe.getModel().type) {
                case "spark_scala": 
                case "python": 
                case "r": {
                    DatasetNeedsToBeRebuiltReason r = new DatasetNeedsToBeRebuiltReason();
                    r.recipeName = successorRecipe.getModel().name;
                    r.recipeType = successorRecipe.getModel().type;
                    d.successorReasons.add(r);
                    d.mightNeedForSuccessor = true;
                    break;
                }
                case "shaker": 
                case "prediction_scoring": 
                case "clustering_scoring": 
                case "pivot": {
                    DatasetNeedsToBeRebuiltReason r = new DatasetNeedsToBeRebuiltReason();
                    r.recipeName = successorRecipe.getModel().name;
                    r.recipeType = successorRecipe.getModel().type;
                    d.successorReasons.add(r);
                    d.mightNeedForSuccessor = true;
                    d.definitelyNeedsForSuccessor = true;
                    break;
                }
            }
        }
        return d;
    }

    private void incrementalMoveOnAfterRecipe(FlowRecipe recipe) throws InterruptedException {
        for (FlowComputable recipeOutput : recipe.getTargets()) {
            String outputNodeId = GraphIds.forComputable(recipeOutput);
            recipeOutput = this.graph.getComputable(recipeOutput.getFullId());
            NodeState currentOutputState = this.stateByNode.get(outputNodeId);
            if (currentOutputState != null && currentOutputState.state == State.DATASET_NEEDS_REBUILD) continue;
            if (currentOutputState != null && currentOutputState.state != State.OK && this.currentUpdateOptions.alwaysRebuildInputOfRecipesUsuallyComputingOutputSchemaBasedOnData && recipeOutput instanceof FlowDataset) {
                FlowDataset recipeOutputDataset = (FlowDataset)recipeOutput;
                DatasetNeedsToBeRebuiltData datasetNeedsToBeRebuiltData = new DatasetNeedsToBeRebuiltData();
                for (GraphNode graphNode : recipeOutputDataset.getSuccessors()) {
                    if (!(graphNode instanceof FlowRecipe)) continue;
                    FlowRecipe successorRecipe = (FlowRecipe)graphNode;
                    switch (successorRecipe.getModel().type) {
                        case "shaker": 
                        case "prediction_scoring": 
                        case "clustering_scoring": 
                        case "pivot": {
                            DatasetNeedsToBeRebuiltReason r = new DatasetNeedsToBeRebuiltReason();
                            r.recipeName = successorRecipe.getModel().name;
                            r.recipeType = successorRecipe.getModel().type;
                            datasetNeedsToBeRebuiltData.successorReasons.add(r);
                            datasetNeedsToBeRebuiltData.mightNeedForSuccessor = true;
                            datasetNeedsToBeRebuiltData.definitelyNeedsForSuccessor = true;
                            currentOutputState.state = State.DATASET_NEEDS_REBUILD;
                            currentOutputState.datasetRebuildData = datasetNeedsToBeRebuiltData;
                            break;
                        }
                    }
                }
            }
            if (currentOutputState != null && currentOutputState.state == State.DATASET_NEEDS_REBUILD) continue;
            this.stateByNode.put(outputNodeId, new NodeState(State.OK, recipeOutput));
            for (GraphNode graphNode : recipeOutput.getSuccessors()) {
                if (!(graphNode instanceof FlowRecipe)) continue;
                this.incrementalMarkRecipe((FlowRecipe)graphNode);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void incrementalMarkRecipe(FlowRecipe recipe) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 37[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void update(JsonObject updateOptions) throws IOException, InterruptedException {
        UpdateOptions options;
        this.currentUpdateOptions = options = (UpdateOptions)JSON.parse((JsonElement)updateOptions, UpdateOptions.class);
        this.mainProgressState = null;
        int numberToCompute = 0;
        if (options.recheckAll) {
            this.stateByNode = new HashMap<String, NodeState>();
            this.initialMark();
        }
        for (NodeState ns : this.stateByNode.values()) {
            ns.checkFailure = null;
            ns.updateSolution = null;
            if (!ns.runnable) continue;
            ++numberToCompute;
        }
        this.mainProgressState = FutureProgress.pushState((String)"Computing recipes status", (double)numberToCompute, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);
        for (AnyLoc startingLoc : this.startingLocs) {
            FlowComputable initialComputable = this.graph.getComputable(startingLoc.getFullName());
            for (GraphNode graphNode : initialComputable.getSuccessors()) {
                if (!(graphNode instanceof FlowRecipe)) continue;
                this.incrementalMarkRecipe((FlowRecipe)graphNode);
            }
        }
        FutureProgress.popState();
    }

    public void forceMarkRecipeOK(String recipeName, boolean hasBeenRebuilt) {
        block16: {
            FlowRecipe recipe;
            block15: {
                recipe = this.graph.getRecipe(this.projectKey, recipeName);
                assert (recipe != null);
                String recipeNodeId = GraphIds.forRecipe(recipe);
                NodeState previousState = this.stateByNode.get(recipeNodeId);
                assert (previousState != null);
                assert (previousState.state != State.OK);
                previousState.state = State.OK;
                if (this.currentUpdateOptions == null || !this.currentUpdateOptions.alwaysRebuildOutputOfRecipesUsuallyComputingOutputSchemaAtRuntime || hasBeenRebuilt) break block15;
                switch (recipe.getModel().type) {
                    case "spark_scala": 
                    case "python": 
                    case "r": 
                    case "pivot": {
                        for (FlowComputable recipeOutput : recipe.getTargets()) {
                            String computableNodeId = GraphIds.forComputable(recipeOutput);
                            NodeState nodeState = new NodeState(State.DATASET_NEEDS_REBUILD, recipeOutput);
                            DatasetNeedsToBeRebuiltReason r = new DatasetNeedsToBeRebuiltReason();
                            r.recipeName = recipe.getModel().name;
                            r.recipeType = recipe.getModel().type;
                            nodeState.datasetRebuildData = new DatasetNeedsToBeRebuiltData();
                            nodeState.datasetRebuildData.predecessorReasons.add(r);
                            nodeState.datasetRebuildData.needsForPredecessor = true;
                            this.stateByNode.put(computableNodeId, nodeState);
                        }
                        break block16;
                    }
                    default: {
                        for (FlowComputable recipeOutput : recipe.getTargets()) {
                            String computableNodeId = GraphIds.forComputable(recipeOutput);
                            this.stateByNode.put(computableNodeId, new NodeState(State.OK, recipeOutput));
                        }
                        break block16;
                    }
                }
            }
            for (FlowComputable recipeOutput : recipe.getTargets()) {
                String computableNodeId = GraphIds.forComputable(recipeOutput);
                this.stateByNode.put(computableNodeId, new NodeState(State.OK, recipeOutput));
            }
        }
    }

    public void markRecipeAsOKAfterUpdate(String recipeName) {
        FlowRecipe recipe = this.graph.getRecipe(this.projectKey, recipeName);
        assert (recipe != null);
        String recipeNodeId = GraphIds.forRecipe(recipe);
        NodeState previousState = this.stateByNode.get(recipeNodeId);
        assert (previousState != null);
        assert (previousState.state != State.OK);
        previousState.state = State.OK;
        for (FlowComputable target : recipe.getTargets()) {
            String computableNodeId = GraphIds.forComputable(target);
            if (target instanceof FlowDataset) {
                DatasetNeedsToBeRebuiltData d = this.datasetNeedsToBeRebuiltBeforeNextRecipe((FlowDataset)target);
                logger.info((Object)("DNTBRD : " + JSON.prettyLog((Object)d)));
                if (d.mightNeedForSuccessor) {
                    NodeState ns = new NodeState(State.DATASET_NEEDS_REBUILD, target);
                    ns.datasetRebuildData = d;
                    this.stateByNode.put(computableNodeId, ns);
                    continue;
                }
                this.stateByNode.put(computableNodeId, new NodeState(State.OK, target));
                continue;
            }
            this.stateByNode.put(computableNodeId, new NodeState(State.OK, target));
        }
    }

    public void markDatasetAsBeingRebuilt(String objectId) {
        AnyLoc loc = DatasetLocUtils.DatasetLoc.resolveSmart(this.projectKey, objectId);
        FlowComputable fc = this.graph.getComputable(loc.getFullName());
        String nodeId = GraphIds.forComputable(fc);
        NodeState previousState = this.stateByNode.get(nodeId);
        assert (previousState != null);
        assert (previousState.state != State.OK);
        previousState.state = State.OK;
    }

    @Override
    public PropagateSchemaToolState getFlowState(JsonObject options) {
        PropagateSchemaToolState ts = new PropagateSchemaToolState();
        ts.stateByNode = this.stateByNode;
        int unchecked = 0;
        int uncheckable = 0;
        int ok = 0;
        int nok = 0;
        int failed = 0;
        int excluded = 0;
        int nbRunnables = 0;
        int datasetNeedsRebuild = 0;
        for (NodeState ns : this.stateByNode.values()) {
            if (ns.runnable) {
                ++nbRunnables;
                switch (ns.state) {
                    case AUTO_OK: 
                    case DATASET_NEEDS_REBUILD: {
                        break;
                    }
                    case FAILED_CHECK: {
                        ++failed;
                        break;
                    }
                    case NOK: {
                        ++nok;
                        break;
                    }
                    case OK: {
                        ++ok;
                        break;
                    }
                    case UNCHECKABLE: {
                        ++uncheckable;
                        break;
                    }
                    case EXCLUDED: {
                        ++excluded;
                        break;
                    }
                    case UNCHECKED: {
                        ++unchecked;
                    }
                }
                continue;
            }
            if (ns.state != State.DATASET_NEEDS_REBUILD) continue;
            ++datasetNeedsRebuild;
        }
        ts.summary = JF.obj().with("TOTAL", (Number)nbRunnables).with("OK", (Number)ok).with("NOK", (Number)nok).with("FAILED_CHECK", (Number)failed).with("UNCHECKABLE", (Number)uncheckable).with("EXCLUDED", (Number)excluded).with("UNCHECKED", (Number)unchecked).with("DATASET_NEEDS_REBUILD", (Number)datasetNeedsRebuild).get();
        return ts;
    }

    public void initialMark() throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            this.graph = this.graphService.getProjectGraphUnsafe(this.projectKey);
            for (AnyLoc startingLoc : this.startingLocs) {
                FlowComputable initialComputable = this.graph.getComputable(startingLoc.getFullName());
                if (initialComputable == null) {
                    throw ErrorContext.iaef((String)"Computable not found: '%s'", (Object)startingLoc.getFullName(), (Object[])new Object[0]);
                }
                this.stateByNode.put(GraphIds.forComputable(initialComputable), new NodeState(State.OK, initialComputable, this.retrievePartitioning(initialComputable), this.getSubType(initialComputable)));
                for (GraphNode graphNode : initialComputable.getSuccessors()) {
                    if (!(graphNode instanceof FlowRunnable) || graphNode instanceof FlowImplicitRecipe) continue;
                    this.initialMarkFlowRunnable((FlowRunnable)graphNode, false);
                }
            }
        }
    }

    private String getSubType(GraphNode node) throws IOException {
        ITaggingService.TaggableType taggableType = NodeState.typeFromNode(node);
        AnyLoc loc = AnyLoc.resolveFull(node.getFullId());
        TaggableObjectsService.TaggableObject taggableObject = this.taggableObjectsReadService.getOrNullUnsafe(loc.getProjectKey(), taggableType, loc.getId());
        if (taggableObject != null) {
            return taggableObject.getSubtype();
        }
        return "";
    }

    private void initialMarkFlowRunnable(FlowRunnable runnable, boolean excluded) throws IOException {
        logger.info((Object)("Initial mark: " + runnable.getName()));
        String runnableId = GraphIds.forRunnable(runnable);
        if (this.stateByNode.get(runnableId) != null) {
            return;
        }
        for (FlowComputable runnableInput : runnable.getSources()) {
            String nodeId = GraphIds.forComputable(runnableInput);
            if (this.stateByNode.get(nodeId) != null) continue;
            this.stateByNode.put(nodeId, new NodeState(State.AUTO_OK, runnableInput, this.retrievePartitioning(runnableInput), this.getSubType(runnableInput)));
        }
        excluded |= this.stopAt.contains(runnable.getName());
        this.stateByNode.put(runnableId, new NodeState((excluded |= runnable instanceof FlowLabelingTask) ? State.EXCLUDED : State.UNCHECKED, runnable, this.retrievePartitioning(runnable), this.getSubType(runnable)));
        for (FlowComputable runnableOutput : runnable.getTargets()) {
            runnableOutput = this.graph.getComputable(runnableOutput.getFullId());
            this.stateByNode.put(GraphIds.forComputable(runnableOutput), new NodeState(excluded ? State.EXCLUDED : State.UNCHECKED, runnableOutput, this.retrievePartitioning(runnableOutput), this.getSubType(runnableOutput)));
            for (GraphNode graphNode : runnableOutput.getSuccessors()) {
                if (!(graphNode instanceof FlowRunnable) || graphNode instanceof FlowImplicitRecipe) continue;
                this.initialMarkFlowRunnable((FlowRunnable)graphNode, excluded);
            }
        }
    }

    private PartitioningScheme retrievePartitioning(GraphNode computable) throws IOException {
        PartitioningScheme partitioningSchema;
        if (computable instanceof FlowPartitionable && (partitioningSchema = ((FlowPartitionable)((Object)computable)).getPartitioned(this.datasetsDAO).getPartitioningSchema()) != null && partitioningSchema.isPartitioned()) {
            return partitioningSchema;
        }
        return null;
    }

    public static class RecipeUpdateOptions {
        public Map<String, JsonObject> byType = Maps.newHashMap();
        public Map<String, JsonObject> byName = Maps.newHashMap();
    }

    public static class UpdateOptions {
        public boolean alwaysRebuildInputOfRecipesUsuallyComputingOutputSchemaBasedOnData = true;
        public boolean alwaysRebuildOutputOfRecipesUsuallyComputingOutputSchemaAtRuntime = true;
        public boolean performExpensive = true;
        public boolean recheckAll = false;
        public boolean markUncheckableAsOK = false;
    }

    static class DatasetNeedsToBeRebuiltData {
        boolean needsForPredecessor;
        boolean mightNeedForSuccessor;
        boolean definitelyNeedsForSuccessor;
        List<DatasetNeedsToBeRebuiltReason> successorReasons = new ArrayList<DatasetNeedsToBeRebuiltReason>();
        List<DatasetNeedsToBeRebuiltReason> predecessorReasons = new ArrayList<DatasetNeedsToBeRebuiltReason>();

        DatasetNeedsToBeRebuiltData() {
        }
    }

    static class DatasetNeedsToBeRebuiltReason {
        String recipeName;
        String recipeType;

        DatasetNeedsToBeRebuiltReason() {
        }
    }

    static class NodeState {
        boolean runnable;
        State state;
        RecipeSchemaService.RecipeSchemaAutoupdateResult updateSolution;
        SerializedError checkFailure;
        String uncheckableReason;
        boolean recipeShouldProbablyBeRebuilt;
        DatasetNeedsToBeRebuiltData datasetRebuildData;
        ITaggingService.TaggableType type;
        String fullId;
        PartitioningScheme partitioning;
        String subType;

        NodeState() {
        }

        NodeState(State state, GraphNode node) {
            this(state, NodeState.typeFromNode(node), node.getFullId());
        }

        NodeState(State state, GraphNode node, PartitioningScheme partitioning, String subType) {
            this(state, NodeState.typeFromNode(node), node.getFullId());
            this.partitioning = partitioning;
            this.subType = subType;
        }

        NodeState(State state, ITaggingService.TaggableType type, String fullId) {
            this.state = state;
            this.runnable = type == ITaggingService.TaggableType.RECIPE || type == ITaggingService.TaggableType.LABELING_TASK;
            this.type = type;
            this.fullId = fullId;
        }

        private static ITaggingService.TaggableType typeFromNode(GraphNode node) {
            if (node instanceof FlowLabelingTask) {
                return ITaggingService.TaggableType.LABELING_TASK;
            }
            if (node instanceof FlowRunnable) {
                return ITaggingService.TaggableType.RECIPE;
            }
            if (node instanceof FlowComputable) {
                return ((FlowComputable)node).getType().toTaggableType();
            }
            return null;
        }
    }

    public static enum State {
        UNCHECKED,
        AUTO_OK,
        NOK,
        OK,
        DATASET_NEEDS_REBUILD,
        UNCHECKABLE,
        FAILED_CHECK,
        EXCLUDED;

    }

    public static class PropagateSchemaToolState
    implements AbstractFlowTool.FlowState {
        Map<String, NodeState> stateByNode = new HashMap<String, NodeState>();
        public JsonObject summary;
    }
}

