/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.pipeline;

import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.AbstractSparkBasedRecipeRunner;
import com.dataiku.dip.dataflow.exec.SparkExecutionEnginesHelper;
import com.dataiku.dip.dataflow.pipeline.SparkPipelineDef;
import com.dataiku.dip.dataflow.pipeline.SparkPipelineDefBuilder;
import com.dataiku.dip.dataflow.pipeline.SparkPipelineRunnableSubgraph;
import com.dataiku.dip.spark.SparkJob;
import com.dataiku.dip.spark.SparkJobHelper;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class SparkPipelineRunner
extends AbstractSparkBasedRecipeRunner {
    @Autowired
    private DatasetsDAO datasetsDAO;
    private final SparkPipelineRunnableSubgraph subgraph;
    private final SparkPipelineDefBuilder defBuilder;
    private SparkPipelineDef def;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.spark.pipeline.runner");

    public SparkPipelineRunner(JobActivity activity) {
        super(activity);
        this.subgraph = (SparkPipelineRunnableSubgraph)activity.getSubgraph();
        this.defBuilder = new SparkPipelineDefBuilder(this.subgraph);
        JobActivity root = this.subgraph.getRoot();
        if (!(root.getSubgraph() instanceof RecipeRunnableSubgraph)) {
            throw new Error("cannot handle non-recipe root in Spark pipeline: " + String.valueOf(root.getSubgraph().getClass()));
        }
        this.projectKey = ((RecipeRunnableSubgraph)root.getSubgraph()).getRecipe().getProjectKey();
    }

    @Override
    public void init() throws Exception {
        this.activity.fillSourceTotalSizes(this.datasetsDAO);
        this.activity.setStatusMessage("Initializing");
        this.def = this.defBuilder.buildDef();
    }

    @Override
    public void run() throws Exception {
        final SparkOverrideConfig sparkConfig = this.defBuilder.getSparkConfigToUse();
        logger.info((Object)("Executing SparkSQL with sparkConfig: " + JSON.log((Object)sparkConfig)));
        this.runSpark("Spark", this.defBuilder.getEngineToUse(), new SparkExecutionEnginesHelper.SparkRecipeJobBuilder(){

            @Override
            public <T extends SparkJob> T buildSparkJob(SparkJobHelper<T> helper, File runDir, SparkSettings sparkSettings, List<SimpleKeyValue> effectiveConf) throws Exception {
                File serializedFile = new File(runDir, "spark-pipeline-def.json");
                JSON.prettyToFile((Object)SparkPipelineRunner.this.def, (File)serializedFile);
                T job = helper.makeClassJobWithNonSecretGlobalFiles("DSS (Pipe): " + SparkPipelineRunner.this.activity.id(), effectiveConf, SparkPipelineRunner.this.defBuilder.getResourceFiles(), true, "com.dataiku.dip.spark.SparkPipelineJob", serializedFile.getAbsolutePath());
                ((SparkJob)job).secretDriverFiles.add(serializedFile.getAbsolutePath());
                return job;
            }

            @Override
            public SparkOverrideConfig getRecipeOverrideConf() {
                return sparkConfig;
            }
        }, null);
        this.activity.setAllSourcesCompletelyRead();
        this.activity.fillTargetWrittenSizes(this.datasetsDAO);
        this.activity.setStatusMessage("Done");
    }

    @Override
    public void notifyBeforeAborting() {
    }

    @Override
    public boolean isAppendMode(String computableRef) {
        return false;
    }
}

