/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.join;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.RowInputStream;
import com.dataiku.dip.datalayer.sort.NumberedRow;
import com.dataiku.dip.datalayer.sort.RowAndSortMark;
import com.dataiku.dip.datalayer.sort.RowValueAccessorFactory;
import com.dataiku.dip.datalayer.sort.RowsComparator;
import com.dataiku.dip.datalayer.sort.SortedRowsIterator;
import com.dataiku.dip.datalayer.sort.Sorter;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class MergeJoiner {
    private static DKULogger logger = DKULogger.getLogger((String)"dip.join.mergerjoiner");

    private static int comparisonOf(Object[] a, Object[] b, List<Comparator<Object>> comparators) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return 1;
        }
        if (b == null) {
            return -1;
        }
        for (int i = 0; i < comparators.size(); ++i) {
            int cmp = comparators.get(i).compare(a[i], b[i]);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    private static Object[] keysOf(Row row, List<RowValueAccessorFactory.ValueReader> readers) {
        Object[] keys = new Object[readers.size()];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = readers.get(i).read(row);
        }
        return keys;
    }

    public static class Merger {
        private final JoinerSide leftSide;
        private final JoinerSide rightSide;
        private final boolean keepUnmatchedLeft;
        private final boolean keepUnmatchedRight;
        private final JoinerStage outputStage;
        private volatile boolean stopped = false;

        public Merger(JoinerSide leftSide, JoinerSide rightSide, boolean keepUnmatchedLeft, boolean keepUnmatchedRight, JoinerStage outputStage) {
            this.leftSide = leftSide;
            this.rightSide = rightSide;
            this.keepUnmatchedLeft = keepUnmatchedLeft;
            this.keepUnmatchedRight = keepUnmatchedRight;
            this.outputStage = outputStage;
        }

        public void abort() {
            this.stopped = true;
        }

        public void iterateJoin() throws Exception {
            Object leftReader;
            ArrayList<RowValueAccessorFactory.ValueReader> leftReaders = new ArrayList<RowValueAccessorFactory.ValueReader>();
            ArrayList<RowValueAccessorFactory.ValueReader> rightReaders = new ArrayList<RowValueAccessorFactory.ValueReader>();
            ArrayList<Comparator<Object>> comparators = new ArrayList<Comparator<Object>>();
            logger.info((Object)("Merge using " + JSON.log(this.leftSide.specs.stream().map(s -> s.column).collect(Collectors.toList()))));
            int n = this.leftSide.specs.size();
            for (int i = 0; i < n; ++i) {
                String leftColumn = this.leftSide.specs.get((int)i).column;
                String rightColumn = this.rightSide.specs.get((int)i).column;
                SchemaColumn leftSchemaColumn = this.leftSide.schema.getColumn(leftColumn);
                SchemaColumn rightSchemaColumn = this.rightSide.schema.getColumn(rightColumn);
                leftReader = RowValueAccessorFactory.getReader(leftSchemaColumn, this.leftSide.outputCf.column(leftColumn));
                RowValueAccessorFactory.ValueReader rightReader = RowValueAccessorFactory.getReader(rightSchemaColumn, this.rightSide.outputCf.column(rightColumn));
                if (!leftReader.resultClass().equals(rightReader.resultClass())) {
                    throw new IllegalArgumentException("Incompatible join key types : " + String.valueOf(leftSchemaColumn.getType()) + " vs. " + String.valueOf(rightSchemaColumn.getType()));
                }
                leftReaders.add((RowValueAccessorFactory.ValueReader)leftReader);
                rightReaders.add(rightReader);
                comparators.add(RowValueAccessorFactory.getComparator(leftSchemaColumn, null, true, RowsComparator.NullsOrdering.AUTO));
            }
            SortedRowsIterator leftIt = this.leftSide.sorter.read();
            SortedRowsIterator rightIt = this.rightSide.sorter.read();
            JoinerState state = new JoinerState(leftIt, leftReaders, rightIt, rightReaders, comparators);
            state.advanceLeft();
            state.advanceRight();
            while (!(this.stopped || state.leftRow == null && state.rightRow == null)) {
                Object[] leftJoinKeys;
                if (state.cmp < 0) {
                    logger.trace(() -> "Unmatched left " + JSON.log((Object)state.leftKeys));
                    if (this.keepUnmatchedLeft) {
                        leftJoinKeys = state.leftKeys;
                        RowAndSortMark leftStart = state.leftRow;
                        leftReader = state.readEqualsLeft(leftStart, leftJoinKeys);
                        this.outputStage.runJoin(new EqualsRowStream((JoinerStateReader)leftReader), null);
                        while (leftReader.hasNext()) {
                            leftReader.next();
                        }
                        continue;
                    }
                    while (state.cmp < 0) {
                        state.advanceLeft();
                    }
                    continue;
                }
                if (state.cmp > 0) {
                    logger.trace(() -> "Unmatched right " + JSON.log((Object)state.rightKeys));
                    if (this.keepUnmatchedRight) {
                        Object[] rightJoinKeys = state.rightKeys;
                        RowAndSortMark rightStart = state.rightRow;
                        JoinerStateReader rightReader = state.readEqualsRight(rightStart, rightJoinKeys);
                        this.outputStage.runJoin(null, new EqualsRowStream(rightReader));
                        while (rightReader.hasNext()) {
                            rightReader.next();
                        }
                        continue;
                    }
                    while (state.cmp < 0) {
                        state.advanceLeft();
                    }
                    continue;
                }
                leftJoinKeys = state.leftKeys;
                Object[] rightJoinKeys = state.rightKeys;
                RowAndSortMark leftStart = state.leftRow;
                RowAndSortMark rightStart = state.rightRow;
                logger.trace(() -> "Equality on " + JSON.log((Object)leftJoinKeys));
                JoinerStateReader leftReader2 = state.readEqualsLeft(leftStart, rightJoinKeys);
                JoinerStateReader rightReader = state.readEqualsRight(rightStart, leftJoinKeys);
                this.outputStage.runJoin(new EqualsRowStream(leftReader2), new EqualsRowStream(rightReader));
                while (leftReader2.hasNext()) {
                    leftReader2.next();
                }
                while (rightReader.hasNext()) {
                    rightReader.next();
                }
            }
        }
    }

    private static class EqualsRowStream
    implements RowStream {
        private final JoinerStateReader reader;

        public EqualsRowStream(JoinerStateReader reader) throws IOException {
            this.reader = reader;
        }

        @Override
        public NumberedRow next() throws Exception {
            return this.reader.hasNext() ? this.reader.next().row : null;
        }

        @Override
        public boolean canSeekToBeginning() {
            return true;
        }

        @Override
        public void seekToBeginning() throws Exception {
            this.reader.reset();
        }

        @Override
        public boolean canSize() {
            return false;
        }

        @Override
        public long size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean canEstimateMemoryUsed() {
            return false;
        }
    }

    public static class JoinerState {
        private final SortedRowsIterator leftIt;
        private final List<RowValueAccessorFactory.ValueReader> leftReaders;
        private final SortedRowsIterator rightIt;
        private final List<RowValueAccessorFactory.ValueReader> rightReaders;
        private final List<Comparator<Object>> comparators;
        public RowAndSortMark leftRow;
        public RowAndSortMark rightRow;
        public Object[] leftKeys;
        public Object[] rightKeys;
        public int cmp;

        public JoinerState(SortedRowsIterator leftIt, List<RowValueAccessorFactory.ValueReader> leftReaders, SortedRowsIterator rightIt, List<RowValueAccessorFactory.ValueReader> rightReaders, List<Comparator<Object>> comparators) {
            this.leftIt = leftIt;
            this.leftReaders = leftReaders;
            this.rightIt = rightIt;
            this.rightReaders = rightReaders;
            this.comparators = comparators;
        }

        public void resetLeft(RowAndSortMark row) throws IOException {
            this.leftIt.resetToNext(row);
            this.leftRow = row;
            this.leftKeys = MergeJoiner.keysOf(this.leftRow.row.row, this.leftReaders);
            this.cmp = MergeJoiner.comparisonOf(this.leftKeys, this.rightKeys, this.comparators);
        }

        public void resetRight(RowAndSortMark row) throws IOException {
            this.rightIt.resetToNext(row);
            this.rightRow = row;
            this.rightKeys = MergeJoiner.keysOf(this.rightRow.row.row, this.rightReaders);
            this.cmp = MergeJoiner.comparisonOf(this.leftKeys, this.rightKeys, this.comparators);
        }

        public void advanceLeft() {
            if (this.leftIt.hasNext()) {
                this.leftRow = this.leftIt.next();
                this.leftKeys = MergeJoiner.keysOf(this.leftRow.row.row, this.leftReaders);
            } else {
                this.leftRow = null;
                this.leftKeys = null;
            }
            this.cmp = MergeJoiner.comparisonOf(this.leftKeys, this.rightKeys, this.comparators);
        }

        public void advanceRight() {
            if (this.rightIt.hasNext()) {
                this.rightRow = this.rightIt.next();
                this.rightKeys = MergeJoiner.keysOf(this.rightRow.row.row, this.rightReaders);
            } else {
                this.rightRow = null;
                this.rightKeys = null;
            }
            this.cmp = MergeJoiner.comparisonOf(this.leftKeys, this.rightKeys, this.comparators);
        }

        public JoinerStateReader readEqualsLeft(final RowAndSortMark start, final Object[] keys) {
            return new JoinerStateReader(){

                @Override
                public RowAndSortMark next() {
                    RowAndSortMark ret = leftRow;
                    this.advanceLeft();
                    return ret;
                }

                @Override
                public boolean hasNext() {
                    return MergeJoiner.comparisonOf(leftKeys, keys, comparators) == 0;
                }

                @Override
                public void reset() throws IOException {
                    this.resetLeft(start);
                }
            };
        }

        public JoinerStateReader readEqualsRight(final RowAndSortMark start, final Object[] keys) {
            return new JoinerStateReader(){

                @Override
                public RowAndSortMark next() {
                    RowAndSortMark ret = rightRow;
                    this.advanceRight();
                    return ret;
                }

                @Override
                public boolean hasNext() {
                    return MergeJoiner.comparisonOf(keys, rightKeys, comparators) == 0;
                }

                @Override
                public void reset() throws IOException {
                    this.resetRight(start);
                }
            };
        }
    }

    public static interface JoinerStateReader {
        public void reset() throws IOException;

        public boolean hasNext();

        public RowAndSortMark next();
    }

    public static class JoinerSide {
        public final Schema schema;
        public final ColumnFactory inputCf;
        public final RowFactory outputRf;
        public final ColumnFactory outputCf;
        public List<Sorter.SortSpec> specs;
        public Sorter sorter;
        public int rowCount;

        public JoinerSide(Schema schema, ColumnFactory inputCf, ColumnFactory outputCf, RowFactory outputRf) {
            this.schema = schema;
            this.inputCf = inputCf;
            this.outputCf = outputCf;
            this.outputRf = outputRf;
        }
    }

    public static interface JoinerStage {
        public void runJoin(RowStream var1, RowStream var2) throws Exception;
    }

    public static class JoinerPairStreamSide {
        public Schema schema;
        public ColumnFactory cf;
        public RowFactory rf;

        public static JoinerPairStreamSide from(Schema schema, ColumnFactory cf, RowFactory rf) {
            JoinerPairStreamSide ret = new JoinerPairStreamSide();
            ret.schema = schema;
            ret.cf = cf;
            ret.rf = rf;
            return ret;
        }

        public static JoinerPairStreamSide from(JoinerInputSide input) {
            JoinerPairStreamSide ret = new JoinerPairStreamSide();
            ret.schema = input.schema;
            ret.cf = input.cf;
            return ret;
        }

        public static JoinerPairStreamSide from(Schema schema) {
            JoinerPairStreamSide ret = new JoinerPairStreamSide();
            ret.schema = schema;
            ret.cf = new StreamColumnFactory();
            ret.rf = new StreamRowFactory();
            return ret;
        }
    }

    public static class UnicityProbingRowStream
    implements RowStream {
        private final RowStream wrapped;
        private NumberedRow first;
        private NumberedRow second;
        private final boolean empty;
        private final boolean unique;

        public UnicityProbingRowStream(RowStream wrapped) throws Exception {
            this.wrapped = wrapped;
            this.first = wrapped.next();
            boolean bl = this.empty = this.first == null;
            if (this.empty) {
                this.second = null;
                this.unique = false;
            } else {
                this.second = wrapped.next();
                this.unique = this.second == null;
            }
        }

        public boolean notUnique() {
            return !this.empty && !this.unique;
        }

        @Override
        public NumberedRow next() throws Exception {
            if (this.first != null) {
                NumberedRow ret = this.first;
                this.first = null;
                return ret;
            }
            if (this.second != null) {
                NumberedRow ret = this.second;
                this.second = null;
                return ret;
            }
            return this.wrapped.next();
        }

        @Override
        public boolean canSeekToBeginning() {
            return this.wrapped.canSeekToBeginning();
        }

        @Override
        public void seekToBeginning() throws Exception {
            this.wrapped.seekToBeginning();
            this.second = null;
            this.first = null;
        }

        @Override
        public boolean canSize() {
            return this.wrapped.canSize();
        }

        @Override
        public long size() {
            return this.wrapped.size();
        }

        @Override
        public boolean canEstimateMemoryUsed() {
            return this.wrapped.canEstimateMemoryUsed();
        }
    }

    public static class RowInputRowStream
    implements RowStream {
        private final RowInputStream is;
        private long idx = 0L;

        public RowInputRowStream(RowInputStream is) {
            this.is = is;
        }

        @Override
        public NumberedRow next() throws Exception {
            Row r = this.is.next();
            if (r == null) {
                return null;
            }
            return new NumberedRow(r, this.idx++);
        }

        @Override
        public boolean canSeekToBeginning() {
            return false;
        }

        @Override
        public void seekToBeginning() throws Exception {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean canSize() {
            return false;
        }

        @Override
        public long size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean canEstimateMemoryUsed() {
            return false;
        }
    }

    public static interface RowStream {
        public NumberedRow next() throws Exception;

        public boolean canSeekToBeginning();

        public void seekToBeginning() throws Exception;

        public boolean canSize();

        public long size();

        public boolean canEstimateMemoryUsed();
    }

    public static class JoinerOutput {
        public final ProcessorOutput out;
        public final RowFactory rf;
        public final ColumnFactory cf;

        public JoinerOutput(ProcessorOutput out, RowFactory rf, ColumnFactory cf) {
            this.out = out;
            this.rf = rf;
            this.cf = cf;
        }
    }

    public static class JoinerInput {
        public final JoinerInputSide left;
        public final JoinerInputSide right;

        public JoinerInput(JoinerInputSide left, JoinerInputSide right) {
            this.left = left;
            this.right = right;
        }

        public JoinerInput swap() {
            return new JoinerInput(this.right, this.left);
        }
    }

    public static class JoinerInputSide {
        public final RowInputStream is;
        public final Schema schema;
        public final ColumnFactory cf;
        public final String prefix;

        public JoinerInputSide(RowInputStream is, Schema schema, ColumnFactory cf, String prefix) {
            this.is = is;
            this.schema = schema;
            this.cf = cf;
            this.prefix = prefix;
        }
    }
}

