/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.inline;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.ComputableHashComputer;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetReadiness;
import com.dataiku.dip.datasets.EditableDatasetConfig;
import com.dataiku.dip.datasets.EditableDatasetHandler;
import com.dataiku.dip.datasets.inline.InlineDatasetConfig;
import com.dataiku.dip.datasets.inline.InlineDatasetTestHandler;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.input.InputSplit;
import com.dataiku.dip.input.InputSplitProgressListener;
import com.dataiku.dip.input.filter.FilterResultWithSplits;
import com.dataiku.dip.input.filter.InputFilter;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.formats.JSONFormatConfig;
import com.dataiku.dip.input.row.RowOrientedDatasetHandler;
import com.dataiku.dip.input.row.RowsInputSplit;
import com.dataiku.dip.output.ForwardToBackendOutput;
import com.dataiku.dip.output.InlineDataOutput;
import com.dataiku.dip.output.InlineDataOutputWriter;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.recipes.ManagedDatasetsCreationService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.datasets.FileUploadService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class InlineDatasetHandler
implements RowOrientedDatasetHandler,
EditableDatasetHandler {
    @Autowired
    private TransactionService transactionService;
    public static final String INLINE_TYPE = "Inline";
    public static final InlineDatasetMeta META = new InlineDatasetMeta();
    private Dataset dataset;
    private File configDir;
    private RelFile rData;
    private RelFile rChanges;
    private AuthCtx authCtx;
    static DKULogger logger = DKULogger.getLogger((String)"dku.datasets.inline");

    public InlineDatasetHandler(AuthCtx authCtx, Dataset dataset) {
        this.authCtx = authCtx;
        SpringUtils.getInstance().autowire((Object)this);
        this.dataset = dataset;
        File datasetDir = FileUploadService.localDatasetDir(dataset.getProjectKey(), dataset.getName());
        datasetDir.mkdirs();
        this.configDir = new File(ApplicationConfigurator.getBaseFolder(), "config");
        this.rData = new RelFile(new String[]{"projects", dataset.getProjectKey(), "datasets", dataset.getName() + ".data"});
        this.rChanges = new RelFile(new String[]{"projects", dataset.getProjectKey(), "datasets", dataset.getName() + ".changes"});
    }

    @Override
    public void close() {
    }

    @Override
    public void clearAllData() throws Exception {
        if (TransactionContext.hasAttachedTransaction()) {
            RWTransactionRef t = TransactionContext.retrieveWrite();
            t.writeObject(this.rData, (Object)new InlineDataOutputWriter.InlineData());
            t.deleteFile(this.rChanges);
        } else {
            try (RWTransaction t = this.transactionService.beginWriteAsDSS();){
                t.writeObject(this.rData, (Object)new InlineDataOutputWriter.InlineData());
                t.deleteFile(this.rChanges);
                t.commit("Clear " + this.dataset.getFullName());
            }
        }
    }

    public void clearChanges() throws Exception {
        logger.info((Object)"Drop changes record file");
        if (TransactionContext.hasAttachedTransaction()) {
            RWTransactionRef t = TransactionContext.retrieveWrite();
            t.deleteFile(this.rChanges);
        } else {
            try (RWTransaction t = this.transactionService.beginWriteAsDSS();){
                t.deleteFile(this.rChanges);
                t.commit("Clear changes in " + this.dataset.getFullName());
            }
        }
    }

    public void rename(String newName) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        if (t.exists(this.rData)) {
            RelFile newData = new RelFile(new String[]{"projects", this.dataset.getProjectKey(), "datasets", newName + ".data"});
            t.moveFile(this.rData, newData);
        }
        if (t.exists(this.rChanges)) {
            RelFile newChanges = new RelFile(new String[]{"projects", this.dataset.getProjectKey(), "datasets", newName + ".changes"});
            t.moveFile(this.rChanges, newChanges);
        }
    }

    @Override
    public InlineDataOutput buildOutput(Partition targetPartition, int targetSplit, int resplitFactor, WarningsContext warningsContext) throws Exception {
        ForwardToBackendOutput fwdOutput = new ForwardToBackendOutput(this.dataset, this.dataset.getSchema());
        return new InlineDataOutput(this.rData, this.dataset.getSchema(), fwdOutput);
    }

    @Override
    public InlineDataOutput buildDataOutput(Partition targetPartition, int targetSplit, int resplitFactor, WarningsContext warningsContext) throws Exception {
        return new InlineDataOutput(this.rData, this.dataset.getSchema(), null);
    }

    @Override
    public InlineDataOutput buildChangesOutput(Partition targetPartition, int targetSplit, int resplitFactor, WarningsContext warningsContext) throws Exception {
        if (this.dataset.getParamsAs(EditableDatasetConfig.class).keepTrackOfChanges()) {
            return new InlineDataOutput(this.rChanges, this.dataset.getSchema(), null);
        }
        this.clearChanges();
        return new InlineDataOutput(null, null, null);
    }

    @Override
    public String suggestName() {
        return "Inline_dataset";
    }

    @Override
    public DatasetTestHandler buildTestHandler() throws IOException {
        return new InlineDatasetTestHandler(this.authCtx, this, (DatasetHandler)this, this.dataset);
    }

    public void initMetadata() {
        this.dataset.setManaged(true);
        this.dataset.setFormatType("json");
        JSONFormatConfig jsonConfig = new JSONFormatConfig(false, true, null);
        jsonConfig.headerRow = true;
        this.dataset.setFormatParams(jsonConfig);
        InlineDatasetConfig params = (InlineDatasetConfig)JSON.deepCopy((Object)this.dataset.getParamsAs(InlineDatasetConfig.class));
        params.uploadBoxId = null;
        this.dataset.setParams(params);
    }

    @Override
    public MemTable getDataAsMemTable() throws Exception {
        return this.getAsMemTable(this.rData);
    }

    @Override
    public MemTable getChangesAsMemTable() throws Exception {
        if (this.dataset.getParamsAs(EditableDatasetConfig.class).keepTrackOfChanges()) {
            return this.getAsMemTable(this.rChanges);
        }
        if (!this.rChanges.resolve(this.configDir).exists()) {
            logger.info((Object)"No changes file. Proceed without.");
            return null;
        }
        return null;
    }

    public MemTable getAsMemTable(RelFile rFile) throws Exception {
        TransactionRef t = TransactionContext.retrieveRead();
        MemTable mt = new MemTable();
        try {
            InlineDataOutputWriter.InlineData obj = (InlineDataOutputWriter.InlineData)t.readObject(rFile, InlineDataOutputWriter.InlineData.class);
            ArrayList<MemColumn> cols = new ArrayList<MemColumn>();
            for (SchemaColumn schemaColumn : obj.schema.columns) {
                cols.add(mt.column(schemaColumn.getName()));
            }
            for (ArrayList arrayList : obj.data) {
                Row row = mt.row();
                for (int i = 0; i < cols.size(); ++i) {
                    row.put((Column)cols.get(i), (String)arrayList.get(i));
                }
                mt.appendRow(row);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Data not found, continue with empty data object");
        }
        return mt;
    }

    @Override
    public ArrayList<ArrayList<String>> getDataAsList() throws Exception {
        return this.getAsList(this.rData);
    }

    @Override
    public ArrayList<ArrayList<String>> getChangesAsList() throws Exception {
        if (!this.dataset.getParamsAs(EditableDatasetConfig.class).keepTrackOfChanges()) {
            return null;
        }
        if (!this.rChanges.resolve(this.configDir).exists()) {
            logger.info((Object)"No changes file. Proceed without.");
            return null;
        }
        return this.getAsList(this.rChanges);
    }

    public ArrayList<ArrayList<String>> getAsList(RelFile rFile) throws Exception {
        if (TransactionContext.hasAttachedTransaction()) {
            TransactionRef t = TransactionContext.retrieveRead();
            if (!t.isFile(rFile)) {
                logger.info((Object)"No data file. Proceed without.");
                return new ArrayList<ArrayList<String>>();
            }
            InlineDataOutputWriter.InlineData obj = (InlineDataOutputWriter.InlineData)t.readObject(rFile, InlineDataOutputWriter.InlineData.class);
            return obj.data;
        }
        try (Transaction t = this.transactionService.beginRead();){
            InlineDataOutputWriter.InlineData obj = (InlineDataOutputWriter.InlineData)t.readObject(rFile, InlineDataOutputWriter.InlineData.class);
            ArrayList<ArrayList<String>> arrayList = obj.data;
            return arrayList;
        }
    }

    @Override
    public void clearPartitions(List<Partition> partitionIdentifiers) throws Exception {
        this.clearAllData();
    }

    @Override
    public boolean isParallelWritable() throws Exception {
        return false;
    }

    @Override
    public long getDataFileSize() {
        File root = this.rData.resolve(this.configDir);
        if (!root.exists()) {
            return 0L;
        }
        return FileUtils.sizeOf((File)root);
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    public boolean isManaged() {
        return true;
    }

    @Override
    public DatasetHandler.DatasetMeta<?, ?> getMeta() {
        return META;
    }

    @Override
    public void checkConfiguration() throws IllegalArgumentException, IOException {
    }

    @Override
    public List<Partition> listPartitions() throws Exception {
        return Lists.newArrayList((Object[])new Partition[]{new Partition(null)});
    }

    @Override
    public long getRecords() throws Exception {
        return this.getDataAsList().size();
    }

    @Override
    public long getPartitionRecords(Partition p) throws Exception {
        return this.getRecords();
    }

    @Override
    public DatasetReadiness getReadiness(Partition p, @Nullable ComputableHashComputer.ReadinessComputationSession session) {
        File root = this.rData.resolve(this.configDir);
        if (root.exists()) {
            String hash;
            try {
                BasicFileAttributes attr = Files.readAttributes(root.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                String identifier = this.rData.getFullPath() + "=" + attr.size() + "@" + String.valueOf(attr.lastModifiedTime());
                hash = DKUtils.md5Base64((String)identifier);
                logger.infoV("Computed hash for identifier '%s': '%s'", new Object[]{identifier, hash});
            }
            catch (IOException e) {
                return DatasetReadiness.error(e);
            }
            if (this.dataset.getParams().isNotReadyIfEmpty()) {
                try {
                    logger.info((Object)("Checking whether partition " + p.id() + " is empty"));
                    return RowOrientedDatasetHandler.Utils.getReadinessNotEmpty((RowsInputSplit)this.getPartitionSplit(p), hash);
                }
                catch (Exception e) {
                    return DatasetReadiness.error(e);
                }
            }
            return DatasetReadiness.ready(hash);
        }
        return DatasetReadiness.notReady(new FileNotFoundException("File does not exist: " + root.getAbsolutePath()));
    }

    @Override
    public boolean partitionExists(Partition p) throws Exception {
        return true;
    }

    @Override
    public boolean executeFastPostCreateOperations() throws Exception {
        return false;
    }

    @Override
    public boolean executeSlowPostCreateOperations_NT() throws Exception {
        return false;
    }

    @Override
    public void executePreRenameOperations() {
    }

    @Override
    public void createManaged() throws Exception {
    }

    @Override
    public void clearAllDataAndStructure() throws Exception {
        if (TransactionContext.hasAttachedTransaction()) {
            RWTransactionRef t = TransactionContext.retrieveWrite();
            t.deleteFile(this.rData);
            t.deleteFile(this.rChanges);
        } else {
            try (RWTransaction t = this.transactionService.beginWriteAsDSS();){
                t.deleteFile(this.rData);
                t.deleteFile(this.rChanges);
                t.commit("Drop " + this.dataset.getFullName());
            }
        }
    }

    @Override
    public FilterResultWithSplits getFilterSplits(InputFilter filter) throws Exception {
        assert (filter != null) : "Filter is required";
        FilterResultWithSplits ret = new FilterResultWithSplits();
        ret.setNeedsRefilter(true);
        ret.withMatchingPartition(new Partition(null)).withSplit((InputSplit)new InlineDataSplit(filter));
        return ret;
    }

    @Override
    public boolean outputHandlesClear() {
        return true;
    }

    @Override
    public RowsInputSplit getSingleSplit() throws Exception {
        return new InlineDataSplit(null);
    }

    @Override
    public RowsInputSplit getSampleSplit() throws Exception {
        return this.getSingleSplit();
    }

    @Override
    public InputSplit getPartitionSplit(Partition partition) throws Exception {
        return this.getSingleSplit();
    }

    public static class InlineDatasetMeta
    extends DatasetHandler.NonFSMeta<InlineDatasetHandler, InlineDatasetConfig> {
        @Override
        public String getType() {
            return InlineDatasetHandler.INLINE_TYPE;
        }

        @Override
        public Class<? extends DatasetHandler.DatasetParams> paramsClass() {
            return InlineDatasetConfig.class;
        }

        @Override
        public DatasetHandler build(AuthCtx authCtx, Dataset dataset) {
            return new InlineDatasetHandler(authCtx, dataset);
        }

        @Override
        public boolean isFSLike() {
            return false;
        }

        @Override
        public boolean isFS() {
            return false;
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isWritable() {
            return false;
        }

        @Override
        public boolean isParallelWritable() {
            return true;
        }

        @Override
        public void fillManagedDatasetParams(Dataset dataset, DSSConnection _dssConnection, ManagedDatasetsCreationService.ManagedDatasetCreationSpecificSettings unused, boolean useExistingParams) {
            dataset.setManaged(true);
            dataset.setType(this.getType());
            InlineDatasetConfig config = new InlineDatasetConfig();
            dataset.setParams(config);
        }
    }

    class InlineDataSplit
    extends RowsInputSplit {
        protected InputFilter filter;

        InlineDataSplit(InputFilter filter) {
            this.filter = filter;
        }

        public String getDesc() {
            return "Inline data";
        }

        @Override
        public long push(ProcessorOutput out, ColumnFactory cf, RowFactory rf, @Nullable ExtractionLimit limit, InputSplitProgressListener listener, WarningsContext warningsContext) throws Exception {
            InlineDataOutputWriter.InlineData obj;
            block13: {
                obj = null;
                try {
                    TransactionRef t;
                    if (TransactionContext.hasAttachedTransaction()) {
                        t = TransactionContext.retrieveRead();
                        obj = (InlineDataOutputWriter.InlineData)t.readObject(InlineDatasetHandler.this.rData, InlineDataOutputWriter.InlineData.class);
                        break block13;
                    }
                    t = InlineDatasetHandler.this.transactionService.beginRead();
                    try {
                        obj = (InlineDataOutputWriter.InlineData)t.readObject(InlineDatasetHandler.this.rData, InlineDataOutputWriter.InlineData.class);
                    }
                    finally {
                        if (t != null) {
                            t.close();
                        }
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)"Failed to load inline data.", (Throwable)e);
                }
            }
            if (obj != null && obj.schema != null) {
                ArrayList<Column> cols = new ArrayList<Column>();
                for (SchemaColumn sc : obj.schema.columns) {
                    cols.add(cf.column(sc.getName()));
                }
                long emitted = 0L;
                for (ArrayList<String> line : obj.data) {
                    Row row = rf.row();
                    for (int i = 0; i < cols.size(); ++i) {
                        row.put((Column)cols.get(i), line.get(i));
                    }
                    out.emitRow(row);
                    if (limit == null || limit.maxRecords <= 0L || limit.maxRecords != ++emitted) continue;
                    break;
                }
            }
            return 0L;
        }
    }
}

