/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sample;

import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.custom.IElementLoadedDesc;
import com.dataiku.dip.custom.IPluginifiedMeta;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.sample.LoadedSampleDataset;
import com.dataiku.dip.datasets.sample.SampleDatasetHandler;
import com.dataiku.dip.datasets.sample.SampleDatasetParams;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.recipes.ManagedDatasetsCreationService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.NotImplementedException;

public class SampleDatasetMeta
extends DatasetHandler.DatasetMeta<SampleDatasetHandler, SampleDatasetParams>
implements IPluginifiedMeta {
    private final LoadedSampleDataset loaded;

    public SampleDatasetMeta(LoadedSampleDataset loaded) {
        this.loaded = loaded;
    }

    @Override
    public IElementLoadedDesc getLoadedDesc() {
        return this.loaded;
    }

    @Override
    public String getType() {
        return "Sample_" + this.loaded.ownerPluginId + "_" + this.loaded.id;
    }

    @Override
    public Class<? extends DatasetHandler.DatasetParams> paramsClass() {
        return SampleDatasetParams.class;
    }

    @Override
    public DatasetHandler build(AuthCtx authCtx, Dataset dataset) {
        return new SampleDatasetHandler(authCtx, this.loaded, dataset);
    }

    public Integer getRowCount(String version) {
        return this.loaded.getDataset((String)version).rowCount;
    }

    public String getActiveVersion() {
        return this.loaded.getActiveVersion();
    }

    public void checkVersionExists(String version) {
        if (this.loaded.getDataset(version) == null) {
            throw ErrorContext.iaef((String)"This sample dataset has no version %s, please use a correct version or update the corresponding plugin component.", (Object)version, (Object[])new Object[0]);
        }
    }

    @Override
    public boolean isFSLike() {
        return false;
    }

    @Override
    public boolean isFS() {
        return false;
    }

    @Override
    public boolean isReadable() {
        return true;
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean isParallelWritable() {
        return false;
    }

    @Override
    public void fillManagedDatasetParams(Dataset dataset, DSSConnection targetConnection, ManagedDatasetsCreationService.ManagedDatasetCreationSpecificSettings specificSettings, boolean useExistingParams) {
        throw new NotImplementedException();
    }

    @Override
    public void fillManagedFolderParams(ManagedFolder folder, DSSConnection targetConnection, boolean useExistingParams) {
        throw new NotImplementedException();
    }
}

