/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sql;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dataflow.ComputableHashComputer;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetReadiness;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.dynamic.VariablesExpansionLoopConfig;
import com.dataiku.dip.datasets.sql.ExternalSQLDatasetTestHandler;
import com.dataiku.dip.datasets.sql.ManagedSQLTableDatasetTestHandler;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.hive.HiveConfigurator;
import com.dataiku.dip.hive.HiveServer2ConnectionPoolService;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.input.InputSplitProgressListener;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.row.RowOrientedDatasetHandler;
import com.dataiku.dip.input.row.RowsInputSplit;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.TimeDimension;
import com.dataiku.dip.recipes.code.hive.HiveConfHelper;
import com.dataiku.dip.recipes.code.sql.SQLQueryRecipeUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.variables.VariablesUtils;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.org.eclipse.jetty.io.RuntimeIOException;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractSQLDatasetHandler
implements RowOrientedDatasetHandler {
    protected final AuthCtx authCtx;
    protected final Dataset dataset;
    protected final AbstractSQLConfig resolvedAbstractConfig;
    protected final AbstractSQLConfig rawAbstractConfig;
    private final DatasetHandler.DatasetMeta<?, ?> meta;
    private SQLConnectionProvider.SQLConnectionData lazyConnData;
    private SQLDialect lazyDialect;
    private AbstractSQLConnection lazyConnection;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.datasets.sql");

    public AbstractSQLDatasetHandler(AuthCtx authCtx, Dataset dataset, DatasetHandler.DatasetMeta<?, ?> meta) {
        AbstractSQLConfig abstractConfig;
        this.authCtx = authCtx;
        this.dataset = dataset;
        this.meta = meta;
        this.rawAbstractConfig = abstractConfig = (AbstractSQLConfig)dataset.getParams();
        this.resolvedAbstractConfig = abstractConfig.getResolved(dataset.getProjectKey());
    }

    public SQLConnectionProvider.SQLConnectionData makeConnData() throws DKUSecurityException {
        try {
            return this.getDSSConnection().getConnectionData_NT(this.authCtx, this.dataset.getProjectKey());
        }
        catch (SQLException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    public AuthCtx getAuthCtx() {
        return this.authCtx;
    }

    public AbstractSQLConfig getResolvedAbstractConfig() {
        return this.resolvedAbstractConfig;
    }

    @Override
    public boolean isManaged() {
        return this.dataset.isManaged();
    }

    @Override
    public DatasetHandler.DatasetMeta<?, ?> getMeta() {
        return this.meta;
    }

    @Override
    public void close() {
    }

    @Override
    public final String suggestName() {
        return this.resolvedAbstractConfig.table;
    }

    @Override
    public DatasetReadiness getReadiness(Partition p, @Nullable ComputableHashComputer.ReadinessComputationSession session) {
        if (ApplicationConfigurator.getParams().getBoolParam("flow.force_consider_sql_datasets_ready", false)) {
            logger.info((Object)"Considering SQL dataset as ready (forced by system property)");
            return DatasetReadiness.ready(null);
        }
        try {
            if (this.getDSSConnection().getDkuPropertiesAsParams().getBoolParam("dku.datasets.sql.readiness.force_consider_ready", false)) {
                logger.info((Object)"Considering SQL dataset as ready (forced by connection-level property)");
                return DatasetReadiness.ready(null);
            }
        }
        catch (DKUSecurityException e) {
            throw new RuntimeException("Failed to get connection data", e);
        }
        if (this.dataset.getDkuPropertiesAsParams().getBoolParam("dku.datasets.sql.readiness.force_consider_ready", false)) {
            logger.info((Object)"Considering SQL dataset as ready (forced by dataset-level property)");
            return DatasetReadiness.ready(null);
        }
        DatasetReadiness readiness = this.getSQLReadiness(p, session);
        switch (readiness.status) {
            case ERROR: {
                logger.error((Object)"Dataset readiness could not be properly checked", readiness.error);
                break;
            }
            case NOT_READY: {
                logger.warn((Object)"Dataset is not ready", readiness.error);
                break;
            }
        }
        return readiness;
    }

    protected abstract DatasetReadiness getSQLReadiness(Partition var1, @Nullable ComputableHashComputer.ReadinessComputationSession var2);

    @Override
    public final DatasetTestHandler buildTestHandler() throws IOException {
        if (this.dataset.isManaged()) {
            return new ManagedSQLTableDatasetTestHandler(this.authCtx, this.dataset, this);
        }
        return new ExternalSQLDatasetTestHandler(this.authCtx, this.dataset, this);
    }

    public Map<String, String> getSparkConnectionInfo() {
        HashMap info = Maps.newHashMap(this.resolvedAbstractConfig.getSparkConnectionInfo());
        String prefix = "dku.spark.sql.";
        for (AbstractSQLConnection.CustomDatabaseProperty prop : this.dataset.getModel().dkuProperties) {
            if (!prop.name.startsWith(prefix)) continue;
            info.put(prop.name.substring(prefix.length()), prop.value);
        }
        if (info.containsKey("partitionColumn")) {
            String partitionColumnName = (String)info.get("partitionColumn");
            logger.info((Object)("Spark integration settings define a partitionColumn : " + partitionColumnName));
            SchemaColumn partitionSchemaColumn = this.dataset.getSchema().getColumn(partitionColumnName);
            if (partitionSchemaColumn != null && !partitionSchemaColumn.getType().isNumeric() && partitionSchemaColumn.getType() != Type.DATE) {
                logger.warn((Object)"Spark only handles numeric and date types for the partition column");
            }
            if (partitionSchemaColumn != null && partitionSchemaColumn.getType().isNumeric()) {
                for (String key : new String[]{"lowerBound", "upperBound"}) {
                    if (!info.containsKey(key)) continue;
                    String value = (String)info.get(key);
                    try {
                        long l = Long.parseLong(value);
                        info.put(key, Long.toString(l));
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Value '" + value + "' for " + key + " is not parseable as a long, trying as a double: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                        try {
                            double d = Double.parseDouble(value);
                            info.put(key, Long.toString((long)d));
                        }
                        catch (Exception e2) {
                            logger.warn((Object)("Value '" + value + "' for " + key + "is not parseable as a double, leaving it to Spark: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                            info.put(key, value);
                        }
                    }
                }
            }
            try {
                if (partitionSchemaColumn != null) {
                    logger.info((Object)("Quoting partition column " + partitionColumnName));
                    info.put("partitionColumn", this.getDialect().quoteIdentifier(partitionColumnName));
                }
            }
            catch (DKUSecurityException e) {
                logger.warn((Object)"Unable to quote the partition column, case sensitivity issues can arise", (Throwable)e);
            }
        }
        return info;
    }

    public SQLConnectionProvider.SQLConnectionData getConnectionData() throws DKUSecurityException {
        if (this.lazyConnData == null) {
            this.lazyConnData = this.makeConnData();
        }
        return this.lazyConnData;
    }

    public SQLDialect getDialect() throws DKUSecurityException {
        if (this.lazyDialect == null) {
            this.lazyDialect = this.getDSSConnection().getDialect();
        }
        return this.lazyDialect;
    }

    public AbstractSQLConnection getDSSConnection() throws DKUSecurityException {
        if (this.lazyConnection == null) {
            try {
                ConnectionsDAO.VirtualConnectionId virtualConnection = ConnectionsDAO.parseVirtualConnection(this.resolvedAbstractConfig.connection);
                if (virtualConnection != null) {
                    ArrayList overrides = Lists.newArrayList((Object[])new SimpleKeyValue[]{new SimpleKeyValue("hive.resultset.use.unique.column.names", "false")});
                    List<SimpleKeyValue> hiveconf = new HiveConfHelper().getResolvedHiveRuntimeConf(this.authCtx, this.dataset.getProjectKey(), overrides);
                    HiveServer2ConnectionPoolService hiveserver2ConnectionPoolService = (HiveServer2ConnectionPoolService)SpringUtils.getBean(HiveServer2ConnectionPoolService.class);
                    this.lazyConnection = HiveConfigurator.configureConnectionForDatabase(this.authCtx, virtualConnection.db, hiveconf, hiveserver2ConnectionPoolService);
                } else {
                    this.lazyConnection = SQLConnectionProvider.getDSSConnection(this.authCtx, this.resolvedAbstractConfig.connection);
                }
            }
            catch (IOException | SQLException e) {
                throw new DKUSecurityException("Unable to get SQL connection for dataset", (Throwable)e);
            }
        }
        return this.lazyConnection;
    }

    public void forceDSSConnection(AbstractSQLConnection connection) {
        this.lazyConnection = connection;
    }

    public SQLConnectionProvider.SQLConnectionWrapper newConnection() throws SQLException, DKUSecurityException, InterruptedException {
        return SQLConnectionProvider.newConnection(this.getConnectionData(), this.authCtx, this.dataset.getProjectKey());
    }

    public String getConnectionName() {
        return this.resolvedAbstractConfig.connection;
    }

    /*
     * Exception decompiling
     */
    protected long executePush(SQLConnectionProvider.SQLConnectionWrapper conn, String query, ProcessorOutput out, ColumnFactory cf, RowFactory rf, @Nullable ExtractionLimit limit, InputSplitProgressListener listener, WarningsContext warningsContext, boolean columnsMatter) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getVerticaSessionId(SQLConnectionProvider.SQLConnectionWrapper conn) throws SQLException {
        try (Statement st2 = conn.createStatement();){
            st2.execute("select session_id from current_session");
            ResultSet rs2 = st2.getResultSet();
            rs2.next();
            String string = rs2.getString("session_id");
            return string;
        }
    }

    /*
     * Exception decompiling
     */
    protected List<Partition> listPartitionsWithQuery(String listingQuery) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 22[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected List<Partition> gatherPartitionsFromResultSet(ResultSet rs2, SQLDialect dialect) throws SQLException, DataStoreIOException {
        ArrayList<Partition> res = new ArrayList<Partition>();
        HashMap<String, Type> readAsByDimensionName = new HashMap<String, Type>();
        HashMap<String, Integer> sqlTypeByDimensionName = new HashMap<String, Integer>();
        HashMap<String, Integer> colIdxByDimensionName = new HashMap<String, Integer>();
        ResultSetMetaData rsmd = rs2.getMetaData();
        for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
            String name = rsmd.getColumnName(i);
            Dimension dim = this.dataset.getPartitioningSchema().getDimension(name);
            if (dim == null) continue;
            SchemaColumn equivalentColumn = dialect.fromSQLType(name, rsmd.getColumnType(i), rsmd.getColumnTypeName(i), rsmd.getPrecision(i), rsmd.getScale(i), ReadTemporalMode.AS_IS, ReadTemporalMode.AS_IS);
            readAsByDimensionName.put(name, equivalentColumn.getType());
            sqlTypeByDimensionName.put(name, rsmd.getColumnType(i));
            colIdxByDimensionName.put(name, i);
        }
        long nbPartitions = 0L;
        while (rs2.next()) {
            if (++nbPartitions > MAX_PARTITIONS) {
                throw new DataStoreIOException("Maximum number of partitions has been reached (current limit is " + MAX_PARTITIONS + " partitions).");
            }
            Partition part = new Partition(this.dataset.getPartitioningSchema());
            for (String dimensionName : this.dataset.getPartitioningSchema().getDimensionNames()) {
                Dimension dim = this.dataset.getPartitioningSchema().getDimension(dimensionName);
                Type readAs = (Type)readAsByDimensionName.get(dimensionName);
                String p = null;
                if (readAs != null && readAs.isTemporal() && dim instanceof TimeDimension) {
                    TimeDimension timeDimension = (TimeDimension)dim;
                    SchemaColumn schemaColumn = new SchemaColumn(dimensionName, readAs);
                    String dssString = dialect.getValueAsDSSString(rs2, (Integer)sqlTypeByDimensionName.get(dimensionName), (Integer)colIdxByDimensionName.get(dimensionName), schemaColumn, false, false, null);
                    if (StringUtils.isBlank((String)dssString)) {
                        throw ErrorContext.iae((String)("One of the partition values for " + this.dataset.getFullName() + " is null or empty, unsupported"));
                    }
                    p = this.formatTimeDimensionPartitionString(dssString, timeDimension);
                } else {
                    p = rs2.getString(dimensionName);
                    if (StringUtils.isBlank((String)p)) {
                        throw ErrorContext.iae((String)("One of the partition values for " + this.dataset.getFullName() + " is null or empty, unsupported"));
                    }
                }
                DimensionValue value = this.dataset.getPartitioningSchema().getDimension(dimensionName).getValueFromId(p);
                part.setDimensionValue(dimensionName, value);
            }
            res.add(part);
        }
        return res;
    }

    private String formatTimeDimensionPartitionString(String rawString, TimeDimension dim) {
        return switch (dim.mappedPeriod) {
            default -> throw new IncompatibleClassChangeError();
            case TimeDimension.Period.YEAR -> rawString.substring(0, 4);
            case TimeDimension.Period.MONTH -> rawString.substring(0, 4) + "-" + rawString.substring(5, 7);
            case TimeDimension.Period.DAY -> rawString.substring(0, 4) + "-" + rawString.substring(5, 7) + "-" + rawString.substring(8, 10);
            case TimeDimension.Period.HOUR -> rawString.substring(0, 4) + "-" + rawString.substring(5, 7) + "-" + rawString.substring(8, 10) + "-" + rawString.substring(11, 13);
        };
    }

    @Override
    public boolean executeFastPostCreateOperations() throws IOException {
        return false;
    }

    @Override
    public void executePreRenameOperations() {
    }

    @Override
    public boolean isParallelWritable() throws Exception {
        return this.getMeta().isParallelWritable(this.dataset.getModel().readWriteOptions);
    }

    protected abstract RowsInputSplit getHasDataSplit() throws Exception;

    private static /* synthetic */ boolean lambda$executePush$1(List columnNames, List columns, int i) {
        return StringUtils.equals((String)((String)columnNames.get(i)), (String)((String)columnNames.get(i + columns.size())));
    }

    private static /* synthetic */ String lambda$executePush$0(ResultSetMetaData rsmd, int i) {
        try {
            return rsmd.getColumnName(i);
        }
        catch (SQLException e) {
            return "";
        }
    }

    public static class AbstractSQLConfig
    implements DatasetHandler.DatasetParams {
        private static final long serialVersionUID = -1L;
        public String connection;
        public boolean notReadyIfEmpty;
        public String mode;
        public String partitioningType = "custom";
        public String explicitPartitionsList;
        public boolean normalizeDoubles = true;
        public String query;
        public String partitionsQuery;
        public String previewPartition;
        public String catalog;
        public String table;
        public String schema;
        public String tableCreationMode = "auto";
        public String customCreateStatement;
        public String customPreWriteStatements;
        public String customPostWriteStatements;
        public int writeInsertBatchSize;
        public boolean writeDescriptionsAsSQLComment = false;
        public AbstractSQLConnection.SqlCommentSynchronizationStatus writeDatasetDescriptionAsSQLComment;
        public AbstractSQLConnection.SqlCommentSynchronizationStatus writeColumnDescriptionsAsSQLComment;
        public boolean noDropOnSchemaMismatch = false;
        public WriteJDBCBadDataBehavior writeJDBCBadDataBehavior = WriteJDBCBadDataBehavior.DISCARD_ROW;
        public ReadTemporalMode datetimenotzReadMode = ReadTemporalMode.AS_IS;
        public ReadTemporalMode dateonlyReadMode = ReadTemporalMode.AS_IS;
        private String assumedTzForUnknownTz;
        public VariablesExpansionLoopConfig variablesExpansionLoopConfig = new VariablesExpansionLoopConfig();
        public SparkJDBCFastPathMode sparkJdbcAccess = SparkJDBCFastPathMode.NONE;
        public int numPartitions = -1;
        public String partitionColumn;
        public String lowerBound;
        public String upperBound;

        public AbstractSQLConfig() {
            this.writeInsertBatchSize = this.getDefaultWriteInsertBatchSize();
        }

        public boolean hasWriteDatasetDescriptionAsSQLCommentEnabled(AbstractSQLConnection connection) {
            if (this.writeDatasetDescriptionAsSQLComment == AbstractSQLConnection.SqlCommentSynchronizationStatus.INHERIT) {
                if (connection == null) {
                    return false;
                }
                return connection.getParams().writeDatasetDescriptionAsSQLComment;
            }
            return this.writeDatasetDescriptionAsSQLComment == AbstractSQLConnection.SqlCommentSynchronizationStatus.ENABLED;
        }

        public boolean hasWriteColumnDescriptionsAsSQLCommentEnabled(AbstractSQLConnection connection) {
            if (this.writeColumnDescriptionsAsSQLComment == AbstractSQLConnection.SqlCommentSynchronizationStatus.INHERIT) {
                if (connection == null) {
                    return false;
                }
                return connection.getParams().writeColumnDescriptionsAsSQLComment;
            }
            return this.writeColumnDescriptionsAsSQLComment == AbstractSQLConnection.SqlCommentSynchronizationStatus.ENABLED;
        }

        public int getDefaultWriteInsertBatchSize() {
            return 10000;
        }

        public boolean supportsInsertWithPreparedStatement() {
            return true;
        }

        public void setAssumedJavaTzForUnknownTz(String assumedTzForUnknownTz) {
            this.assumedTzForUnknownTz = assumedTzForUnknownTz;
        }

        public String getAssumedJavaTzForUnknownTz() {
            if (this.assumedTzForUnknownTz == null || this.assumedTzForUnknownTz.length() == 0) {
                return DateTimeZone.getDefault().getID();
            }
            return this.assumedTzForUnknownTz;
        }

        public String getAssumedDBTzForUnknownTz() {
            return this.getAssumedJavaTzForUnknownTz();
        }

        public AbstractSQLConfig getResolved(String projectKey) {
            return (AbstractSQLConfig)VariablesUtils.expandObjectFieldsAllowUnresolved(projectKey, this, new String[]{"connection", "query", "partitionsQuery", "previewPartition", "catalog", "table", "schema", "customCreateStatement", "customPreWriteStatements", "customPostWriteStatements", "assumedTzForUnknownTz"});
        }

        @Override
        public String getConnection() {
            return this.connection;
        }

        @Override
        public boolean isNotReadyIfEmpty() {
            return this.notReadyIfEmpty;
        }

        public InfoMessage.InfoMessages canHaveSparkIntegration(Boolean readOrWrite) {
            InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
            if (!"table".equals(this.mode)) {
                ret.withFatal((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "Datasets in " + this.mode + " mode cannot be used directly from Spark");
            } else if (readOrWrite == null && !this.sparkJdbcAccess.canReadOrWrite()) {
                ret.withFatal((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "Spark direct jdbc read/write is disabled on the dataset");
            } else if (readOrWrite != null && readOrWrite.booleanValue() && !this.sparkJdbcAccess.canRead()) {
                ret.withFatal((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "Spark direct jdbc read is disabled on the dataset");
            } else if (readOrWrite != null && !readOrWrite.booleanValue() && !this.sparkJdbcAccess.canWrite()) {
                ret.withFatal((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "Spark direct jdbc write is disabled on the dataset");
            }
            return ret;
        }

        public Map<String, String> getSparkConnectionInfo() {
            HashMap info = Maps.newHashMap();
            if (this.sparkJdbcAccess.canRead() || this.sparkJdbcAccess.canWrite()) {
                if (StringUtils.isNotBlank((String)this.partitionColumn)) {
                    info.put("partitionColumn", this.partitionColumn);
                    if (StringUtils.isNotBlank((String)this.lowerBound) && StringUtils.isNotBlank((String)this.upperBound)) {
                        info.put("upperBound", this.upperBound);
                        info.put("lowerBound", this.lowerBound);
                    }
                }
                if (this.numPartitions != 0) {
                    info.put("numPartitions", Integer.toString(this.numPartitions));
                }
                if (this.writeInsertBatchSize > 0) {
                    info.put("batchSize", Integer.toString(this.writeInsertBatchSize));
                }
            }
            return info;
        }

        public static enum WriteJDBCBadDataBehavior {
            ERROR,
            DISCARD_CELL,
            DISCARD_ROW;

        }
    }

    private class VerticaQueryAborter
    extends QueryAborter {
        private String sessionId;

        VerticaQueryAborter(SQLConnectionProvider.SQLConnectionData connData, String sessionId, Statement s) {
            super(connData, s);
            this.sessionId = sessionId;
        }

        @Override
        public void run() {
            super.run();
            try {
                logger.info((Object)("Vertica: Sending manual additional abort on session " + this.sessionId));
                try (SQLConnectionProvider.SQLConnectionWrapper auxiliaryConn = SQLConnectionProvider.newConnection(this.connectionData, AbstractSQLDatasetHandler.this.authCtx, AbstractSQLDatasetHandler.this.dataset.getProjectKey());
                     Statement st2 = auxiliaryConn.createStatement();){
                    st2.execute("select statement_id from sessions where session_id='" + this.sessionId + "';");
                    ResultSet rs2 = st2.getResultSet();
                    if (rs2.next()) {
                        long statementId = rs2.getLong("statement_id");
                        logger.infoV("Exuecuting INTERRUPT_STATEMENT on sess=%s st=%s", new Object[]{this.sessionId, statementId});
                        st2.execute("select interrupt_statement('" + this.sessionId + "', " + statementId + ")");
                    } else {
                        logger.warn((Object)("Did not find an interruptible statement on session " + this.sessionId));
                    }
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Vertica:Aborting the query failed.", (Throwable)ex);
            }
        }
    }

    private class MySQLQueryAborter
    extends QueryAborter {
        private final SQLConnectionProvider.SQLConnectionWrapper conn;

        MySQLQueryAborter(SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, Statement s) {
            super(connData, s);
            this.conn = conn;
        }

        @Override
        public void run() {
            super.run();
            SQLQueryRecipeUtils.killMySQLConnection(this.connectionData, this.conn, AbstractSQLDatasetHandler.this.authCtx, AbstractSQLDatasetHandler.this.dataset.getProjectKey());
        }
    }

    private static class QueryAborter
    implements Runnable {
        protected Statement s;
        protected SQLConnectionProvider.SQLConnectionData connectionData;

        QueryAborter(SQLConnectionProvider.SQLConnectionData connData, Statement s) {
            this.s = s;
            this.connectionData = connData;
        }

        @Override
        public void run() {
            try {
                logger.info((Object)("Stopping the current query (s=" + String.valueOf(this.s) + ")"));
                this.s.cancel();
            }
            catch (SQLException ex) {
                logger.error((Object)"Aborting the query failed.", (Throwable)ex);
            }
        }
    }

    public static enum ReadTemporalMode {
        AS_IS,
        AS_DATE,
        AS_STRING;

    }

    public static enum SparkJDBCFastPathMode {
        NONE(false, false),
        READ(true, false),
        WRITE(false, true),
        READ_WRITE(true, true);

        private final boolean read;
        private final boolean write;

        private SparkJDBCFastPathMode(boolean read, boolean write) {
            this.read = read;
            this.write = write;
        }

        public boolean canReadOrWrite() {
            return this.read || this.write;
        }

        public boolean canRead() {
            return this.read;
        }

        public boolean canWrite() {
            return this.write;
        }
    }
}

