/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.datamodel.actual;

import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.badges.TypeBadge;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.PublishedApiServicePackageInfo;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractAPIServiceDeployment;
import com.dataiku.dip.deployer.apideployer.published.PublishedAPIServicesService;
import com.dataiku.dip.deployer.common.DeployerCodes;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractDeploymentHeavyStatus;
import com.dataiku.dip.deployer.common.datamodel.actual.DeploymentHealth;
import com.dataiku.dip.deployer.common.datamodel.actual.PublishedPackageInfo;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.lambda.model.serverconfig.GenerationsMapping;
import com.dataiku.lambda.model.serverconfig.LambdaEndpointConfig;
import com.dataiku.lambda.model.studioconfig.ApiEndpointQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public abstract class APIServiceDeploymentHeavyStatus
extends AbstractDeploymentHeavyStatus {
    public List<PublishedPackageInfo> packages = new ArrayList<PublishedPackageInfo>();
    public List<EndpointSummary> endpoints = new ArrayList<EndpointSummary>();

    protected APIServiceDeploymentHeavyStatus() {
    }

    protected APIServiceDeploymentHeavyStatus(String deploymentId, String infraId) {
        super(deploymentId, infraId);
    }

    public List<EndpointSummary> summarizeEndpoints_NT(AbstractAPIServiceDeployment deployment, boolean withPackageExtraInfo) throws NotFoundException {
        Optional<PublishedPackageInfo> packageInfoOpt;
        ArrayList<EndpointSummary> packageEndpoints = new ArrayList<EndpointSummary>();
        if (deployment.generationsMapping == null) {
            InfoMessage message = InfoMessage.error((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_INVALID_GENERATIONS_MAPPING, (String)"No active version configured in this deployment.");
            this.setMessageAndHealthWithSeverity(message, DeploymentHealth.ERROR);
            return packageEndpoints;
        }
        if (this.packages.isEmpty()) {
            this.healthMessages.withError((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_INVALID_GENERATIONS_MAPPING, "The deployment's service has no versions.");
            return packageEndpoints;
        }
        this.packages.sort((o1, o2) -> -o1.id.compareTo(o2.id));
        if (deployment.generationsMapping.getMode() == GenerationsMapping.GenerationsMappingMode.MULTI_GENERATION) {
            this.healthMessages.withInfo((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_MULTI_GENERATION_DEPLOYMENT, "Endpoints from the most recent service version will be displayed.");
        }
        if ((packageInfoOpt = this.packages.stream().filter(p -> deployment.generationsMapping.isUsed(p.id)).findFirst()).isEmpty()) {
            InfoMessage message = InfoMessage.error((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_INVALID_GENERATIONS_MAPPING, (String)"No included service version is selected as an active generation.");
            this.setMessageAndHealthWithSeverity(message, DeploymentHealth.ERROR);
            return packageEndpoints;
        }
        PublishedApiServicePackageInfo packageInfo = (PublishedApiServicePackageInfo)packageInfoOpt.get();
        for (LambdaEndpointConfig lec : packageInfo.endpoints) {
            EndpointSummary es = new EndpointSummary();
            es.id = lec.id;
            es.type = lec.type;
            es.tags = lec.tags;
            es.typeBadges = lec.typeBadges;
            if (withPackageExtraInfo) {
                PublishedAPIServicesService publishedAPIServicesService = (PublishedAPIServicesService)SpringUtils.getBean(PublishedAPIServicesService.class);
                List<ApiEndpointQuery> originalTestQueries = publishedAPIServicesService.readTestQueries_NT(deployment.publishedServiceId, packageInfo.id, lec.id);
                if (originalTestQueries != null) {
                    es.testQueries = originalTestQueries.stream().map(testQuery -> this.adaptQueryForInfraType((ApiEndpointQuery)testQuery, es.type)).collect(Collectors.toList());
                }
                if (lec.hasCustomCode()) {
                    es.code = publishedAPIServicesService.readCode_NT(deployment.publishedServiceId, packageInfo.id, lec);
                }
            }
            packageEndpoints.add(es);
        }
        if (packageEndpoints.isEmpty()) {
            InfoMessage message = InfoMessage.warning((InfoMessage.MessageCode)DeployerCodes.WARN_API_DEPLOYER_SERVICE_VERSION_HAS_NO_ENDPOINTS, (String)"No endpoints in the service version specified in deployment settings.");
            this.setMessageAndHealthWithSeverity(message, DeploymentHealth.WARNING);
        }
        return packageEndpoints;
    }

    public ApiEndpointQuery adaptQueryForInfraType(ApiEndpointQuery query, LambdaEndpointConfig.EndpointType endpointType) {
        return query;
    }

    public static class EndpointSummary {
        public LambdaEndpointConfig.EndpointType type;
        public String id;
        public List<ApiEndpointQuery> testQueries = new ArrayList<ApiEndpointQuery>();
        @Nullable
        public String code;
        public PredictionMLTask.PredictionType predictionType;
        public List<String> tags = new ArrayList<String>();
        public List<TypeBadge> typeBadges = new ArrayList<TypeBadge>();
    }
}

