/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.datamodel.actual.snowpark;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.AbstractFullyManagedStatusReporter;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.DeploymentStatusReport;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.snowpark.SnowparkDeploymentLocalSummary;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.snowpark.SnowparkDeploymentRemoteSummary;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.snowpark.comparator.SnowparkDetailedServiceComparator;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.snowpark.comparator.SnowparkServiceComparator;
import com.dataiku.dip.deployer.common.DeployerCodes;
import com.dataiku.dip.deployer.common.datamodel.actual.DeploymentHealth;
import com.dataiku.dip.deployer.common.datamodel.actual.DeploymentResourceComparator;
import com.dataiku.dip.externalinfras.snowpark.datamodel.SnowparkDeployedEndpoint;
import com.dataiku.dip.externalinfras.snowpark.datamodel.SnowparkDeployedUserFunction;
import com.dataiku.dip.externalinfras.snowpark.datamodel.SnowparkDetailedService;
import com.dataiku.dip.externalinfras.snowpark.datamodel.SnowparkService;
import com.dataiku.dip.externalinfras.snowpark.datamodel.SnowparkServiceStatus;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.utils.StringUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SnowparkDeploymentStatusReporter
extends AbstractFullyManagedStatusReporter {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.deployment.actual.snowpark.status-reporter");

    public SnowparkDeploymentStatusReporter(String infraId, String deploymentId) {
        super(infraId, deploymentId);
    }

    public DeploymentStatusReport computeFullCheck(@Nonnull SnowparkDeploymentLocalSummary localSummary, @Nonnull SnowparkDeploymentRemoteSummary remoteSummary, boolean isDeploymentEnabled) {
        DeploymentStatusReport fullStatusReport = new DeploymentStatusReport(this.deploymentId, this.infraId);
        fullStatusReport.statusMessages.mergeFrom(this.checkDetailedServiceSync(localSummary.service, remoteSummary.service));
        fullStatusReport.statusMessages.mergeFrom(this.checkEndpointSync(localSummary.endpointUrl, remoteSummary.endpoint));
        if (!fullStatusReport.statusMessages.isEmpty()) {
            fullStatusReport.isOutOfSync = true;
            fullStatusReport.setHealthWithSeverity(DeploymentHealth.OUT_OF_SYNC);
        }
        Pair<DeploymentHealth, InfoMessage.InfoMessages> udfStatusReport = this.checkUdfHealth(localSummary.udfName, remoteSummary.udf, isDeploymentEnabled);
        fullStatusReport.statusMessages.mergeFrom((InfoMessage.InfoMessages)udfStatusReport.second);
        fullStatusReport.setHealthWithSeverity((DeploymentHealth)((Object)udfStatusReport.first));
        Pair<DeploymentHealth, InfoMessage.InfoMessages> endpointStatusReport = this.checkServiceHealth(localSummary.service, remoteSummary.service, isDeploymentEnabled);
        fullStatusReport.statusMessages.mergeFrom((InfoMessage.InfoMessages)endpointStatusReport.second);
        fullStatusReport.setHealthWithSeverity((DeploymentHealth)((Object)endpointStatusReport.first));
        Pair<DeploymentHealth, InfoMessage.InfoMessages> serviceStatusReport = SnowparkDeploymentStatusReporter.checkServiceStatusesHealth(remoteSummary.serviceStatuses);
        fullStatusReport.statusMessages.mergeFrom((InfoMessage.InfoMessages)serviceStatusReport.second);
        fullStatusReport.setHealthWithSeverity((DeploymentHealth)((Object)serviceStatusReport.first));
        return fullStatusReport;
    }

    private Pair<DeploymentHealth, InfoMessage.InfoMessages> checkServiceHealth(@Nullable SnowparkService localService, @Nullable SnowparkService remoteService, boolean isDeploymentEnabled) {
        String serviceName;
        InfoMessage.InfoMessages serviceHealthMessages = new InfoMessage.InfoMessages();
        DeploymentHealth serviceHealth = DeploymentHealth.HEALTHY;
        boolean exists = !Objects.isNull(remoteService);
        boolean serviceShouldExist = !Objects.isNull(localService);
        String string = serviceName = serviceShouldExist ? localService.name : "";
        if (isDeploymentEnabled) {
            if (serviceShouldExist && !exists) {
                String message = "Service '%s' is not present in Snowpark. Updating the deployment should create it.";
                logger.warnV(message, new Object[]{serviceName});
                serviceHealth = DeploymentHealth.UNHEALTHY;
                serviceHealthMessages.withErrorV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_MISSING_RESOURCE_CONFIG, message, new Object[]{serviceName});
            } else if (!serviceShouldExist && !exists) {
                serviceHealth = DeploymentHealth.OUT_OF_SYNC;
                serviceHealthMessages.withWarningV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_DEPLOYMENT_INCOMPLETE, "The deployment is incomplete.", new Object[0]);
            }
        } else if (exists) {
            serviceHealthMessages.withWarning((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_OUT_OF_SYNC_CONFIG, String.format("The deployment is disabled but the Snowpark service '%s' is running. Update your deployment to completely disable it.", serviceName));
            serviceHealth = DeploymentHealth.OUT_OF_SYNC;
        } else {
            serviceHealth = DeploymentHealth.DISABLED;
            serviceHealthMessages.withInfo((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_FULLY_MANAGED_DISABLED_DEPLOYMENT, "Update the deployment settings in order to enable it again.");
        }
        return new Pair((Object)serviceHealth, (Object)serviceHealthMessages);
    }

    private Pair<DeploymentHealth, InfoMessage.InfoMessages> checkUdfHealth(@Nullable String localUdfName, @Nullable SnowparkDeployedUserFunction remoteUdf, boolean isDeploymentEnabled) {
        String udfName;
        InfoMessage.InfoMessages udfHealthMessages = new InfoMessage.InfoMessages();
        DeploymentHealth udfHealth = DeploymentHealth.HEALTHY;
        boolean exists = !Objects.isNull(remoteUdf);
        boolean udfShouldExist = !Objects.isNull(localUdfName);
        String string = udfName = localUdfName != null ? localUdfName : "";
        if (isDeploymentEnabled) {
            if (udfShouldExist && !exists) {
                String message = "UDF '%s' is not present in Snowpark. Updating the deployment should create it.";
                logger.warnV(message, new Object[]{udfName});
                udfHealth = DeploymentHealth.UNHEALTHY;
                udfHealthMessages.withErrorV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_MISSING_RESOURCE_CONFIG, message, new Object[]{udfName});
            } else if (!udfShouldExist && !exists) {
                udfHealth = DeploymentHealth.OUT_OF_SYNC;
                udfHealthMessages.withWarningV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_DEPLOYMENT_INCOMPLETE, "The deployment is incomplete.", new Object[0]);
            }
        } else if (exists) {
            udfHealthMessages.withWarning((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_OUT_OF_SYNC_CONFIG, String.format("The deployment is disabled but the Snowpark UDF '%s' exists. Update your deployment to completely disable it.", udfName));
            udfHealth = DeploymentHealth.OUT_OF_SYNC;
        } else {
            udfHealth = DeploymentHealth.DISABLED;
            udfHealthMessages.withInfo((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_FULLY_MANAGED_DISABLED_DEPLOYMENT, "Update the deployment settings in order to enable it again.");
        }
        return new Pair((Object)udfHealth, (Object)udfHealthMessages);
    }

    public static Pair<DeploymentHealth, InfoMessage.InfoMessages> checkServiceStatusesHealth(@Nullable List<SnowparkServiceStatus> statuses) {
        SnowparkServiceStatus status = SnowparkServiceStatus.getWorse(statuses);
        if (status == null) {
            DeploymentHealth health = DeploymentHealth.WARNING;
            InfoMessage.InfoMessages healthMessages = new InfoMessage.InfoMessages().withWarningV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_SNOWPARK_ERROR, "Impossible to fetch service status.", new Object[0]);
            return new Pair((Object)health, (Object)healthMessages);
        }
        if (status.status.equalsIgnoreCase("FAILED")) {
            DeploymentHealth health = DeploymentHealth.ERROR;
            InfoMessage.InfoMessages healthMessages = new InfoMessage.InfoMessages().withErrorV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_SNOWPARK_UNHEALTHY_SERVICE, status.message, new Object[0]);
            return new Pair((Object)health, (Object)healthMessages);
        }
        if (status.status.equalsIgnoreCase("UNKNOWN")) {
            DeploymentHealth health = DeploymentHealth.UNKNOWN;
            InfoMessage.InfoMessages healthMessages = new InfoMessage.InfoMessages().withWarningV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_SNOWPARK_UNHEALTHY_SERVICE, status.message, new Object[0]);
            return new Pair((Object)health, (Object)healthMessages);
        }
        if (status.status.equalsIgnoreCase("PENDING")) {
            DeploymentHealth health = DeploymentHealth.WARNING;
            InfoMessage.InfoMessages healthMessages = new InfoMessage.InfoMessages().withWarningV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_SNOWPARK_UNHEALTHY_SERVICE, status.message, new Object[0]);
            return new Pair((Object)health, (Object)healthMessages);
        }
        if (!status.status.equalsIgnoreCase("READY")) {
            DeploymentHealth health = DeploymentHealth.WARNING;
            InfoMessage.InfoMessages healthMessages = new InfoMessage.InfoMessages().withWarningV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_SNOWPARK_UNHEALTHY_SERVICE, status.message, new Object[0]);
            return new Pair((Object)health, (Object)healthMessages);
        }
        DeploymentHealth health = DeploymentHealth.HEALTHY;
        InfoMessage.InfoMessages healthMessages = new InfoMessage.InfoMessages();
        return new Pair((Object)health, (Object)healthMessages);
    }

    private InfoMessage.InfoMessages checkServiceSync(@Nullable SnowparkService localService, @Nullable SnowparkService remoteService) {
        InfoMessage.InfoMessages serviceSyncMessages = new InfoMessage.InfoMessages();
        if (localService != null && remoteService != null) {
            SnowparkServiceComparator endpointComparator = new SnowparkServiceComparator(localService);
            if (endpointComparator.isOutOfSync(remoteService)) {
                for (String outOfSyncField : endpointComparator.reportOutOfSyncFields(remoteService)) {
                    logger.warnV("Snowpark service %s out of sync. %s", new Object[]{localService.name, outOfSyncField});
                    serviceSyncMessages.withWarningV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_OUT_OF_SYNC_CONFIG, outOfSyncField, new Object[0]);
                }
            } else {
                logger.debugV("Snowpark service %s is synchronized.", new Object[]{localService.name});
            }
        }
        return serviceSyncMessages;
    }

    private InfoMessage.InfoMessages checkDetailedServiceSync(@Nullable SnowparkDetailedService localService, @Nullable SnowparkDetailedService remoteService) {
        InfoMessage.InfoMessages serviceSyncMessages = new InfoMessage.InfoMessages();
        if (localService != null && remoteService != null) {
            SnowparkDetailedServiceComparator endpointComparator = new SnowparkDetailedServiceComparator(localService);
            if (endpointComparator.isOutOfSync(remoteService)) {
                for (String outOfSyncField : endpointComparator.reportOutOfSyncFields(remoteService)) {
                    logger.warnV("Snowpark service %s out of sync. %s", new Object[]{localService.name, outOfSyncField});
                    serviceSyncMessages.withWarningV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_OUT_OF_SYNC_CONFIG, outOfSyncField, new Object[0]);
                }
            } else {
                logger.debugV("Snowpark service %s is synchronized.", new Object[]{localService.name});
            }
        }
        return serviceSyncMessages;
    }

    private InfoMessage.InfoMessages checkEndpointSync(@Nullable String localEndpointUrl, @Nullable SnowparkDeployedEndpoint remoteEndpoint) {
        String remoteUrl;
        InfoMessage.InfoMessages endpointSyncMessages = new InfoMessage.InfoMessages();
        HashSet<String> outOfSyncFields = new HashSet<String>();
        String string = remoteUrl = remoteEndpoint != null ? remoteEndpoint.ingressUrl : null;
        if (!StringUtils.equalsOrBothBlank((String)remoteUrl, (String)localEndpointUrl)) {
            outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Endpoint URL", remoteUrl, localEndpointUrl));
        }
        if (!outOfSyncFields.isEmpty()) {
            for (String outOfSyncField : outOfSyncFields) {
                logger.warnV(outOfSyncField, new Object[0]);
                endpointSyncMessages.withWarningV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_OUT_OF_SYNC_CONFIG, outOfSyncField, new Object[0]);
            }
        } else {
            logger.debugV("Snowpark endpoint URL %s is synchronized.", new Object[]{localEndpointUrl});
        }
        return endpointSyncMessages;
    }
}

