/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.datamodel.actual.vertexai;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.AbstractFullyManagedStatusReporter;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.DeploymentStatusReport;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.vertexai.VertexAIDeploymentLocalSummary;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.vertexai.VertexAIDeploymentRemoteSummary;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.vertexai.comparator.VertexAIDeployedModelComparator;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.vertexai.comparator.VertexAIEndpointComparator;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.vertexai.comparator.VertexAIModelComparator;
import com.dataiku.dip.deployer.common.DeployerCodes;
import com.dataiku.dip.deployer.common.datamodel.actual.DeploymentHealth;
import com.dataiku.dip.externalinfras.vertexai.VertexAIUtils;
import com.dataiku.dip.externalinfras.vertexai.datamodel.VertexAIDeployedModel;
import com.dataiku.dip.externalinfras.vertexai.datamodel.VertexAIEndpoint;
import com.dataiku.dip.externalinfras.vertexai.datamodel.VertexAIModel;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.DeployedModel;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.Endpoint;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.Model;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class VertexAIDeploymentStatusReporter
extends AbstractFullyManagedStatusReporter {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.deployment.actual.vertex_ai.status-reporter");

    public VertexAIDeploymentStatusReporter(String deploymentId, String infraId) {
        super(deploymentId, infraId);
    }

    private DeploymentStatusReport computeBasicOutOfSyncCheck(@Nonnull VertexAIDeploymentLocalSummary localSummary, @Nullable Endpoint remoteEndpoint) {
        DeploymentStatusReport basicStatusReport = new DeploymentStatusReport(this.deploymentId, this.infraId);
        basicStatusReport.statusMessages.mergeFrom(this.checkEndpointSync(localSummary.endpoint, remoteEndpoint));
        String expectedModelName = localSummary.model != null ? localSummary.model.getFullName() : "";
        basicStatusReport.statusMessages.mergeFrom(this.checkDeployedModelSync(localSummary.deployedModel, remoteEndpoint, expectedModelName));
        if (!basicStatusReport.statusMessages.isEmpty()) {
            basicStatusReport.isOutOfSync = true;
            basicStatusReport.setHealthWithSeverity(DeploymentHealth.OUT_OF_SYNC);
        }
        return basicStatusReport;
    }

    public DeploymentStatusReport computeBasicCheck(@Nonnull VertexAIDeploymentLocalSummary localSummary, @Nullable Endpoint remoteEndpoint, boolean isDeploymentEnabled) {
        DeploymentStatusReport basicStatusReport = this.computeBasicOutOfSyncCheck(localSummary, remoteEndpoint);
        Pair<DeploymentHealth, InfoMessage.InfoMessages> endpointStatusReport = this.checkEndpointHealth(localSummary.endpoint, localSummary.deployedModel, remoteEndpoint, isDeploymentEnabled);
        basicStatusReport.statusMessages.mergeFrom((InfoMessage.InfoMessages)endpointStatusReport.second);
        basicStatusReport.setHealthWithSeverity((DeploymentHealth)((Object)endpointStatusReport.first));
        return basicStatusReport;
    }

    public DeploymentStatusReport computeFullCheck(VertexAIDeploymentLocalSummary localSummary, VertexAIDeploymentRemoteSummary remoteSummary, boolean isDeploymentEnabled) {
        DeploymentStatusReport fullStatusReport = this.computeBasicOutOfSyncCheck(localSummary, remoteSummary.endpoint);
        fullStatusReport.statusMessages.mergeFrom(this.checkModelSync(localSummary.model, remoteSummary.model));
        if (!fullStatusReport.statusMessages.isEmpty()) {
            fullStatusReport.isOutOfSync = true;
            fullStatusReport.setHealthWithSeverity(DeploymentHealth.OUT_OF_SYNC);
        }
        Pair<DeploymentHealth, InfoMessage.InfoMessages> endpointStatusReport = this.checkEndpointHealth(localSummary.endpoint, localSummary.deployedModel, remoteSummary.endpoint, isDeploymentEnabled);
        fullStatusReport.statusMessages.mergeFrom((InfoMessage.InfoMessages)endpointStatusReport.second);
        fullStatusReport.setHealthWithSeverity((DeploymentHealth)((Object)endpointStatusReport.first));
        return fullStatusReport;
    }

    private InfoMessage.InfoMessages checkModelSync(@Nullable VertexAIModel localModel, @Nullable Model remoteModel) {
        InfoMessage.InfoMessages modelSyncMessages = new InfoMessage.InfoMessages();
        if (localModel == null) {
            modelSyncMessages.withWarningV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_DEPLOYMENT_INCOMPLETE, "The deployment is incomplete.", new Object[0]);
        } else if (remoteModel == null) {
            String modelId = localModel.getId();
            String missingMessage = "The latest deployed Vertex AI Model with id %s is missing, so it is likely someone has deleted the Vertex AI model manually.";
            logger.warnV(missingMessage, new Object[]{modelId});
            modelSyncMessages.withWarningV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_MISSING_RESOURCE_CONFIG, missingMessage, new Object[]{modelId});
        } else if (new VertexAIModelComparator(localModel).isOutOfSync(remoteModel)) {
            for (String outOfSyncField : new VertexAIModelComparator(localModel).reportOutOfSyncFields(remoteModel)) {
                logger.warnV("Vertex AI model %s out of sync. %s", new Object[]{localModel.getId(), outOfSyncField});
                modelSyncMessages.withWarningV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_OUT_OF_SYNC_CONFIG, outOfSyncField, new Object[0]);
            }
        } else {
            logger.debugV("Vertex AI model %s is synchronized.", new Object[]{localModel.getId()});
        }
        return modelSyncMessages;
    }

    private Pair<DeploymentHealth, InfoMessage.InfoMessages> checkEndpointHealth(@Nullable VertexAIEndpoint localEndpoint, @Nullable VertexAIDeployedModel localDeployedModel, @Nullable Endpoint remoteEndpoint, boolean isDeploymentEnabled) {
        InfoMessage.InfoMessages endpointHealthMessages = new InfoMessage.InfoMessages();
        DeploymentHealth endpointHealth = DeploymentHealth.HEALTHY;
        boolean exists = !Objects.isNull(remoteEndpoint);
        boolean endpointShouldExist = !Objects.isNull(localEndpoint);
        String endpointId = endpointShouldExist ? localEndpoint.getId() : "";
        String deployedModelId = !Objects.isNull(localDeployedModel) ? localDeployedModel.getId() : "";
        Map traffic = !Objects.isNull(remoteEndpoint) ? remoteEndpoint.getTrafficSplitMap() : new HashMap();
        boolean deployedModelShouldExist = StringUtils.isNotBlank((CharSequence)deployedModelId);
        if (isDeploymentEnabled) {
            if (exists && deployedModelShouldExist) {
                int trafficForDefinedDeployedModel = traffic.getOrDefault(deployedModelId, 0);
                Optional<DeployedModel> remoteDeployedModelOpt = VertexAIUtils.getDeployedModel(deployedModelId, remoteEndpoint);
                DeploymentHealth trafficHealth = DeploymentHealth.HEALTHY;
                if (remoteDeployedModelOpt.isEmpty()) {
                    trafficHealth = DeploymentHealth.UNHEALTHY;
                    String message = "Unable to find DeployedModel '%s' in its associated Endpoint. Updating the deployment should delete invalid DeployedModels (if any) and create a new one.";
                    endpointHealthMessages.withErrorV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_MISSING_RESOURCE_CONFIG, message, new Object[]{deployedModelId});
                } else if (trafficForDefinedDeployedModel == 0) {
                    trafficHealth = DeploymentHealth.UNHEALTHY;
                    endpointHealthMessages.withErrorV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_VERTEXAI_ENDPOINT_TRAFFIC, "The traffic configured for the for deployed model '%s' associated to the endpoint '%s' is set to %s%% instead of 100%%.", new Object[]{deployedModelId, endpointId, trafficForDefinedDeployedModel});
                } else if (trafficForDefinedDeployedModel != 100) {
                    trafficHealth = DeploymentHealth.WARNING;
                    endpointHealthMessages.withWarningV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_VERTEXAI_ENDPOINT_TRAFFIC, "The traffic configured for the endpoint '%s' is set to %s%% instead of 100%% for deployed model '%s'.", new Object[]{endpointId, trafficForDefinedDeployedModel, deployedModelId});
                }
                endpointHealth = endpointHealth.getSeverer(trafficHealth);
                for (Map.Entry trafficEntry : traffic.entrySet()) {
                    if (StringUtils.equals((CharSequence)((CharSequence)trafficEntry.getKey()), (CharSequence)deployedModelId)) continue;
                    trafficHealth = DeploymentHealth.WARNING;
                    endpointHealthMessages.withWarningV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_VERTEXAI_ENDPOINT_TRAFFIC, "Unexpected unmanaged deployed model '%s' associated to the endpoint '%s'. Its traffic is set to %s%%. You might be incurring in unnecessary costs.", new Object[]{trafficEntry.getKey(), endpointId, trafficEntry.getValue()});
                }
                endpointHealth = endpointHealth.getSeverer(trafficHealth);
            } else if (!exists && !endpointShouldExist || !deployedModelShouldExist) {
                endpointHealth = DeploymentHealth.OUT_OF_SYNC;
                endpointHealthMessages.withWarningV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_DEPLOYMENT_INCOMPLETE, "The deployment is incomplete.", new Object[0]);
            } else {
                String message = "Endpoint '%s' is not present in Vertex AI. Updating the deployment should create it.";
                logger.warnV(message, new Object[]{endpointId});
                endpointHealth = DeploymentHealth.UNHEALTHY;
                endpointHealthMessages.withErrorV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_MISSING_RESOURCE_CONFIG, message, new Object[]{endpointId});
            }
        } else if (exists && !traffic.isEmpty()) {
            endpointHealthMessages.withWarning((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_OUT_OF_SYNC_CONFIG, String.format("The deployment is disabled but the Vertex AI Endpoint '%s' has a deployed model. Update your deployment to completely disable it.", endpointId));
            endpointHealth = DeploymentHealth.OUT_OF_SYNC;
        } else {
            endpointHealth = DeploymentHealth.DISABLED;
            endpointHealthMessages.withInfo((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_FULLY_MANAGED_DISABLED_DEPLOYMENT, "Update the deployment settings in order to enable it again.");
        }
        return new Pair((Object)endpointHealth, (Object)endpointHealthMessages);
    }

    private InfoMessage.InfoMessages checkEndpointSync(@Nullable VertexAIEndpoint localEndpoint, @Nullable Endpoint remoteEndpoint) {
        InfoMessage.InfoMessages endpointSyncMessages = new InfoMessage.InfoMessages();
        if (localEndpoint != null && remoteEndpoint != null) {
            VertexAIEndpointComparator endpointComparator = new VertexAIEndpointComparator(localEndpoint);
            if (endpointComparator.isOutOfSync(remoteEndpoint)) {
                for (String outOfSyncField : endpointComparator.reportOutOfSyncFields(remoteEndpoint)) {
                    logger.warnV("Vertex AI endpoint %s out of sync. %s", new Object[]{localEndpoint.getId(), outOfSyncField});
                    endpointSyncMessages.withWarningV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_OUT_OF_SYNC_CONFIG, outOfSyncField, new Object[0]);
                }
            } else {
                logger.debugV("Vertex AI endpoint %s is synchronized.", new Object[]{localEndpoint.getId()});
            }
        }
        return endpointSyncMessages;
    }

    private InfoMessage.InfoMessages checkDeployedModelSync(@Nullable VertexAIDeployedModel localDeployedModel, @Nullable Endpoint remoteEndpoint, String expectedModelName) {
        InfoMessage.InfoMessages deployedModelSyncMessages = new InfoMessage.InfoMessages();
        String deployedModelId = localDeployedModel != null ? localDeployedModel.getId() : "";
        Optional<DeployedModel> remoteDeployedModelOpt = VertexAIUtils.getDeployedModel(deployedModelId, remoteEndpoint);
        if (localDeployedModel != null && remoteDeployedModelOpt.isPresent() && StringUtils.isNotBlank((CharSequence)expectedModelName)) {
            DeployedModel remoteDeployedModel = remoteDeployedModelOpt.get();
            if (new VertexAIDeployedModelComparator(localDeployedModel).isOutOfSync(remoteDeployedModel, expectedModelName)) {
                for (String outOfSyncField : new VertexAIDeployedModelComparator(localDeployedModel).reportOutOfSyncFields(remoteDeployedModel, expectedModelName)) {
                    logger.warnV("Vertex AI deployed Model %s out of sync. %s", new Object[]{deployedModelId, outOfSyncField});
                    deployedModelSyncMessages.withWarningV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_OUT_OF_SYNC_CONFIG, outOfSyncField, new Object[0]);
                }
            } else {
                logger.debugV("Vertex AI deployed model %s is synchronized.", new Object[]{remoteDeployedModel.getId()});
            }
        }
        return deployedModelSyncMessages;
    }
}

