/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.deployments;

import com.dataiku.dip.deployer.apideployer.datamodel.config.VertexAIAPIDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.VertexAIAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.deployments.FullyManagedAPIServiceDeploymentConfigManager;
import com.dataiku.dip.utils.CollectorUtils;
import com.dataiku.dip.variables.VariablesContext;
import java.util.AbstractMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class VertexAIDeploymentConfigManager
extends FullyManagedAPIServiceDeploymentConfigManager {
    public static final String TAGS_SANITIZATION_CHARACTER = "-";
    private final VertexAIAPIDeployment deployment;
    private final VertexAIAPIDeploymentInfra infra;
    private static final Pattern SANITIZE_TAG = Pattern.compile("[^a-zA-Z0-9\\-_]");
    private static final int TAG_MAX_LENGTH = 63;

    public VertexAIDeploymentConfigManager(VertexAIAPIDeployment deployment, VertexAIAPIDeploymentInfra infra, VariablesContext vc) {
        super(vc);
        this.deployment = deployment;
        this.infra = infra;
    }

    @Override
    protected VertexAIAPIDeployment getDeployment() {
        return this.deployment;
    }

    @Override
    protected VertexAIAPIDeploymentInfra getInfra() {
        return this.infra;
    }

    @Override
    @Nonnull
    public Map<String, String> prepareTags() {
        return (Map)super.prepareTags().entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<String, String>(this.sanitizeTag((String)entry.getKey()), this.sanitizeTag((String)entry.getValue()))).collect(CollectorUtils.toMap());
    }

    private String sanitizeTag(String tag) {
        String sanitizedTag = SANITIZE_TAG.matcher(tag.toLowerCase()).replaceAll(TAGS_SANITIZATION_CHARACTER);
        return sanitizedTag.substring(0, Math.min(sanitizedTag.length(), 63));
    }
}

