/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.infra;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.deployer.apideployer.datamodel.config.SageMakerAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.infra.ApiNodeInfraManager;
import com.dataiku.dip.deployer.apideployer.monitoring.ActivityMetric;
import com.dataiku.dip.deployer.apideployer.monitoring.SageMakerActivityMetricsFetchingService;
import com.dataiku.dip.deployer.common.DeployerCodes;
import com.dataiku.dip.deployer.common.DeployerUtils;
import com.dataiku.dip.externalinfras.sagemaker.SageMakerUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.SageMakerClient;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class SageMakerInfraManager
implements ApiNodeInfraManager {
    private final SageMakerAPIDeploymentInfra infra;
    @Autowired
    private SageMakerActivityMetricsFetchingService activityMetricsFetchingService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.infra.sagemaker.manager");

    public SageMakerInfraManager(SageMakerAPIDeploymentInfra infra) {
        this.infra = infra;
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    public InfoMessage.InfoMessages checkInfraStatus_NT(AuthCtx authCtx) {
        InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        boolean isMissingRegion = StringUtils.isBlank((String)this.infra.awsRegion);
        if (isMissingRegion) {
            messages.withError((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_SAGEMAKER_MISSING_REGION, "AWS region is empty.");
            return messages;
        }
        try {
            SageMakerClient sageMakerClient = SageMakerUtils.checkAndLoginSageMaker_NT(authCtx, this.infra.authConnection, this.infra.awsRegion, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());
            SageMakerUtils.retrieveEndpointList_NT(sageMakerClient, null, true);
        }
        catch (Exception e) {
            String errorMessage = "SageMaker request failed with error " + String.valueOf(e);
            messages.withFatal((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_SAGEMAKER_ERROR, errorMessage);
            logger.error((Object)errorMessage);
        }
        return messages;
    }

    @Override
    public ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint getActivityMetrics_NT(AuthCtx authCtx, int connectTimeout, int socketTimeout, String overridingConnectionName) {
        return this.activityMetricsFetchingService.getInfraActivityMetrics_NT(authCtx, this.infra, connectTimeout, socketTimeout, overridingConnectionName);
    }
}

