/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.monitoring;

import com.dataiku.dip.deployer.apideployer.monitoring.ActivityMetric;
import com.dataiku.dip.deployer.apideployer.monitoring.DatabricksActivityMetricsFetchingService;
import com.dataiku.dip.deployer.apideployer.monitoring.EndpointOrigin;
import com.dataiku.dip.externalinfras.databricks.DatabricksHTTPClient;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelib.com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class GetEndpointMonitoringMetrics<E extends EndpointOrigin>
implements Callable<Pair<E, ActivityMetric.TimeAndMetricsByTime>> {
    private static final Pattern METRIC_LINE_PATTERN = Pattern.compile("^(\\w+)\\{.*?\\} (\\d+\\.\\d+) (\\d+)$");
    DatabricksHTTPClient client;
    E endpoint;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.monitoring.databricksActivityMetricsFetchingService");

    public GetEndpointMonitoringMetrics(DatabricksHTTPClient client, E endpoint) {
        this.client = client;
        this.endpoint = endpoint;
    }

    @Override
    public Pair<E, ActivityMetric.TimeAndMetricsByTime> call() throws Exception {
        String rawResp = this.client.getEndpointMonitoringMetrics(this.endpoint.getExternalEndpointName());
        ActivityMetric.TimeAndMetricsByTime timeAndMetricsByTime = new ActivityMetric.TimeAndMetricsByTime();
        if (StringUtils.isEmpty((String)rawResp)) {
            logger.infoV("No metrics for %s", new Object[]{this.endpoint.describeForLogs()});
        } else {
            this.parseMetrics(timeAndMetricsByTime, rawResp);
        }
        return new Pair(this.endpoint, (Object)timeAndMetricsByTime);
    }

    @VisibleForTesting
    public void parseMetrics(ActivityMetric.TimeAndMetricsByTime timeAndMetricsByTime, String rawResp) {
        String[] metricLines;
        for (String metricLine : metricLines = rawResp.split("\n")) {
            if (metricLine.startsWith("#")) continue;
            Matcher matcher = METRIC_LINE_PATTERN.matcher(metricLine);
            if (matcher.find()) {
                double value;
                DatabricksActivityMetricsFetchingService.DatabricksMetricTypeMap dbxMetricType;
                String metricNameStr = matcher.group(1);
                try {
                    dbxMetricType = DatabricksActivityMetricsFetchingService.DatabricksMetricTypeMap.valueOf(metricNameStr);
                }
                catch (IllegalArgumentException iae) {
                    logger.debugV("Unknown metric name %s of %s. Full metric line is: %s", new Object[]{metricNameStr, this.endpoint.describeForLogs(), metricLine});
                    continue;
                }
                if (null == dbxMetricType.metricType) continue;
                String valueStr = matcher.group(2);
                try {
                    value = dbxMetricType.convertValueToDSSMetrics(Double.parseDouble(valueStr));
                }
                catch (NumberFormatException nfe) {
                    logger.errorV((Throwable)nfe, "Bad value for metric %s of %s. Full metric line is: %s", new Object[]{metricNameStr, this.endpoint.describeForLogs(), metricLine});
                    continue;
                }
                String timestampAsString = matcher.group(3);
                try {
                    long timestamp = Long.parseUnsignedLong(timestampAsString);
                    ActivityMetric.TimeAndMetrics metrics = timeAndMetricsByTime.computeIfAbsent(timestamp / 1000L, ActivityMetric.TimeAndMetrics::new);
                    ActivityMetric metric = metrics.activityMetricsByType.computeIfAbsent(dbxMetricType.metricType, t -> new ActivityMetric((ActivityMetric.Type)t, 0.0));
                    metric.setValue(metric.getValue() + value);
                }
                catch (NumberFormatException nfe) {
                    logger.errorV((Throwable)nfe, "Invalid timestamp for metric %s of %s. Full metric line is: %s", new Object[]{metricNameStr, this.endpoint.describeForLogs(), metricLine});
                }
                continue;
            }
            logger.warnV("Unmatched metric line for %s: %s", new Object[]{this.endpoint.describeForLogs(), metricLine});
        }
    }
}

