/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.common.deployments.actions;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeployment;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.deployer.common.deployments.actions.DeploymentAction;
import com.dataiku.dip.deployer.common.engine.DeploymentReport;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DeploymentUpdate
extends DeploymentAction {
    @Nullable
    private final DeploymentReport report;
    protected List<String> publishedItemIds;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.deployment.actions.update");

    protected DeploymentUpdate() {
        this.report = null;
    }

    protected DeploymentUpdate(boolean inProgress, long startTimestamp, @Nullable Long endTimestamp, PublicUser requester, @Nullable InfoMessage.Severity status, @Nullable DeploymentReport report, AbstractDeploymentInfra infra, AbstractDeployment deployment, List<String> publishedItemIds) {
        super(inProgress, startTimestamp, endTimestamp, requester, status, infra, deployment);
        this.report = report;
        this.publishedItemIds = publishedItemIds;
    }

    protected DeploymentUpdate(DeploymentUpdate other) {
        this(other.inProgress, other.startTimestamp, other.endTimestamp, other.requester, other.status, other.report, other.infra, other.deployment, other.publishedItemIds);
    }

    public static DeploymentUpdate initiated(PublicUser requester, AbstractDeploymentInfra infra, AbstractDeployment deployment, long startTimestamp, List<String> publishedItemIds) {
        return new DeploymentUpdate(true, startTimestamp, null, requester, null, null, infra, deployment, publishedItemIds);
    }

    private static DeploymentUpdate completed(DeploymentUpdate updateToComplete, InfoMessage.Severity status, DeploymentReport report, long endTimestamp) {
        return new DeploymentUpdate(false, updateToComplete.getStartTimestamp(), endTimestamp, updateToComplete.getRequester(), status, report, updateToComplete.getInfra(), updateToComplete.getDeployment(), updateToComplete.getPublishedItemIds());
    }

    public Head asHead() {
        return new Head(this);
    }

    @Override
    public String getType() {
        return "UPDATE";
    }

    @Nullable
    public DeploymentReport getReport() {
        return this.report;
    }

    public List<String> getPublishedItemIds() {
        return this.publishedItemIds;
    }

    @Override
    public DeploymentUpdate completeAction(@Nullable Object report, long endTimestamp) {
        if (report == null) {
            return DeploymentUpdate.completed(this, InfoMessage.Severity.ERROR, null, endTimestamp);
        }
        if (report instanceof DeploymentReport) {
            DeploymentReport deploymentReport = (DeploymentReport)((Object)report);
            InfoMessage.Severity status = deploymentReport.getMaxSeverity();
            return DeploymentUpdate.completed(this, status, deploymentReport, endTimestamp);
        }
        logger.errorV("Wrong report type. Expected %s, got: %s", new Object[]{DeploymentReport.class.getName(), report.getClass().getName()});
        throw ErrorContext.iae((String)"Couldn't complete the deployment update action due to the invalid report type");
    }

    protected DeploymentUpdate copyWithAllData() {
        DeploymentReport deploymentReport = this.report != null ? this.report.copyHookStatusWithSensitiveDataAdded() : null;
        return new DeploymentUpdate(this.inProgress, this.startTimestamp, this.endTimestamp, this.requester, this.status, deploymentReport, this.infra, this.deployment, this.publishedItemIds);
    }

    protected DeploymentUpdate copyWithNonAdminDeploymentFailureMessage() {
        DeploymentReport deploymentReport = this.report != null ? this.report.copyWithNonAdminDeploymentFailureMessage() : null;
        return new DeploymentUpdate(this.inProgress, this.startTimestamp, this.endTimestamp, this.requester, this.status, deploymentReport, this.infra, this.deployment, this.publishedItemIds);
    }

    public DeploymentUpdate withoutAdminInfo() {
        this.infra = null;
        return this;
    }

    public static class Head {
        public final long startTimestamp;
        public final String type;
        public final List<String> publishedItemIds;
        private Status status;

        public Head(DeploymentUpdate update) {
            this.startTimestamp = update.getStartTimestamp();
            this.type = update.getType();
            this.status = this.computeHeadStatus(update);
            this.publishedItemIds = update.getPublishedItemIds();
        }

        @Nonnull
        private Status computeHeadStatus(@Nonnull DeploymentUpdate update) {
            if (update.isInProgress()) {
                return Status.RUNNING;
            }
            if (update.getReport() != null && update.getReport().interrupted) {
                return Status.ABORTED;
            }
            if (update.getStatus() == null) {
                return Status.UNKNOWN;
            }
            return switch (update.getStatus()) {
                default -> throw new IncompatibleClassChangeError();
                case InfoMessage.Severity.SUCCESS, InfoMessage.Severity.INFO -> Status.SUCCESS;
                case InfoMessage.Severity.WARNING -> Status.WARNING;
                case InfoMessage.Severity.ERROR -> Status.ERROR;
            };
        }

        public void markAsUnknownIfRunning() {
            if (Status.RUNNING.equals((Object)this.status)) {
                this.status = Status.UNKNOWN;
            }
        }

        public static enum Status {
            SUCCESS,
            WARNING,
            ERROR,
            RUNNING,
            ABORTED,
            UNKNOWN;

        }
    }
}

