/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.projectdeployer.infra;

import com.dataiku.dip.connections.AbstractLLMConnection;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.deployer.common.DeployerUtils;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractInfraBasicInfo;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractPublishedItemBasicInfo;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.deployer.common.infra.AbstractInfrasService;
import com.dataiku.dip.deployer.projectdeployer.datamodel.actual.ConsistencyChecksReport;
import com.dataiku.dip.deployer.projectdeployer.datamodel.config.AbstractProjectDeployment;
import com.dataiku.dip.deployer.projectdeployer.datamodel.config.AbstractProjectDeploymentInfra;
import com.dataiku.dip.deployer.projectdeployer.datamodel.config.MultiAutomationNodeInfra;
import com.dataiku.dip.deployer.projectdeployer.datamodel.config.SingleAutomationNodeInfra;
import com.dataiku.dip.deployer.projectdeployer.deployments.ProjectDeploymentsService;
import com.dataiku.dip.deployer.projectdeployer.infra.AbstractAutomationNodeInfraManager;
import com.dataiku.dip.deployer.projectdeployer.infra.AutomationNodeInfrasDAO;
import com.dataiku.dip.deployer.projectdeployer.infra.MultiAutomationNodeInfraManager;
import com.dataiku.dip.directory.NodeConnection;
import com.dataiku.dip.directory.NodesDirectory;
import com.dataiku.dip.directory.NodesDirectoryService;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.nodeclients.AutomationNodeClient;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.backend.ProjectDeployerInfraChangedEvent;
import com.dataiku.dip.server.notifications.backend.ProjectDeployerInfraCreatedEvent;
import com.dataiku.dip.server.notifications.backend.ProjectDeployerInfraDeletedEvent;
import com.dataiku.dip.server.services.ProjectFoldersService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AutomationNodeInfrasService
extends AbstractInfrasService<AbstractProjectDeployment, AbstractPublishedItemBasicInfo.PublishedProjectBasicInfo, AbstractProjectDeploymentInfra> {
    @Autowired
    private AutomationNodeInfrasDAO deploymentInfrasDAO;
    @Autowired
    private ProjectDeploymentsService projectDeploymentsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private PubSubService pubSub;

    protected ProjectDeploymentsService getDeploymentsService() {
        return this.projectDeploymentsService;
    }

    protected AutomationNodeInfrasDAO getDeploymentInfrasDAO() {
        return this.deploymentInfrasDAO;
    }

    public ProjectFoldersService.ProjectFolderSummary getProjectFolderHierarchy_Check_NT(AuthCtx authCtx, String infraId) throws IOException, UnauthorizedException, CodedException {
        TransactionContext.assertNoAttachedTransaction();
        AbstractProjectDeploymentInfra infra = this.getAutomationNodeInfra_CheckRead(authCtx, infraId);
        AbstractAutomationNodeInfraManager manager = infra.getInfraManager(authCtx, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());
        return manager.getProjectFolderHierarchy();
    }

    @Override
    public InfoMessage.InfoMessages checkInfraStatus_Check_NT(AuthCtx authCtx, String infraId) throws IOException, UnauthorizedException {
        TransactionContext.assertNoAttachedTransaction();
        AbstractProjectDeploymentInfra infra = this.getAutomationNodeInfra_CheckRead(authCtx, infraId);
        AbstractAutomationNodeInfraManager manager = infra.getInfraManager(authCtx, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());
        return manager.checkInfraStatus();
    }

    public AbstractInfraBasicInfo.AbstractProjectDeploymentInfraBasicInfo basicInfoUnsafe(AbstractProjectDeploymentInfra infra) {
        if (infra instanceof SingleAutomationNodeInfra) {
            return new AbstractInfraBasicInfo.SingleAutomationNodeInfraBasicInfo((SingleAutomationNodeInfra)infra);
        }
        if (infra instanceof MultiAutomationNodeInfra) {
            return new AbstractInfraBasicInfo.MultiAutomationNodeInfraBasicInfo((MultiAutomationNodeInfra)infra);
        }
        throw ErrorContext.iaef((String)"Infrastructure type is invalid: %s", (Object)JSON.getType((Object)infra), (Object[])new Object[0]);
    }

    @Override
    public List<AbstractInfraBasicInfo.AbstractProjectDeploymentInfraBasicInfo> listBasicInfoUnsafe_Check(AuthCtx authCtx) throws IOException {
        return this.getDeploymentInfrasDAO().listUnsafe().stream().filter(infra -> AutomationNodeInfrasService.hasReadPermission(infra, authCtx)).map(this::basicInfoUnsafe).collect(Collectors.toList());
    }

    public List<String> getProjectKeys_NT(AuthCtx authCtx, String infraId) throws IOException, UnauthorizedException, CodedException {
        TransactionContext.assertNoAttachedTransaction();
        AbstractProjectDeploymentInfra infra = this.getAutomationNodeInfra_CheckRead(authCtx, infraId);
        AbstractAutomationNodeInfraManager manager = infra.getInfraManager(authCtx, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());
        return manager.getProjectKeys();
    }

    public List<String> listUserLogins_NT(AuthCtx authCtx, String infraId) throws IOException, UnauthorizedException, CodedException {
        TransactionContext.assertNoAttachedTransaction();
        AbstractProjectDeploymentInfra infra = this.getAutomationNodeInfra_CheckAdmin(authCtx, infraId);
        AbstractAutomationNodeInfraManager manager = infra.getInfraManager(authCtx, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());
        return manager.listUserLogins();
    }

    public List<String> listConnectionsNames_Check_NT(AuthCtx authCtx, String infraId, @Nullable String deploymentId) throws IOException, UnauthorizedException, URISyntaxException, CodedException {
        TransactionContext.assertNoAttachedTransaction();
        AbstractProjectDeploymentInfra infra = this.getAutomationNodeInfra_CheckRead(authCtx, infraId);
        AbstractAutomationNodeInfraManager manager = infra.getInfraManager(authCtx, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());
        return manager.listConnectionsNames(deploymentId);
    }

    public List<String> listContainerExecNames_Check_NT(AuthCtx authCtx, String infraId, @Nullable String deploymentId) throws IOException, UnauthorizedException, URISyntaxException, CodedException {
        TransactionContext.assertNoAttachedTransaction();
        AbstractProjectDeploymentInfra infra = this.getAutomationNodeInfra_CheckRead(authCtx, infraId);
        AbstractAutomationNodeInfraManager manager = infra.getInfraManager(authCtx, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());
        return manager.listContainerExecNames(deploymentId);
    }

    public AbstractProjectDeploymentInfra getAutomationNodeInfra_CheckRead(AuthCtx authCtx, String infraId) throws IOException, UnauthorizedException {
        AbstractProjectDeploymentInfra infra;
        try (Transaction ignored = this.transactionService.retrieveOrBeginRead();){
            infra = (AbstractProjectDeploymentInfra)this.deploymentInfrasDAO.getMandatoryUnsafe(infraId);
        }
        if (!AutomationNodeInfrasService.hasReadPermission(infra, authCtx)) {
            throw new UnauthorizedException("You may not read this infrastructure", this.getExceptionTypePrefix() + "infrastructure-action-denied");
        }
        return infra;
    }

    private AbstractProjectDeploymentInfra getAutomationNodeInfra_CheckAdmin(AuthCtx authCtx, String infraId) throws IOException, UnauthorizedException {
        AbstractProjectDeploymentInfra infra;
        try (Transaction ignored = this.transactionService.retrieveOrBeginRead();){
            infra = (AbstractProjectDeploymentInfra)this.deploymentInfrasDAO.getMandatoryUnsafe(infraId);
        }
        if (!AutomationNodeInfrasService.hasAdminPermission(infra, authCtx)) {
            throw new UnauthorizedException("You may not manage this infrastructure", this.getExceptionTypePrefix() + "infrastructure-action-denied");
        }
        return infra;
    }

    public List<MultiAutomationNodeInfra.AutomationNodeRef> getAutomationNodesFromNodesDirectory() {
        NodesDirectoryService nodesDirectoryService = (NodesDirectoryService)SpringUtils.getBean(NodesDirectoryService.class);
        NodesDirectory nd = nodesDirectoryService.getNodesDirectoryUnsafe_AutoTXN();
        if (nd.enabled) {
            return nd.nodes.stream().filter(nr -> nr.nodeType == NodesDirectory.NodeType.DSS_EXECUTION).map(nr -> new MultiAutomationNodeInfra.AutomationNodeRef(nr.nodeId, nr.url, nr.externalUrl, nr.adminAPIKey)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public Map<String, List<String>> listOtherAutomationNodeUrls(AuthCtx authCtx, String infraId) throws IOException {
        HashMap<String, List<String>> automationNodeUrlToInfraIds = new HashMap<String, List<String>>();
        List allInfras = this.deploymentInfrasDAO.listUnsafe();
        for (AbstractProjectDeploymentInfra infra : allInfras) {
            if (Objects.equals(infra.id, infraId) || !AutomationNodeInfrasService.hasReadPermission(infra, authCtx)) continue;
            if (infra instanceof SingleAutomationNodeInfra) {
                try {
                    String automationNodeUrl = ((SingleAutomationNodeInfra)infra).getConnectionInfo().url;
                    if (automationNodeUrl == null) continue;
                    automationNodeUrlToInfraIds.computeIfAbsent(automationNodeUrl, k -> new ArrayList()).add(infra.id);
                }
                catch (Exception e) {
                    this.getLogger().warnV((Throwable)e, "Error while retrieving automation node url of infrastructure %s, skipping.", new Object[]{infra.id});
                }
                continue;
            }
            if (!(infra instanceof MultiAutomationNodeInfra)) continue;
            ((MultiAutomationNodeInfra)infra).getOptionalNodeConnections().values().forEach(nodeConnection -> nodeConnection.ifPresent(connection -> automationNodeUrlToInfraIds.computeIfAbsent(connection.url, k -> new ArrayList()).add(infra.id)));
        }
        return automationNodeUrlToInfraIds;
    }

    public MultiAutomationNodeInfraManager.PersonalPublicAPIKeyOnAllNodes generatePersonalAPIKey_Check(AuthCtx authCtx, String infraId, String label, String description, @Nullable String forUser) throws IOException, CodedException, UnauthorizedException {
        MultiAutomationNodeInfra infra;
        if (StringUtils.isBlank((String)label)) {
            throw ErrorContext.iae((String)"Personal API key for multi automation node deployment infrastructures must have a label");
        }
        try (Transaction ignored = this.transactionService.beginRead();){
            AbstractProjectDeploymentInfra abstractProjectDeploymentInfra = this.getAutomationNodeInfra_CheckRead(authCtx, infraId);
            if (!(abstractProjectDeploymentInfra instanceof MultiAutomationNodeInfra)) {
                throw ErrorContext.iae((String)"Invalid deployment type, personal API key generation is for multi automation node deployment infrastructures only");
            }
            infra = (MultiAutomationNodeInfra)abstractProjectDeploymentInfra;
        }
        if (StringUtils.isNotBlank((String)forUser) && !AbstractInfrasService.hasAdminPermission(infra, authCtx)) {
            forUser = null;
            this.getLogger().infoV("Non infra admin user %s setting a non blank forUser parameter, ignoring it.", new Object[0]);
        }
        MultiAutomationNodeInfraManager manager = (MultiAutomationNodeInfraManager)infra.getInfraManager(authCtx, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());
        return manager.createPersonalAPIKey(authCtx, label, description, forUser);
    }

    public ConsistencyChecksReport runConsistencyChecks(AuthCtx authCtx, String infraId) throws UnauthorizedException, IOException {
        AbstractProjectDeploymentInfra infra = this.getAutomationNodeInfra_CheckRead(authCtx, infraId);
        if (!(infra instanceof MultiAutomationNodeInfra)) {
            throw new IllegalArgumentException("Consistency checks are only available for multi-node project deployment infrastructures.");
        }
        ConsistencyChecksReport report = new ConsistencyChecksReport(infraId);
        Map<String, Optional<NodeConnection>> nodeConnections = ((MultiAutomationNodeInfra)infra).getOptionalNodeConnections();
        HashMap<String, Map<String, DSSConnection>> connectionsPerNode = new HashMap<String, Map<String, DSSConnection>>();
        HashSet<String> allConnections = new HashSet<String>();
        for (Map.Entry<String, Optional<NodeConnection>> entry : nodeConnections.entrySet()) {
            String nodeId = entry.getKey();
            Optional<NodeConnection> optNodeConnection = entry.getValue();
            if (optNodeConnection.isEmpty()) {
                report.connectionChecksErrorMessages.add(String.format("We could not get the details for your automation node \"%s\". A problem might have occurred with your node directory.", nodeId));
                continue;
            }
            try {
                AutomationNodeClient client = AutomationNodeClient.automationNodeProxyUserClient(authCtx, infra, optNodeConnection.get(), DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());
                try {
                    Map<String, DSSConnection> connectionsForNode = client.listAdminConnections();
                    allConnections.addAll(connectionsForNode.keySet());
                    connectionsPerNode.put(nodeId, connectionsForNode);
                    report.checkedAutomationNodeIdsForConnection.add(nodeId);
                }
                finally {
                    if (client == null) continue;
                    client.close();
                }
            }
            catch (Exception e) {
                report.connectionChecksErrorMessages.add(String.format("The connections of the automation node \"%s\" could not be retrieved. \n %s", nodeId, ExceptionUtils.getMessageWithCauses((Throwable)e)));
            }
        }
        for (String connection : allConnections) {
            String automationNodeToComputeDiffOn = null;
            ConsistencyChecksReport.ConnectionDiscrepancies connectionDiscrepancies = new ConsistencyChecksReport.ConnectionDiscrepancies();
            for (String automationNodeId : nodeConnections.keySet()) {
                if (!connectionsPerNode.containsKey(automationNodeId)) continue;
                if (!((Map)connectionsPerNode.get(automationNodeId)).containsKey(connection)) {
                    String connectionAbsentOnNode = String.format("The connection does not exist on automation node \"%s\"", automationNodeId);
                    connectionDiscrepancies.messages.add(connectionAbsentOnNode);
                    continue;
                }
                connectionDiscrepancies.connectionUrls.add(new ConsistencyChecksReport.ConnectionUrlOnNode(automationNodeId, String.format("%s/admin/connections/%s/", nodeConnections.get((Object)automationNodeId).get().externalUrl, connection)));
                if (automationNodeToComputeDiffOn != null) {
                    connectionDiscrepancies.messages.addAll(this.computeDiscrepancies((DSSConnection)((Map)connectionsPerNode.get(automationNodeToComputeDiffOn)).get(connection), (DSSConnection)((Map)connectionsPerNode.get(automationNodeId)).get(connection), automationNodeToComputeDiffOn, automationNodeId));
                    continue;
                }
                automationNodeToComputeDiffOn = automationNodeId;
            }
            report.connectionsChecks.put(connection, connectionDiscrepancies);
        }
        report.connectionsChecks = this.orderBySeverityThenByName(report.connectionsChecks);
        return report;
    }

    private LinkedHashMap<String, ConsistencyChecksReport.ConnectionDiscrepancies> orderBySeverityThenByName(Map<String, ConsistencyChecksReport.ConnectionDiscrepancies> connectionsChecks) {
        return connectionsChecks.entrySet().stream().sorted((entry1, entry2) -> {
            int count1 = ((ConsistencyChecksReport.ConnectionDiscrepancies)entry1.getValue()).messages.size();
            int count2 = ((ConsistencyChecksReport.ConnectionDiscrepancies)entry2.getValue()).messages.size();
            int countComparison = Integer.compare(count2, count1);
            if (countComparison != 0) {
                return countComparison;
            }
            return ((String)entry1.getKey()).compareTo((String)entry2.getKey());
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    private List<String> computeDiscrepancies(DSSConnection connectionOnNode1, DSSConnection connectionOnNode2, String automationNodeId1, String automationNodeId2) {
        if (!Objects.equals(connectionOnNode1.getType(), connectionOnNode2.getType())) {
            String differentTypesMsg = String.format("The connection type is different between node \"%s\" (%s) and node \"%s\" (%s)", automationNodeId1, connectionOnNode1.getType(), automationNodeId2, connectionOnNode2.getType());
            return Collections.singletonList(differentTypesMsg);
        }
        if (connectionOnNode1 instanceof AbstractLLMConnection && connectionOnNode2 instanceof AbstractLLMConnection) {
            ArrayList<String> ret = new ArrayList<String>();
            AbstractLLMConnection llmConnection1 = (AbstractLLMConnection)connectionOnNode1;
            AbstractLLMConnection llmConnection2 = (AbstractLLMConnection)connectionOnNode2;
            Map<String, Object> checkablesOn1 = llmConnection1.getConsistencyCheckables();
            Map<String, Object> checkablesOn2 = llmConnection2.getConsistencyCheckables();
            assert (Objects.equals(checkablesOn1.keySet(), checkablesOn2.keySet())) : String.format("The checkable fields of %s and %s must be equal.", automationNodeId1, automationNodeId2);
            for (String field : checkablesOn1.keySet()) {
                Object checkable2;
                Object checkable1 = checkablesOn1.get(field);
                if (JSON.jsonEquals((Object)checkable1, (Object)(checkable2 = checkablesOn2.get(field)))) continue;
                StringBuilder builder = new StringBuilder();
                builder.append(String.format("The LLM connection has different \"%s\" configuration between node \"%s\" and \"%s\".", field, automationNodeId1, automationNodeId2));
                if (AbstractLLMConnection.ENABLED_MODELS.equals(field)) {
                    HashSet disjunctionModels = new HashSet(CollectionUtils.disjunction((Iterable)((Set)checkable1), (Iterable)((Set)checkable2)));
                    builder.append(String.format(" Difference: %s", disjunctionModels));
                }
                ret.add(builder.toString());
            }
            return ret;
        }
        return Collections.emptyList();
    }

    @Override
    protected void publishInfraCreationEventAfterTransaction(String infraId) {
        this.pubSub.publishAfterTransaction((DSSEvent)new ProjectDeployerInfraCreatedEvent(infraId));
    }

    @Override
    protected void publishInfraChangedEventAfterTransaction(String infraId) {
        this.pubSub.publishAfterTransaction((DSSEvent)new ProjectDeployerInfraChangedEvent(infraId));
    }

    @Override
    protected void publishInfraDeletedEventAfterTransaction(String infraId, AbstractDeploymentInfra.InfraType infraType) {
        this.pubSub.publishAfterTransaction((DSSEvent)new ProjectDeployerInfraDeletedEvent(infraId));
    }

    @Override
    protected String getExceptionTypePrefix() {
        return "projectdeployer-";
    }

    @Override
    protected DKULogger getLogger() {
        return DKULogger.getLogger((String)"dku.projectdeployer.infras.service");
    }
}

