/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docextraction;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.docextraction.Screenshotter;
import com.dataiku.dip.utils.DKULogger;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;

public interface IDocumentScreenshotsDrawer
extends Closeable {
    public static final int DEFAULT_MEMORY_LIMIT_PER_DOCUMENT = 50;
    public static final int MEMORY_LIMIT_PER_DOCUMENT = DKUApp.getParams().getIntParam("dku.docextraction.memoryLimitPerDocumentInMB", Integer.valueOf(50));
    public static final int DEFAULT_BASE_DPI = 72;
    public static final int BYTES_PER_PIXEL = 4;
    public static final DKULogger logger = DKULogger.getLogger((String)"dku.docextraction.drawer");

    public static double getMaximumScalePriorImageDrawing(float widthPoints, float heightPoints) {
        double maximumScaleToFitMemLimit;
        int defaultDpi = 72 * Screenshotter.SCREENSHOTS_SCALE_FACTOR;
        double scaleForCurrentImage = Screenshotter.SCREENSHOTS_SCALE_FACTOR.intValue();
        if (scaleForCurrentImage > (maximumScaleToFitMemLimit = Math.sqrt((double)MEMORY_LIMIT_PER_DOCUMENT * 1000000.0 / (double)(4.0f * widthPoints * heightPoints)))) {
            logger.info((Object)("Reducing rendering DPI from " + defaultDpi + " to " + (int)(72.0 * maximumScaleToFitMemLimit) + " to limit memory usage."));
            scaleForCurrentImage = maximumScaleToFitMemLimit;
        }
        return scaleForCurrentImage;
    }

    public BufferedImage drawImage(int var1) throws IOException;

    public int getPageCount();
}

