/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.externalinfras.azureml.http;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.externalinfras.azureml.AzureMLUtils;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMonitor;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.util.HTTPClientUtils;
import com.dataiku.dip.util.ProxyUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PerfUtils;
import com.dataiku.dss.shadelib.org.apache.http.HttpEntity;
import com.dataiku.dss.shadelib.org.apache.http.HttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.config.RequestConfig;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.CloseableHttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpPost;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpRequestBase;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import com.dataiku.dss.shadelib.org.apache.http.client.utils.URIBuilder;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.CloseableHttpClient;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.HttpClientBuilder;
import com.dataiku.dss.shadelib.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import com.dataiku.dss.shadelib.org.apache.http.util.EntityUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.AccessToken;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenRequestContext;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class AzureMonitorHttpClient
implements AutoCloseable {
    private static final String AZUREMONITOR_TOKEN_REQUEST_SCOPE = "https://management.azure.com/.default";
    public static final String AZUREMONITOR_MAX_TOKEN_REQUEST_WAIT_SECONDS = "dku.deployer.deployment.azuremonitor.max_token_wait_second";
    public static final long AZUREMONITOR_MAX_TOKEN_REQUEST_WAIT_SECONDS_DEFAULT = 15L;
    final CloseableHttpClient httpClient;
    public final TokenCredential credential;
    private final PoolingHttpClientConnectionManager cm;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.externalinfras.azureml.utils");

    public AzureMonitorHttpClient(ProxySettings proxySettings, TokenCredential credential, int connectTimeout, int socketTimeout) {
        this.credential = credential;
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.addInterceptorFirst(PerfUtils.MARK_HTTP_REQUEST_INTERCEPTOR);
        ProxyUtils.applyProxySettings((ProxySettings)proxySettings, (HttpClientBuilder)builder);
        this.cm = new PoolingHttpClientConnectionManager();
        this.cm.setMaxTotal(10);
        this.cm.setDefaultMaxPerRoute(10);
        RequestConfig rc = RequestConfig.custom().setConnectTimeout(connectTimeout).setConnectionRequestTimeout(10000).setSocketTimeout(socketTimeout).build();
        builder.setDefaultRequestConfig(rc);
        this.httpClient = builder.build();
    }

    public Map<String, AzureMonitor.Metric> getEndpointMetrics_NT(String location, String subscriptionId, List<String> endpointFullResourceIds, Instant start, Instant end, String interval, String metricName, String aggregation, @Nullable String filter) throws IOException, URISyntaxException {
        try {
            AzureMLUtils.checkRate("Get Azure Monitor Metrics");
            logger.debugV("Fetching metric '%s' from Azure Monitor for location '%s', subscription '%s', resources ['%s'], from '%s' to '%s', interval '%s', aggregated by '%s', and filtered by '%s'", new Object[]{metricName, location, subscriptionId, endpointFullResourceIds, start, end, interval, aggregation, filter});
            URIBuilder builder = new URIBuilder("https://" + location + ".metrics.monitor.azure.com/subscriptions/" + subscriptionId + "/metrics:getBatch").setParameter("interval", interval).setParameter("metricnamespace", "microsoft.machinelearningservices/workspaces/onlineendpoints").setParameter("metricnames", metricName).setParameter("aggregation", aggregation).setParameter("api-version", "2023-05-01-preview").setParameter("starttime", start.toString()).setParameter("endtime", end.toString());
            if (StringUtils.isNotEmpty((String)filter)) {
                builder.setParameter("filter", filter);
            }
            HttpPost req = new HttpPost(builder.build());
            req.setEntity(JSON.toHttpEntity((Object)new ResourceIdList(endpointFullResourceIds)));
            AzureMonitor.MetricResultsResponse response = this.execRequest_NT((HttpRequestBase)req, new TypeToken<AzureMonitor.MetricResultsResponse>(){});
            HashMap<String, AzureMonitor.Metric> metricsByResourceId = new HashMap<String, AzureMonitor.Metric>();
            for (AzureMonitor.Values resourceValues : response.values) {
                if (resourceValues.value.size() != 1 || !resourceValues.value.get((int)0).errorCode.equals("Success")) {
                    logger.error((Object)("Error while querying Azure Monitor, query was not successful for resource: " + resourceValues.resourceid));
                    continue;
                }
                AzureMonitor.Metric metric = resourceValues.value.get(0);
                String[] endpointSplit = resourceValues.resourceid.split("/");
                if (endpointSplit.length != 11) {
                    logger.error((Object)("Error while querying Azure Monitor, incorrect returned resource id:" + resourceValues.resourceid));
                    continue;
                }
                String endpointId = endpointSplit[10];
                metricsByResourceId.put(endpointId, metric);
            }
            return metricsByResourceId;
        }
        catch (Exception e) {
            logger.errorV((Throwable)e, "Error while retrieving Endpoints metrics from Azure Monitor", new Object[0]);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T execRequest_NT(HttpRequestBase requestBase, TypeToken<T> typeToken) throws IOException {
        TransactionContext.assertNoAttachedTransaction();
        CloseableHttpResponse resp = null;
        try {
            requestBase.setHeader("Authorization", String.format("Bearer %s", this.getTokenFromCredential()));
            resp = this.httpClient.execute((HttpUriRequest)requestBase);
            Object object = HTTPClientUtils.handleJSONResp((HttpResponse)resp, typeToken, response -> new IOException(response.toString()));
            return (T)object;
        }
        finally {
            if (Objects.nonNull(resp)) {
                EntityUtils.consume((HttpEntity)resp.getEntity());
            }
            requestBase.releaseConnection();
        }
    }

    private String getTokenFromCredential() {
        TokenRequestContext tokenRequestContext = new TokenRequestContext();
        tokenRequestContext.addScopes(new String[]{AZUREMONITOR_TOKEN_REQUEST_SCOPE});
        long maxDuration = DKUApp.getParams().getLongParam(AZUREMONITOR_MAX_TOKEN_REQUEST_WAIT_SECONDS, 15L);
        return ((AccessToken)this.credential.getToken(tokenRequestContext).timeout(Duration.ofSeconds(maxDuration)).retry(5L).block(Duration.ofSeconds(maxDuration))).getToken();
    }

    @Override
    public void close() {
        try {
            logger.infoV("Closing Azure Monitor HttpClient and connection pool manager.", new Object[0]);
            this.httpClient.close();
            this.cm.close();
        }
        catch (Exception e) {
            logger.error((Object)("Unable to close Azure Monitor HttpClient: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
    }

    private static class ResourceIdList {
        public List<String> resourceids;

        public ResourceIdList(List<String> resourceids) {
            this.resourceids = resourceids;
        }
    }
}

