/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats.avro;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.utils.ErrorContext;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.JsonProperties;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;

public class SchemaConverter {
    public static final String LOGICAL_TIMESTAMP_MILLIS = "timestamp-millis";
    public static final String LOGICAL_TIMESTAMP_MICROS = "timestamp-micros";
    public static final String LOGICAL_DATE = "date";
    public static final String LOGICAL_LOCAL_TIMESTAMP_MILLIS = "local-timestamp-millis";
    public static final String LOGICAL_LOCAL_TIMESTAMP_MICROS = "local-timestamp-micros";
    private int uniqueId = 0;

    public static Schema convertSchema(com.dataiku.dip.coremodel.Schema dssSchema) {
        return SchemaConverter.convertSchema(dssSchema, AvroFlavor.HIVE);
    }

    public static Schema convertSchema(com.dataiku.dip.coremodel.Schema dssSchema, AvroFlavor flavor) {
        return new SchemaConverter().convertSchemaImpl(dssSchema, flavor);
    }

    public static com.dataiku.dip.coremodel.Schema convertSchema(Schema avroSchema) {
        return new SchemaConverter().convertSchemaImpl(avroSchema);
    }

    public static Schema getNullableTypeFromUnion(Schema unionType) {
        if (unionType.getType() != Schema.Type.UNION) {
            throw new RuntimeException("Must be UNION");
        }
        List unionTypes = unionType.getTypes();
        if (unionTypes.size() == 2) {
            Schema type1 = (Schema)unionTypes.get(0);
            Schema type2 = (Schema)unionTypes.get(1);
            if (type1.getType() == Schema.Type.NULL && type2.getType() != Schema.Type.NULL) {
                return type2;
            }
            if (type2.getType() == Schema.Type.NULL && type1.getType() != Schema.Type.NULL) {
                return type1;
            }
        }
        throw new RuntimeException("Avro UNION types are not supported : " + String.valueOf(unionType));
    }

    public static int getNullIndexInUnion(Schema unionType) {
        if (unionType.getType() != Schema.Type.UNION) {
            throw new RuntimeException("Must be UNION");
        }
        List types = unionType.getTypes();
        for (int i = 0; i < types.size(); ++i) {
            if (((Schema)types.get(i)).getType() != Schema.Type.NULL) continue;
            return i;
        }
        throw new RuntimeException("This is not a nullable type");
    }

    private com.dataiku.dip.coremodel.Schema convertSchemaImpl(Schema avroSchema) {
        com.dataiku.dip.coremodel.Schema schema = new com.dataiku.dip.coremodel.Schema();
        if (avroSchema.getType() != Schema.Type.RECORD) {
            throw new RuntimeException("Root schema must be a record");
        }
        HashSet typeStack = Sets.newHashSet();
        for (Schema.Field field : avroSchema.getFields()) {
            schema.addColumn(this.convertField(field, typeStack));
        }
        return schema;
    }

    private Schema convertSchemaImpl(com.dataiku.dip.coremodel.Schema dssSchema, AvroFlavor flavor) {
        SchemaColumn fake = this.newSchemaColumn(Type.OBJECT);
        fake.objectFields = dssSchema.getColumns();
        return this.convertType(fake, flavor);
    }

    private Schema makeNullable(Schema initialAvroType) {
        ArrayList<Schema> types = new ArrayList<Schema>();
        types.add(Schema.create((Schema.Type)Schema.Type.NULL));
        types.add(initialAvroType);
        return Schema.createUnion(types);
    }

    private Schema convertArray(SchemaColumn fake, AvroFlavor flavor) {
        switch (flavor) {
            case HIVE: {
                return Schema.createArray((Schema)this.makeNullable(this.convertType(fake.arrayContent, flavor)));
            }
            case PIG: {
                if (fake.arrayContent.getType() != Type.OBJECT) {
                    throw new RuntimeException("Pig only supports array of objects in Avro (bag of tuples)");
                }
                return Schema.createArray((Schema)this.convertType(fake.arrayContent, flavor));
            }
        }
        throw new RuntimeException("Unsupported Avro flavor");
    }

    private Schema convertType(SchemaColumn sc, AvroFlavor flavor) {
        switch (sc.getType()) {
            case TINYINT: {
                return Schema.create((Schema.Type)Schema.Type.INT);
            }
            case SMALLINT: {
                return Schema.create((Schema.Type)Schema.Type.INT);
            }
            case INT: {
                return Schema.create((Schema.Type)Schema.Type.INT);
            }
            case BIGINT: {
                return Schema.create((Schema.Type)Schema.Type.LONG);
            }
            case FLOAT: {
                return Schema.create((Schema.Type)Schema.Type.FLOAT);
            }
            case DOUBLE: {
                return Schema.create((Schema.Type)Schema.Type.DOUBLE);
            }
            case BOOLEAN: {
                return Schema.create((Schema.Type)Schema.Type.BOOLEAN);
            }
            case STRING: {
                return Schema.create((Schema.Type)Schema.Type.STRING);
            }
            case DATE: {
                return new LogicalType(LOGICAL_TIMESTAMP_MILLIS).addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
            }
            case DATEONLY: {
                return new LogicalType(LOGICAL_DATE).addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
            }
            case DATETIMENOTZ: {
                return new LogicalType(LOGICAL_LOCAL_TIMESTAMP_MILLIS).addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
            }
            case ARRAY: {
                return this.convertArray(sc, flavor);
            }
            case MAP: {
                return this.convertMap(sc, flavor);
            }
            case OBJECT: {
                return this.convertObject(sc, flavor);
            }
        }
        throw new RuntimeException("DSS type " + String.valueOf(sc.getType()) + " isn't supported by Avro");
    }

    private Schema convertObject(SchemaColumn fake, AvroFlavor flavor) {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        for (SchemaColumn sc : fake.objectFields) {
            Schema converted = this.makeNullable(this.convertType(sc, flavor));
            Schema.Field field = new Schema.Field(sc.getName(), converted, null, (Object)JsonProperties.NULL_VALUE);
            fields.add(field);
        }
        Schema root = Schema.createRecord((String)("dku_record_" + this.uniqueId++), (String)"", (String)"com.dataiku.dss", (boolean)false);
        root.setFields(fields);
        return root;
    }

    private Schema convertMap(SchemaColumn sc, AvroFlavor flavor) {
        if (sc.mapKeys.getType() != Type.STRING) {
            throw new RuntimeException("Map keys must be string in Avro");
        }
        return Schema.createMap((Schema)this.makeNullable(this.convertType(sc.mapValues, flavor)));
    }

    private SchemaColumn buildUnion(Schema avroSchema, Set<Schema> typeStack) {
        SchemaColumn sc = null;
        List unionTypes = avroSchema.getTypes();
        for (Schema currentType : unionTypes) {
            if (currentType.getType() == Schema.Type.NULL) continue;
            SchemaColumn convertedCurrentType = this.convertType(currentType, typeStack);
            if (sc == null) {
                sc = convertedCurrentType;
                continue;
            }
            Type prevType = sc.getType();
            Type newType = TypeCoercer.coerce(prevType, convertedCurrentType.getType());
            if (newType != prevType) {
                switch (newType) {
                    case ARRAY: 
                    case MAP: 
                    case OBJECT: {
                        sc.setType(Type.STRING);
                        break;
                    }
                }
            }
            sc.setType(newType);
        }
        if (sc == null) {
            sc = new SchemaColumn();
            sc.setType(Type.STRING);
        }
        return sc;
    }

    private SchemaColumn buildRecord(Schema avroSchema, Set<Schema> typeStack) {
        SchemaColumn sc = this.newSchemaColumn(Type.OBJECT);
        sc.objectFields = new ArrayList();
        for (Schema.Field field : avroSchema.getFields()) {
            SchemaColumn dssField = this.convertType(field.schema(), typeStack);
            dssField.setName(field.name());
            sc.objectFields.add(dssField);
        }
        return sc;
    }

    private SchemaColumn buildArray(Schema avroSchema, Set<Schema> typeStack) {
        SchemaColumn sc = this.newSchemaColumn(Type.ARRAY);
        sc.arrayContent = this.convertType(avroSchema.getElementType(), typeStack);
        return sc;
    }

    private SchemaColumn buildMap(Schema avroSchema, Set<Schema> typeStack) {
        SchemaColumn sc = this.newSchemaColumn(Type.MAP);
        sc.mapKeys = this.newSchemaColumn(Type.STRING);
        sc.mapValues = this.convertType(avroSchema.getValueType(), typeStack);
        return sc;
    }

    private SchemaColumn newSchemaColumn(Type dssType) {
        SchemaColumn sc = new SchemaColumn();
        sc.setType(dssType);
        return sc;
    }

    private SchemaColumn convertType(Schema avroSchema, Set<Schema> typeStack) {
        if (typeStack.contains(avroSchema)) {
            throw ErrorContext.iae((String)"DSS doesn't support recursive schema definition in Avro files");
        }
        typeStack.add(avroSchema);
        SchemaColumn sc = this.doConvertType(avroSchema, typeStack);
        typeStack.remove(avroSchema);
        return sc;
    }

    private SchemaColumn doConvertType(Schema avroSchema, Set<Schema> typeStack) {
        switch (avroSchema.getType()) {
            case RECORD: {
                return this.buildRecord(avroSchema, typeStack);
            }
            case ARRAY: {
                return this.buildArray(avroSchema, typeStack);
            }
            case MAP: {
                return this.buildMap(avroSchema, typeStack);
            }
            case UNION: {
                return this.buildUnion(avroSchema, typeStack);
            }
            case ENUM: {
                return this.newSchemaColumn(Type.STRING);
            }
            case FIXED: {
                return this.newSchemaColumn(Type.STRING);
            }
            case STRING: {
                return this.newSchemaColumn(Type.STRING);
            }
            case BYTES: {
                return this.newSchemaColumn(Type.STRING);
            }
            case INT: {
                if (avroSchema.getLogicalType() != null && LOGICAL_DATE.equalsIgnoreCase(avroSchema.getLogicalType().getName())) {
                    return this.newSchemaColumn(Type.DATEONLY);
                }
                return this.newSchemaColumn(Type.INT);
            }
            case LONG: {
                if (avroSchema.getLogicalType() != null && LOGICAL_TIMESTAMP_MILLIS.equalsIgnoreCase(avroSchema.getLogicalType().getName())) {
                    return this.newSchemaColumn(Type.DATE);
                }
                if (avroSchema.getLogicalType() != null && LOGICAL_LOCAL_TIMESTAMP_MILLIS.equalsIgnoreCase(avroSchema.getLogicalType().getName())) {
                    return this.newSchemaColumn(Type.DATETIMENOTZ);
                }
                return this.newSchemaColumn(Type.BIGINT);
            }
            case FLOAT: {
                return this.newSchemaColumn(Type.FLOAT);
            }
            case DOUBLE: {
                return this.newSchemaColumn(Type.DOUBLE);
            }
            case BOOLEAN: {
                return this.newSchemaColumn(Type.BOOLEAN);
            }
            case NULL: {
                return this.newSchemaColumn(Type.STRING);
            }
        }
        throw new RuntimeException("Unhandled Avro type: " + String.valueOf(avroSchema.getType()));
    }

    private SchemaColumn convertField(Schema.Field field, Set<Schema> typeStack) {
        SchemaColumn sc = this.convertType(field.schema(), typeStack);
        sc.setName(field.name());
        return sc;
    }

    public static enum AvroFlavor {
        PIG,
        HIVE;

    }

    public static enum TypeCoercer {
        STRING(null, Type.STRING),
        OBJECT(STRING, Type.OBJECT),
        MAP(STRING, Type.MAP),
        ARRAY(STRING, Type.ARRAY),
        DATE(STRING, Type.DATE),
        DOUBLE(STRING, Type.DOUBLE),
        FLOAT(DOUBLE, Type.FLOAT),
        BIGINT(DOUBLE, Type.BIGINT),
        INT(BIGINT, Type.INT),
        SMALLINT(INT, Type.SMALLINT),
        TINYINT(SMALLINT, Type.TINYINT),
        BOOLEAN(TINYINT, Type.BOOLEAN);

        private static final Map<Type, TypeCoercer> mapping;
        private final TypeCoercer parent;
        private final Type dssType;
        private final int level;

        private TypeCoercer(TypeCoercer parent, Type dssType) {
            this.parent = parent;
            this.dssType = dssType;
            this.level = parent != null ? parent.level + 1 : 0;
        }

        private static TypeCoercer get(Type dssType) {
            TypeCoercer tc = mapping.get(dssType);
            if (tc == null) {
                throw new RuntimeException("Unknown type : " + String.valueOf(dssType));
            }
            return tc;
        }

        public static Type coerce(Type type1, Type type2) {
            TypeCoercer c1 = TypeCoercer.get(type1);
            TypeCoercer c2 = TypeCoercer.get(type2);
            if (c1.dssType == c2.dssType) {
                return c1.dssType;
            }
            if (c1.level < c2.level) {
                return TypeCoercer.coerce(c1.dssType, c2.parent.dssType);
            }
            return TypeCoercer.coerce(c1.parent.dssType, c2.dssType);
        }

        static {
            mapping = new HashMap<Type, TypeCoercer>();
            for (TypeCoercer tc : TypeCoercer.values()) {
                mapping.put(tc.dssType, tc);
            }
        }
    }
}

