/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats.custom;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.custom.CustomJavaRuntimeDataProvider;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.datasets.fs.FSDatasetUtils;
import com.dataiku.dip.formats.custom.CustomFormatSchemaProvider;
import com.dataiku.dip.formats.custom.CustomJavaFormatDesc;
import com.dataiku.dip.formats.custom.CustomJavaFormatExtractor;
import com.dataiku.dip.formats.custom.LoadedJavaFormat;
import com.dataiku.dip.input.stream.DecodedInputStreamFactory;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.input.stream.StreamsInputSplit;
import com.dataiku.dip.plugin.CustomFormat;
import com.dataiku.dip.plugin.CustomFormatSchemaDetector;
import com.dataiku.dip.plugin.InputStreamWithContextInfo;
import com.dataiku.dip.plugin.tools.PluginClazzLoader;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.input.CloseShieldInputStream;
import com.google.gson.JsonObject;
import java.io.InputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.lang.NotImplementedException;
import org.apache.log4j.Logger;

public class CustomJavaFormatWithSchemaExtractor
extends CustomJavaFormatExtractor
implements CustomFormatSchemaProvider {
    private static Logger logger = Logger.getLogger((String)"dku.formats.custom.java.input.with_schema");

    public CustomJavaFormatWithSchemaExtractor(AuthCtx authCtx, String projectKey, JsonObject config, LoadedJavaFormat loaded, CustomJavaRuntimeDataProvider service) {
        super(authCtx, projectKey, config, loaded, service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Schema detectSchema(StreamsInputSplit split) throws Exception {
        EnrichedInputStream stream;
        Schema schema = null;
        while (schema == null && (stream = split.nextStream()) != null) {
            InputStream rawStream;
            InputStreamWithContextInfo isn;
            if (stream.isArchive()) {
                ArchiveInputStream archiveStream = stream.archiveContent();
                try {
                    ArchiveEntry entry;
                    while (schema == null && (entry = archiveStream.getNextEntry()) != null) {
                        if (entry.isDirectory()) continue;
                        logger.info((Object)("  Start archive stream entry : " + stream.desc() + "/" + entry.getName() + " size= " + entry.getSize()));
                        if (FSDatasetUtils.isBadFile(entry.getName())) continue;
                        this.rc.setFile(stream.desc() + "/" + entry.getName());
                        isn = new InputStreamWithContextInfo((InputStream)new CloseShieldInputStream((InputStream)archiveStream), stream.getPathWithinProvider() + "/" + entry.getName(), stream.desc() + "/" + entry.getName(), null, stream.getLastModifiedSupplier());
                        schema = this.doExtractSchema(isn);
                    }
                    continue;
                }
                finally {
                    if (archiveStream != null) {
                        archiveStream.close();
                    }
                    continue;
                }
            }
            if (stream.getCompression() == EnrichedInputStream.Compression.GZIP || stream.getCompression() == EnrichedInputStream.Compression.BZIP2 || stream.getCompression() == EnrichedInputStream.Compression.SNAPPY || stream.getCompression() == EnrichedInputStream.Compression.DEFLATE || stream.getCompression() == EnrichedInputStream.Compression.LZO) {
                InputStream decompressedStream;
                rawStream = stream.rawHeadStream(this.limit != null ? this.limit.maxBytes : -1L);
                try {
                    decompressedStream = new DecodedInputStreamFactory().addDecoding(stream.getCompression(), rawStream);
                }
                catch (Exception e) {
                    IOUtils.closeQuietly((InputStream)rawStream);
                    throw e;
                }
                try {
                    this.rc.setFile(stream.desc());
                    isn = new InputStreamWithContextInfo(decompressedStream, stream.getPathWithinProvider(), stream.getFilename(), null, stream.getLastModifiedSupplier());
                    schema = this.doExtractSchema(isn);
                    continue;
                }
                finally {
                    IOUtils.closeQuietly((InputStream)decompressedStream);
                    continue;
                }
            }
            if (stream.getCompression() == EnrichedInputStream.Compression.NONE) {
                rawStream = stream.rawHeadStream(this.limit != null ? this.limit.maxBytes : -1L);
                logger.info((Object)("Start uncompressed stream : " + stream.desc()));
                try {
                    this.rc.setFile(stream.desc());
                    InputStreamWithContextInfo isn2 = new InputStreamWithContextInfo(rawStream, stream.getPathWithinProvider(), stream.getFilename(), null, stream.getLastModifiedSupplier());
                    schema = this.doExtractSchema(isn2);
                    continue;
                }
                finally {
                    IOUtils.closeQuietly((InputStream)rawStream);
                    continue;
                }
            }
            throw new NotImplementedException();
        }
        return schema;
    }

    protected Schema doExtractSchema(InputStreamWithContextInfo in) throws Exception {
        ClassLoader classLoader = this.service.getClassloader(this.loaded.getType());
        CustomFormat format = (CustomFormat)new PluginClazzLoader(classLoader).loadClazz(((CustomJavaFormatDesc)this.loaded.getDesc()).formatClass);
        PluginSettingsResolver.ResolvedSettings resolvedSettings = this.service.getExpandedPluginSettings(this.loaded.getType(), this.authCtx, this.projectKey, this.config);
        try (CustomFormatSchemaDetector detector = format.getDetector(resolvedSettings.config, resolvedSettings.pluginConfig);){
            Schema schema = detector.readSchema(in);
            return schema;
        }
    }
}

