/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats.yxdb;

import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SchemaValidator;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datasets.SchemaDetection;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.formats.FormatMeta;
import com.dataiku.dip.formats.yxdb.AlteryxDBFormatConfig;
import com.dataiku.dip.input.formats.ArchiveCapableFormatExtractor;
import com.dataiku.dip.input.formats.FixedSchemaExtractor;
import com.dataiku.dip.input.formats.FormatExtractor;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.plugin.InputStreamWithContextInfo;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.ParamDesc;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.com.google.common.io.BaseEncoding;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.tlarsendataguy.yxdb.Spatial;
import com.tlarsendataguy.yxdb.YxdbField;
import com.tlarsendataguy.yxdb.YxdbReader;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class AlteryxDBFormatExtractor
extends ArchiveCapableFormatExtractor
implements FixedSchemaExtractor {
    public static final FormatMeta<AlteryxDBFormatExtractor, AlteryxDBFormatConfig> META = new FormatMeta<AlteryxDBFormatExtractor, AlteryxDBFormatConfig>(){

        @Override
        public String getType() {
            return "yxdb";
        }

        @Override
        public String getLabel() {
            return "YXDB";
        }

        @Override
        public SchemaDetection.SchemaHandlingType getSchemaHandlingType() {
            return SchemaDetection.SchemaHandlingType.FIXED_TYPE_AND_SCHEMA;
        }

        @Override
        public ParamDesc[] getParams() {
            String language = "en";
            return new ParamDesc[]{ParamDesc.advancedSelect("dateTypeHandling", this.translate(language, "FORMATS.AlteryxDBFormatConfig.dateTypeHandling", "Read Date fields as"), "", AlteryxDBFormatConfig.DateHandling.class, language).withDefaultValue(AlteryxDBFormatConfig.DateHandling.READ_AS_STRING).withTooltip(this.translate(language, "FORMATS.AlteryxDBFormatConfig.dateTypeHandling.TOOLTIP", "Specify how values of type Date are mapped in DSS.")), ParamDesc.advancedSelect("dateTimeTypeHandling", this.translate(language, "FORMATS.AlteryxDBFormatConfig.dateTimeTypeHandling", "Read Date/Time fields as"), "", ParamDesc.enumValues(AlteryxDBFormatConfig.DateHandling.class), new String[]{"String", "DSS Datetime with tz"}).withDefaultValue(AlteryxDBFormatConfig.DateHandling.READ_AS_STRING).withTooltip(this.translate(language, "FORMATS.AlteryxDBFormatConfig.dateTimeTypeHandling.TOOLTIP", "Specify how values of type DateTime are mapped in DSS.")), ParamDesc.advancedSelect("assumedTz", this.translate(language, "FORMATS.AlteryxDBFormatConfig.assumedTz", "Assumed time zone"), "", this.getTimezoneIds(), this.getTimezoneLabels()).withDefaultValue("").withTooltip(this.translate(language, "FORMATS.AlteryxDBFormatConfig.assumedTz.TOOLTIP", "When reading Date or Date/Time fields as DSS datetime with tz, timezone to assign to this timezone-less data."))};
        }

        private String[] getTimezoneIds() {
            ArrayList<String> result = new ArrayList<String>();
            result.add("");
            result.addAll(DateTimeZone.getAvailableIDs());
            return result.toArray(new String[0]);
        }

        private String[] getTimezoneLabels() {
            ArrayList<String> result = new ArrayList<String>();
            result.add("Local time zone");
            result.addAll(DateTimeZone.getAvailableIDs());
            return result.toArray(new String[0]);
        }

        @Override
        public Class<? extends FormatParams> paramsClass() {
            return AlteryxDBFormatConfig.class;
        }

        @Override
        public FormatExtractor build(AuthCtx authCtx, String projectKey, FormatParams params) {
            return new AlteryxDBFormatExtractor((AlteryxDBFormatConfig)params);
        }

        @Override
        public OutputFormatter buildFormatter(AuthCtx authCtx, String projectKey, FormatParams params) {
            throw new NotImplementedException("YXDB format can only be read by DSS");
        }
    };
    private final AlteryxDBFormatConfig config;
    private static final Logger logger = Logger.getLogger((String)"dku.format.yxdb");

    public AlteryxDBFormatExtractor(AlteryxDBFormatConfig config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Schema detectSchema(InputStream stream) throws Exception {
        try (BufferedInputStream inputStream = new BufferedInputStream(stream);){
            Schema schema;
            YxdbReader reader = new YxdbReader(inputStream);
            try {
                schema = this.buildSchema(reader.listFields());
            }
            catch (Throwable throwable) {
                reader.close();
                throw throwable;
            }
            reader.close();
            return schema;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doExtractStream(InputStreamWithContextInfo isn, ProcessorOutput out, ColumnFactory cf, RowFactory rf, ArchiveCapableFormatExtractor.ArchiveCapableObserver observer) throws Exception {
        InputStream is = isn.getInputStream();
        logger.info((Object)"YXDB starting to process one stream");
        long rowCount = 0L;
        try (BufferedInputStream inputStream = new BufferedInputStream(is);){
            YxdbReader reader = new YxdbReader(inputStream);
            Schema dssSchema = this.getSchema();
            List<YxdbField> alteryxDBSchema = reader.listFields();
            if (dssSchema == null) {
                logger.info((Object)"No DSS schema has been provided. A new one will be generated from the YXDB file.");
                dssSchema = this.buildSchema(alteryxDBSchema);
            }
            logger.debug((Object)("YXDB file original schema is :\n" + JSON.prettyLog(alteryxDBSchema)));
            logger.debug((Object)("DSS schema is :\n" + JSON.prettyLog((Object)dssSchema)));
            new SchemaValidator().validate(dssSchema);
            ArrayList<Column> columns = new ArrayList<Column>();
            for (SchemaColumn sc : dssSchema.getColumns()) {
                columns.add(cf.column(sc.getName()));
            }
            try {
                while (true) {
                    if (reader.next()) {
                        Row row = this.extractRow(reader, columns, rf);
                        isn.fillRowContext(row.getRowContext());
                        row.getRowContext().sourceRecord = rowCount + 1L;
                        out.emitRow(row);
                        if (++rowCount % 500L == 0L) {
                            observer.onInterval(rowCount);
                        }
                        if (observer.checkLimit(rowCount)) continue;
                        boolean bl = false;
                        return bl;
                        continue;
                    }
                    break;
                }
            }
            finally {
                reader.close();
            }
        }
        observer.onEnd(rowCount);
        return true;
    }

    private Row extractRow(YxdbReader reader, List<Column> columns, RowFactory rf) {
        Row row = rf.row();
        List<YxdbField> yxdbFields = reader.listFields();
        int columnCount = yxdbFields.size();
        block12: for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
            YxdbField field = yxdbFields.get(columnIndex);
            Column column = columns.get(columnIndex);
            switch (field.type()) {
                case STRING: {
                    Object value = reader.readString(columnIndex);
                    if (value == null) continue block12;
                    row.put(column, (String)value);
                    continue block12;
                }
                case BLOB: {
                    String value;
                    byte[] bytes = reader.readBlob(columnIndex);
                    if (bytes == null) continue block12;
                    try {
                        value = Spatial.ToGeoJson(bytes);
                    }
                    catch (RuntimeException e) {
                        value = BaseEncoding.base64().encode(bytes);
                    }
                    row.put(column, value);
                    continue block12;
                }
                case BYTE: {
                    Object value = reader.readByte(columnIndex);
                    if (value == null) continue block12;
                    row.put(column, ((Byte)value).intValue());
                    continue block12;
                }
                case DOUBLE: {
                    Object value = reader.readDouble(columnIndex);
                    if (value == null) continue block12;
                    row.put(column, ((Double)value).doubleValue());
                    continue block12;
                }
                case LONG: {
                    Object value = reader.readLong(columnIndex);
                    if (value == null) continue block12;
                    row.put(column, ((Long)value).longValue());
                    continue block12;
                }
                case BOOLEAN: {
                    Object value = reader.readBoolean(columnIndex);
                    if (value == null) continue block12;
                    row.put(column, ((Boolean)value).booleanValue());
                    continue block12;
                }
                case DATE: {
                    DateTime dt;
                    Object value;
                    if (this.config.dateTypeHandling == AlteryxDBFormatConfig.DateHandling.READ_AS_TIMESTAMP) {
                        value = reader.readDate(columnIndex);
                        if (value == null) continue block12;
                        dt = new DateTime(((LocalDate)value).getYear(), ((LocalDate)value).getMonthValue(), ((LocalDate)value).getDayOfMonth(), 0, 0, this.config.getAssumedTimezone());
                        row.put(column, DKUDateUtils.isoFormatUTC((long)dt.getMillis()));
                        continue block12;
                    }
                    value = reader.readString(columnIndex);
                    if (value == null) continue block12;
                    row.put(column, (String)value);
                    continue block12;
                }
                case DATETIME: {
                    DateTime dt;
                    Object value;
                    if (this.config.dateTimeTypeHandling == AlteryxDBFormatConfig.DateHandling.READ_AS_TIMESTAMP) {
                        value = reader.readDateTime(columnIndex);
                        if (value == null) continue block12;
                        dt = new DateTime(((LocalDateTime)value).getYear(), ((LocalDateTime)value).getMonthValue(), ((LocalDateTime)value).getDayOfMonth(), ((LocalDateTime)value).getHour(), ((LocalDateTime)value).getMinute(), ((LocalDateTime)value).getSecond(), ((LocalDateTime)value).getNano() / 1000000, this.config.getAssumedTimezone());
                        row.put(column, DKUDateUtils.isoFormatUTC((long)dt.getMillis()));
                        continue block12;
                    }
                    value = reader.readString(columnIndex);
                    if (value == null) continue block12;
                    row.put(column, (String)value);
                    continue block12;
                }
                default: {
                    logger.warn((Object)("Unhandled YXDB type: " + String.valueOf((Object)field.type())));
                }
            }
        }
        return row;
    }

    private Schema buildSchema(List<YxdbField> listFields) {
        Schema schema = new Schema();
        for (YxdbField field : listFields) {
            String name = field.name();
            if (name == null) {
                throw new IllegalArgumentException("Invalid/Unhandled YXDB file: missing name for a field.");
            }
            YxdbField.DataType type = field.type();
            if (type == null) {
                throw new IllegalArgumentException("Invalid/Unhandled YXDB file: missing type for field " + name);
            }
            schema.addColumn(new SchemaColumn(name, this.toDSSType(type)));
        }
        return schema;
    }

    private Type toDSSType(YxdbField.DataType type) {
        Preconditions.checkNotNull((Object)((Object)type));
        switch (type) {
            case STRING: 
            case BLOB: {
                return Type.STRING;
            }
            case LONG: {
                return Type.BIGINT;
            }
            case DOUBLE: {
                return Type.DOUBLE;
            }
            case BOOLEAN: {
                return Type.BOOLEAN;
            }
            case DATE: {
                switch (this.config.dateTypeHandling) {
                    case READ_AS_TIMESTAMP: {
                        return Type.DATE;
                    }
                    case READ_AS_STRING: {
                        return Type.STRING;
                    }
                }
                throw new IllegalArgumentException("Unhandled DateHandling value found in config.dateTypeHandling");
            }
            case DATETIME: {
                switch (this.config.dateTimeTypeHandling) {
                    case READ_AS_TIMESTAMP: {
                        return Type.DATE;
                    }
                    case READ_AS_STRING: {
                        return Type.STRING;
                    }
                }
                throw new IllegalArgumentException("Unhandled DateHandling value found in config.dateTimeTypeHandling");
            }
            case BYTE: {
                return Type.TINYINT;
            }
        }
        throw new IllegalArgumentException("Unhandled YXDB type");
    }
}

