/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.impala;

import com.dataiku.dip.connections.ImpalaConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.impala.ImpalaConfigurator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.ImpalaSQLDialect;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.warnings.WarningsContext;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang.StringUtils;

public class ImpalaUpdater {
    private static DKULogger logger = DKULogger.getLogger(ImpalaUpdater.class);

    public boolean invalidateTable(String projectKey, String database, String table, AuthCtx authCtx, WarningsContext warningsContext, boolean lenient) throws SQLException, IOException, DKUSecurityException, InterruptedException {
        if (!ImpalaConfigurator.impalaAvailable(authCtx, projectKey)) {
            return false;
        }
        try {
            ImpalaConnection connection = ImpalaConfigurator.configureConnectionForDatabase(authCtx, "default");
            SQLConnectionProvider.SQLConnectionData cdata = connection.getConnectionData_NT(authCtx, projectKey);
            try (SQLConnectionProvider.SQLConnectionWrapper jdbc2 = SQLConnectionProvider.newConnection(cdata, authCtx, projectKey);
                 Statement stmt = jdbc2.createStatement();){
                ImpalaSQLDialect dialect = new ImpalaSQLDialect();
                if (StringUtils.isBlank((String)database)) {
                    stmt.execute("INVALIDATE METADATA " + dialect.quoteIdentifier(table));
                } else {
                    stmt.execute("INVALIDATE METADATA " + dialect.quoteIdentifier(database) + "." + dialect.quoteIdentifier(table));
                }
            }
            logger.info((Object)("Invalidated Impala metadata for table " + database + "." + table));
            return true;
        }
        catch (SQLException e) {
            if (lenient) {
                String message = "Cannot invalidate Impala metadata for table " + database + "." + table;
                if (warningsContext != null) {
                    warningsContext.addWarning(WarningsContext.WarningType.IMPALA_METADATA_SYNCHRONIZE, message, (Throwable)e, logger);
                } else {
                    logger.warn((Object)message, (Throwable)e);
                }
                return false;
            }
            throw e;
        }
    }
}

