/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.row;

import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.input.InputSplitProgressListener;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.row.RowsInputSplit;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.warnings.WarningsContext;
import java.util.List;
import javax.annotation.Nullable;

public class RowSequenceInputSplit
extends RowsInputSplit {
    List<? extends RowsInputSplit> splits;
    protected static DKULogger logger = DKULogger.getLogger((String)"dku.input.rows");

    public RowSequenceInputSplit(List<? extends RowsInputSplit> splits) {
        this.splits = splits;
    }

    @Override
    public long push(ProcessorOutput out, ColumnFactory cf, RowFactory rf, @Nullable ExtractionLimit limit, InputSplitProgressListener listener, WarningsContext warningsContext) throws Exception {
        long totalRowsPushed = 0L;
        long initialRowsToPush = limit == null ? -1L : limit.maxRecords;
        for (RowsInputSplit rowsInputSplit : this.splits) {
            logger.info((Object)("Starting to push split " + String.valueOf(rowsInputSplit) + " with limit= " + (limit == null ? -1L : limit.maxRecords)));
            totalRowsPushed += rowsInputSplit.push(out, cf, rf, limit, listener, warningsContext);
            if (initialRowsToPush <= 0L) continue;
            assert (limit != null);
            limit.maxRecords = initialRowsToPush - totalRowsPushed;
            if (limit.maxRecords > 0L) {
                logger.info((Object)("After split " + String.valueOf(rowsInputSplit) + ", still have " + limit.maxRecords + " to push"));
                continue;
            }
            if (limit.maxRecords == 0L) {
                logger.info((Object)"Limit done");
                return totalRowsPushed;
            }
            throw new Error("Unreachable initialRows=" + initialRowsToPush + " pushed=" + totalRowsPushed + " max=" + limit.maxRecords);
        }
        return totalRowsPushed;
    }

    public String getDesc() {
        return "Multi Split";
    }
}

