/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.integrations;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.analysis.coreservices.MLBaseService;
import com.dataiku.dip.analysis.docgen.ModelDocumentGenerationService;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dashboards.DashboardsService;
import com.dataiku.dip.dashboards.export.DashboardsExportService;
import com.dataiku.dip.dashboards.export.model.DashboardExport;
import com.dataiku.dip.dashboards.model.Dashboard;
import com.dataiku.dip.dashboards.model.DashboardPageSectionSettings;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.ColoringDefinition;
import com.dataiku.dip.datasets.DatasetSelection;
import com.dataiku.dip.datasets.UniversalSingleThreadPusher;
import com.dataiku.dip.datasets.fs.LocalFSProvider;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.export.BasicExportHandler;
import com.dataiku.dip.export.CustomExportersRegistry;
import com.dataiku.dip.export.ExportParams;
import com.dataiku.dip.export.ExportUtils;
import com.dataiku.dip.export.input.ExportDataset;
import com.dataiku.dip.files.MimeTypeUtils;
import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.formats.html.HtmlFormat;
import com.dataiku.dip.fs.FSEnumerationResult;
import com.dataiku.dip.fs.FSEnumerationSettings;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.graphicsexport.BaseExportService;
import com.dataiku.dip.graphicsexport.FlowDocumentGenerationService;
import com.dataiku.dip.graphicsexport.model.BaseExport;
import com.dataiku.dip.graphicsexport.model.ExportFormat;
import com.dataiku.dip.graphicsexport.wikis.WikiExportService;
import com.dataiku.dip.graphicsexport.wikis.model.WikiExport;
import com.dataiku.dip.graphicsexport.wikis.model.WikiExportType;
import com.dataiku.dip.input.TableColoring;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.managedfolder.ManagedFoldersService;
import com.dataiku.dip.notebooks.exports.JupyterExport;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.output.StreamOutputWriter;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.reports.Report;
import com.dataiku.dip.reports.ReportsService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.notifications.VariableLookup;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.server.services.JupyterExportService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.model.DatasetExploreSettings;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.server.DataService;
import com.dataiku.dip.shaker.server.DatasetExploreSettingsDAO;
import com.dataiku.dip.shaker.server.MemScriptRunner;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Params;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.lookup.StringLookup;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AttachmentService {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private ExportUtils exportUtils;
    @Autowired
    private GeneralSettingsService generalSettingsService;
    @Autowired
    private ManagedFolderDAO managedFolderDAO;
    @Autowired
    private ReportsService reportsService;
    @Autowired
    private JupyterExportService jupyterExportService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private DashboardsExportService dashboardsExportService;
    @Autowired
    private WikiExportService wikiExportService;
    @Autowired
    private ModelDocumentGenerationService modelDocumentGenerationService;
    @Autowired
    private FlowDocumentGenerationService flowDocumentGenerationService;
    @Autowired
    private ManagedFoldersService managedFoldersService;
    @Autowired
    private MLBaseService mlBaseService;
    @Autowired
    private DashboardsService dashboardsService;
    private static final FSEnumerationSettings FIRST_NOT_EMPTY = FSEnumerationSettings.firstNotEmpty();
    private static final String ERR_NO_ATTACHMENT = "No {0} selected in the attachment. Select a {0} or remove the associated attachment";
    private static DKULogger logger = DKULogger.getLogger((String)"dip.attachements.service");

    public void add(MailScenarioAttachment attachment, Multipart multipart, AuthCtx authCtx, String projectKey, VariableLookup lookup) throws Exception {
        if (attachment.type == null) {
            logger.warn((Object)"Attachment of unspecified type, skipping");
            return;
        }
        logger.info((Object)("Process attachment of type " + String.valueOf((Object)attachment.type)));
        int maxAttachmentSize = 0x1400000;
        try (Transaction t = this.transactionService.beginRead();){
            GeneralSettingsDAO.GeneralSettings generalSettings = this.generalSettingsService.read();
            if (generalSettings.limits.attachmentBytes.hard > -1L) {
                maxAttachmentSize = (int)generalSettings.limits.attachmentBytes.hard;
            }
        }
        ExportRestrictions exportRestrictions = new ExportRestrictions(ApplicationConfigurator.getParams());
        if (exportRestrictions.disableAll) {
            throw new UnauthorizedException("Exports and attachments have been forbidden by your administrator", "export-forbidden");
        }
        switch (attachment.type) {
            case LOG: {
                this.handle(multipart, lookup, maxAttachmentSize);
                break;
            }
            case DATASET: {
                if (exportRestrictions.disableAllDataset) {
                    throw new UnauthorizedException("Dataset exports have been forbidden by your administrator", "dataset-export-forbidden");
                }
                AttachmentParams attachmentParams = (DatasetExportAttachment)JSON.parse((String)JSON.json((Object)attachment.params), DatasetExportAttachment.class);
                this.handle((DatasetExportAttachment)attachmentParams, multipart, authCtx, projectKey, lookup, maxAttachmentSize);
                break;
            }
            case DASHBOARD_EXPORT: {
                AttachmentParams attachmentParams = (DashboardExportAttachment)JSON.parse((String)JSON.json((Object)attachment.params), DashboardExportAttachment.class);
                this.handle((DashboardExportAttachment)attachmentParams, multipart, authCtx, projectKey);
                break;
            }
            case FOLDER: {
                if (exportRestrictions.disableAllData) {
                    throw new UnauthorizedException("Data exports have been forbidden by your administrator", "data-export-forbidden");
                }
                AttachmentParams attachmentParams = (FolderAttachment)JSON.parse((String)JSON.json((Object)attachment.params), FolderAttachment.class);
                this.handle((FolderAttachment)attachmentParams, multipart, projectKey, maxAttachmentSize, authCtx);
                break;
            }
            case FOLDER_ITEM: {
                if (exportRestrictions.disableAllData) {
                    throw new UnauthorizedException("Data exports have been forbidden by your administrator", "data-export-forbidden");
                }
                AttachmentParams attachmentParams = (FolderItemAttachment)JSON.parse((String)JSON.json((Object)attachment.params), FolderItemAttachment.class);
                this.handle((FolderItemAttachment)attachmentParams, multipart, projectKey, lookup, maxAttachmentSize, authCtx);
                break;
            }
            case NOTEBOOK_EXPORT: {
                AttachmentParams attachmentParams = (NotebookExportAttachment)JSON.parse((String)JSON.json((Object)attachment.params), NotebookExportAttachment.class);
                this.handle((NotebookExportAttachment)attachmentParams, multipart, authCtx, projectKey, lookup);
                break;
            }
            case RMARKDOWN_REPORT: {
                AttachmentParams attachmentParams = (RMarkdownReportAttachment)JSON.parse((String)JSON.json((Object)attachment.params), RMarkdownReportAttachment.class);
                this.handle((RMarkdownReportAttachment)attachmentParams, multipart, authCtx, projectKey);
                break;
            }
            case WIKI_EXPORT: {
                AttachmentParams attachmentParams = (WikiExportAttachment)JSON.parse((String)JSON.json((Object)attachment.params), WikiExportAttachment.class);
                this.handle((WikiExportAttachment)attachmentParams, multipart, authCtx, projectKey);
                break;
            }
            case SAVED_MODEL_DOCUMENTATION_EXPORT: {
                AttachmentParams attachmentParams = (SavedModelDocumentationExportAttachment)JSON.parse((String)JSON.json((Object)attachment.params), SavedModelDocumentationExportAttachment.class);
                this.handle((SavedModelDocumentationExportAttachment)attachmentParams, multipart, authCtx, projectKey);
                break;
            }
            case ANALYSIS_MODEL_DOCUMENTATION_EXPORT: {
                AttachmentParams attachmentParams = (AnalysisModelDocumentationExportAttachment)JSON.parse((String)JSON.json((Object)attachment.params), AnalysisModelDocumentationExportAttachment.class);
                this.handle((AnalysisModelDocumentationExportAttachment)attachmentParams, multipart, authCtx, projectKey);
                break;
            }
            case FLOW_DOCUMENTATION_EXPORT: {
                AttachmentParams attachmentParams = (FlowDocumentationExportAttachment)JSON.parse((String)JSON.json((Object)attachment.params), FlowDocumentationExportAttachment.class);
                this.handle((FlowDocumentationExportAttachment)attachmentParams, multipart, authCtx, projectKey);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(FlowDocumentationExportAttachment attachmentParams, Multipart multipart, AuthCtx authCtx, String projectKey) throws Exception {
        if (!(attachmentParams.defaultTemplate || attachmentParams.sourceFolderId != null && attachmentParams.templatePath != null)) {
            throw new IllegalArgumentException("No custom template selected. Select a custom template or use default template.");
        }
        File templateFile = this.flowDocumentGenerationService.getTemplate(attachmentParams.defaultTemplate, projectKey, attachmentParams.sourceFolderId, attachmentParams.templatePath, authCtx);
        File outputFile = this.flowDocumentGenerationService.generateDocumentAndWaitFile((DSSAuthCtx)authCtx, projectKey, new FileInputStream(templateFile));
        try {
            this.attachFileToEmail(multipart, outputFile);
        }
        finally {
            this.flowDocumentGenerationService.clean(outputFile);
        }
    }

    private void handle(SavedModelDocumentationExportAttachment attachmentParams, Multipart multipart, AuthCtx authCtx, String projectKey) throws Exception {
        if (attachmentParams.modelId == null) {
            throw new IllegalArgumentException("No saved model selected in the attachment. Select a saved model or remove the associated attachment.");
        }
        if (attachmentParams.fullModelId == null) {
            throw new IllegalArgumentException("No model selected in the attachment. Select a model or remove the associated attachment.");
        }
        if (ModelDocumentGenerationService.isModelDocumentationConstant(attachmentParams.fullModelId)) {
            FullModelId fmi = this.modelDocumentGenerationService.getSavedModelFMI_NT(projectKey, attachmentParams.modelId, attachmentParams.fullModelId);
            if (fmi == null) {
                throw new IllegalArgumentException(String.format("Failed to get model version typed %s of %s", attachmentParams.fullModelId, attachmentParams.modelId));
            }
            attachmentParams.fullModelId = fmi.toString();
        }
        this.handle((ModelDocumentationExportAttachment)attachmentParams, multipart, authCtx, projectKey);
    }

    private void handle(AnalysisModelDocumentationExportAttachment attachmentParams, Multipart multipart, AuthCtx authCtx, String projectKey) throws Exception {
        if (attachmentParams.analysisId == null) {
            throw new IllegalArgumentException("No analysis selected in the attachment. Select an analysis or remove the associated attachment.");
        }
        if (attachmentParams.fullModelId == null) {
            throw new IllegalArgumentException("No model selected in the attachment. Select a model or remove the associated attachment.");
        }
        if (ModelDocumentGenerationService.isModelDocumentationConstant(attachmentParams.fullModelId)) {
            MLTaskLoc loc = new MLTaskLoc(projectKey, attachmentParams.analysisId, attachmentParams.mlTaskId);
            String fullModelId = this.mlBaseService.getLatestModelId(loc).toString();
            if (fullModelId == null) {
                throw new IllegalArgumentException("Failed to get model version typed " + attachmentParams.fullModelId + " of " + attachmentParams.analysisId);
            }
            attachmentParams.fullModelId = fullModelId;
        }
        this.handle((ModelDocumentationExportAttachment)attachmentParams, multipart, authCtx, projectKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(ModelDocumentationExportAttachment attachmentParams, Multipart multipart, AuthCtx authCtx, String projectKey) throws Exception {
        if (!(attachmentParams.defaultTemplate || attachmentParams.sourceFolderId != null && attachmentParams.templatePath != null)) {
            throw new IllegalArgumentException("No custom template selected. Select a custom template or use default template.");
        }
        FullModelId fmi = FullModelId.parse(attachmentParams.fullModelId);
        String modelProjectKey = fmi.getProjectKey();
        if (modelProjectKey == null) {
            throw new IllegalArgumentException("Unknown source project for selected model. Select a different model or remove this attachment.");
        }
        File templateFile = this.modelDocumentGenerationService.getTemplate(attachmentParams.defaultTemplate, attachmentParams.fullModelId, authCtx, projectKey, attachmentParams.sourceFolderId, attachmentParams.templatePath);
        File outputFile = this.modelDocumentGenerationService.generateDocumentAndWaitFile((DSSAuthCtx)authCtx, modelProjectKey, new FileInputStream(templateFile), fmi);
        try {
            this.attachFileToEmail(multipart, outputFile);
        }
        finally {
            try {
                this.modelDocumentGenerationService.clean(outputFile);
            }
            catch (IOException e) {
                logger.warn((Object)"Unable to delete temporary export directory.", (Throwable)e);
            }
        }
    }

    private void handle(NotebookExportAttachment attachment, Multipart multipart, AuthCtx authCtx, String projectKey, VariableLookup lookup) throws Exception {
        AnyLoc loc = DatasetLocUtils.DatasetLoc.resolveSmart(projectKey, attachment.attachedNotebookId);
        JupyterExport export = null;
        logger.infoV("Handling notebook attachment of notebook=%s mode=%s execute=%s", new Object[]{attachment.attachedNotebookId, attachment.mode, attachment.execute});
        switch (attachment.mode) {
            case CREATE_NEW: {
                export = this.jupyterExportService.create_NT(authCtx, loc.getProjectKey(), loc.getId(), attachment.execute);
                break;
            }
            case USE_LATEST: {
                export = this.jupyterExportService.getLast_NT(loc.getProjectKey(), loc.getId());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported attachment mode " + String.valueOf((Object)attachment.mode));
            }
        }
        if (attachment.isInline) {
            if (StringUtils.isBlank((String)attachment.htmlVariable)) {
                logger.info((Object)"Variable name for notebook as html not defined, using default : 'notebookHtml'");
                attachment.htmlVariable = "notebookHtml";
            }
            lookup.addVariable(attachment.htmlVariable, export.html);
        } else {
            MimeBodyPart fileBodyPart = new MimeBodyPart();
            ByteArrayDataSource source = new ByteArrayDataSource(export.html.getBytes(StandardCharsets.UTF_8), "text/html");
            fileBodyPart.setDataHandler(new DataHandler((DataSource)source));
            fileBodyPart.setFileName("notebook.html");
            multipart.addBodyPart((BodyPart)fileBodyPart);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(RMarkdownReportAttachment attachment, Multipart multipart, AuthCtx authCtx, String projectKey) throws Exception {
        String script;
        Report report;
        try (Transaction transaction = this.transactionService.beginRead();){
            AnyLoc loc = DatasetLocUtils.DatasetLoc.resolveSmart(projectKey, attachment.attachedReportId);
            report = this.reportsService.getMandatoryUnsafe(loc.getProjectKey(), loc.getId());
            script = this.reportsService.getScript(loc.getProjectKey(), loc.getId());
        }
        File outputFile = this.reportsService.newReportDownloadTempFile(report, attachment.rmdOutputFormat);
        try {
            ByteArrayDataSource source;
            FutureResponse fr = this.reportsService.startDownload_NT(authCtx, report, script, attachment.rmdOutputFormat, attachment.useLatestSnapshotIfItContainsFormat, outputFile);
            fr = this.futureService.waitForFinalResponse(fr);
            MimeBodyPart fileBodyPart = new MimeBodyPart();
            try (FileInputStream is = new FileInputStream(outputFile);){
                source = new ByteArrayDataSource((InputStream)is, attachment.rmdOutputFormat.getContentType());
            }
            fileBodyPart.setDataHandler(new DataHandler((DataSource)source));
            fileBodyPart.setFileName(report.getDisplayName() + "." + attachment.rmdOutputFormat.getExtension());
            multipart.addBodyPart((BodyPart)fileBodyPart);
        }
        finally {
            DKUFileUtils.forceDelete((File)outputFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends BaseExport> void exportToMultipart(String projectKey, T export, BaseExportService<T, ?, ?> baseExportService, Multipart multipart, AuthCtx authCtx) throws Exception {
        File file = baseExportService.exportAndWait((AuthCtx)authCtx, export).exportFile;
        try {
            this.attachFileToEmail(multipart, file);
        }
        finally {
            try {
                baseExportService.clean(projectKey, export.exportId);
            }
            catch (IOException e) {
                logger.warn((Object)"Unable to delete temporary export directory.", (Throwable)e);
            }
        }
    }

    private void handle(DashboardExportAttachment attachment, Multipart multipart, AuthCtx authCtx, String projectKey) throws Exception {
        ErrorContext.checkNotNull((Object)attachment.dashboardId, (String)MessageFormat.format(ERR_NO_ATTACHMENT, "dashboard"));
        ExportFormat exportFormat = attachment.exportFormat;
        if (attachment.shouldUseDashboardFormatSettings) {
            try (Transaction t = this.transactionService.beginRead();){
                Dashboard dashboard = this.dashboardsService.getOrNull(projectKey, attachment.dashboardId);
                exportFormat = new ExportFormat();
                DashboardPageSectionSettings.PageSectionFormat pageSectionFormat = dashboard.pageSectionSettings.getPageSectionFormat();
                exportFormat.paperSize = ExportFormat.PaperSize.valueOf(pageSectionFormat.getFormatName().name());
                exportFormat.fileType = attachment.exportFormat.fileType;
                exportFormat.height = pageSectionFormat.getyInPx();
                exportFormat.width = pageSectionFormat.getxInPx();
            }
        }
        DashboardExport export = new DashboardExport(projectKey, new DashboardExport.Target(attachment.dashboardId, attachment.filtersBySlide, exportFormat));
        this.exportToMultipart(projectKey, export, this.dashboardsExportService, multipart, authCtx);
    }

    private void handle(WikiExportAttachment attachment, Multipart multipart, AuthCtx authCtx, String projectKey) throws Exception {
        WikiExport export;
        ErrorContext.checkNotNull((Object)((Object)attachment.exportType), (String)"No export type defined for the wiki export attachment");
        if (attachment.exportType == WikiExportType.WHOLE_WIKI) {
            export = new WikiExport(projectKey, attachment.exportFormat, attachment.exportAttachments);
        } else {
            ErrorContext.checkNotNull((Object)attachment.articleId, (String)MessageFormat.format(ERR_NO_ATTACHMENT, "wiki article"));
            export = new WikiExport(projectKey, attachment.exportFormat, attachment.articleId, attachment.exportType == WikiExportType.ARTICLE_AND_CHILDREN, attachment.exportAttachments);
        }
        this.exportToMultipart(projectKey, export, this.wikiExportService, multipart, authCtx);
    }

    private void handle(FolderItemAttachment attachment, Multipart multipart, String projectKey, VariableLookup lookup, int maxAttachmentSize, AuthCtx authCtx) throws Exception {
        if (StringUtils.isNotBlank((String)attachment.folderId) && StringUtils.isNotBlank((String)attachment.attachedItemPath)) {
            byte[] bytesContent;
            EnrichedInputStream attachmentStream;
            File localBasePath;
            ManagedFolder folder;
            StringSubstitutor substitutor = new StringSubstitutor((StringLookup)lookup);
            String attachedItemPath = substitutor.replace(attachment.attachedItemPath);
            if (StringUtils.isBlank((String)attachedItemPath)) {
                throw new IllegalArgumentException("Substitution in attached item path yielded an empty path");
            }
            if (attachment.isInline && StringUtils.isBlank((String)attachment.contentId)) {
                throw new IllegalArgumentException("inline folder items must have a valid contentId");
            }
            ManagedFolderHandler handler = null;
            try (Transaction transaction = this.transactionService.beginRead();){
                AnyLoc loc = DatasetLocUtils.DatasetLoc.resolveSmart(projectKey, attachment.folderId);
                folder = (ManagedFolder)this.managedFolderDAO.getMandatoryUnsafe(loc);
            }
            try {
                handler = (ManagedFolderHandler)folder.buildHandler(authCtx);
                localBasePath = handler.getProvider() instanceof LocalFSProvider ? new File(handler.getResolvedPath()) : null;
                long fileSize = handler.getFileSize(attachedItemPath);
                if (fileSize > (long)maxAttachmentSize) {
                    try {
                        handler.close();
                    }
                    catch (Exception e) {
                        logger.errorV((Throwable)e, "Cannot close managed folder handler for %s", new Object[]{folder.getFullId()});
                    }
                    throw new IllegalArgumentException("File produced for the attachment is too large (" + fileSize + " > " + maxAttachmentSize + ")");
                }
                attachmentStream = handler.getInputStream(attachedItemPath);
            }
            catch (IOException e) {
                if (handler != null) {
                    handler.close();
                }
                throw new IllegalArgumentException("File does not exist:" + attachedItemPath, e);
            }
            try (ManagedFolderHandler.WrappedInputStream st2 = new ManagedFolderHandler.WrappedInputStream(handler, attachmentStream.rawStream());){
                bytesContent = IOUtils.toByteArray((InputStream)st2);
            }
            String fileName = (String)PathUtils.splitBasename((String)attachedItemPath).second;
            String fileContentType = localBasePath != null ? DKUtils.probeContentTypeWithFallback((File)new File(localBasePath, attachedItemPath)) : DKUtils.guessMimeTypeFromExtension((String)fileName);
            MimeBodyPart fileBodyPart = new MimeBodyPart();
            ByteArrayDataSource source = new ByteArrayDataSource(bytesContent, fileContentType);
            fileBodyPart.setDataHandler(new DataHandler((DataSource)source));
            fileBodyPart.setFileName(fileName);
            if (StringUtils.isNotBlank((String)attachment.contentId)) {
                fileBodyPart.setDisposition("inline");
                fileBodyPart.setContentID("<" + attachment.contentId + ">");
            }
            multipart.addBodyPart((BodyPart)fileBodyPart);
        }
    }

    private void handle(FolderAttachment attachment, Multipart multipart, String projectKey, int maxAttachmentSize, AuthCtx authCtx) throws Exception {
        if (StringUtils.isNotBlank((String)attachment.attachedFolderId)) {
            ManagedFolder folder = null;
            String basePath = "/";
            AnyLoc loc = DatasetLocUtils.DatasetLoc.resolveSmart(projectKey, attachment.attachedFolderId);
            try (Transaction transaction = this.transactionService.beginRead();){
                folder = (ManagedFolder)this.managedFolderDAO.getMandatoryUnsafe(loc);
            }
            try (ManagedFolderHandler handler = (ManagedFolderHandler)folder.buildHandler(authCtx);){
                handler.buildOneProvider();
                FSEnumerationResult result = handler.getProvider().enumerateRecursive("/", FIRST_NOT_EMPTY);
                if (!result.enumerationPrefixExists()) {
                    throw new IllegalArgumentException("The managed folder is empty or contains only empty files");
                }
            }
            File attachmentExportTmpFolder = ApplicationConfigurator.getFile((String)("tmp/attachment" + SecretKeyGenerator.generate((int)8)));
            DKUFileUtils.mkdirs((File)attachmentExportTmpFolder);
            File targetArchive = DKUFileUtils.getWithin((File)attachmentExportTmpFolder, (String[])new String[]{folder.name + ".zip"});
            try (AutoDelete tmp = new AutoDelete(attachmentExportTmpFolder);){
                byte[] bytesContent;
                logger.info((Object)("Zipping into " + attachmentExportTmpFolder.getAbsolutePath()));
                try (ManagedFolderHandler handler = (ManagedFolderHandler)folder.buildHandler(authCtx);
                     FileOutputStream fos = new FileOutputStream(targetArchive);){
                    handler.zipToStream("/", fos);
                }
                if (!targetArchive.exists()) {
                    throw new IllegalArgumentException("No file was produced for the attachment");
                }
                if (targetArchive.length() > (long)maxAttachmentSize) {
                    throw new IllegalArgumentException("File produced for the attachment is too large (" + targetArchive.length() + " > " + maxAttachmentSize + ")");
                }
                MimeBodyPart fileBodyPart = new MimeBodyPart();
                try (FileInputStream fis = new FileInputStream(targetArchive);){
                    bytesContent = IOUtils.toByteArray((InputStream)fis);
                }
                ByteArrayDataSource source = new ByteArrayDataSource(bytesContent, "application/zip");
                fileBodyPart.setDataHandler(new DataHandler((DataSource)source));
                fileBodyPart.setFileName(targetArchive.getName());
                multipart.addBodyPart((BodyPart)fileBodyPart);
            }
        }
    }

    private void handle(Multipart multipart, VariableLookup lookup, int maxAttachmentSize) throws Exception {
        File logFile = (File)lookup.rawGet("scenarioRunLogFile");
        try (LimitedByteArrayOutputStream byteOutputStream = new LimitedByteArrayOutputStream(maxAttachmentSize);){
            logger.info((Object)("Reading log for attachment from " + String.valueOf(logFile)));
            GZIPOutputStream gzipped = new GZIPOutputStream(byteOutputStream);
            try (FileInputStream fis = new FileInputStream(logFile);){
                IOUtils.copy((InputStream)fis, (OutputStream)gzipped);
            }
            gzipped.close();
            MimeBodyPart fileBodyPart = new MimeBodyPart();
            ByteArrayDataSource source = new ByteArrayDataSource(byteOutputStream.toByteArray(), "application/x-gzip");
            fileBodyPart.setDataHandler(new DataHandler((DataSource)source));
            fileBodyPart.setFileName("run.log.gz");
            multipart.addBodyPart((BodyPart)fileBodyPart);
        }
    }

    private void handle(DatasetExportAttachment attachment, Multipart multipart, AuthCtx authCtx, String projectKey, VariableLookup lookup, int maxAttachmentSize) throws Exception {
        if (StringUtils.isNotBlank((String)attachment.attachedDataset)) {
            Dataset dataset;
            try (Transaction transaction = this.transactionService.beginRead();){
                dataset = this.datasetAccessService.getMandatory(DatasetLocUtils.DatasetLoc.resolveSmart(projectKey, attachment.attachedDataset));
            }
            ExportParams ep = attachment.exportParams;
            ep.contextProjectKey = projectKey;
            if (ep.destinationType == ExportParams.ExportDestinationType.CUSTOM_MANAGED) {
                throw new IllegalArgumentException("Can't export to fully-custom, no file would be produced for the attachment");
            }
            if (dataset.getPartitioningSchema() != null && dataset.getPartitioningSchema().isPartitioned()) {
                if (StringUtils.isNotBlank((String)attachment.partitionId)) {
                    String partitionId = new StringSubstitutor((StringLookup)lookup).replace(attachment.partitionId);
                    logger.info((Object)("Using partitions : " + partitionId));
                    List<Partition> partitions = PartitionFactory.fromPartitionSpec(dataset.getPartitioningSchema(), partitionId);
                    ep.selection.partitionSelectionMethod = DatasetSelection.PartitionSelectionMethod.SELECTED;
                    ep.selection.selectedPartitions = Lists.newArrayList();
                    for (Partition partition : partitions) {
                        ep.selection.selectedPartitions.add(partition.id());
                    }
                } else {
                    logger.info((Object)"No partition specified for attachment, taking ALL");
                    ep.selection.partitionSelectionMethod = DatasetSelection.PartitionSelectionMethod.ALL;
                }
            }
            if (attachment.isInline) {
                if (StringUtils.isBlank((String)attachment.htmlVariable)) {
                    logger.info((Object)"Variable name for dataset as html not defined, using default : 'datasetHtml'");
                    attachment.htmlVariable = "datasetHtml";
                }
                ep.selection.maxReadUncompressedBytes = maxAttachmentSize;
                String tableAsHtml = this.getDatasetAsHtml(authCtx, dataset, ep, attachment.doNotEscapeHtml);
                lookup.addVariable(attachment.htmlVariable, tableAsHtml);
            } else {
                this.attachDataset(multipart, authCtx, maxAttachmentSize, dataset, ep);
            }
        } else {
            logger.warn((Object)"No dataset to export");
        }
    }

    private void attachFileToEmail(Multipart multipart, File file) throws IOException, MessagingException {
        try (FileInputStream is = new FileInputStream(file);){
            MimeBodyPart fileBodyPart = new MimeBodyPart();
            ByteArrayDataSource source = new ByteArrayDataSource((InputStream)is, DKUtils.probeContentTypeWithFallback((File)file));
            fileBodyPart.setDataHandler(new DataHandler((DataSource)source));
            fileBodyPart.setFileName(file.getName());
            multipart.addBodyPart((BodyPart)fileBodyPart);
        }
    }

    private void attachDataset(Multipart multipart, AuthCtx authCtx, int maxAttachmentSize, Dataset dataset, ExportParams ep) throws Exception {
        File attachmentExportTmpFolder = ApplicationConfigurator.getFile((String)("tmp/attachment" + SecretKeyGenerator.generate((int)8)));
        DKUFileUtils.mkdirs((File)attachmentExportTmpFolder);
        ep.filenameBase = dataset.getName();
        MimeTypeUtils.MimeType mimeType = ep.exporterType == null ? this.exportUtils.computeMimeType(ep) : CustomExportersRegistry.getExporter(ep.exporterType).getMimeType(ep);
        File outputFile = new File(attachmentExportTmpFolder, dataset.getName() + mimeType.extension);
        SerializedShakerScript.TableColoring coloring = this.retrieveTableColoring(ep, dataset.getProjectKey(), dataset.getName());
        try (AutoDelete tmp = new AutoDelete(attachmentExportTmpFolder);){
            ExportDataset ei = new ExportDataset(authCtx, dataset.serialize(), ExportUtils.convertColoring(coloring));
            BasicExportHandler exportHandler = new BasicExportHandler();
            exportHandler.doExport(authCtx, ei, ep, outputFile);
            if (!outputFile.exists()) {
                throw new IllegalArgumentException("No file was produced for the attachment");
            }
            if (outputFile.length() > (long)maxAttachmentSize) {
                throw new IllegalArgumentException("File produced for the attachment is too large (" + outputFile.length() + " > " + maxAttachmentSize + ")");
            }
            MimeBodyPart fileBodyPart = new MimeBodyPart();
            ByteArrayDataSource source = new ByteArrayDataSource(IOUtils.toByteArray((InputStream)new FileInputStream(outputFile)), mimeType.mimeType);
            fileBodyPart.setDataHandler(new DataHandler((DataSource)source));
            fileBodyPart.setFileName(outputFile.getName());
            multipart.addBodyPart((BodyPart)fileBodyPart);
        }
    }

    private String getDatasetAsHtml(AuthCtx authCtx, Dataset dataset, ExportParams ep, boolean doNotEscapeHtml) throws Exception {
        HtmlFormat.Config config = new HtmlFormat.Config();
        config.applyColoring = ep.applyColoring;
        config.cssClasses = "";
        config.header = true;
        config.border = 0;
        config.nullString = "";
        config.indentString = null;
        config.doNotEscapeHtml = doNotEscapeHtml;
        OutputFormatter formatter = FormatFactory.buildFormatter(authCtx, dataset.getProjectKey(), "html", config);
        SerializedShakerScript script = new SerializedShakerScript();
        script.coloring = this.retrieveTableColoring(ep, dataset.getProjectKey(), dataset.getName());
        if (script.coloring != null) {
            script.contextProjectKey = script.getProjectKey(dataset);
            script.origin = SerializedShakerScript.ShakerOrigin.DATASET_EXPLORE;
            if (script.coloring.scheme == ColoringDefinition.TableColoringScheme.ALL_COLUMNS_VALUES || script.coloring.scheme == ColoringDefinition.TableColoringScheme.MEANING_AND_STATUS) {
                if (script.coloring.coloringGroups != null && script.coloring.coloringGroups.size() > 0) {
                    script.coloring.scheme = ColoringDefinition.TableColoringScheme.COLORING_GROUPS;
                } else if (script.coloring.individualColumnsRules != null && script.coloring.individualColumnsRules.size() > 0) {
                    script.coloring.scheme = ColoringDefinition.TableColoringScheme.INDIVIDUAL_COLUMNS_RULES;
                }
            }
            TableColoring tableColoring = ExportUtils.convertColoring(script.coloring);
            formatter.setColoring(tableColoring);
            MemScriptRunner.TableWithReport tableWithReport = ((DataService)SpringUtils.getBean(DataService.class)).get_NOTRANSACTION(dataset, script, null, null, true, authCtx);
            if (tableWithReport != null && tableWithReport.table != null) {
                formatter.setMemTable((Object)tableWithReport.table);
            }
        }
        Schema datasetSchema = dataset.getSchema();
        formatter.setOutputSchema(datasetSchema);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamColumnFactory cf = new StreamColumnFactory();
        StreamRowFactory rf = new StreamRowFactory();
        StreamOutputWriter out = new StreamOutputWriter((OutputStream)baos, formatter);
        out.init((ColumnFactory)cf);
        UniversalSingleThreadPusher.push(authCtx, dataset, ep.selection, (ProcessorOutput)out, (ColumnFactory)cf, (RowFactory)rf, new WarningsContext());
        out.lastRowEmitted();
        return baos.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SerializedShakerScript.TableColoring retrieveTableColoring(ExportParams exportParams, String projectKey, String datasetName) {
        try {
            if (!exportParams.applyColoring) return null;
            DatasetExploreSettingsDAO exploreSettingsDAO = (DatasetExploreSettingsDAO)SpringUtils.getBean(DatasetExploreSettingsDAO.class);
            try (Transaction ignored = this.transactionService.beginRead();){
                DatasetExploreSettings exploreSettings = exploreSettingsDAO.getUnsafe(projectKey, datasetName);
                if (exploreSettings == null) return null;
                if (exploreSettings.script == null) return null;
                SerializedShakerScript.TableColoring tableColoring = exploreSettings.script.coloring;
                return tableColoring;
            }
        }
        catch (Exception e) {
            logger.error((Object)String.format("Unable to retrieve table coloring for dataset %s.%s", projectKey, datasetName), (Throwable)e);
        }
        return null;
    }

    public static class MailScenarioAttachment {
        public AttachmentType type;
        public JsonObject params = new JsonObject();
    }

    public static enum AttachmentType {
        LOG,
        DATASET,
        FOLDER,
        FOLDER_ITEM,
        NOTEBOOK_EXPORT,
        RMARKDOWN_REPORT,
        DASHBOARD_EXPORT,
        WIKI_EXPORT,
        ANALYSIS_MODEL_DOCUMENTATION_EXPORT,
        SAVED_MODEL_DOCUMENTATION_EXPORT,
        FLOW_DOCUMENTATION_EXPORT;

    }

    private static class ExportRestrictions {
        public final boolean disableAll;
        public final boolean disableAllData;
        public final boolean disableAllDataset;

        public ExportRestrictions(Params params) {
            this.disableAll = params.getBoolParam("dku.exports.disableAllExports", false);
            this.disableAllData = this.disableAll || params.getBoolParam("dku.exports.disableAllDataExports", false);
            this.disableAllDataset = this.disableAllData || params.getBoolParam("dku.exports.disableAllDatasetExports", false);
        }
    }

    public static class DatasetExportAttachment
    implements AttachmentParams {
        public String attachedDataset;
        public String partitionId;
        public ExportParams exportParams = new ExportParams();
        public boolean doNotEscapeHtml;
        public String htmlVariable;
        public boolean isInline;
    }

    public static class DashboardExportAttachment
    implements AttachmentParams {
        public ExportFormat exportFormat;
        public boolean shouldUseDashboardFormatSettings;
        public String dashboardId;
        public List<String> filtersBySlide;
    }

    public static class FolderAttachment
    implements AttachmentParams {
        public String attachedFolderId;
    }

    public static class FolderItemAttachment
    implements AttachmentParams {
        public String folderId;
        public String attachedItemPath;
        public String contentId;
        public boolean isInline;
    }

    public static class NotebookExportAttachment
    implements AttachmentParams {
        public String htmlVariable;
        public String attachedNotebookId;
        public NotebookExportAttachmentExportMode mode = NotebookExportAttachmentExportMode.USE_LATEST;
        public boolean execute = true;
        public boolean isInline;

        public static enum NotebookExportAttachmentExportMode {
            CREATE_NEW,
            USE_LATEST;

        }
    }

    public static class RMarkdownReportAttachment
    implements AttachmentParams {
        public boolean useLatestSnapshotIfItContainsFormat = true;
        public String attachedReportId;
        public Report.ReportOutputFormat rmdOutputFormat = Report.ReportOutputFormat.PDF_DOCUMENT;
    }

    public static class WikiExportAttachment
    implements AttachmentParams {
        public WikiExportType exportType;
        public String articleId;
        public ExportFormat exportFormat;
        public boolean exportAttachments;
    }

    public static class SavedModelDocumentationExportAttachment
    extends ModelDocumentationExportAttachment {
        public String modelId;
    }

    public static class AnalysisModelDocumentationExportAttachment
    extends ModelDocumentationExportAttachment {
        public String analysisId;
        public String mlTaskId;
    }

    public static class FlowDocumentationExportAttachment
    implements AttachmentParams {
        public boolean defaultTemplate;
        public String sourceFolderId;
        public String templatePath;
    }

    public static class ModelDocumentationExportAttachment
    implements AttachmentParams {
        public String fullModelId;
        public boolean defaultTemplate;
        public String sourceFolderId;
        public String templatePath;
    }

    public static class LimitedByteArrayOutputStream
    extends OutputStream {
        private final long maxSize;
        private final ByteArrayOutputStream backingStream = new ByteArrayOutputStream();

        public LimitedByteArrayOutputStream(long maxSize) {
            this.maxSize = maxSize;
        }

        private void ensureLimit(int written) throws IOException {
            if ((long)(this.backingStream.size() + written) > this.maxSize) {
                throw new IOException("Buffer size exceeded");
            }
        }

        public byte[] toByteArray() {
            return this.backingStream.toByteArray();
        }

        public int size() {
            return this.backingStream.size();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.ensureLimit(len);
            this.backingStream.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.ensureLimit(1);
            this.backingStream.write(b);
        }

        @Override
        public void close() throws IOException {
            this.backingStream.close();
        }

        @Override
        public void flush() throws IOException {
            this.backingStream.flush();
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }
    }

    public static class ScenarioLogAttachment
    implements AttachmentParams {
    }

    @UIModel
    public static interface AttachmentParams {
    }
}

