/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.anthropic.api;

import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.online.anthropic.api.AnthropicChatQuery;
import com.dataiku.dip.llm.online.marshall.FinishReasonResponseAdapter;
import com.dataiku.dip.util.JsonUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nullable;

public class AnthropicChatChunkResponseAdapter {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.llm.anthropic.api");

    private AnthropicChatChunkResponseAdapter() {
    }

    public static LLMClient.StreamedCompletionResponseChunk adapt(JsonObject response, String uniqueId) {
        String type;
        switch (type = response.get("type").getAsString()) {
            case "ping": 
            case "message_start": 
            case "message_delta": 
            case "message_stop": 
            case "content_block_stop": {
                logger.info((Object)String.format("Skipping response chunk with type: %s", type));
                return LLMClient.StreamedCompletionResponseChunk.empty();
            }
            case "content_block_start": {
                return AnthropicChatChunkResponseAdapter.adaptContentBlockStart(response, uniqueId);
            }
            case "content_block_delta": {
                return AnthropicChatChunkResponseAdapter.adaptContentBlockDelta(response, uniqueId);
            }
        }
        logger.info((Object)String.format("Unknown response chunk: %s", JSON.prettyLog((Object)response)));
        return LLMClient.StreamedCompletionResponseChunk.empty();
    }

    public static void enrichFooter(JsonObject response, LLMClient.StreamedCompletionResponseFooter footer) {
        String type;
        switch (type = response.get("type").getAsString()) {
            case "message_start": {
                footer.promptTokens = AnthropicChatChunkResponseAdapter.extractPromptTokens(response);
            }
            case "message_delta": {
                footer.completionTokens = AnthropicChatChunkResponseAdapter.extractCompletionTokens(response);
                footer.finishReason = AnthropicChatChunkResponseAdapter.extractFinishReason(response);
            }
        }
    }

    private static LLMClient.StreamedCompletionResponseChunk adaptContentBlockStart(JsonObject response, String uniqueId) {
        String blockType;
        String type = response.get("type").getAsString();
        int index = response.get("index").getAsInt();
        JsonObject contentBlock = response.get("content_block").getAsJsonObject();
        switch (blockType = contentBlock.get("type").getAsString()) {
            case "text": {
                logger.info((Object)String.format("Skipping response chunk with type: (%s, %s)", type, blockType));
                return LLMClient.StreamedCompletionResponseChunk.empty();
            }
            case "tool_use": {
                String toolUseId = contentBlock.get("id").getAsString();
                String toolName = contentBlock.get("name").getAsString();
                LLMClient.FunctionToolCall ftc = new LLMClient.FunctionToolCall();
                ftc.index = index;
                ftc.id = toolUseId;
                ftc.function = new LLMClient.FunctionToolCallInfo();
                ftc.function.name = toolName;
                LLMClient.StreamedCompletionResponseChunk chunk = new LLMClient.StreamedCompletionResponseChunk();
                chunk.toolCalls = List.of(ftc);
                return chunk;
            }
            case "thinking": {
                String thinking = contentBlock.get("thinking").getAsString();
                LLMClient.SourceItem sourceItem = new LLMClient.SourceItem();
                sourceItem.text = thinking;
                sourceItem.type = "TEXT";
                sourceItem.index = index;
                LLMClient.Artifact artifact = new LLMClient.Artifact();
                artifact.id = uniqueId;
                artifact.type = "REASONING";
                artifact.parts = List.of(sourceItem);
                LLMClient.StreamedCompletionResponseChunk chunk = new LLMClient.StreamedCompletionResponseChunk();
                chunk.artifacts = List.of(artifact);
                return chunk;
            }
        }
        logger.info((Object)String.format("Unknown response chunk: %s", JSON.prettyLog((Object)response)));
        return LLMClient.StreamedCompletionResponseChunk.empty();
    }

    private static LLMClient.StreamedCompletionResponseChunk adaptContentBlockDelta(JsonObject response, String uniqueId) {
        String deltaType;
        int index = response.get("index").getAsInt();
        JsonObject delta = response.get("delta").getAsJsonObject();
        switch (deltaType = delta.get("type").getAsString()) {
            case "text_delta": {
                String text = delta.get("text").getAsString();
                LLMClient.StreamedCompletionResponseChunk chunk = new LLMClient.StreamedCompletionResponseChunk();
                chunk.text = text;
                return chunk;
            }
            case "input_json_delta": {
                String partialJson = delta.get("partial_json").getAsString();
                LLMClient.FunctionToolCall ftc = new LLMClient.FunctionToolCall();
                ftc.index = index;
                ftc.function = new LLMClient.FunctionToolCallInfo();
                ftc.function.arguments = partialJson;
                LLMClient.StreamedCompletionResponseChunk chunk = new LLMClient.StreamedCompletionResponseChunk();
                chunk.toolCalls = List.of(ftc);
                return chunk;
            }
            case "thinking_delta": {
                String thinking = delta.get("thinking").getAsString();
                LLMClient.SourceItem sourceItem = new LLMClient.SourceItem();
                sourceItem.text = thinking;
                sourceItem.type = "TEXT";
                sourceItem.index = index;
                LLMClient.Artifact artifact = new LLMClient.Artifact();
                artifact.id = uniqueId;
                artifact.type = "REASONING";
                artifact.parts = List.of(sourceItem);
                LLMClient.StreamedCompletionResponseChunk chunk = new LLMClient.StreamedCompletionResponseChunk();
                chunk.artifacts = List.of(artifact);
                return chunk;
            }
            case "signature_delta": {
                AnthropicChatQuery.ThinkingMessagePart thinkingMessagePart = new AnthropicChatQuery.ThinkingMessagePart();
                thinkingMessagePart.signature = delta.get("signature").getAsString();
                LLMClient.MemoryFragment memoryFragment = new LLMClient.MemoryFragment();
                memoryFragment.llmReasoning = JSON.toJsonObject((Object)thinkingMessagePart, (String[])new String[0]);
                LLMClient.StreamedCompletionResponseChunk chunk = new LLMClient.StreamedCompletionResponseChunk();
                chunk.memoryFragment = memoryFragment;
                return chunk;
            }
        }
        logger.info((Object)String.format("Unknown response chunk: %s", JSON.prettyLog((Object)response)));
        return LLMClient.StreamedCompletionResponseChunk.empty();
    }

    @Nullable
    public static Integer extractPromptTokens(JsonObject response) {
        String type = response.get("type").getAsString();
        if (!"message_start".equals(type)) {
            return null;
        }
        try {
            JsonObject usage = response.get("message").getAsJsonObject().get("usage").getAsJsonObject();
            return usage.get("input_tokens").getAsInt();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static Integer extractCompletionTokens(JsonObject response) {
        String type = response.get("type").getAsString();
        if (!"message_delta".equals(type)) {
            return null;
        }
        try {
            JsonObject usage = response.get("usage").getAsJsonObject();
            return usage.get("output_tokens").getAsInt();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static LLMClient.FinishReason extractFinishReason(JsonObject response) {
        String type = response.get("type").getAsString();
        if (!"message_delta".equals(type)) {
            return null;
        }
        JsonObject delta = response.get("delta").getAsJsonObject();
        String stopReason = JsonUtils.getStringMemberOrNull(delta, "stop_reason");
        if (stopReason == null) {
            return null;
        }
        return FinishReasonResponseAdapter.adapt(stopReason);
    }
}

