/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Partitionable;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.utils.NotImplementedException;

public enum MetricTargetType {
    DATASET,
    SAVED_MODEL,
    MANAGED_FOLDER,
    PROJECT,
    MODEL_EVALUATION_STORE;


    public static MetricTargetType getMetricTargetType(Partitionable dataStore) {
        if (dataStore instanceof Dataset) {
            return DATASET;
        }
        if (dataStore instanceof ManagedFolder) {
            return MANAGED_FOLDER;
        }
        if (dataStore instanceof ModelEvaluationStore) {
            return MODEL_EVALUATION_STORE;
        }
        if (dataStore instanceof SavedModel) {
            return SAVED_MODEL;
        }
        throw new IllegalArgumentException("Unexpected type: " + String.valueOf(dataStore.getClass()));
    }

    public ITaggingService.TaggableType toTaggableType() {
        switch (this) {
            case DATASET: {
                return ITaggingService.TaggableType.DATASET;
            }
            case SAVED_MODEL: {
                return ITaggingService.TaggableType.SAVED_MODEL;
            }
            case MANAGED_FOLDER: {
                return ITaggingService.TaggableType.MANAGED_FOLDER;
            }
            case PROJECT: {
                return ITaggingService.TaggableType.PROJECT;
            }
            case MODEL_EVALUATION_STORE: {
                return ITaggingService.TaggableType.MODEL_EVALUATION_STORE;
            }
        }
        throw new NotImplementedException("Unknown MetricTargetType: " + String.valueOf((Object)this));
    }
}

