/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.model;

import com.dataiku.dip.pivot.backend.common.ResponseValidator;
import com.dataiku.dip.pivot.backend.model.ColumnSummary;
import com.dataiku.dip.pivot.backend.model.FilterFacet;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorResponse;
import com.dataiku.dip.pivot.backend.model.SideResponseKey;
import com.dataiku.dip.shaker.server.SampleMetadata;
import com.dataiku.dip.utils.JSON;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@UIModel
public abstract class PivotTableResponse {
    public List<FilterFacet> filterFacets = new ArrayList<FilterFacet>();
    public Map<SideResponseKey, List<PivotTableResponse>> sideResponses = new HashMap<SideResponseKey, List<PivotTableResponse>>();
    public long beforeFilterRecords;
    public long afterFilterRecords;
    public PivotEngine engine;
    public SampleMetadata sampleMetadata;
    public ColumnSummary columnsSummary;

    public void setRecordCounts(long totalRecordsBeforeFiltering, long totalRecordsAfterFiltering) {
        ResponseValidator.validateRecordsCount(totalRecordsBeforeFiltering, totalRecordsAfterFiltering);
        this.beforeFilterRecords = totalRecordsBeforeFiltering;
        this.afterFilterRecords = totalRecordsAfterFiltering;
    }

    static {
        JSON.registerAdapter((Type)new TypeToken<Map<SideResponseKey, List<PivotTableResponse>>>(){}.getType(), (Object)new JSON.Adapter<Map<SideResponseKey, List<PivotTableResponse>>>(){

            public JsonElement serialize(Map<SideResponseKey, List<PivotTableResponse>> src, Type type, JsonSerializationContext context) {
                JsonObject jsonObject = new JsonObject();
                for (Map.Entry<SideResponseKey, List<PivotTableResponse>> entry : src.entrySet()) {
                    List serializedResponses = entry.getValue().stream().map(arg_0 -> ((JsonSerializationContext)context).serialize(arg_0)).collect(Collectors.toList());
                    jsonObject.add(entry.getKey().name(), context.serialize(serializedResponses));
                }
                return jsonObject;
            }

            public Map<SideResponseKey, List<PivotTableResponse>> deserialize(JsonElement src, Type type, JsonDeserializationContext context) throws JsonParseException {
                HashMap<SideResponseKey, List<PivotTableResponse>> res = new HashMap<SideResponseKey, List<PivotTableResponse>>();
                JsonObject jsonObject = src.getAsJsonObject();
                for (Map.Entry entry : jsonObject.entrySet()) {
                    ArrayList<PivotTableResponse> deserializedResponses = new ArrayList<PivotTableResponse>();
                    JsonElement jsonElement = (JsonElement)entry.getValue();
                    HashSet tensorKeys = Sets.newHashSet((Object[])new String[]{SideResponseKey.REFERENCE_LINES.name(), SideResponseKey.GAUGE_MAX.name(), SideResponseKey.GAUGE_MIN.name(), SideResponseKey.GAUGE_TARGETS.name(), SideResponseKey.GAUGE_RANGES.name()});
                    if (jsonElement.isJsonArray()) {
                        for (JsonElement element : jsonElement.getAsJsonArray()) {
                            PivotTableResponse response = tensorKeys.contains(entry.getKey()) ? (PivotTableResponse)context.deserialize(element, PivotTableTensorResponse.class) : (PivotTableResponse)context.deserialize(element, PivotTableResponse.class);
                            deserializedResponses.add(response);
                        }
                    }
                    res.put(SideResponseKey.valueOf((String)entry.getKey()), deserializedResponses);
                }
                return res;
            }
        });
    }

    public static enum PivotEngine {
        SQL,
        LINO;

    }
}

