/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.frontend.model;

import com.dataiku.dip.pivot.backend.dss.DataTensor;
import com.dataiku.dip.pivot.backend.dss.LongDataTensor;
import com.dataiku.dip.pivot.backend.dss.TensorType;
import com.dataiku.dip.pivot.frontend.model.ChartDef;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFColor;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFWorkbook;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FontFormatting {
    private Map<String, String> backgroundColorMap;
    private Map<String, String> fontColorMap;

    public Map<String, String> getBackgroundColorMap() {
        return this.backgroundColorMap;
    }

    public Map<String, String> getFontColorMap() {
        return this.fontColorMap;
    }

    public static XSSFColor getColor(int index, DataTensor<?> value, List<Map<String, XSSFColor>> colorMapping) {
        String colorValue = null;
        if (value.type == TensorType.NUMERICAL) {
            colorValue = Double.toString(value.getAsDouble(0));
            if (colorValue.endsWith(".0")) {
                colorValue = colorValue.substring(0, colorValue.length() - 2);
            }
        } else if (value.type == TensorType.ALPHANUM) {
            colorValue = (String)value.get(0);
        } else if (value.type == TensorType.DATE) {
            DateTime date = (DateTime)value.get(0, true);
            colorValue = date != null ? Long.toString(date.getMillis()) : "";
        }
        return colorMapping.get(index).get(colorValue);
    }

    public static XSSFColor getColorFromCoordinates(List<DataTensor<?>> aggregations, List<Map<String, XSSFColor>> colorMapping, ChartDef.ColorMode colorMode, int[] coords, int measureOffset, LongDataTensor counts) {
        if (colorMapping != null) {
            int cellIndex = 0;
            if (colorMode == ChartDef.ColorMode.UNIQUE_SCALE) {
                cellIndex = aggregations.size() - 1;
                measureOffset = 0;
            } else {
                cellIndex = measureOffset;
            }
            DataTensor<?> tensor = aggregations.get(cellIndex);
            long[] countsTensor = counts.tensor;
            return FontFormatting.getColor(tensor, colorMapping, coords, measureOffset, countsTensor);
        }
        return null;
    }

    public static XSSFColor getColor(DataTensor<?> tensor, List<Map<String, XSSFColor>> colorMapping, int[] valueIndex, int measureOffset, long[] countsTensor) {
        if (colorMapping != null) {
            String colorValue = null;
            if (tensor.type == TensorType.NUMERICAL) {
                int loc = tensor.loc(valueIndex);
                long[] nonNullCounts = tensor.nonNullCounts != null ? tensor.nonNullCounts : countsTensor;
                String string = colorValue = nonNullCounts[loc] > 0L ? Double.toString(tensor.getAsDouble(valueIndex)) : "";
                if (colorValue.endsWith(".0")) {
                    colorValue = colorValue.substring(0, colorValue.length() - 2);
                }
            } else if (tensor.type == TensorType.ALPHANUM) {
                colorValue = (String)tensor.get(valueIndex);
            } else if (tensor.type == TensorType.DATE) {
                DateTime date = (DateTime)tensor.get(valueIndex, true);
                colorValue = date != null ? Long.toString(date.getMillis()) : "";
            }
            return colorMapping.get(measureOffset).get(colorValue);
        }
        return null;
    }

    public static void getColorMapping(XSSFWorkbook workbook, int measureIndex, Map<String, String> colorMaps, List<Map<String, XSSFColor>> colorMapping) {
        HashMap fontColorMap = new HashMap();
        colorMapping.add(fontColorMap);
        if (!colorMaps.isEmpty()) {
            for (Map.Entry<String, String> entry : colorMaps.entrySet()) {
                XSSFColor color = new XSSFColor(workbook.getStylesSource().getIndexedColors());
                String colorHex = entry.getValue().substring(1);
                if (colorHex.length() == 3) {
                    colorHex = colorHex.replaceAll("^(.)(.)(.)$", "$1$1$2$2$3$3");
                }
                color.setARGBHex(colorHex);
                colorMapping.get(measureIndex).put(entry.getKey(), color);
            }
        }
    }
}

