/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.r;

import com.dataiku.dip.code.CodeEnvResolutionService;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.AbstractCodeBasedRecipeRunner;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.List;

public abstract class AbstractRRecipeRunner
extends AbstractCodeBasedRecipeRunner {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.code.r");

    public AbstractRRecipeRunner(JobActivity activity) {
        super(activity);
    }

    protected void executeScript(String projectKey, String envName, File targetLogFile, File tmpDirectory, String scriptData) throws Exception {
        String wrapperContent = DKUtils.getResourceFileContentUTF8((String)"com/dataiku/dip/dataflow/exec/R-exec-wrapper.R");
        File scriptFile = new File(tmpDirectory, "R-recipe.R");
        DKUFileUtils.writeFileUTF8((File)scriptFile, (String)scriptData);
        this.writeRemoteRunEnvDefForLocalExecution(tmpDirectory, envName);
        List<String> cmd = AbstractRRecipeRunner.getRCmd(projectKey, envName, Lists.newArrayList((Object[])new String[]{scriptFile.getAbsolutePath()}));
        logger.info((Object)("Execute activity command: " + JSON.log(cmd)));
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.directory(tmpDirectory);
        builder.command(cmd);
        this.execute(builder, targetLogFile, wrapperContent, "R", GeneralSettingsDAO.CGrouppableProcessType.PYTHON_R_RECIPE, false);
    }

    public static List<String> getRCmd(String projectKey, String envName, List<String> args) throws IOException {
        return ((CodeEnvResolutionService)SpringUtils.getBean(CodeEnvResolutionService.class)).getRCmd(envName, projectKey, args);
    }
}

