/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.resourceusage;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.resourceusage.ComputeResourceUsageReportingService;
import com.dataiku.dip.resourceusage.ComputeResourceUsageToAggregateEvent;
import com.dataiku.dip.resourceusage.k8s.KubernetesClusterUsageStatus;
import com.dataiku.dip.security.audit.AuditObj;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonElement;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BackendComputeResourceUsageReportingService
implements ComputeResourceUsageReportingService {
    @Autowired
    AuditTrailService auditTrailService;
    @Autowired
    private PubSubService pubSubService;
    private final boolean aggregationEnabled = DKUApp.getParams().getBoolParam("dku.usageReporting.cruAggregation.enabled", true);
    private static DKULogger logger = DKULogger.getLogger((String)"dku.cru.reporting");

    public void reportStart(ComputeResourceUsage usage) {
        this.auditTrailService.emit(new AuditObj("compute-resource-usage").with("msgType", "compute-resource-usage-start").with("computeResourceUsage", (JsonElement)JSON.toJsonObject((Object)usage, (String[])new String[0])));
    }

    public void reportUpdate(ComputeResourceUsage usage) {
        this.auditTrailService.emit(new AuditObj("compute-resource-usage").with("msgType", "compute-resource-usage-update").with("computeResourceUsage", (JsonElement)JSON.toJsonObject((Object)usage, (String[])new String[0])));
    }

    public void reportComplete(ComputeResourceUsage usage) {
        this.auditTrailService.emit(new AuditObj("compute-resource-usage").with("msgType", "compute-resource-usage-complete").with("computeResourceUsage", (JsonElement)JSON.toJsonObject((Object)usage, (String[])new String[0])));
        if (this.aggregationEnabled) {
            this.pubSubService.publish((DSSEvent)new ComputeResourceUsageToAggregateEvent(usage));
        }
    }

    public void reportK8SClusterStatus(KubernetesClusterUsageStatus status) {
        this.auditTrailService.emit(new AuditObj("compute-resource-usage").with("msgType", "kubernetes-cluster-usage-status").with("clusterId", status.clusterId).with("podsStatus", (JsonElement)JSON.toJsonObject((Object)status.podsStatus, (String[])new String[0])));
    }
}

