/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.coremodel.JobDef;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.dataflow.jobrunner.status.EnhancedSerializedJobStatus;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.AbstractFlowItemBuildingStepRunner;
import com.dataiku.dip.scheduler.steps.FlowComputableSpecification;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;

public class BuildFlowItemStepRunner
extends AbstractFlowItemBuildingStepRunner<BuildFlowItemStepParams> {
    public static final StepMeta META = new StepMeta(){

        @Override
        public String getType() {
            return "build_flowitem";
        }

        @Override
        public Class<? extends StepParams> paramsClass() {
            return BuildFlowItemStepParams.class;
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new BuildFlowItemStepRunner(scenario, step, step.getParamsAs(BuildFlowItemStepParams.class));
        }

        @Override
        public String buildName(Step step) {
            BuildFlowItemStepParams params = step.getParamsAs(BuildFlowItemStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("build");
            if (params != null) {
                for (FlowComputableSpecification built : params.getBuilds()) {
                    sb.append(" ");
                    sb.append(built.getItemName());
                }
            }
            return sb.toString();
        }

        @Override
        public String buildId(Step step) {
            BuildFlowItemStepParams params = step.getParamsAs(BuildFlowItemStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("build");
            if (params != null) {
                sb.append("_");
                sb.append(params.getJobType().ordinal());
                sb.append("_");
                sb.append(params.refreshHiveMetastore);
                for (FlowComputableSpecification built : params.getBuilds()) {
                    sb.append("_");
                    sb.append(built.getPartitionInvariantId());
                }
            }
            return sb.toString();
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario scenario, Step step, PluginUsagesInspector pluginUsagesInspector) {
            BuildFlowItemStepParams stepParams = (BuildFlowItemStepParams)step.params;
            if (null != stepParams && null != stepParams.builds) {
                return StepMeta.UnavailableStepInfo.checkFlowComputableSpecs(scenario, step, pluginUsagesInspector, stepParams.builds, logger);
            }
            return null;
        }
    };
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.scenario.buildflowitem");

    public BuildFlowItemStepRunner(Scenario scenario, Step step, BuildFlowItemStepParams params) {
        super(scenario, step, params);
        this.params = params;
    }

    protected void assertValidParams() {
        if (((BuildFlowItemStepParams)this.params).builds.isEmpty()) {
            throw ErrorContext.iae((String)"Empty job (nothing to build)");
        }
    }

    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        logger.infoV("Start step %s", new Object[]{this.step.name});
        this.assertValidParams();
        JobDef buildJobDef = this.buildJobDef(stepRun);
        AbstractFlowItemBuildingStepRunner.BuildJobInfo buildJobInfo = this.runBuildJob(buildJobDef);
        ReportItem.JobExecuted jobItem = buildJobInfo.jobItem;
        stepReportItem = this.updateStepReportItemWithJobResult(stepReportItem, jobItem);
        EnhancedSerializedJobStatus sjs = buildJobInfo.jobStatus;
        stepRun.payload = this.getSafeJobStatus(sjs);
        logger.infoV("Done step %s", new Object[]{this.step.name});
        assert (stepReportItem.getOutcome() != null);
    }

    @Override
    protected DKULogger getLogger() {
        return logger;
    }

    public static class BuildFlowItemStepParams
    extends AbstractFlowItemBuildingStepRunner.FlowItemBuildingStepParams {

        public static class Builder
        extends AbstractFlowItemBuildingStepRunner.FlowItemBuildingStepParams.Builder<BuildFlowItemStepParams> {
            @Override
            protected BuildFlowItemStepParams instantiateParams() {
                return new BuildFlowItemStepParams();
            }

            @Override
            public BuildFlowItemStepParams build() {
                return (BuildFlowItemStepParams)this.params;
            }
        }
    }
}

