/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.datasets.DatasetConnectionUtils;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.queries.QueryParams;
import com.dataiku.dip.queries.QueryRunResult;
import com.dataiku.dip.queries.SQLQueryRuntime;
import com.dataiku.dip.recipes.ParamsWithSelectableConnection;
import com.dataiku.dip.scheduler.ScenarioCodes;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.NonFatalStepParams;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.springframework.beans.factory.annotation.Autowired;

public class ExecuteSQLStepRunner
implements StepRunner {
    public static final StepMeta META = new StepMeta(){

        @Override
        public Class<? extends StepParams> paramsClass() {
            return ExecuteSQLStepParams.class;
        }

        @Override
        public String getType() {
            return "exec_sql";
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new ExecuteSQLStepRunner(step.getParamsAs(ExecuteSQLStepParams.class));
        }

        @Override
        public String buildName(Step step) {
            ExecuteSQLStepParams stepParams = step.getParamsAs(ExecuteSQLStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("run sql on ");
            if (stepParams != null && stepParams.connection != null) {
                sb.append(stepParams.connection);
            }
            return sb.toString();
        }

        @Override
        public String buildId(Step step) {
            ExecuteSQLStepParams stepParams = step.getParamsAs(ExecuteSQLStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("sql");
            if (stepParams != null) {
                sb.append("_");
                sb.append(stepParams.connection);
                if (StringUtils.isNotBlank((String)stepParams.sql)) {
                    sb.append("_");
                    sb.append(DKUtils.md5Base64((String)stepParams.sql));
                }
            }
            return sb.toString();
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario sc, Step step, PluginUsagesInspector pluginUsagesInspector) {
            return null;
        }
    };
    @Autowired
    private VariablesService variablesService;
    private final ExecuteSQLStepParams params;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.scenario.step.sql");

    public ExecuteSQLStepRunner(ExecuteSQLStepParams params) {
        this.params = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        QueryRunResult result;
        DSSConnection connection;
        logger.info((Object)("Start EXEC_SQL step run: " + JSON.log((Object)this.params)));
        if (StringUtils.isBlank((String)this.params.connection)) {
            throw new CodedException((InfoMessage.MessageCode)ScenarioCodes.ERR_SCENARIO_INVALID_STEP_CONFIG, "Execute SQL step: no connection specified");
        }
        String projectKey = stepRun.getScenarioRun().getScenario().getProjectKey();
        VariablesContext variablesContext = this.variablesService.getForProject(projectKey);
        DSSAuthCtx authCtx = stepRun.getScenarioRun().getRunAsUser();
        if (ConnectionsDAO.parseVirtualConnection(this.params.connection) == null && !(connection = ConnectionsDAO.get().getMandatoryConnection(authCtx, this.params.connection)).isFreelyUsableBy(authCtx)) {
            throw new DKUSecurityException("User " + String.valueOf((Object)authCtx) + " is not allowed to use connection " + this.params.connection);
        }
        StrSubstitutor substitutor = new StrSubstitutor(variablesContext.getAllVariables());
        QueryParams qp = new QueryParams();
        qp.connection = this.params.getConnection();
        qp.sql = substitutor.replace(this.params.getSql());
        final SQLQueryRuntime queryRuntime = new SQLQueryRuntime(projectKey, qp, null, authCtx);
        int maxRows = 10;
        if (this.params.overrideDefaultLimit) {
            maxRows = this.params.maxRows != null ? this.params.maxRows : -1;
        }
        int safetyRowLimit = ApplicationConfigurator.getParams().getIntParam("dku.sql.step.safetyLimit", Integer.valueOf(500));
        try {
            logger.info((Object)("Running a query for a step: " + this.params.getSql()));
            queryRuntime.init(maxRows);
            try (FutureAborter.AutoCloseableAbortHook aborter = FutureAborter.pushAutoCloseableHook((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        queryRuntime.cancel();
                    }
                    catch (SQLException e) {
                        logger.error((Object)"Failed to cancel SQL query", (Throwable)e);
                    }
                }
            });){
                GeneralSettingsDAO.SoftHardLimit globalLimit = ((GeneralSettingsDAO)SpringUtils.getBean(GeneralSettingsDAO.class)).getUnsafeAutoTXN().limits.sqlScenarioResultSetBytes;
                long maxByteSize = globalLimit.hard != -1L ? globalLimit.hard : Long.MAX_VALUE;
                result = queryRuntime.getPage(0, safetyRowLimit, maxByteSize, null);
            }
        }
        finally {
            queryRuntime.close(true, true);
        }
        if (result.success) {
            if (result.totalRows >= (long)safetyRowLimit) {
                stepReportItem.withThrown(new WarningsContext.SerializedThrowable("SQL result exceeded safety row limit (" + safetyRowLimit + ")"));
                stepReportItem.withOutcome(ReportItem.Outcome.FAILED);
            } else {
                if (maxRows > 0 && result.totalRows >= (long)maxRows) {
                    logger.warn((Object)("SQL result exceeded row limit (" + maxRows + ")"));
                }
                stepReportItem.withOutcome(ReportItem.Outcome.SUCCESS);
            }
        } else {
            if (result.errorMessage != null) {
                stepReportItem.withThrown(new WarningsContext.SerializedThrowable(result.errorMessage));
            }
            stepReportItem.withOutcome(ReportItem.Outcome.FAILED);
        }
        logger.infoV("Exited the exec sql step. Result: success=%s, updatedRows=%s, totalRows=%s, totalRowsClipped=%s, hasResultSet=%s, columnNames=[%s]", new Object[]{result.success, result.updatedRows, result.totalRows, result.totalRowsClipped, result.hasResultset, result.columns.stream().map(col -> col.name).collect(Collectors.joining(", "))});
        stepRun.payload = result;
        stepRun.getScenarioRun().withStepRunOutput(stepRun, result);
    }

    public static class ExecuteSQLStepParams
    extends NonFatalStepParams
    implements StepParams,
    ParamsWithSelectableConnection {
        public String connection;
        public String sql;
        public boolean overrideDefaultLimit;
        public Integer maxRows;
        public List<SimpleKeyValue> extraConf = Lists.newArrayList();

        public String getSql() {
            return this.sql;
        }

        @Override
        public String getConnection() {
            return this.connection;
        }

        public List<SimpleKeyValue> getExtraConf() {
            return Lists.newArrayList(this.extraConf);
        }

        public ExecuteSQLStepParams withSql(String sql) {
            this.sql = sql;
            return this;
        }

        public ExecuteSQLStepParams withExtraConf(List<SimpleKeyValue> extraConf) {
            this.extraConf = Lists.newArrayList(extraConf);
            return this;
        }

        public ExecuteSQLStepParams withExtraConf(SimpleKeyValue extraConf) {
            this.extraConf.add(extraConf);
            return this;
        }

        public ExecuteSQLStepParams withExtraConf(String key, String value) {
            return this.withExtraConf(new SimpleKeyValue(key, value));
        }

        public ExecuteSQLStepParams withConnection(String connection) {
            this.connection = connection;
            return this;
        }

        @Override
        public void setConnection(String connection) {
            this.connection = connection;
        }

        @Override
        public DatasetConnectionUtils.UsedConnection collectConnectionUsage(TaggableObjectsService.TaggableObject object) {
            if (StringUtils.isNotBlank((String)this.connection)) {
                return new DatasetConnectionUtils.UsedConnection(this.connection, null);
            }
            return null;
        }
    }
}

