/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.agentreview.AgentReviewRun;
import com.dataiku.dip.agentreview.AgentReviewRunHistoryItem;
import com.dataiku.dip.agentreview.AgentReviewRunState;
import com.dataiku.dip.agentreview.AgentReviewService;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.futures.FutureHistoryService;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.NonFatalStepParams;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;

public class RunAgentReviewStepRunner
implements StepRunner {
    public static final StepMeta META = new StepMeta(){
        public final String RUN_AGENT_REVIEW = "run_agent_review";

        @Override
        public Class<? extends StepParams> paramsClass() {
            return RunAgentReviewStepParams.class;
        }

        @Override
        public String getType() {
            return "run_agent_review";
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new RunAgentReviewStepRunner(step, step.getParamsAs(RunAgentReviewStepParams.class));
        }

        @Override
        public String buildName(Step step) {
            RunAgentReviewStepParams stepParams = step.getParamsAs(RunAgentReviewStepParams.class);
            return "Run agent review " + stepParams.agentReviewId;
        }

        @Override
        public String buildId(Step step) {
            RunAgentReviewStepParams stepParams = step.getParamsAs(RunAgentReviewStepParams.class);
            return "run_agent_review_" + stepParams.agentReviewId;
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario sc, Step step, PluginUsagesInspector pluginUsagesInspector) {
            return null;
        }
    };
    private final RunAgentReviewStepParams params;
    private final Step step;
    @Autowired
    private AgentReviewService agentReviewService;
    @Autowired
    private ReadWriteJobsInternalDB jobsDatabaseService;
    @Autowired
    private FutureHistoryService futureHistoryService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.scheduler.steps.runagentreview");

    RunAgentReviewStepRunner(Step step, RunAgentReviewStepParams params) {
        this.step = step;
        this.params = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        logger.infoV("Start step %s", new Object[]{this.step.name});
        try {
            stepReportItem.withStart(DateTime.now().getMillis());
            String projectKey = stepRun.getScenarioRun().getScenario().getProjectKey();
            String agentReviewId = this.params.agentReviewId;
            if (agentReviewId == null) {
                throw new IllegalArgumentException("Agent Review ID is mandatory");
            }
            AnyLoc agentReviewLoc = new AnyLoc(projectKey, agentReviewId);
            long start = System.currentTimeMillis();
            AgentReviewRun run = this.agentReviewService.performRun_NT(stepRun.getScenarioRun().getRunAsUser(), projectKey, agentReviewId, null, false, this.params.useActiveVersionOfAgent, null);
            ReportTargetItem.AgentReviewRunItem target = new ReportTargetItem.AgentReviewRunItem(projectKey, this.params.agentReviewId, run.id);
            ReportItem.StartedAgentReviewRun startedReportItem = (ReportItem.StartedAgentReviewRun)new ReportItem.StartedAgentReviewRun(target).withStart(start).withEnd(System.currentTimeMillis()).withOutcome(ReportItem.Outcome.SUCCESS);
            this.jobsDatabaseService.tryRegisterFlowObjectEvent(agentReviewLoc, null, null, stepRun.getScenarioRun(), stepRun, startedReportItem);
            FutureResponse future = this.futureHistoryService.waitForFinalResponse(run.getFutureHistoryKey());
            if (future == null || !future.hasResult || future.result == null) {
                logger.errorV("Agent Review Run %s failed to start or complete", new Object[]{run.id});
                stepReportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.FAILED);
                return;
            }
            AgentReviewRun finishedRun = (AgentReviewRun)future.result;
            if (finishedRun.status == AgentReviewRunState.FINISHED || finishedRun.status == AgentReviewRunState.ABORTED) {
                AgentReviewRunHistoryItem rhi = this.agentReviewService.getRunHistoryItem_NT(stepRun.getScenarioRun().getRunAsUser(), finishedRun);
                ReportItem.FinishedAgentReviewRun finishedReportItem = (ReportItem.FinishedAgentReviewRun)new ReportItem.FinishedAgentReviewRun(target).withStart(System.currentTimeMillis());
                try {
                    finishedReportItem.withRunHistoryItem(rhi);
                    if (finishedRun.status == AgentReviewRunState.ABORTED) {
                        finishedReportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.ABORTED);
                    } else if (rhi.nbFail > 0) {
                        finishedReportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.FAILED);
                    } else if (rhi.nbSkipped > 0 || rhi.nbConflict > 0 || rhi.nbEmpty > 0) {
                        finishedReportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.WARNING);
                    } else {
                        finishedReportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.SUCCESS);
                    }
                    stepReportItem.withEnd(DateTime.now().getMillis()).withOutcome(finishedReportItem.outcome);
                }
                finally {
                    this.jobsDatabaseService.tryRegisterFlowObjectEvent(agentReviewLoc, null, null, stepRun.getScenarioRun(), stepRun, finishedReportItem);
                }
            } else {
                stepReportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.FAILED);
            }
            logger.infoV("Done step %s", new Object[]{this.step.name});
        }
        catch (Exception e) {
            logger.errorV((Throwable)e, "Error while computing %s", new Object[]{this.step.name});
            stepReportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.FAILED);
        }
    }

    public static class RunAgentReviewStepParams
    extends NonFatalStepParams
    implements StepParams {
        public String projectKey;
        public String agentReviewId;
        public boolean useActiveVersionOfAgent;

        public String getProjectKey() {
            return this.projectKey;
        }

        public RunAgentReviewStepParams withProjectKey(String projectKey) {
            this.projectKey = projectKey;
            return this;
        }
    }
}

