/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scoring.exports;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.code.AutomationNodeCodeEnvsService;
import com.dataiku.dip.code.DSSInternalCodeEnvsService;
import com.dataiku.dip.code.DesignNodeCodeEnvsService;
import com.dataiku.dip.code.PythonCodeEnvPackagesUtils;
import com.dataiku.dip.connections.DatabricksModelDeploymentConnection;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.externalinfras.databricks.DatabricksUtils;
import com.dataiku.dip.externalml.mlflow.DatabricksUtilsKernelProtocol;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.scoring.exports.MLflowScoring;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.FilesystemACLUtils;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKULogger;
import java.io.File;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class ExportAndRegisterMLflowModelInFutureThread
extends SimpleFutureThread<DatabricksUtilsKernelProtocol.RequestModelRegistrationResponse> {
    @Nonnull
    private final FullModelId fmi;
    @Nonnull
    private final DatabricksModelDeploymentConnection connection;
    private final boolean useUnityCatalog;
    @Nonnull
    private final String modelName;
    @Nonnull
    private final String experimentName;
    private final List<File> extraLogFiles;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.scoring.exports.databricks");

    public ExportAndRegisterMLflowModelInFutureThread(@Nonnull AuthCtx authCtx, @Nonnull FullModelId fmi, @Nonnull DatabricksModelDeploymentConnection connection, boolean useUnityCatalog, @Nonnull String modelName, @Nonnull String experimentName, List<File> extraLogFiles) {
        super(authCtx);
        this.fmi = fmi;
        this.connection = connection;
        this.useUnityCatalog = useUnityCatalog;
        this.modelName = modelName;
        this.experimentName = experimentName;
        this.extraLogFiles = extraLogFiles;
    }

    public FuturePayload getPayload() {
        FuturePayload fp = FuturePayload.newSimple((String)"export_model_to_mlflow_and_register", (String)"Exports a model to the MLflow format and registers it in a remote registry");
        fp.targets.add(new FuturePayload.FuturePayloadTarget(this.fmi.getProjectKey(), this.fmi.toString(), this.fmi.toString(), null));
        return fp;
    }

    @Override
    protected DatabricksUtilsKernelProtocol.RequestModelRegistrationResponse compute() throws Exception {
        logger.infoV("Exporting model %s to registry of connection %s under name %s. Use Unity Catalog: %b. Log in a run of experiment: %s.", new Object[]{this.fmi.toString(), this.connection.name, this.modelName, this.useUnityCatalog, this.experimentName});
        MLflowScoring mlflowScoring = new MLflowScoring(this.fmi, true, true);
        try (AutoDelete tmpExportDir = DSSTempUtils.getTempFolder((String)"model-export", (String)"model");){
            DatabricksUtilsKernelProtocol.RequestModelRegistrationResponse requestModelRegistrationResponse;
            block25: {
                logger.debugV("Exporting DSS model to MLflow format in temporary dir %s", new Object[]{tmpExportDir});
                try (FutureProgress.AutocloseableFutureProgressState fp = FutureProgress.pushAutoCloseableState((String)"Exporting model to MLflow format", (double)1.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                    mlflowScoring.writeToDir((File)tmpExportDir);
                }
                FilesystemACLUtils.grantFSFullACLs((AuthCtx)this.owner, null, new File[]{tmpExportDir});
                fp = FutureProgress.pushAutoCloseableState((String)"Registering model in Databricks Repository", (double)1.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);
                try {
                    Schema schema = this.fmi.getNonScoredSchema();
                    String targetName = null;
                    try {
                        targetName = this.fmi.getResolvedPredictionPreprocessingParams().getTarget();
                    }
                    catch (NoSuchElementException nse) {
                        logger.debug((Object)"Model has no target.");
                    }
                    String codeEnvName = DSSInternalCodeEnvsService.getCodeEnvName(DSSInternalCodeEnvsService.DSSInternalCodeEnvType.DATABRICKS_UTILS_CODE_ENV);
                    logger.debugV("Exported model %s an MLflow model. Will use code environment %s to do the export.", new Object[]{this.fmi.isExternalMLflowModelVersion() ? "is" : "is not", codeEnvName});
                    if (this.useUnityCatalog) {
                        logger.debug((Object)"Doing extra checks for export to Unity Catalog...");
                        if (null == schema) {
                            throw new Error("Model has no schema. Import in Unity Catalog will fail. You may try with the Workspace Registry.");
                        }
                        if (StringUtils.isBlank((CharSequence)targetName)) {
                            throw new Error("Model has no target. Import in Unity Catalog will fail. You may try with the Workspace Registry.");
                        }
                        logger.debug((Object)"Checking if code env seems to have required packages...");
                        PythonCodeEnvPackagesUtils.PythonEnvPackages pythonEnvPackages = ExportAndRegisterMLflowModelInFutureThread.getPythonEnvPackages(codeEnvName, this.fmi);
                        PythonCodeEnvPackagesUtils.PythonPackageVersion mlflowVersion = pythonEnvPackages.getPackageVersion("mlflow");
                        String MLFLOW_MIN_VERSION = "2.5.0";
                        if (null == mlflowVersion || mlflowVersion.lt(PythonCodeEnvPackagesUtils.PythonPackageVersion.fromString("2.5.0"))) {
                            throw new Error(String.format("The code environment of your model (%s) must include mlflow>=%s when exporting to the Unity Catalog. It must also include mlflow[databricks] or mlflow-skinny[databricks].", codeEnvName, "2.5.0"));
                        }
                    }
                    DatabricksUtilsKernelProtocol.RequestModelRegistrationResponse resp = DatabricksUtils.registerModelInDatabricks(this.owner, (File)tmpExportDir, this.connection, this.useUnityCatalog, this.modelName, this.experimentName, null != schema ? schema.columns : null, targetName, this.extraLogFiles);
                    logger.infoV("Model successfully registered. Version: %s. Status: %s. Status message: %s.", new Object[]{resp.version, resp.status, resp.statusMessage});
                    requestModelRegistrationResponse = resp;
                    if (fp == null) break block25;
                }
                catch (Throwable throwable) {
                    if (fp != null) {
                        try {
                            fp.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                fp.close();
            }
            return requestModelRegistrationResponse;
        }
    }

    @Nonnull
    private static PythonCodeEnvPackagesUtils.PythonEnvPackages getPythonEnvPackages(String codeEnvName, FullModelId fmi) throws Exception {
        PythonCodeEnvPackagesUtils.PythonEnvPackages pythonEnvPackages;
        switch (ApplicationConfigurator.getNodeType()) {
            case DESIGN: {
                pythonEnvPackages = ((DesignNodeCodeEnvsService)SpringUtils.getBean(DesignNodeCodeEnvsService.class)).getPythonEnvPackages(codeEnvName);
                if (null != pythonEnvPackages) break;
                throw new Error(String.format("Could not list code environment %s packages", codeEnvName));
            }
            case AUTOMATION: {
                pythonEnvPackages = ((AutomationNodeCodeEnvsService)SpringUtils.getBean(AutomationNodeCodeEnvsService.class)).getPythonEnvPackages(fmi.getProjectKey(), codeEnvName);
                if (null != pythonEnvPackages) break;
                throw new Error(String.format("Could not list packages for version of code env %s for project %s", codeEnvName, fmi.getProjectKey()));
            }
            default: {
                throw new Error("Unreachable");
            }
        }
        return pythonEnvPackages;
    }
}

