/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.impersonation;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import java.io.File;
import java.io.IOException;

public class MapRTicketGenerator {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.security.impersonation.tokens");

    public static boolean isMapR() {
        return "mapr".equals(System.getenv("DKU_HADOOP_FLAVOR"));
    }

    public static void generateTicketForUser(String proxyUser, String tokenFile) throws IOException {
        String duration = ApplicationConfigurator.getIniValue((String)"mus", (String)"mapr_ticket_duration", (String)"1:0:0");
        logger.info((Object)("Generating MapR ticket for user=" + proxyUser + " duration=" + duration));
        try {
            DKUtils.execAndLogThrows((String[])new String[]{"maprlogin", "generateticket", "-type", "service", "-out", tokenFile, "-user", proxyUser, "-duration", duration}, null, (File)null);
        }
        catch (Exception e) {
            throw new IOException("error generating MapR ticket for user " + proxyUser, e);
        }
    }
}

