/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.semanticmodels;

import com.dataiku.dip.dao.AbstractStandardDAO;
import com.dataiku.dip.semanticmodels.SemanticModel;
import com.dataiku.dip.semanticmodels.SemanticModelsDAO;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class FilesBasedSemanticModelsDAO
extends AbstractStandardDAO<SemanticModel>
implements SemanticModelsDAO {
    @Override
    protected SemanticModel getOrNull_noTag(String projectKey, String id, boolean unsafe) throws IOException {
        RelFile rf;
        TransactionRef tr = TransactionContext.retrieveRead();
        if (!tr.isFile(rf = this.getDAOFile(projectKey, id))) {
            return null;
        }
        SemanticModel model = unsafe ? (SemanticModel)tr.readObjectUnsafe(rf, SemanticModel.class) : (SemanticModel)tr.readObject(rf, SemanticModel.class);
        model.id = id;
        model.projectKey = projectKey;
        return model;
    }

    @Override
    protected List<SemanticModel> list_noTag(String projectKey, boolean unsafe) throws IOException {
        RelFile semanticModelsFolder = this.semanticModelsFolder(projectKey);
        TransactionRef tr = TransactionContext.retrieveRead();
        ArrayList<SemanticModel> ret = new ArrayList<SemanticModel>();
        if (tr.isDirectory(semanticModelsFolder)) {
            for (RelFile f : tr.listFiles(semanticModelsFolder)) {
                try {
                    String id = StringUtils.removeEnd((String)f.getLeafName(), (String)".json");
                    SemanticModel model = (SemanticModel)this.getMandatory(projectKey, id, unsafe);
                    ret.add(model);
                }
                catch (Exception e) {
                    this.logger.error((Object)("Failed to read semantic model file: " + String.valueOf(f)), (Throwable)e);
                }
            }
        }
        return ret;
    }

    @Override
    protected RelFile getDAOFile(String projectKey, String id) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"Semantic model id is not specified");
        return new RelFile(this.semanticModelsFolder(projectKey), new String[]{id + ".json"});
    }

    @Override
    protected String getHumanReadableType() {
        return ITaggingService.TaggableType.SEMANTIC_MODEL.toHumanReadableString();
    }

    @Override
    public void delete(String projectKey, String id) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        RelFile semanticModelFile = this.getDAOFile(projectKey, id);
        t.deleteFile(semanticModelFile);
    }

    @Override
    public int approximateCount(String projectKey) throws IOException {
        RelFile semanticModelsFolder;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.exists(semanticModelsFolder = this.semanticModelsFolder(projectKey))) {
            return 0;
        }
        return t.listFiles(semanticModelsFolder).size();
    }

    private RelFile semanticModelsFolder(String projectKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        return new RelFile(new String[]{"projects", projectKey, "semantic-models"});
    }
}

