/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.semanticmodels.SemanticModel;
import com.dataiku.dip.semanticmodels.SemanticModelLoc;
import com.dataiku.dip.semanticmodels.SemanticModelsCRUDService;
import com.dataiku.dip.semanticmodels.SemanticModelsDAO;
import com.dataiku.dip.semanticmodels.model.SemanticModelVersion;
import com.dataiku.dip.semanticmodels.values.DistinctValuesService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
public class PublicAPISemanticModelsController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private SemanticModelsCRUDService semanticModelsCRUDService;
    @Autowired
    private SemanticModelsDAO semanticModelsDAO;
    @Autowired
    private DistinctValuesService distinctValuesService;

    @AuditedCall(value={"msgType", "semantic-models-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/semantic-models/"}, method={RequestMethod.GET})
    @ResponseBody
    public List<SemanticModel> list(HttpServletRequest req, @PathVariable String projectKey) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (Transaction ignored = this.transactionService.beginRead();){
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            List<SemanticModel> list = this.semanticModelsDAO.listUnsafe(projectKey);
            return list;
        }
    }

    @AuditedCall(value={"msgType", "semantic-model-get", "projectKey", "${projectKey}", "semanticModelId", "${semanticModelId}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/semantic-models/{semanticModelId}"}, method={RequestMethod.GET})
    @ResponseBody
    public SemanticModel get(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String semanticModelId) throws DKUSecurityException, CodedException, IOException {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (Transaction ignored = this.transactionService.beginRead();){
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            SemanticModel semanticModel = (SemanticModel)this.semanticModelsDAO.getMandatoryUnsafe(projectKey, semanticModelId);
            return semanticModel;
        }
    }

    @AuditedCall(value={"msgType", "semantic-models-create", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/semantic-models/"}, method={RequestMethod.POST})
    @ResponseBody
    public SemanticModel create(HttpServletRequest req, @PathVariable String projectKey, @RequestParam String name) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            String id = this.semanticModelsCRUDService.create(authCtx, projectKey, name);
            SemanticModel created = (SemanticModel)this.semanticModelsDAO.getMandatory(projectKey, id);
            t.commitV("Created semantic model %s (%s)", new Object[]{created.name, created.id});
            SemanticModel semanticModel = created;
            return semanticModel;
        }
    }

    @AuditedCall(value={"msgType", "semantic-models-save", "projectKey", "${projectKey}", "semanticModelId", "${semanticModelId}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/semantic-models/{semanticModelId}"}, method={RequestMethod.PUT})
    @ResponseBody
    public SemanticModel save(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String semanticModelId, @RequestBody SemanticModel semanticModel) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            semanticModel.projectKey = projectKey;
            semanticModel.id = semanticModelId;
            SemanticModel saved = this.semanticModelsCRUDService.save(semanticModel, false);
            t.commitV("Saved semantic model %s (%s)", new Object[]{saved.name, saved.id});
            SemanticModel semanticModel2 = saved;
            return semanticModel2;
        }
    }

    @AuditedCall(value={"msgType", "semantic-models-delete", "projectKey", "${projectKey}", "semanticModelId", "${semanticModelId}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/semantic-models/{semanticModelId}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    public void delete(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String semanticModelId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            SemanticModel semanticModel = (SemanticModel)this.semanticModelsDAO.getMandatory(projectKey, semanticModelId);
            this.semanticModelsCRUDService.delete(authCtx, projectKey, semanticModelId, Set.of());
            t.commitV("Deleted semantic model %s (%s)", new Object[]{semanticModel.name, semanticModel.id});
        }
    }

    @AuditedCall(value={"msgType", "semantic-model-save", "projectKey", "${projectKey}", "semanticModelId", "${semanticModelId}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/semantic-models/{semanticModelId}/versions/{versionId}"}, method={RequestMethod.PUT})
    public void saveVersion(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String semanticModelId, @PathVariable String versionId, @RequestBody SemanticModelVersion version) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            SemanticModel sm = (SemanticModel)this.semanticModelsDAO.getMandatory(projectKey, semanticModelId);
            boolean found = false;
            for (int i = 0; i < sm.versions.size(); ++i) {
                SemanticModelVersion v = sm.versions.get(i);
                if (!v.id.equals(versionId)) continue;
                sm.versions.set(i, version);
                found = true;
                break;
            }
            if (!found) {
                sm.versions.add(version);
            }
            this.semanticModelsCRUDService.save(sm, false);
            t.commitV("Saved semantic model %s version %s (%s)", new Object[]{sm.name, versionId, sm.id});
        }
    }

    @AuditedCall(value={"msgType", "semantic-model-get-index-basic-attribute", "projectKey", "${projectKey}", "semanticModelId", "${semanticModelId}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/semantic-models/{semanticModelId}/versions/{versionId}/distinct-values/forAttribute"}, method={RequestMethod.GET})
    @ResponseBody
    public DistinctValuesService.BasicDistinctValuesResult getBasicDistinctValuesForAttribute(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String semanticModelId, @PathVariable String versionId, @RequestParam String entity, @RequestParam String attribute, @RequestParam(required=false, defaultValue="1000") long maxValues) throws Exception {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        SemanticModelLoc loc = new SemanticModelLoc(projectKey, semanticModelId, versionId);
        return this.distinctValuesService.getBasicForAttribute_NT(loc, entity, attribute, maxValues);
    }

    @AuditedCall(value={"msgType", "semantic-model-get-index-basic", "projectKey", "${projectKey}", "semanticModelId", "${semanticModelId}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/semantic-models/{semanticModelId}/versions/{versionId}/distinct-values/global"}, method={RequestMethod.GET})
    @ResponseBody
    public DistinctValuesService.BasicDistinctValuesForSemanticModelResult getBasicDistinctValuesForSemanticModel(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String semanticModelId, @PathVariable String versionId, @RequestParam(required=false, defaultValue="1000") long maxValues) throws Exception {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        SemanticModelLoc loc = new SemanticModelLoc(projectKey, semanticModelId, versionId);
        return this.distinctValuesService.getBasicForSemanticModel_NT(loc, maxValues);
    }

    @AuditedCall(value={"msgType", "semantic-model-update-index", "projectKey", "${projectKey}", "semanticModelId", "${semanticModelId}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/semantic-models/{semanticModelId}/versions/{versionId}/distinct-values/actions/startUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<Void> startUpdateDistinctValues(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String semanticModelId, @PathVariable String versionId) throws Exception {
        AuthCtx authCtx = null;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        return this.distinctValuesService.startRefreshDistinctValues_NT(authCtx, new SemanticModelLoc(projectKey, semanticModelId, versionId));
    }
}

