/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.businessapps.BusinessAppsService;
import com.dataiku.dip.deployer.projectdeployer.published.PublishedProjectsService;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.projects.TutorialsService;
import com.dataiku.dip.projects.apps.AppsService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ImageService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.RandomPhotosService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.Id;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableLong;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ImageController
extends DIPInternalControllerBase {
    @Autowired
    ImageService service;
    @Autowired
    UIAuthService authService;
    @Autowired
    ProjectsService projectsService;
    @Autowired
    PublishedProjectsService publishedProjectsService;
    @Autowired
    TransactionService transactionService;
    @Autowired
    TutorialsService tutorialsService;
    @Autowired
    AppsService appsService;
    @Autowired
    RandomPhotosService randomPhotoService;
    @Autowired
    private PermissionsService permissionsService;

    @AuditNotNeeded
    @RequestMapping(value={"/api/image/set-image"})
    public void setTotem(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String type, @RequestParam String id, @RequestParam String dataUrl) throws IOException, DKUSecurityException {
        if (StringUtils.isBlank((String)projectKey) || "undefined".equals(projectKey)) {
            projectKey = null;
        }
        try (RWTransaction t = this.transactionService.beginWriteForUI(req, false);){
            AuthCtx u = this.authService.getMandatoryUser(req);
            if ("DASHBOARD_TILE".equals(type)) {
                this.projectsService.checkPermNoXSRF(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_DASHBOARDS);
                id = SecretKeyGenerator.generateSmall();
            } else if ("PUBLISHED_PROJECT".equals(type)) {
                this.publishedProjectsService.getPublishedItemWithWritePermissionCheck_T(projectKey, u);
            } else if ("USER".equals(type)) {
                if (!u.isAdmin() && !u.getAssociatedDSSUser().equals(id)) {
                    throw new DKUSecurityException("You are not allowed to change another user's image");
                }
            } else if ("PROMOTED_CONTENT".equals(type)) {
                if (!u.isAdmin()) {
                    throw new DKUSecurityException("You are not allowed to set a promoted content image");
                }
            } else if ("APP".equals(type) || "APPFULL".equals(type)) {
                this.appsService.checkEditPerm(u, id);
            } else if (projectKey != null) {
                this.projectsService.checkPermNoXSRF(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            } else {
                throw new IllegalArgumentException("Failed to check permissions with type=" + type + "; projectKey=" + projectKey);
            }
            String encodingPrefix = "base64,";
            int contentStartIndex = dataUrl.indexOf(encodingPrefix) + encodingPrefix.length();
            byte[] imageData = Base64.decodeBase64((String)dataUrl.substring(contentStartIndex));
            this.service.setImage(projectKey, type, id, imageData);
            ImageController.writeJSON((HttpServletResponse)resp, (Object)new Id(id));
            t.commit("Updated image for " + type + " " + id);
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/image/set-captured-object-thumbnail"})
    public void setCapturedObjectThumbnail(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String type, @RequestParam String id, @RequestParam String dataUrl) throws IOException, DKUSecurityException {
        block10: {
            if (StringUtils.isBlank((String)projectKey) || "undefined".equals(projectKey)) {
                throw new IllegalArgumentException("Missing projectKey");
            }
            if (StringUtils.isBlank((String)type) || "undefined".equals(type)) {
                throw new IllegalArgumentException("Missing type");
            }
            if (StringUtils.isBlank((String)id) || "undefined".equals(id)) {
                throw new IllegalArgumentException("Missing id");
            }
            try (Transaction t = this.transactionService.beginRead();){
                AuthCtx u = this.authService.getMandatoryUser(req);
                if ("DASHBOARD".equals(type) || "WEB_APP".equals(type) || "ARTICLE".equals(type) || "DATASET".equals(type)) {
                    this.projectsService.failIfNoDashboardReadPermission(u, new SmartObjectRef(ITaggingService.TaggableType.valueOf(type), id), projectKey);
                    break block10;
                }
                throw new IllegalArgumentException("Failed to check permissions with type=" + type + "; projectKey=" + projectKey);
            }
        }
        String encodingPrefix = "base64,";
        int contentStartIndex = dataUrl.indexOf(encodingPrefix) + encodingPrefix.length();
        byte[] imageData = Base64.decodeBase64((String)dataUrl.substring(contentStartIndex));
        this.service.setCapturedThumbnail_NT(projectKey, type, id, imageData, null, 150);
        ImageController.writeJSON((HttpServletResponse)resp, (Object)new Id(id));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/image/remove-image"})
    public void removeTotem(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="projectKey", required=false) String projectKey, @RequestParam String type, @RequestParam String id) throws IOException, DKUSecurityException {
        if (StringUtils.isBlank((String)projectKey) || "undefined".equals(projectKey)) {
            projectKey = null;
        }
        try (RWTransaction t = this.transactionService.beginWriteForUI(req, true);){
            AuthCtx u = this.authService.getMandatoryUserNoXSRF(req);
            if ("PUBLISHED_PROJECT".equals(type)) {
                this.publishedProjectsService.getPublishedItemWithWritePermissionCheck_T(projectKey, u);
            } else if ("USER".equals(type)) {
                if (!u.isAdmin() && !u.getAssociatedDSSUser().equals(id)) {
                    throw new DKUSecurityException("You are not allowed to remove another user's image");
                }
            } else if ("APP".equals(type) || "APPFULL".equals(type)) {
                this.appsService.checkEditPerm(u, id);
            } else if (projectKey != null) {
                this.projectsService.checkPermNoXSRF(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            } else {
                throw new IllegalArgumentException("Failed to check permissions with type=" + type + "; projectKey=" + projectKey);
            }
            this.service.removeImage(projectKey, type, id);
            if ("USER".equals(type)) {
                t.commit("Removed image for user " + id);
            } else if ("APP".equals(type) || "APPFULL".equals(type)) {
                t.commit("Removed image for app " + id);
            } else {
                t.commit("Removed image for project " + projectKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditNotNeeded
    @RequestMapping(value={"/api/image/get-image"})
    public void anyTotem(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="size", required=false) String requestedSize, @RequestParam(value="projectKey", required=false) String projectKey, @RequestParam(value="type", required=true) String type, @RequestParam(value="id", required=true) String id, @RequestParam(value="hash", required=false) String hash, @RequestParam(value="color", required=false) String color, @RequestParam(value="pattern", required=false) Integer pattern, @RequestParam(value="initials", required=false) String initials, @RequestParam(value="dashboardId", required=false) String dashboardId) throws IOException, DKUSecurityException {
        InputStream picData;
        MutableLong lastModified;
        long ifModifiedSince;
        if (StringUtils.isBlank((String)projectKey) || "undefined".equals(projectKey)) {
            projectKey = null;
        }
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUserNoXSRF(req);
            if ("PUBLISHED_PROJECT".equals(type)) {
                this.publishedProjectsService.getPublishedItemWithReadPermissionCheck_T(projectKey, u);
            } else if ("BUSINESS_APP".equals(type)) {
                this.permissionsService.checkBusinessAppPrivileges(u, id, BusinessAppsService.BusinessAppPrivilegeType.USE);
            } else if (projectKey != null) {
                if ("DASHBOARD".equals(type) || "WEB_APP".equals(type) || "ARTICLE".equals(type) || "DATASET".equals(type)) {
                    this.projectsService.failIfNoDashboardReadPermission(u, new SmartObjectRef(ITaggingService.TaggableType.valueOf(type), id), projectKey);
                } else if ("DASHBOARD_TILE".equals(type) && dashboardId != null) {
                    this.projectsService.failIfNoDashboardReadPermission(u, new SmartObjectRef(ITaggingService.TaggableType.DASHBOARD, dashboardId), projectKey);
                } else {
                    boolean isVisibleProject;
                    boolean bl = isVisibleProject = "PROJECT".equals(type) && this.projectsService.isVisible(projectKey);
                    if (!isVisibleProject) {
                        this.projectsService.checkPerm(u, projectKey, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS);
                    }
                }
            }
            ifModifiedSince = req.getDateHeader("If-Modified-Since");
            lastModified = new MutableLong();
            picData = this.service.getImage(projectKey, type, id, requestedSize, lastModified, color, pattern, initials);
        }
        if (picData == null) {
            resp.setStatus(404);
            return;
        }
        resp.setDateHeader("Last-Modified", lastModified.longValue());
        resp.setContentType("image/png");
        if (StringUtils.isBlank((String)hash) || "undefined".equals(hash)) {
            resp.addDateHeader("Expires", System.currentTimeMillis() + 60000L);
        } else {
            resp.addDateHeader("Expires", System.currentTimeMillis() + 86400000L);
        }
        try {
            if (lastModified.longValue() <= ifModifiedSince) {
                resp.setStatus(304);
            } else {
                IOUtils.copy((InputStream)picData, (OutputStream)resp.getOutputStream());
            }
        }
        finally {
            picData.close();
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/image/get-object-thumbnail-info"})
    public void getObjectThumbnailInfo(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String type, @RequestParam String id) throws IOException, DKUSecurityException {
        if (!("DASHBOARD".equals(type) || "WEB_APP".equals(type) || "ARTICLE".equals(type) || "DATASET".equals(type))) {
            throw new IllegalArgumentException("Thumbnails are not handled for type=" + type);
        }
        ObjectThumbnailInfo info = new ObjectThumbnailInfo();
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            this.projectsService.failIfNoDashboardReadPermission(u, new SmartObjectRef(ITaggingService.TaggableType.valueOf(type), id), projectKey);
            info.lastModified = this.service.getCapturedObjectThumbnailLastModified(projectKey, type, id);
        }
        ImageController.writeJSON((HttpServletResponse)resp, (Object)info);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/image/get-tutorial-thumbnail"})
    public void getTutorialThumbnail(HttpServletRequest req, HttpServletResponse resp, @RequestParam String tutorialId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUserNoXSRF(req);
        }
        URL url = this.tutorialsService.getThumbnailURL(tutorialId);
        try (InputStream picData = url.openStream();){
            resp.setContentType("image/png");
            IOUtils.copy((InputStream)picData, (OutputStream)resp.getOutputStream());
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/image/random-photo/{query:.+}"})
    public void getRandomPhoto(HttpServletRequest req, HttpServletResponse resp, @PathVariable String query, @RequestParam(defaultValue="1920") int width, @RequestParam(defaultValue="1280") int height) throws IOException {
        if (!query.matches("\\w+")) {
            throw new IllegalArgumentException("Invalid query. It must only include alphanumeric characters.");
        }
        if (width < 8 || width > 8192) {
            throw new IllegalArgumentException("Invalid width. It must be between 8 and 8192 pixels");
        }
        if (height < 8 || height > 8192) {
            throw new IllegalArgumentException("Invalid height. It must be between 8 and 8192 pixels");
        }
        try (Transaction ignored = this.transactionService.beginRead();){
            this.authService.getMandatoryUserNoXSRF(req);
        }
        File file = this.randomPhotoService.getRandomPhoto(query, width, height);
        if (file == null) {
            resp.setStatus(500);
        } else {
            String contentType = "image/" + (file.getName().endsWith(".png") ? "png" : "jpeg");
            try (FileInputStream imageResponse = new FileInputStream(file);){
                resp.setContentType(contentType);
                IOUtils.copy((InputStream)imageResponse, (OutputStream)resp.getOutputStream());
            }
        }
    }

    private static class ObjectThumbnailInfo {
        public long lastModified;

        private ObjectThumbnailInfo() {
        }
    }
}

