/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.ElasticSearchConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchDatasetHandler;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchIndex;
import com.dataiku.dip.datasets.elasticsearch.InteractiveSearchService;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.searchnotebooks.SearchNotebook;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.TagFilterUtils;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.controllers.SQLNotebooksController;
import com.dataiku.dip.server.services.ConnectionsService;
import com.dataiku.dip.server.services.InterestsService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.SearchNotebooksService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.timelines.TimelinesService;
import com.dataiku.dip.transactions.exceptions.TransactionBadlyFailedError;
import com.dataiku.dip.transactions.ifaces.MinimalRWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.util.Id;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class SearchNotebooksController
extends DIPInternalControllerBase {
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private PermissionsService permissionsService;
    @Autowired
    private SearchNotebooksService searchNotebooksService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private TimelinesService timelinesService;
    @Autowired
    private InterestsService interestsService;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private ConnectionsService connectionsService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private InteractiveSearchService interactiveSearchService;
    private static final DKULogger logger = DKULogger.getLogger(SearchNotebooksController.class);

    @AuditInline
    @RequestMapping(value={"/api/search-notebooks/create"})
    public void create(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String connection, @RequestParam String name) throws Exception {
        Id newId;
        ErrorContext.checkNotEmpty((String)name, (String)"notebook name");
        ErrorContext.checkNotEmpty((String)connection, (String)"connection");
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            newId = new Id(this.searchNotebooksService.create(user, projectKey, connection, name));
            t.commit("Created Search notebook " + projectKey + "." + newId.id);
            this.auditTrailService.generic("search-notebook-create").with("projectKey", projectKey).with("connection", connection).with("notebookId", newId.id).emit();
        }
        SearchNotebooksController.writeJSON((HttpServletResponse)resp, (Object)newId);
    }

    @AuditInline
    @RequestMapping(value={"/api/search-notebooks/copy"})
    public void copy(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String notebookId, @RequestParam String newNotebookName) throws Exception {
        Id newId;
        ErrorContext.checkNotEmpty((String)notebookId, (String)"notebook id");
        ErrorContext.checkNotEmpty((String)newNotebookName, (String)"new notebook name");
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            newId = new Id(this.searchNotebooksService.copy(user, projectKey, notebookId, newNotebookName));
            t.commit("Copied Search notebook to " + projectKey + "." + newId.id);
            this.auditTrailService.generic("search-notebook-copy").with("projectKey", projectKey).with("sourceId", notebookId).with("newId", newId.id).emit();
        }
        SearchNotebooksController.writeJSON((HttpServletResponse)resp, (Object)newId);
    }

    @AuditInline
    @RequestMapping(value={"/api/search-notebooks/save"})
    public void save(HttpServletRequest req, HttpServletResponse resp, @RequestParam SearchNotebook notebook, @RequestParam(required=false) TaggableObjectsService.TaggableObjectSaveInfo saveInfo) throws TransactionBadlyFailedError, Exception {
        SearchNotebook newNotebook;
        ErrorContext.checkNotNull((Object)notebook, (String)"search notebook");
        if (saveInfo == null) {
            saveInfo = new TaggableObjectsService.TaggableObjectSaveInfo();
        }
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(u, notebook.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.connectionsService.checkUserForConnection(u, notebook.connection);
            newNotebook = this.searchNotebooksService.save(notebook, saveInfo.summaryOnly);
            if (saveInfo.summaryOnly) {
                t.commit("Updated summary for Search notebook " + notebook.projectKey + "." + notebook.name + " (id: " + notebook.id + ")", 60000L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_NOT_ALL_EXPLICIT);
            } else {
                t.commit("Saved settings for Search notebook " + notebook.projectKey + "." + notebook.name + " (id: " + notebook.id + ")");
            }
            this.auditTrailService.generic("search-notebook-save").with("projectKey", notebook.projectKey).with("notebookId", notebook.id).emit();
        }
        SearchNotebooksController.writeJSON((HttpServletResponse)resp, (Object)newNotebook);
    }

    @AuditedCall(value={"msgType", "search-notebooks-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/search-notebooks/list-heads"})
    public void listHeads(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam(required=false) TagFilterUtils.TagFilter tagFilter) throws Exception {
        AuthCtx u;
        TaggableObjectsService.FilteredTaggableItems heads = new TaggableObjectsService.FilteredTaggableItems();
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            u = this.authService.getMandatoryUser(req);
            for (SearchNotebook nbk : this.searchNotebooksService.list(projectKey)) {
                if (!TagFilterUtils.matches(tagFilter, nbk.tags)) {
                    ++heads.filteredOut;
                    continue;
                }
                SearchNotebook.SearchNotebookListItem head = new SearchNotebook.SearchNotebookListItem(nbk);
                this.taggableObjectsService.setEditionInfoFromTags(nbk, head);
                heads.items.add(head);
            }
        }
        this.interestsService.enrichListItems(u.getAssociatedDSSUser(), projectKey, heads.items);
        SearchNotebooksController.writeJSON((HttpServletResponse)resp, heads);
    }

    @AuditedCall(value={"msgType", "connections-list", "for", "search-notebooks"})
    @RequestMapping(value={"/api/search-notebooks/list-connections"})
    public void listConnections(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        SQLNotebooksController.NotebookConnectionListing ret = new SQLNotebooksController.NotebookConnectionListing();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkReadProjectContentAllowed(authCtx);
            for (Map.Entry<String, DSSConnection> entry : this.connectionsService.listUnsafe().entrySet()) {
                DSSConnection conn = entry.getValue();
                try {
                    ElasticSearchConnection esConn;
                    if (!(conn instanceof ElasticSearchConnection) || !conn.isFreelyUsableBy(authCtx) || !this.searchNotebooksService.isDialectCompatible(esConn = (ElasticSearchConnection)conn)) continue;
                    SQLNotebooksController.NotebookConnection nconn = new SQLNotebooksController.NotebookConnection();
                    nconn.name = entry.getKey();
                    nconn.type = esConn.getType();
                    nconn.label = nconn.name;
                    ret.nconns.add(nconn);
                }
                catch (IllegalArgumentException e) {
                    logger.error((Object)("Failed to read connection during list-connections: " + conn.name), (Throwable)e);
                }
            }
        }
        SearchNotebooksController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "search-notebook-read-meta", "projectKey", "${projectKey}", "notebookId", "${id}"})
    @RequestMapping(value={"/api/search-notebooks/get-summary"})
    public void getSummary(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id) throws Exception {
        AuthCtx authCtx;
        TaggableObjectsService.TaggableObjectSummary summ = new TaggableObjectsService.TaggableObjectSummary();
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            summ.object = this.searchNotebooksService.getMandatoryUnsafe(projectKey, id);
        }
        summ.timeline = this.timelinesService.getObjectTimeline_NT(summ.object.getTaggableType(), projectKey, id, summ.object.creationTag, summ.object.versionTag, 0, 100);
        summ.interest = this.interestsService.getObjectAndUserInterest_noFail(authCtx, summ.object.getTaggableType(), projectKey, id);
        SearchNotebooksController.writeJSON((HttpServletResponse)resp, (Object)summ);
    }

    @ResponseBody
    @AuditedCall(value={"msgType", "search-notebook-infer-schema", "projectKey", "${projectKey}", "connection", "${connection}", "index", "${index}"})
    @RequestMapping(value={"/api/search-notebooks/infer-schema"}, method={RequestMethod.POST})
    public ElasticSearchIndex.InferredSchemaWithStats inferSchema(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String index, @RequestParam String connection) throws Exception {
        Dataset ds;
        DSSAuthCtx user;
        ErrorContext.checkNotEmpty((String)connection, (String)"connection name");
        ErrorContext.checkNotEmpty((String)index, (String)"index name");
        try (Transaction t = this.transactionService.beginRead();){
            user = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges((AuthCtx)user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            ds = this.createFakeDataset(user, projectKey, index, connection);
        }
        try (ElasticSearchDatasetHandler elasticSearchDatasetHandler = new ElasticSearchDatasetHandler(user, ds);){
            ElasticSearchIndex elasticSearchIndex = elasticSearchDatasetHandler.getEsIndexForced();
            ElasticSearchIndex.InferredSchemaWithStats inferredSchemaWithStats = elasticSearchIndex.inferSchemaFromMapping(elasticSearchIndex.rootIndex);
            return inferredSchemaWithStats;
        }
    }

    private Dataset createFakeDataset(AuthCtx user, String projectKey, String index, String connection) throws IOException, DKUSecurityException {
        DSSConnection dssConnection = this.connectionsService.getUnsafe(connection);
        if (!(dssConnection instanceof ElasticSearchConnection)) {
            throw new IllegalArgumentException(String.format("Connection '%s' is not an Elastic Search Connection, got '%s'", connection, dssConnection.type));
        }
        ElasticSearchDatasetHandler.Config config = new ElasticSearchDatasetHandler.Config();
        config.index = index;
        Dataset ds = new Dataset();
        ds.setManaged(false);
        ds.setFullName(projectKey + ".FakeESDataset");
        config.connection = connection;
        this.connectionsService.checkUserForConnection(user, connection);
        ds.setParams(config);
        return ds;
    }

    @AuditedCall(value={"msgType", "search-notebook-interactive-search", "projectKey", "${projectKey}", "connection", "${connection}", "index", "${index}", "schema", "${schema}", "searchQuery", "${searchQuery}"})
    @RequestMapping(value={"/api/search-notebooks/interactive-es-search"}, method={RequestMethod.POST})
    public void getElasticSearchDocumentFrom(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String connection, @RequestParam String index, @RequestParam Schema schema, @RequestParam ElasticSearchIndex.ESQueryBuilder.PaginatedInteractiveSearchQuery searchQuery) throws Exception {
        Dataset ds;
        DSSAuthCtx user;
        ErrorContext.checkNotEmpty((String)connection, (String)"connection");
        ErrorContext.checkNotEmpty((String)index, (String)"index");
        ErrorContext.checkNotNull((Object)schema, (String)"schema");
        try (Transaction t = this.transactionService.beginRead();){
            user = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges((AuthCtx)user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            ds = this.createFakeDataset(user, projectKey, index, connection);
            ds.setSchema(schema);
        }
        SerializedShakerScript sss = new SerializedShakerScript();
        SearchNotebooksController.writeJSON((HttpServletResponse)resp, (Object)this.interactiveSearchService.startSearchFuture(user, ds, sss, searchQuery, true));
    }

    @ResponseBody
    @AuditedCall(value={"msgType", "search-notebook-list-usable-datasets", "projectKey", "${projectKey}", "preSelectedDatasets", "${preSelectedDatasets}", "connection", "${connection}"})
    @RequestMapping(value={"/api/search-notebooks/list-usable-datasets"})
    public FutureResponse<List<SerializedDataset>> listAllUsable(HttpServletRequest req, @RequestParam String projectKey, @RequestParam List<String> preSelectedDatasets, @RequestParam boolean loadAll, @RequestParam String connection) throws Exception {
        UsableDatasetListerFutureThread ft;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            this.connectionsService.checkUserForConnection(u, connection);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            ft = new UsableDatasetListerFutureThread((DSSAuthCtx)u, projectKey, preSelectedDatasets, loadAll, connection);
        }
        SpringUtils.getInstance().autowire((Object)ft);
        return this.futureService.runFuture(ft, 2000L, new TypeToken<FutureResponse<List<SerializedDataset>>>(){});
    }

    @ResponseBody
    @AuditedCall(value={"msgType", "resolve-datasets", "projectKey", "${projectKey}", "datasetNames", "${datasetNames}"})
    @RequestMapping(value={"/api/search-notebooks/resolve-datasets"}, method={RequestMethod.POST})
    public List<SerializedDataset> resolveDatasets(HttpServletRequest req, @RequestParam String projectKey, @RequestParam List<String> datasetNames) throws Exception {
        ArrayList<SerializedDataset> serializedDatasets = new ArrayList<SerializedDataset>();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            for (String datasetName : datasetNames) {
                DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveFull(datasetName);
                this.permissionsService.checkDatasetPrivileges(user, loc, Privileges.DatasetLevelPrivilegeType.READ_DATA);
                SerializedDataset sds = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(loc);
                SerializedDataset resolved = this.resolveDatasetIndex(user, sds);
                serializedDatasets.add(resolved);
            }
        }
        return serializedDatasets;
    }

    private SerializedDataset resolveDatasetIndex(AuthCtx user, SerializedDataset sds) throws IOException, DKUSecurityException {
        Dataset dataset = Dataset.fromSerialized(sds);
        try (ElasticSearchDatasetHandler elasticSearchDatasetHandler = new ElasticSearchDatasetHandler(user, dataset);){
            ElasticSearchIndex elasticSearchIndex = elasticSearchDatasetHandler.getEsIndexForced();
            ElasticSearchDatasetHandler.Config params = dataset.getParamsAs(ElasticSearchDatasetHandler.Config.class);
            params.index = elasticSearchIndex.rootIndex;
        }
        return dataset.serialize();
    }

    class UsableDatasetListerFutureThread
    extends SimpleFutureThread<List<SerializedDataset>> {
        private final String projectKey;
        private final String connection;
        private final List<String> preSelectedDatasets;
        private final boolean loadAll;
        private final FuturePayload futurePayload;

        public UsableDatasetListerFutureThread(DSSAuthCtx owner, String projectKey, List<String> preSelectedDatasets, boolean loadAll, String connection) {
            super((AuthCtx)owner);
            this.projectKey = projectKey;
            this.connection = connection;
            this.preSelectedDatasets = preSelectedDatasets;
            this.loadAll = loadAll;
            FuturePayload fp = new FuturePayload();
            fp.action = "search_notebook_list_usable_datasets";
            fp.displayName = "Listing usable datasets";
            this.futurePayload = fp;
        }

        @Override
        public List<SerializedDataset> compute() throws Exception {
            Set<String> projects = this.getSelectedProjects();
            ArrayList<SerializedDataset> res = new ArrayList<SerializedDataset>();
            for (SerializedDataset sd : this.getDatasetsOnConnection(projects)) {
                SerializedDataset resolved = SearchNotebooksController.this.resolveDatasetIndex(this.owner, sd);
                resolved.smartName = resolved.getFullName();
                res.add(resolved);
            }
            return res;
        }

        private Set<String> getSelectedProjects() throws Exception {
            HashSet<String> projects = new HashSet<String>();
            projects.add(this.projectKey);
            for (String datasetName : this.preSelectedDatasets) {
                DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveFull(datasetName);
                projects.add(loc.getProjectKey());
            }
            if (this.loadAll) {
                try (Transaction t = SearchNotebooksController.this.transactionService.beginRead();){
                    for (ProjectsService.UIProject psum : SearchNotebooksController.this.projectsService.listAccessibleUnsafe(this.owner)) {
                        projects.add(psum.projectKey);
                    }
                }
            }
            return projects;
        }

        private List<SerializedDataset> getDatasetsOnConnection(Set<String> projects) throws IOException, DKUSecurityException {
            ArrayList<SerializedDataset> filteredDatasets = new ArrayList<SerializedDataset>();
            for (String pKey : projects) {
                Transaction t = SearchNotebooksController.this.transactionService.beginRead();
                try {
                    for (SerializedDataset sd : SearchNotebooksController.this.datasetsDAO.listUnsafe(pKey)) {
                        DatasetLocUtils.DatasetLoc loc;
                        if (sd.getParams() == null || sd.getParams().getConnection() == null || !sd.getParams().getConnection().equals(this.connection) || !SearchNotebooksController.this.permissionsService.hasDatasetPrivilege(this.owner, loc = DatasetLocUtils.resolveFull(sd.getFullName()), Privileges.DatasetLevelPrivilegeType.READ_DATA)) continue;
                        filteredDatasets.add(sd);
                    }
                }
                finally {
                    if (t == null) continue;
                    t.close();
                }
            }
            return filteredDatasets;
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }
    }
}

