/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers.admin;

import com.dataiku.dip.llm.online.LLMCostLimitingCountersRepository;
import com.dataiku.dip.llm.online.LLMCostLimitingQuotasRepository;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class AdminLLMCostLimitingController
extends DIPInternalControllerBase {
    @Autowired
    private UIAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private LLMCostLimitingCountersRepository countersRepository;
    @Autowired
    private LLMCostLimitingQuotasRepository quotasRepository;

    @AuditNotNeeded
    @RequestMapping(value={"/api/admin/get-cost-limit-counters"})
    public void getCostLimitCounters(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
        }
        catch (Exception e) {
            AdminLLMCostLimitingController.callFailed((Throwable)e, (HttpServletRequest)req, (HttpServletResponse)resp);
            return;
        }
        AdminLLMCostLimitingController.writeJSON((HttpServletResponse)resp, this.countersRepository.getAllAggregatedData(false));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/admin/get-cost-limit-progress"})
    public void getCostLimitProgress(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        catch (Exception e) {
            AdminLLMCostLimitingController.callFailed((Throwable)e, (HttpServletRequest)req, (HttpServletResponse)resp);
            return;
        }
        AdminLLMCostLimitingController.writeJSON((HttpServletResponse)resp, this.countersRepository.getAuthorizedProgressData(authCtx));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/admin/get-cost-limit-quotas"})
    public void getCostLimitQuotas(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        catch (Exception e) {
            AdminLLMCostLimitingController.callFailed((Throwable)e, (HttpServletRequest)req, (HttpServletResponse)resp);
            return;
        }
        AdminLLMCostLimitingController.writeJSON((HttpServletResponse)resp, (Object)this.quotasRepository.getAuthorizedSettings(authCtx, false));
    }
}

