/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.datasets;

import com.dataiku.dip.code.CodeEnvPermissionsService;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.dataquality.DataQualityRunOrigin;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.jobsdb.JobsdbDatasetHandler;
import com.dataiku.dip.datasets.jobsdb.JobsdbDatasetParams;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.mec.ModelEvaluationStoresCRUDService;
import com.dataiku.dip.metrics.ChecksSet;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputation;
import com.dataiku.dip.metrics.MetricMetadata;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.metrics.MetricsEngineDesc;
import com.dataiku.dip.metrics.MetricsLaunchService;
import com.dataiku.dip.metrics.MetricsService;
import com.dataiku.dip.metrics.ProbesSet;
import com.dataiku.dip.metrics.checks.Check;
import com.dataiku.dip.metrics.engines.MetricsEngineRun;
import com.dataiku.dip.metrics.probes.BasicProbeType;
import com.dataiku.dip.metrics.probes.PartitioningProbeType;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.metrics.probes.ProbeType;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.services.FlowZonesService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.dataquality.DataQualityRulesLaunchService;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class MetricsSettingsController
extends DIPInternalControllerBase {
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ManagedFolderDAO managedFolderDAO;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private ProjectsDAO projectsDAO;
    @Autowired
    private ModelEvaluationStoresCRUDService modelEvaluationStoresCRUDService;
    @Autowired
    private MetricsService metricsService;
    @Autowired
    private MetricsComputationService metricsComputationService;
    @Autowired
    private DataQualityRulesLaunchService dataQualityRulesLaunchService;
    @Autowired
    private MetricsLaunchService metricsLaunchService;
    @Autowired
    private DatasetSaveService datasetSaveService;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private CodeEnvPermissionsService codeEnvPermissionsService;
    @Autowired
    private FlowZonesService flowZonesService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    static DKULogger logger = DKULogger.getLogger((String)"dip.datasets.metrics.settings.controller");

    @AuditedCall(value={"msgType", "dataset-edit-status", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/datasets/save-metrics"})
    public void saveOnDataset(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam String metricsData, @RequestParam String checksData) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            AuthCtx liu = t.getUser();
            ProbesSet metrics = (ProbesSet)JSON.parse((String)metricsData, ProbesSet.class);
            for (Probe probe : metrics.probes) {
                this.codeEnvPermissionsService.failIfCodeEnvNotUsable(projectKey, ProbeType.getProbeType(probe.getType()), probe.getConfiguration(), null, t.getUser());
            }
            MetricsSettingsController.writeJSON((HttpServletResponse)resp, (Object)this.metricsService.saveMetricsSetOnDataset(projectKey, datasetName, metrics, liu));
            t.commit("Save metrics settings on dataset " + projectKey + "." + datasetName);
        }
    }

    @AuditedCall(value={"msgType", "folder-edit-status", "projectKey", "${projectKey}", "folderId", "${folderId}"})
    @RequestMapping(value={"/api/managedfolder/save-metrics"})
    public void saveOnFolder(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String folderId, @RequestParam String metricsData, @RequestParam String checksData) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            AuthCtx liu = t.getUser();
            ProbesSet metrics = (ProbesSet)JSON.parse((String)metricsData, ProbesSet.class);
            ChecksSet checks = (ChecksSet)JSON.parse((String)checksData, ChecksSet.class);
            for (Probe probe : metrics.probes) {
                this.codeEnvPermissionsService.failIfCodeEnvNotUsable(projectKey, ProbeType.getProbeType(probe.getType()), probe.getConfiguration(), null, t.getUser());
            }
            for (Check check : checks.checks) {
                this.codeEnvPermissionsService.failIfCodeEnvNotUsable(projectKey, check, check, null, t.getUser());
            }
            MetricsSettingsController.writeJSON((HttpServletResponse)resp, (Object)this.metricsService.saveMetricsSetOnManagedFolder(projectKey, folderId, metrics, checks, liu));
            t.commit("Save metrics settings on managed folder " + projectKey + "." + folderId);
        }
    }

    @AuditedCall(value={"msgType", "project-edit-status", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/save-metrics"})
    public void saveOnProject(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String metricsData, @RequestParam String checksData) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            AuthCtx liu = t.getUser();
            ProbesSet metrics = (ProbesSet)JSON.parse((String)metricsData, ProbesSet.class);
            ChecksSet checks = (ChecksSet)JSON.parse((String)checksData, ChecksSet.class);
            for (Probe probe : metrics.probes) {
                this.codeEnvPermissionsService.failIfCodeEnvNotUsable(projectKey, ProbeType.getProbeType(probe.getType()), probe.getConfiguration(), null, t.getUser());
            }
            for (Check check : checks.checks) {
                this.codeEnvPermissionsService.failIfCodeEnvNotUsable(projectKey, check, check, null, t.getUser());
            }
            MetricsSettingsController.writeJSON((HttpServletResponse)resp, (Object)this.metricsService.saveMetricsSetOnProject(projectKey, metrics, checks, liu));
            t.commit("Save metrics settings on project " + projectKey);
        }
    }

    @AuditedCall(value={"msgType", "model-edit-status", "projectKey", "${projectKey}", "modelId", "${modelId}"})
    @RequestMapping(value={"/api/savedmodels/save-metrics"})
    public void saveOnModel(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String folderId, @RequestParam String checksData) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            AuthCtx liu = t.getUser();
            ChecksSet checks = (ChecksSet)JSON.parse((String)checksData, ChecksSet.class);
            for (Check check : checks.checks) {
                this.codeEnvPermissionsService.failIfCodeEnvNotUsable(projectKey, check, check, null, t.getUser());
            }
            MetricsSettingsController.writeJSON((HttpServletResponse)resp, (Object)this.metricsService.saveMetricsSetOnSavedModel(projectKey, folderId, checks, liu));
            t.commit("Save metrics settings on saved model " + projectKey + "." + folderId);
        }
    }

    private MetricsComputationService.MetricsComputationEnvironment buildMetricsEnvironment() throws IOException {
        MetricsComputationService.MetricsComputationEnvironment environment = new MetricsComputationService.MetricsComputationEnvironment();
        environment.startedFromBuild = false;
        GeneralSettingsDAO.GeneralSettings generalSettings = this.generalSettingsDAO.read();
        environment.graphiteServerUrl = generalSettings.graphiteServerUrl;
        environment.graphiteMetricPrefix = generalSettings.graphiteMetricPrefix;
        return environment;
    }

    @AuditedCall(value={"msgType", "dataset-compute-status", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/datasets/compute-metrics"})
    public void computeOnDataset(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam(required=false) String partitionId, @RequestParam boolean allPartitions) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            Dataset dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
            Partition partition = MetricsComputationService.makePartitionFromId(dataset.getPartitioningSchema(), partitionId);
            if (allPartitions) {
                MetricsSettingsController.writeJSON((HttpServletResponse)resp, this.metricsLaunchService.launchComputeMetricsOnAllAndAllPartitions(user, dataset, this.buildMetricsEnvironment()));
            } else {
                MetricsSettingsController.writeJSON((HttpServletResponse)resp, this.metricsLaunchService.launchComputeMetrics(user, dataset, partition, new MetricsEngineDesc.MetricsEngineContext(user), this.buildMetricsEnvironment()));
            }
        }
    }

    @AuditedCall(value={"msgType", "dataset-compute-status", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/datasets/compute-column-metrics"})
    public void computeColumnOnDataset(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam String columnName, @RequestParam(required=false) String partitionId, @RequestParam boolean allPartitions) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            Dataset dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
            Partition partition = MetricsComputationService.makePartitionFromId(dataset.getPartitioningSchema(), partitionId);
            ProbesSet metrics = this.metricsService.subsetProbesForColumn(dataset, columnName);
            if (allPartitions) {
                MetricsSettingsController.writeJSON((HttpServletResponse)resp, this.metricsLaunchService.launchComputeMetricsOnAllAndAllPartitions(user, dataset, metrics, this.buildMetricsEnvironment()));
            } else {
                MetricsSettingsController.writeJSON((HttpServletResponse)resp, this.metricsLaunchService.launchComputeMetrics(user, dataset, partition, metrics, new MetricsEngineDesc.MetricsEngineContext(user), this.buildMetricsEnvironment()));
            }
        }
    }

    @AuditedCall(value={"msgType", "dataset-compute-status", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/datasets/compute-detailed-column-metrics"})
    public void computeDetailedColumnOnDataset(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam(required=false) String columnName, @RequestParam(value="statisticsConfig") String statisticsConfigStr, @RequestParam(required=false) String partitionId, @RequestParam(required=false, defaultValue="false") boolean forceRefresh) throws Exception {
        MetricsComputationService.MetricsComputationEnvironment metricsEnvironment;
        Dataset dataset;
        AuthCtx user;
        SerializedShakerScript.FullSampleStatisticsConfig statisticsConfig = (SerializedShakerScript.FullSampleStatisticsConfig)JSON.parse((String)statisticsConfigStr, SerializedShakerScript.FullSampleStatisticsConfig.class);
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
            metricsEnvironment = this.buildMetricsEnvironment();
        }
        if (StringUtils.isNotBlank((String)columnName) && dataset.getSchema().getColumn(columnName) == null) {
            throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_SCHEMA_TO_DATA_MISMATCH, "Column not found in the dataset schema, check case-sensitivity issues");
        }
        if (statisticsConfig.numberTopValues < 10 || statisticsConfig.numberTopValues > 100) {
            throw new Exception("The number of top values should be between 10 and 100");
        }
        MetricsSettingsController.writeJSON((HttpServletResponse)resp, this.metricsLaunchService.computeDetailedColumnMetrics_NT(columnName, partitionId, forceRefresh, dataset, user, metricsEnvironment, statisticsConfig));
    }

    @AuditedCall(value={"msgType", "folder-compute-status", "projectKey", "${projectKey}", "folderId", "${folderId}"})
    @RequestMapping(value={"/api/managedfolder/compute-metrics"})
    public void computeOnFolder(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String folderId, @RequestParam(required=false) String partitionId, @RequestParam boolean allPartitions) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            ManagedFolder folder = (ManagedFolder)this.managedFolderDAO.getMandatory(projectKey, folderId);
            Partition partition = MetricsComputationService.makePartitionFromId(folder.getPartitioningSchema(), partitionId);
            if (allPartitions) {
                MetricsSettingsController.writeJSON((HttpServletResponse)resp, this.metricsLaunchService.launchComputeMetricsOnAllAndAllPartitions(user, folder, this.buildMetricsEnvironment()));
            } else {
                MetricsSettingsController.writeJSON((HttpServletResponse)resp, this.metricsLaunchService.launchComputeMetrics(user, folder, partition, folder.metrics, new MetricsEngineDesc.MetricsEngineContext(user), this.buildMetricsEnvironment()));
            }
        }
    }

    @AuditedCall(value={"msgType", "dataset-compute-status", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/datasets/compute-probe"})
    public void computeProbeOnDataset(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam(required=false) String partitionId, @RequestParam boolean allPartitions, @RequestParam String data) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            Dataset dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
            Partition partition = MetricsComputationService.makePartitionFromId(dataset.getPartitioningSchema(), partitionId);
            ProbesSet metrics = (ProbesSet)JSON.parse((String)data, ProbesSet.class);
            if (allPartitions) {
                MetricsSettingsController.writeJSON((HttpServletResponse)resp, this.metricsLaunchService.launchComputeMetricsOnAllPartitions(user, dataset, metrics, this.buildMetricsEnvironment()));
            } else {
                MetricsSettingsController.writeJSON((HttpServletResponse)resp, this.metricsLaunchService.launchComputeMetrics(user, dataset, partition, metrics, new MetricsEngineDesc.MetricsEngineContext(user), this.buildMetricsEnvironment()));
            }
        }
    }

    @AuditedCall(value={"msgType", "folder-compute-status", "projectKey", "${projectKey}", "folderId", "${folderId}"})
    @RequestMapping(value={"/api/managedfolder/compute-probe"})
    public void computeProbeOnFolder(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String folderId, @RequestParam(required=false) String partitionId, @RequestParam boolean allPartitions, @RequestParam String data) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            ManagedFolder folder = (ManagedFolder)this.managedFolderDAO.getMandatory(projectKey, folderId);
            Partition partition = MetricsComputationService.makePartitionFromId(folder.getPartitioningSchema(), partitionId);
            ProbesSet metrics = (ProbesSet)JSON.parse((String)data, ProbesSet.class);
            if (allPartitions) {
                MetricsSettingsController.writeJSON((HttpServletResponse)resp, this.metricsLaunchService.launchComputeMetricsOnAllPartitions(user, folder, metrics, this.buildMetricsEnvironment()));
            } else {
                MetricsSettingsController.writeJSON((HttpServletResponse)resp, this.metricsLaunchService.launchComputeMetrics(user, folder, partition, metrics, new MetricsEngineDesc.MetricsEngineContext(user), this.buildMetricsEnvironment()));
            }
        }
    }

    @AuditedCall(value={"msgType", "dataset-compute-status", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/datasets/refresh-partition-list-metric"})
    public void refreshDatasetPartitions(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            Dataset dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
            ProbesSet metrics = new ProbesSet();
            Probe partitioningProbe = new Probe("partitioning");
            Probe basicProbe = new Probe("basic");
            metrics.probes.add(partitioningProbe);
            metrics.probes.add(basicProbe);
            PartitioningProbeType.PartitioningProbeConfiguration partitioningProbeConfiguration = new PartitioningProbeType.PartitioningProbeConfiguration();
            BasicProbeType.BasicProbeConfiguration basicProbeConfiguration = new BasicProbeType.BasicProbeConfiguration();
            partitioningProbe.withConfiguration(partitioningProbeConfiguration).withEnabled(true);
            basicProbe.withConfiguration(basicProbeConfiguration).withEnabled(true);
            MetricsSettingsController.writeJSON((HttpServletResponse)resp, this.metricsLaunchService.launchComputeMetrics(user, dataset, Partition.newALL((PartitioningScheme)dataset.getPartitioningSchema()), metrics, new MetricsEngineDesc.MetricsEngineContext(user), this.buildMetricsEnvironment()));
        }
    }

    @AuditedCall(value={"msgType", "folder-compute-status", "projectKey", "${projectKey}", "folderId", "${folderId}"})
    @RequestMapping(value={"/api/managedfolder/refresh-partition-list-metric"})
    public void refreshFolderPartitions(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String folderId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            ManagedFolder folder = (ManagedFolder)this.managedFolderDAO.getMandatory(projectKey, folderId);
            ProbesSet metrics = new ProbesSet();
            Probe partitioningProbe = new Probe("partitioning");
            Probe basicProbe = new Probe("basic");
            metrics.probes.add(partitioningProbe);
            metrics.probes.add(basicProbe);
            PartitioningProbeType.PartitioningProbeConfiguration partitioningProbeConfiguration = new PartitioningProbeType.PartitioningProbeConfiguration();
            BasicProbeType.BasicProbeConfiguration basicProbeConfiguration = new BasicProbeType.BasicProbeConfiguration();
            partitioningProbe.withConfiguration(partitioningProbeConfiguration).withEnabled(true);
            basicProbe.withConfiguration(basicProbeConfiguration).withEnabled(true);
            MetricsSettingsController.writeJSON((HttpServletResponse)resp, this.metricsLaunchService.launchComputeMetricsOnAllAndAllPartitions(user, folder, metrics, this.buildMetricsEnvironment()));
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/datasets/compute-plan"})
    public void computePlanOnDataset(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam String metricsData) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            Dataset dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
            ProbesSet metrics = (ProbesSet)JSON.parse((String)metricsData, ProbesSet.class);
            List<MetricsEngineRun> plan = this.metricsComputationService.computePlan(dataset.getProjectKey(), authCtx, dataset, MetricTargetType.DATASET, metrics);
            MetricsSettingsController.writeJSON((HttpServletResponse)resp, (Object)Lists.newArrayList((Iterable)Iterables.transform(plan, (Function)new Function<MetricsEngineRun, ComputedPlanRun>(){

                public ComputedPlanRun apply(MetricsEngineRun metricsEngineRun) {
                    return new ComputedPlanRun(metricsEngineRun);
                }
            })));
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/managedfolder/compute-plan"})
    public void computePlanOnFolder(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String folderId, @RequestParam String metricsData) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            ManagedFolder folder = (ManagedFolder)this.managedFolderDAO.getMandatory(projectKey, folderId);
            ProbesSet metrics = (ProbesSet)JSON.parse((String)metricsData, ProbesSet.class);
            List<MetricsEngineRun> plan = this.metricsComputationService.computePlan(folder.getProjectKey(), authCtx, folder, MetricTargetType.MANAGED_FOLDER, metrics);
            MetricsSettingsController.writeJSON((HttpServletResponse)resp, (Object)Lists.newArrayList((Iterable)Iterables.transform(plan, (Function)new Function<MetricsEngineRun, ComputedPlanRun>(){

                public ComputedPlanRun apply(MetricsEngineRun metricsEngineRun) {
                    return new ComputedPlanRun(metricsEngineRun);
                }
            })));
        }
    }

    @AuditedCall(value={"msgType", "object-create-metrics-dataset", "projectKey", "${projectKey}", "objectId", "${objectId}"})
    @RequestMapping(value={"/api/datasets/create-metrics-dataset"})
    public void createMetricsDataset(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String objectId, @RequestParam(required=false, defaultValue="METRICS_HISTORY") JobsdbDatasetParams.View view, @RequestParam(required=false, defaultValue="") String partition, @RequestParam(required=false, defaultValue="") String filter, @RequestParam ITaggingService.TaggableType taggableType) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            TaggableObjectsService.TaggableObject taggableObject;
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            String datasetNameSuffix = view == JobsdbDatasetParams.View.CHECKS_HISTORY || view == JobsdbDatasetParams.View.CHECKS_LAST ? "_checks" : "_metrics";
            switch (taggableType) {
                case MODEL_EVALUATION_STORE: {
                    taggableObject = this.modelEvaluationStoresCRUDService.getMandatoryUnsafe(projectKey, objectId);
                    break;
                }
                case SAVED_MODEL: {
                    taggableObject = (TaggableObjectsService.TaggableObject)this.savedModelsDAO.getMandatoryUnsafe(projectKey, objectId);
                    break;
                }
                case MANAGED_FOLDER: {
                    taggableObject = (TaggableObjectsService.TaggableObject)this.managedFolderDAO.getMandatoryUnsafe(projectKey, objectId);
                    break;
                }
                case DATASET: {
                    taggableObject = (TaggableObjectsService.TaggableObject)this.datasetsDAO.getMandatoryUnsafe(projectKey, objectId);
                    datasetNameSuffix = view == JobsdbDatasetParams.View.CHECKS_HISTORY || view == JobsdbDatasetParams.View.CHECKS_LAST ? "_rules" : "_metrics";
                    break;
                }
                case PROJECT: {
                    taggableObject = this.projectsDAO.getMandatoryUnsafe(projectKey);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Object type %s is not valid", new Object[]{taggableType}));
                }
            }
            String metricsDatasetName = this.datasetSaveService.transmogrifyName(projectKey, taggableObject.getDisplayName() + datasetNameSuffix);
            DatasetHandler.DatasetMeta<?, ?> datasetMeta = DatasetHandlerFactory.getMeta("JobsDB");
            Dataset dataset = new Dataset();
            dataset.setFullName(projectKey + "." + metricsDatasetName);
            datasetMeta.fillManagedDatasetParams(dataset, null, null);
            dataset.setSchema(JobsdbDatasetHandler.getSchema(JobsdbDatasetParams.RetrievalScope.SINGLE_OBJECT, view));
            JobsdbDatasetParams params = dataset.getParamsAs(JobsdbDatasetParams.class);
            params.view = view;
            params.scope = JobsdbDatasetParams.RetrievalScope.SINGLE_OBJECT;
            params.smartName = objectId;
            params.partition = partition;
            params.filter = filter;
            DatasetSaveService.DatasetCreationContext dsCtx = DatasetSaveService.DatasetCreationContext.buildDefault();
            String zoneId = this.flowZonesService.retrieveZone(projectKey, taggableObject);
            dsCtx.setZoneId(zoneId);
            MetricsSettingsController.writeJSON((HttpServletResponse)resp, this.datasetSaveService.create(projectKey, dataset.serialize(), dsCtx, user));
            t.commit("Added dataset to view " + view.name() + " of " + projectKey + "." + objectId);
        }
    }

    @AuditedCall(value={"msgType", "folder-compute-status", "projectKey", "${projectKey}", "folderId", "${folderId}"})
    @RequestMapping(value={"/api/managedfolder/run-check"})
    public void runMFCheck(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String folderId, @RequestParam(required=false) String partitionId, @RequestParam boolean allPartitions, @RequestParam String data) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            ManagedFolder mf = (ManagedFolder)this.managedFolderDAO.getMandatory(projectKey, folderId);
            ChecksSet checks = (ChecksSet)JSON.parse((String)data, ChecksSet.class);
            Partition partition = MetricsComputationService.makePartitionFromId(mf.getPartitioningSchema(), partitionId);
            if (allPartitions) {
                MetricsSettingsController.writeJSON((HttpServletResponse)resp, this.metricsLaunchService.launchRunChecksOnAllPartitions(user, mf, checks, this.buildMetricsEnvironment(), (DataQualityRunOrigin)new DataQualityRunOrigin.Test()));
            } else {
                MetricsSettingsController.writeJSON((HttpServletResponse)resp, this.metricsLaunchService.launchRunChecks(user, mf, partition, checks, this.buildMetricsEnvironment(), (DataQualityRunOrigin)new DataQualityRunOrigin.Test()));
            }
        }
    }

    @AuditedCall(value={"msgType", "model-compute-status", "projectKey", "${projectKey}", "modelId", "${modelId}"})
    @RequestMapping(value={"/api/savedmodels/run-check"})
    public void runSMCheck(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String modelId, @RequestParam String data) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            SavedModel sm = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(projectKey, modelId);
            ChecksSet checks = (ChecksSet)JSON.parse((String)data, ChecksSet.class);
            MetricsSettingsController.writeJSON((HttpServletResponse)resp, this.metricsLaunchService.launchRunChecksOnSMVersion(user, sm, sm.activeVersion, checks, this.buildMetricsEnvironment(), new DataQualityRunOrigin.Test()));
        }
    }

    @AuditedCall(value={"msgType", "modelevaluationstore-compute-status", "projectKey", "${projectKey}", "mesId", "${mesId}"})
    @RequestMapping(value={"/api/modelevaluationstores/run-check"})
    public void runMECheck(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String mesId, @RequestParam(required=false) String evaluationId, @RequestParam boolean allRuns, @RequestParam String data) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            ChecksSet checks = (ChecksSet)JSON.parse((String)data, ChecksSet.class);
            ModelEvaluationStore mes = this.modelEvaluationStoresCRUDService.getMandatoryUnsafe(projectKey, mesId);
            if (allRuns) {
                MetricsSettingsController.writeJSON((HttpServletResponse)resp, this.metricsLaunchService.launchRunChecksOnAllPartitions(user, mes, checks, this.buildMetricsEnvironment(), (DataQualityRunOrigin)new DataQualityRunOrigin.Test()));
            } else {
                if (StringUtils.isEmpty((String)evaluationId)) {
                    evaluationId = this.modelEvaluationStoresCRUDService.getLatestEvaluationId(projectKey, mesId);
                }
                MetricsSettingsController.writeJSON((HttpServletResponse)resp, this.metricsLaunchService.launchRunChecks(user, mes, evaluationId, checks, this.buildMetricsEnvironment(), (DataQualityRunOrigin)new DataQualityRunOrigin.Test()));
            }
        }
    }

    @AuditedCall(value={"msgType", "folder-compute-status", "projectKey", "${projectKey}", "folderId", "${folderId}"})
    @RequestMapping(value={"/api/managedfolder/run-checks"})
    public void runMFChecks(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String folderId, @RequestParam(required=false) String partitionId, @RequestParam boolean allPartitions) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            ManagedFolder mf = (ManagedFolder)this.managedFolderDAO.getMandatory(projectKey, folderId);
            Partition partition = MetricsComputationService.makePartitionFromId(mf.getPartitioningSchema(), partitionId);
            if (allPartitions) {
                MetricsSettingsController.writeJSON((HttpServletResponse)resp, this.metricsLaunchService.launchRunChecksOnAllPartitions(user, mf, this.buildMetricsEnvironment(), (DataQualityRunOrigin)new DataQualityRunOrigin.Manual()));
            } else {
                MetricsSettingsController.writeJSON((HttpServletResponse)resp, this.metricsLaunchService.launchRunChecks(user, mf, partition, this.buildMetricsEnvironment(), (DataQualityRunOrigin)new DataQualityRunOrigin.Manual()));
            }
        }
    }

    @AuditedCall(value={"msgType", "model-compute-status", "projectKey", "${projectKey}", "modelId", "${modelId}"})
    @RequestMapping(value={"/api/savedmodels/run-checks"})
    public void runSMChecks(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String modelId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            SavedModel sm = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(projectKey, modelId);
            MetricsSettingsController.writeJSON((HttpServletResponse)resp, this.metricsLaunchService.launchRunChecksOnSMVersion(user, sm, sm.activeVersion, this.buildMetricsEnvironment(), new DataQualityRunOrigin.Manual()));
        }
    }

    @AuditedCall(value={"msgType", "modelevaluationstore-compute-status", "projectKey", "${projectKey}", "mesId", "${mesId}"})
    @RequestMapping(value={"/api/modelevaluationstores/run-checks"})
    public void runMESChecks(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String mesId, @RequestParam(required=false) String evaluationId, @RequestParam boolean allRuns) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            ModelEvaluationStore mes = this.modelEvaluationStoresCRUDService.getMandatory(projectKey, mesId);
            if (allRuns) {
                MetricsSettingsController.writeJSON((HttpServletResponse)resp, this.metricsLaunchService.launchRunChecksOnAllPartitions(user, mes, this.buildMetricsEnvironment(), (DataQualityRunOrigin)new DataQualityRunOrigin.Manual()));
            } else {
                if (StringUtils.isEmpty((String)evaluationId)) {
                    evaluationId = this.modelEvaluationStoresCRUDService.getLatestEvaluationId(projectKey, mesId);
                }
                MetricsSettingsController.writeJSON((HttpServletResponse)resp, this.metricsLaunchService.launchRunChecks(user, mes, evaluationId, this.buildMetricsEnvironment(), (DataQualityRunOrigin)new DataQualityRunOrigin.Manual()));
            }
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/datasets/get-hint"})
    public void listComputedChecksOnDataset(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam String data) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            Dataset dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
            Probe probe = (Probe)JSON.parse((String)data, Probe.class);
            MetricsSettingsController.writeJSON((HttpServletResponse)resp, (Object)this.metricsService.getHint(dataset, MetricTargetType.DATASET, probe));
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/managedfolder/get-hint"})
    public void listComputedChecksOnMF(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String folderId, @RequestParam String data) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            ManagedFolder folder = (ManagedFolder)this.managedFolderDAO.getMandatory(projectKey, folderId);
            Probe probe = (Probe)JSON.parse((String)data, Probe.class);
            MetricsSettingsController.writeJSON((HttpServletResponse)resp, (Object)this.metricsService.getHint(folder, MetricTargetType.MANAGED_FOLDER, probe));
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/savedmodels/get-hint"})
    public void listComputedChecksOnSM(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String modelId, @RequestParam String data) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            SavedModel sm = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(projectKey, modelId);
            Probe probe = (Probe)JSON.parse((String)data, Probe.class);
            MetricsSettingsController.writeJSON((HttpServletResponse)resp, (Object)this.metricsService.getHint(sm, MetricTargetType.SAVED_MODEL, probe));
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/modelevaluationstores/get-hint"})
    public void listComputedChecksOnMES(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String mesId, @RequestParam String data) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            Probe probe = (Probe)JSON.parse((String)data, Probe.class);
            ModelEvaluationStore mes = this.modelEvaluationStoresCRUDService.getMandatory(projectKey, mesId);
            MetricsSettingsController.writeJSON((HttpServletResponse)resp, (Object)this.metricsService.getHint(mes, MetricTargetType.MODEL_EVALUATION_STORE, probe));
        }
    }

    @AuditedCall(value={"msgType", "dataset-clear-status", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/datasets/clear-metrics"})
    public void clearMetricsOnDataset(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam(required=false) String partition) throws Exception {
        Dataset dataset;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
        }
        this.metricsService.clearMetrics(dataset, partition);
    }

    @AuditedCall(value={"msgType", "folder-clear-status", "projectKey", "${projectKey}", "folderId", "${folderId}"})
    @RequestMapping(value={"/api/managedfolder/clear-metrics"})
    public void clearMetricsOnFolder(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String folderId) throws Exception {
        ManagedFolder folder;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            folder = (ManagedFolder)this.managedFolderDAO.getMandatory(projectKey, folderId);
        }
        this.metricsService.clearMetrics(folder, null);
    }

    @AuditedCall(value={"msgType", "model-clear-status", "projectKey", "${projectKey}", "modelId", "${modelId}"})
    @RequestMapping(value={"/api/savedmodels/clear-metrics"})
    public void clearMetricsOnSM(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String modelId, @RequestParam(required=false) String partition) throws Exception {
        SavedModel model;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            model = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(projectKey, modelId);
        }
        this.metricsService.clearMetrics(model, partition);
    }

    @AuditedCall(value={"msgType", "model-clear-status", "projectKey", "${projectKey}", "mesId", "${mesId}"})
    @RequestMapping(value={"/api/modelevaluationstores/clear-metrics"})
    public void clearMetricsOnMES(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String mesId, @RequestParam(required=false) String partition) throws Exception {
        ModelEvaluationStore mes;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            mes = this.modelEvaluationStoresCRUDService.getMandatoryUnsafe(projectKey, mesId);
        }
        this.metricsService.clearMetrics(mes, partition);
    }

    @AuditedCall(value={"msgType", "project-clear-status", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/clear-metrics"})
    public void clearMetricsOnProject(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        SerializedProject model;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            model = this.projectsDAO.getMandatoryUnsafe(projectKey);
        }
        this.metricsService.clearMetrics(model);
    }

    public static class ComputedPlanRun {
        public final String engineType;
        public final List<ComputedPlanComputation> computations;
        public final double cost;

        ComputedPlanRun(MetricsEngineRun metricsEngineRun) {
            this.engineType = metricsEngineRun.engineType;
            this.cost = metricsEngineRun.cost;
            this.computations = Lists.newArrayList((Iterable)Iterables.transform(metricsEngineRun.getComputations(), (Function)new Function<MetricComputation, ComputedPlanComputation>(){

                public ComputedPlanComputation apply(MetricComputation metricComputation) {
                    return new ComputedPlanComputation(metricComputation);
                }
            }));
        }
    }

    public static class ComputedPlanComputation {
        public final Metric metric;
        public final MetricMetadata meta;
        public final double cost;

        ComputedPlanComputation(MetricComputation metricComputation) {
            this.metric = metricComputation.metric;
            this.meta = metricComputation.metric.getMeta();
            this.cost = metricComputation.cost;
        }
    }
}

