/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.common;

import com.dataiku.dip.connections.ConnectionWithAzureAuthCredentials;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithGoogleAuthCredentials;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.GoogleCredentialCache;
import com.dataiku.dip.connections.IcebergConnection;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.auth.AuthCtxUsage;
import com.dataiku.dip.security.auth.TicketAuthService;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.AccessToken;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenRequestContext;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class ConnectionsIntercomControllerBase
extends DIPInternalControllerBase {
    @Autowired
    protected ConnectionsDAO connectionsDAO;
    @Autowired
    protected TransactionService transactionService;
    @Autowired
    protected TicketAuthService authService;
    @Autowired
    protected PasswordEncryptionService cryptoService;

    protected abstract boolean isAuthenticationValid(AuthCtx var1, DSSConnection var2, HttpServletRequest var3) throws IOException;

    protected abstract AuthCtxUsage getAuthCtxUsage(HttpServletRequest var1) throws IOException, DKUSecurityException;

    public void getFullyResolvedCredentials(HttpServletRequest req, HttpServletResponse resp, String name, String projectKey, boolean useTokenCache) throws Exception {
        try (AuthCtxUsage tu = this.getAuthCtxUsage(req);){
            DSSConnection conn;
            try (Transaction t = this.transactionService.beginRead();){
                conn = this.connectionsDAO.getMandatoryConnection(tu.getAuthCtx(), name);
            }
            if (!this.isAuthenticationValid(tu.getAuthCtx(), conn, req)) {
                throw new UnauthorizedException("You may not read details of connection " + name, "connection-details-denied");
            }
            ConnectionsIntercomControllerBase.writeJSON((HttpServletResponse)resp, (Object)conn.getFullyResolvedCredentials(new ConnectionWithBasicCredential.CredentialResolutionContext(tu.getAuthCtx(), projectKey).withUseTokenCache(useTokenCache), Object.class));
        }
    }

    public void refreshGoogleDefaultCredentialAccessToken(HttpServletRequest req, HttpServletResponse resp, String name) throws Exception {
        try (AuthCtxUsage tu = this.getAuthCtxUsage(req);){
            DSSConnection conn;
            try (Transaction t = this.transactionService.beginRead();){
                conn = this.connectionsDAO.getMandatoryConnection(tu.getAuthCtx(), name);
            }
            if (!this.isAuthenticationValid(tu.getAuthCtx(), conn, req)) {
                throw new UnauthorizedException("You may not read details of connection " + name, "connection-details-denied");
            }
            if (!(conn instanceof ConnectionWithGoogleAuthCredentials)) {
                throw new UnauthorizedException("You may not refresh details of connection " + name, "connection-details-denied");
            }
            if (((ConnectionWithGoogleAuthCredentials)((Object)conn)).getGoogleAuth2NonResolvedParams().getAuthType() != ConnectionWithGoogleAuthCredentials.AuthType.ENVIRONMENT) {
                throw new UnauthorizedException("Connection " + name + " is not using default credentials", "connection-details-denied");
            }
            ConnectionsIntercomControllerBase.writeJSON((HttpServletResponse)resp, (Object)GoogleCredentialCache.getTokenFromMetadataServer());
        }
    }

    public void refreshAccessTokenForIceberg(HttpServletRequest req, HttpServletResponse resp, String name, String projectKey, boolean useTokenCache, String onBehalf) throws Exception {
        try (AuthCtxUsage tu = this.getAuthCtxUsage(req);){
            DSSConnection onBehalfConn;
            DSSConnection conn;
            try (Transaction t = this.transactionService.beginRead();){
                conn = this.connectionsDAO.getMandatoryConnection(tu.getAuthCtx(), name);
                onBehalfConn = this.connectionsDAO.getMandatoryConnection(tu.getAuthCtx(), onBehalf);
            }
            if (!this.isAuthenticationValid(tu.getAuthCtx(), conn, req)) {
                throw new UnauthorizedException("You may not read details of connection " + name, "connection-details-denied");
            }
            if (!(onBehalfConn instanceof IcebergConnection)) {
                throw new DKUSecurityException("Unexpected connection to fetch credentials on behalf of: " + onBehalfConn.getClass().getCanonicalName());
            }
            Object rawCreds = conn.getFullyResolvedCredentials(new ConnectionWithBasicCredential.CredentialResolutionContext(tu.getAuthCtx(), projectKey).withUseTokenCache(useTokenCache), Object.class);
            JsonObject icebergCreds = ((IcebergConnection)onBehalfConn).makeLoadCredentialsResponse(tu.getAuthCtx(), projectKey, rawCreds, conn);
            ConnectionsIntercomControllerBase.writeJSON((HttpServletResponse)resp, (Object)icebergCreds);
        }
    }

    public void refreshAzureDefaultCredentialAccessToken(HttpServletRequest req, HttpServletResponse resp, String name, String claims, List<String> scopes, String tenantId) throws Exception {
        try (AuthCtxUsage tu = this.getAuthCtxUsage(req);){
            DSSConnection conn;
            try (Transaction t = this.transactionService.beginRead();){
                conn = this.connectionsDAO.getMandatoryConnection(tu.getAuthCtx(), name);
            }
            if (!this.isAuthenticationValid(tu.getAuthCtx(), conn, req)) {
                throw new UnauthorizedException("You may not read details of connection " + name, "connection-details-denied");
            }
            if (!(conn instanceof ConnectionWithAzureAuthCredentials)) {
                throw new UnauthorizedException("You may not refresh details of connection " + name, "connection-details-denied");
            }
            if (((ConnectionWithAzureAuthCredentials)((Object)conn)).getAzureAuth2NonResolvedParams().getAuthType() != ConnectionWithAzureAuthCredentials.AuthType.ENVIRONMENT) {
                throw new UnauthorizedException("Connection " + name + " is not using default credentials", "connection-details-denied");
            }
            TokenRequestContext requestCtx = new TokenRequestContext();
            requestCtx.setClaims(claims);
            requestCtx.setScopes(scopes);
            requestCtx.setTenantId(tenantId);
            AccessToken accessToken = ConnectionWithAzureAuthCredentials.getDefaultAzureCredential(conn.getProxySettings()).getTokenSync(requestCtx);
            ConnectionWithAzureAuthCredentials.SerializableAzureAuthCredentials creds = ConnectionWithAzureAuthCredentials.SerializableAzureAuthCredentials.fromEnvironmentToken(accessToken);
            ConnectionsIntercomControllerBase.writeJSON((HttpServletResponse)resp, (Object)creds);
        }
    }

    public void getPrivateKeyLastModified(HttpServletRequest req, HttpServletResponse resp, String name) throws Exception {
        try (AuthCtxUsage tu = this.getAuthCtxUsage(req);){
            File currentKey;
            DSSConnection conn;
            try (Transaction t = this.transactionService.beginRead();){
                conn = this.connectionsDAO.getMandatoryConnection(tu.getAuthCtx(), name);
            }
            if (!this.isAuthenticationValid(tu.getAuthCtx(), conn, req)) {
                throw new UnauthorizedException("You may not read details of connection " + name, "connection-details-denied");
            }
            if (!(conn instanceof ConnectionWithGoogleAuthCredentials)) {
                throw new UnauthorizedException("You may not refresh details of connection " + name, "connection-details-denied");
            }
            if (((ConnectionWithGoogleAuthCredentials)((Object)conn)).getGoogleAuth2NonResolvedParams().getAuthType() == ConnectionWithGoogleAuthCredentials.AuthType.OAUTH) {
                throw new UnauthorizedException("Connection " + name + " cannot be using a private key", "connection-details-denied");
            }
            String currentKeyPath = ((ConnectionWithGoogleAuthCredentials)((Object)conn)).getPrivateKeyPathOrNull();
            long lastModified = StringUtils.isBlank((String)currentKeyPath) ? 0L : ((currentKey = new File(currentKeyPath)).exists() ? currentKey.lastModified() : 0L);
            ConnectionsIntercomControllerBase.writeJSON((HttpServletResponse)resp, (Object)lastModified);
        }
    }
}

