/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.p;

import com.dataiku.dip.llm.governance.forbiddenterms.ForbiddenTermsDetectionGuardrail;
import com.dataiku.dip.llm.governance.forbiddenterms.IForbiddenTermsService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.AuthCtxCreationService;
import com.dataiku.dip.security.auth.SharedSecretAuthService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.utils.JSON;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ForbiddenTermsPrivilegedIntercomController
extends DIPInternalControllerBase {
    @Autowired
    private SharedSecretAuthService authService;
    @Autowired
    private IForbiddenTermsService forbiddenTermsService;
    @Autowired
    private AuthCtxCreationService authCtxCreationService;

    @AuditNotNeeded
    @ResponseBody
    @RequestMapping(value={"/api/pintercom/llm-forbidden-terms/get"})
    public Set<String> get(HttpServletRequest req, @RequestParam String settings, @RequestParam String authCtxIdentifier) throws Exception {
        this.authService.failIfNoSharedSecret(req);
        ForbiddenTermsDetectionGuardrail.Params forbiddenTermSettings = (ForbiddenTermsDetectionGuardrail.Params)JSON.parse((String)settings, ForbiddenTermsDetectionGuardrail.Params.class);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Received a forbidden terms request: " + JSON.log((Object)forbiddenTermSettings)));
        }
        AuthCtx counterpartAuthCtx = this.authCtxCreationService.create_autoTxn(authCtxIdentifier);
        return this.forbiddenTermsService.getForbiddenTerms_NoCheck(counterpartAuthCtx, forbiddenTermSettings);
    }
}

