/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.emails;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.BasePermissions;
import com.dataiku.dip.server.notifications.backend.WorkspaceInvitationChangedEvent;
import com.dataiku.dip.server.notifications.backend.WorkspaceInvitationEmailSentEvent;
import com.dataiku.dip.server.notifications.emails.AbstractInviteEmailSendService;
import com.dataiku.dip.server.notifications.emails.WorkspaceInvitationEmailBuilder;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.workspaces.Workspace;
import com.dataiku.dip.workspaces.WorkspacesService;
import java.io.IOException;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkspaceInviteEmailSendService
extends AbstractInviteEmailSendService {
    @Autowired
    private WorkspacesService workspacesService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private PubSubService pubSubService;
    private static final Logger logger = Logger.getLogger((String)"dku.notifications.access.invited");

    @PostConstruct
    public void init() {
        logger.debug((Object)"Init workspace invitation email service");
        this.pubSubService.subscribe("workspace-invitation-changed", evt -> {
            if (!evt.getAction().equals((Object)WorkspaceInvitationChangedEvent.ActionType.CREATED)) {
                return;
            }
            GeneralSettingsDAO.GeneralSettings generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
            if (!GeneralSettingsService.arePermissionsByEmailEnabled(generalSettings)) {
                return;
            }
            AbstractInviteEmailSendService.InvitationEmailSendResult result = new AbstractInviteEmailSendService.InvitationEmailSendResult();
            for (String email : evt.getEmails()) {
                this.sendInviteEmails(result, evt.getWorkspaceKey(), email, evt.getUserLogin(), generalSettings);
            }
            if (!result.isEmpty()) {
                String triggeredByUser = evt.getUserLogin();
                try (RWTransaction rwt = this.transactionService.beginWriteAsDSS();){
                    this.updateEmailStatusesAndSaveWorkspace(evt.getWorkspaceKey(), triggeredByUser, result);
                    rwt.commit("Sent workspace invitation emails");
                }
            }
        });
        logger.debug((Object)"Done init workspace invitation email service");
    }

    public void updateEmailStatusesAndSaveWorkspace(String workspaceKey, String triggeredByUser, AbstractInviteEmailSendService.InvitationEmailSendResult result) throws IOException, DKUSecurityException {
        boolean anyChange = false;
        RWTransactionRef t = TransactionContext.retrieveWrite();
        Workspace workspace = this.workspacesService.getMandatoryWorkspace(workspaceKey);
        for (BasePermissions.PermissionItem permission : workspace.permissions) {
            if (permission == null || permission.pendingUserEmail == null) continue;
            if (result.sentEmails.stream().anyMatch(sentEmail -> sentEmail != null && sentEmail.equalsIgnoreCase(permission.pendingUserEmail))) {
                anyChange |= !AbstractInviteEmailSendService.InvitationEmailStatus.SENT.equals((Object)permission.invitationEmailStatus);
                permission.invitationEmailStatus = AbstractInviteEmailSendService.InvitationEmailStatus.SENT;
                continue;
            }
            if (!result.failedEmails.stream().anyMatch(failedEmail -> failedEmail != null && failedEmail.equalsIgnoreCase(permission.pendingUserEmail))) continue;
            anyChange |= !AbstractInviteEmailSendService.InvitationEmailStatus.FAILED.equals((Object)permission.invitationEmailStatus);
            permission.invitationEmailStatus = AbstractInviteEmailSendService.InvitationEmailStatus.FAILED;
        }
        if (anyChange) {
            this.workspacesService.saveAndCheckPermissions(t.getUser(), workspace);
        }
        this.pubSubService.publishAfterTransaction(new WorkspaceInvitationEmailSentEvent(triggeredByUser, workspaceKey, result));
    }

    @Override
    public Future<InfoMessage.InfoMessages> sendInviteEmail(GeneralSettingsDAO.GeneralSettings generalSettings, String email, String workspaceKey, @Nullable String senderLogin) throws Exception {
        logger.info((Object)("Sending workspace invitation email to " + email));
        WorkspaceInvitationEmailBuilder emailBuilder = new WorkspaceInvitationEmailBuilder(workspaceKey);
        return emailBuilder.sendToUser(generalSettings, email, senderLogin);
    }
}

