/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.recipes;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.StreamingEndpointsDAO;
import com.dataiku.dip.dataflow.exec.sql.SQLQueryRecipeMeta;
import com.dataiku.dip.dataflow.exec.sql.SQLScriptRecipeMeta;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.recipes.code.hive.HiveRecipeMeta;
import com.dataiku.dip.recipes.code.impala.ImpalaRecipeMeta;
import com.dataiku.dip.recipes.code.sparksql.SparkSQLQueryRecipeMeta;
import com.dataiku.dip.recipes.streaming.ksql.KsqlRecipeMeta;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.sql.HiveSQLDialect;
import com.dataiku.dip.sql.ImpalaSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.SparkSQLDialect;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class InsertableFragmentsComputer {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.fragmentscomputer");
    private final AuthCtx authCtx;
    private final String projectKey;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private StreamingEndpointsDAO streamingEndpointsDAO;
    @Autowired
    private ProjectsService projectsService;

    public InsertableFragmentsComputer(String projectKey, AuthCtx authCtx) {
        this.authCtx = authCtx;
        this.projectKey = projectKey;
        SpringUtils.getInstance().autowire((Object)this);
    }

    private DatasetFragments computeInsertableSQLFragments(Dataset dataset) throws IOException, DKUSecurityException {
        String datasetConnection = DatasetInspector.getSQLConnectionNameForSQLAbleDatasetOrHive(this.authCtx, dataset);
        if (datasetConnection == null) {
            return null;
        }
        DSSConnection connection = ConnectionsDAO.get().getConnection(this.authCtx, datasetConnection);
        if (!(connection instanceof AbstractSQLConnection)) {
            return null;
        }
        SQLDialect dialect = ((AbstractSQLConnection)connection).getDialect();
        if (DatasetInspector.isSQLQuery(dataset.getModel())) {
            String tableName = "${tbl:" + dataset.getName() + "}";
            return this.computeGenericSQLFragments(dataset, tableName, dialect);
        }
        SQLUtils.SQLTable table = DatasetUtils.getResolvedTable(dataset, dialect, true, false);
        return this.computeGenericSQLFragments(dataset, table, dialect);
    }

    private DatasetFragments computeInsertableSparkSQLFragments(Dataset dataset, SparkSQLQueryRecipeMeta.SparkSQLQueryRecipeParams params) throws IOException {
        SQLUtils.SQLTable table = DatasetInspector.isMetastoreAssociatedType(dataset) || DatasetInspector.isHiveTable(dataset) ? DatasetUtils.getResolvedTable(dataset, (SQLDialect)new SparkSQLDialect(), params.useGlobalMetastore, true) : new SQLUtils.SQLTable(null, null, dataset.getName());
        return this.computeGenericSQLFragments(dataset, table, (SQLDialect)new SparkSQLDialect());
    }

    private DatasetFragments computeInsertableHiveFragments(Dataset dataset, HiveRecipeMeta.HiveRecipeParams params) throws IOException {
        if (DatasetInspector.isHiveQuery(dataset)) {
            String tableName = "${tbl:" + dataset.getName() + "}";
            return this.computeGenericSQLFragments(dataset, tableName, (SQLDialect)new HiveSQLDialect());
        }
        if (DatasetInspector.isHDFSDatasetWithAssociatedHiveTableOrIsHiveTableDataset(dataset)) {
            boolean useLocalMetastore = params.executionEngine == HiveRecipeMeta.HiveExecutionEngine.HIVECLI_LOCAL;
            SQLUtils.SQLTable table = DatasetUtils.getResolvedTable(dataset, (SQLDialect)new HiveSQLDialect(), !useLocalMetastore, false);
            return this.computeGenericSQLFragments(dataset, table, (SQLDialect)new HiveSQLDialect());
        }
        return null;
    }

    private DatasetFragments computeInsertableImpalaFragments(Dataset dataset) throws IOException {
        if (DatasetInspector.isHDFSDatasetWithAssociatedHiveTableOrIsHiveTableDataset(dataset)) {
            SQLUtils.SQLTable table = DatasetUtils.getResolvedTable(dataset, (SQLDialect)new ImpalaSQLDialect(), true, false);
            return this.computeGenericSQLFragments(dataset, table, (SQLDialect)new ImpalaSQLDialect());
        }
        return null;
    }

    private DatasetFragments computeInsertableKsqlFragments(StreamingEndpoint streamingEndpoint, KsqlRecipeMeta.KsqlRecipeParams params) throws IOException {
        DatasetFragments icf = new DatasetFragments();
        icf.datasetRef = "`" + streamingEndpoint.id + "`";
        for (SchemaColumn column : streamingEndpoint.schema.getColumns()) {
            icf.columnRefs.put(column.getName(), "`" + column.getName() + "`");
        }
        return icf;
    }

    public InsertableFragments computeInsertableCodeFragments(SerializedRecipe recipe) throws IOException, DKUSecurityException {
        StreamingEndpoint se;
        SerializedDataset sd;
        DatasetLocUtils.DatasetLoc datasetLoc;
        InsertableFragments fragments = new InsertableFragments();
        for (SerializedRecipe.RecipeInput input : recipe.getFlatInputs()) {
            datasetLoc = input.getLoc(this.projectKey).toDatasetLoc();
            this.projectsService.failIfNoTaggableTypeReadUseAccessWithUnknownType(this.authCtx, datasetLoc, recipe.projectKey);
            sd = (SerializedDataset)this.datasetsDAO.getOrNull(datasetLoc);
            se = (StreamingEndpoint)this.streamingEndpointsDAO.getOrNull(datasetLoc);
            if (sd != null) {
                fragments.inputs.put(sd.name, this.computeInsertableCodeFragments(Dataset.fromSerialized(sd), recipe.params));
                continue;
            }
            if (se == null) continue;
            fragments.inputs.put(se.id, this.computeInsertableCodeFragments(se, recipe.params));
        }
        for (SerializedRecipe.RecipeOutput output : recipe.getFlatOutputs()) {
            datasetLoc = output.getLoc(this.projectKey).toDatasetLoc();
            this.projectsService.failIfNoTaggableTypeReadUseAccessWithUnknownType(this.authCtx, datasetLoc, recipe.projectKey);
            sd = (SerializedDataset)this.datasetsDAO.getOrNull(datasetLoc);
            se = (StreamingEndpoint)this.streamingEndpointsDAO.getOrNull(datasetLoc);
            if (sd != null) {
                fragments.outputs.put(sd.name, this.computeInsertableCodeFragments(Dataset.fromSerialized(sd), recipe.params));
                continue;
            }
            if (se == null) continue;
            fragments.outputs.put(se.id, this.computeInsertableCodeFragments(se, recipe.params));
        }
        return fragments;
    }

    private DatasetFragments computeInsertableCodeFragments(Dataset dataset, RecipeParams params) {
        DatasetFragments icf = null;
        try {
            if (params instanceof SparkSQLQueryRecipeMeta.SparkSQLQueryRecipeParams) {
                icf = this.computeInsertableSparkSQLFragments(dataset, (SparkSQLQueryRecipeMeta.SparkSQLQueryRecipeParams)params);
            } else if (params instanceof HiveRecipeMeta.HiveRecipeParams) {
                icf = this.computeInsertableHiveFragments(dataset, (HiveRecipeMeta.HiveRecipeParams)params);
            } else if (params instanceof ImpalaRecipeMeta.ImpalaRecipeParams) {
                icf = this.computeInsertableImpalaFragments(dataset);
            } else if (params instanceof SQLQueryRecipeMeta.SQLQueryRecipeParams || params instanceof SQLScriptRecipeMeta.SQLScriptRecipeParams) {
                icf = this.computeInsertableSQLFragments(dataset);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unexpected error while building insertable code fragments for dataset " + dataset.getFullName()), (Throwable)e);
        }
        if (icf == null) {
            icf = this.computeGenericFragments(dataset);
        }
        return icf;
    }

    private DatasetFragments computeInsertableCodeFragments(StreamingEndpoint streamingEndpoint, RecipeParams params) {
        DatasetFragments icf = null;
        try {
            if (params instanceof KsqlRecipeMeta.KsqlRecipeParams) {
                icf = this.computeInsertableKsqlFragments(streamingEndpoint, (KsqlRecipeMeta.KsqlRecipeParams)params);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unexpected error while building insertable code fragments for streaming endpoint " + streamingEndpoint.getFullId()), (Throwable)e);
        }
        if (icf == null) {
            icf = this.computeGenericFragments(streamingEndpoint);
        }
        return icf;
    }

    private DatasetFragments computeGenericFragments(Dataset dataset) {
        DatasetFragments icf = new DatasetFragments();
        icf.datasetRef = "\"" + dataset.getName() + "\"";
        for (SchemaColumn column : dataset.getSchema().getColumns()) {
            icf.columnRefs.put(column.getName(), "\"" + column.getName() + "\"");
        }
        return icf;
    }

    private DatasetFragments computeGenericFragments(StreamingEndpoint streamingEndpoint) {
        DatasetFragments icf = new DatasetFragments();
        icf.datasetRef = "\"" + streamingEndpoint.id + "\"";
        for (SchemaColumn column : streamingEndpoint.schema.getColumns()) {
            icf.columnRefs.put(column.getName(), "\"" + column.getName() + "\"");
        }
        return icf;
    }

    private DatasetFragments computeGenericSQLFragments(Dataset dataset, String tableName, SQLDialect dialect) {
        DatasetFragments icf = new DatasetFragments();
        icf.datasetRef = tableName;
        for (SchemaColumn column : dataset.getSchema().getColumns()) {
            icf.columnRefs.put(column.getName(), dialect.quoteIdentifier(column.getName()));
        }
        return icf;
    }

    private DatasetFragments computeGenericSQLFragments(Dataset dataset, SQLUtils.SQLTable table, SQLDialect dialect) {
        return this.computeGenericSQLFragments(dataset, dialect.getQuotedTableFullName(table), dialect);
    }

    public static class DatasetFragments {
        String datasetRef;
        Map<String, String> columnRefs = new HashMap<String, String>();
    }

    public static class InsertableFragments {
        Map<String, DatasetFragments> inputs = new HashMap<String, DatasetFragments>();
        Map<String, DatasetFragments> outputs = new HashMap<String, DatasetFragments>();
    }
}

