/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.recipes;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.llm.EnrichedLLMStructuredRef;
import com.dataiku.dip.llm.LLMRefEnricherService;
import com.dataiku.dip.llm.PromptDef;
import com.dataiku.dip.recipes.nlp.classification.model_provided.NLPLLMModelProvidedClassificationRecipePayloadParams;
import com.dataiku.dip.recipes.nlp.classification.model_provided.NLPLLMModelProvidedClassificationRecipeRunner;
import com.dataiku.dip.recipes.nlp.classification.user_provided.NLPLLMUserProvidedClassificationRecipePayloadParams;
import com.dataiku.dip.recipes.nlp.classification.user_provided.NLPLLMUserProvidedClassificationRecipeRunner;
import com.dataiku.dip.recipes.nlp.common.NLPRecipePayloadParams;
import com.dataiku.dip.recipes.nlp.prompt.PromptRecipePayloadParams;
import com.dataiku.dip.recipes.nlp.prompt.RawQueryOutputMode;
import com.dataiku.dip.recipes.nlp.prompt.RawResponseOutputMode;
import com.dataiku.dip.recipes.nlp.summarization.SummarizationRecipePayloadParams;
import com.dataiku.dip.recipes.nlp.summarization.SummarizationRecipeRunner;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.recipes.RecipeSaveService;
import com.dataiku.dip.utils.JSON;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NLPRecipesService {
    @Autowired
    private RecipeSaveService recipeSaveService;
    @Autowired
    private LLMRefEnricherService llmRefEnricherService;

    public PromptDef getRecipePrompt(AuthCtx authCtx, SerializedRecipe sr, String payload) throws Exception {
        PromptRecipePayloadParams promptRecipePayload = this.createPromptRecipePayload(authCtx, sr, payload);
        return promptRecipePayload.prompt;
    }

    public PromptRecipePayloadParams createPromptRecipePayload(AuthCtx authCtx, SerializedRecipe sr, String payload) throws Exception {
        PromptRecipePayloadParams promptRecipePayload = new PromptRecipePayloadParams();
        promptRecipePayload.rawQueryOutputMode = RawQueryOutputMode.RAW_WITHOUT_FULL_IMAGES;
        promptRecipePayload.rawResponseOutputMode = RawResponseOutputMode.RAW_WITHOUT_TRACES;
        switch (sr.type) {
            case "nlp_llm_user_provided_classification": {
                NLPLLMUserProvidedClassificationRecipePayloadParams userProvidedClassificationRecipePayload = (NLPLLMUserProvidedClassificationRecipePayloadParams)JSON.parse((String)payload, NLPLLMUserProvidedClassificationRecipePayloadParams.class);
                promptRecipePayload.prompt = NLPLLMUserProvidedClassificationRecipeRunner.getPrompt(userProvidedClassificationRecipePayload);
                EnrichedLLMStructuredRef enrichedLLMRef = this.llmRefEnricherService.getEnrichedLLMRef(userProvidedClassificationRecipePayload.llmId, authCtx, sr.projectKey);
                this.convertCommonPayloadParams(userProvidedClassificationRecipePayload, promptRecipePayload, enrichedLLMRef);
                break;
            }
            case "nlp_llm_model_provided_classification": {
                NLPLLMModelProvidedClassificationRecipePayloadParams modelProvidedClassificationRecipePayload = (NLPLLMModelProvidedClassificationRecipePayloadParams)JSON.parse((String)payload, NLPLLMModelProvidedClassificationRecipePayloadParams.class);
                switch (modelProvidedClassificationRecipePayload.task) {
                    case SENTIMENT_ANALYSIS: {
                        promptRecipePayload.prompt = NLPLLMModelProvidedClassificationRecipeRunner.getSentimentAnalysisPrompt(modelProvidedClassificationRecipePayload);
                        break;
                    }
                    case EMOTION_ANALYSIS: {
                        promptRecipePayload.prompt = NLPLLMModelProvidedClassificationRecipeRunner.getEmotionAnalysisPrompt(modelProvidedClassificationRecipePayload);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid classification task type to convert to prompt recipe: " + String.valueOf((Object)modelProvidedClassificationRecipePayload.task));
                    }
                }
                EnrichedLLMStructuredRef enrichedLLMRef = this.llmRefEnricherService.getEnrichedLLMRef(modelProvidedClassificationRecipePayload.llmId, authCtx, sr.projectKey);
                this.convertCommonPayloadParams(modelProvidedClassificationRecipePayload, promptRecipePayload, enrichedLLMRef);
                break;
            }
            case "nlp_llm_summarization": {
                SummarizationRecipePayloadParams summarizationRecipePayload = (SummarizationRecipePayloadParams)JSON.parse((String)payload, SummarizationRecipePayloadParams.class);
                EnrichedLLMStructuredRef enrichedLLMRef = this.llmRefEnricherService.getEnrichedLLMRef(summarizationRecipePayload.llmId, authCtx, sr.projectKey);
                promptRecipePayload.prompt = SummarizationRecipeRunner.getPrompt(summarizationRecipePayload, enrichedLLMRef);
                this.convertCommonPayloadParams(summarizationRecipePayload, promptRecipePayload, enrichedLLMRef);
                break;
            }
            default: {
                throw new IllegalArgumentException("Only summarization & classification recipes can be converted to prompt recipe");
            }
        }
        return promptRecipePayload;
    }

    public void convertNLPRecipeToPromptRecipe(AuthCtx authCtx, SerializedRecipe sr, String payload) throws Exception {
        PromptRecipePayloadParams promptRecipePayload = this.createPromptRecipePayload(authCtx, sr, payload);
        sr.type = "prompt";
        this.recipeSaveService.save(sr.projectKey, sr, JSON.pretty((Object)promptRecipePayload));
    }

    private void convertCommonPayloadParams(NLPRecipePayloadParams nlpRecipePayload, PromptRecipePayloadParams promptRecipePayload, EnrichedLLMStructuredRef enrichedLLMRef) {
        promptRecipePayload.completionSettings = nlpRecipePayload.completionSettings;
        if (!enrichedLLMRef.promptDriven) {
            throw new IllegalArgumentException("Cannot convert to prompt recipe: LLM is not promptable");
        }
        promptRecipePayload.llmId = nlpRecipePayload.llmId;
    }
}

