/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.llm.EnrichedLLMStructuredRef;
import com.dataiku.dip.llm.PromptChatClient;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.promptstudio.PromptResponse;
import com.dataiku.dip.llm.promptstudio.PromptStudio;
import com.dataiku.dip.recipes.nlp.common.LLMCompletionSettings;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.streaming.endpoints.httpsse.MiniSSEEmitter;
import com.dataiku.dip.utils.SmartLogTail;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class LLMQuickChatService {
    public LLMQuickChatResponse streamChatResponse(AuthCtx authCtx, String projectKey, EnrichedLLMStructuredRef enrichedLLMRef, LLMQuickChatInput chatInput, MiniSSEEmitter emitter) throws Exception {
        PromptChatClient.PromptChat promptChat = new PromptChatClient.PromptChat();
        promptChat.projectKey = projectKey;
        promptChat.enrichedLLMRef = enrichedLLMRef;
        promptChat.messages = chatInput.chatMessages;
        promptChat.llmSettings = new LLMCompletionSettings();
        promptChat.lastUserMessage = chatInput.lastUserMessage;
        promptChat.context = chatInput.context;
        promptChat.streamingDisabled = false;
        promptChat.useDevKernel = true;
        PromptChatClient pcc = new PromptChatClient(authCtx, promptChat);
        PromptResponse.SingleInputPromptResponse chatResponse = pcc.streamChatResponse(emitter);
        LLMQuickChatResponse llmQuickChatResponse = new LLMQuickChatResponse();
        llmQuickChatResponse.lastMessageId = chatResponse.lastMessageId;
        llmQuickChatResponse.chatMessages = chatResponse.chatMessages;
        llmQuickChatResponse.fullTrace = chatResponse.fullTrace;
        llmQuickChatResponse.llmError = chatResponse.llmError;
        llmQuickChatResponse.log = chatResponse.log;
        llmQuickChatResponse.contextUpsert = chatResponse.contextUpsert;
        return llmQuickChatResponse;
    }

    public static class LLMQuickChatInput {
        public Map<String, PromptStudio.ConversationMessage> chatMessages;
        public PromptStudio.ConversationMessage lastUserMessage;
        public JsonObject context;
    }

    public static class LLMQuickChatResponse {
        public String llmError;
        public String lastMessageId;
        public Map<String, PromptStudio.ConversationMessage> chatMessages = new HashMap<String, PromptStudio.ConversationMessage>();
        public LLMClient.LLMMeshTraceSpan fullTrace;
        public LLMClient.LLMMeshTraceSpan traceOfPython;
        public SmartLogTail log;
        public JsonObject contextUpsert;
    }
}

