/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.filtering;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.pivot.frontend.model.ChartFilter;
import com.dataiku.dip.shaker.DateRelativeFilterHelper;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.FilterAndFlagProcessor;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.shaker.sql.SqlFilterAndFlagOnDate;
import com.dataiku.dip.shaker.text.Labelled;
import com.dataiku.dip.shaker.types.AnyTemporal;
import com.dataiku.dip.shaker.types.DateOnly;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.util.ParamDesc;
import com.dataiku.dip.util.ShortTimezoneList;
import com.dataiku.dss.shadelib.com.google.common.collect.Sets;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInstant;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInterval;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.dataiku.dss.shadelib.org.joda.time.format.ISODateTimeFormat;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class FilterAndFlagOnDate
extends FilterAndFlagProcessor
implements Processor {
    private final Parameter parameters;
    private DateTimeFormatter isoFormatter;
    private DateTime min;
    private DateTime max;
    private boolean hasPartValues;
    private final List<Long> partValues = new ArrayList<Long>();
    AnyTemporal temporalMeaning = new AnyTemporal();
    DateOnly dateOnlyMeaning = new DateOnly();
    @VisibleForTesting
    DateTime nowForTests;
    public static final ProcessorMeta<FilterAndFlagOnDate, Parameter> META_FILTER = new FilterAndFlagProcessor.FilterProcessorMeta<FilterAndFlagOnDate, Parameter>(){

        @Override
        public String getName() {
            return "FilterOnDate";
        }

        @Override
        public String getDocPage() {
            return "filter-on-date";
        }

        @Override
        public Category getCategory() {
            return Category.FILTER;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.FILTER, ProcessorTag.DATE});
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnDate.FILTER.HELP", "Filter rows from the dataset using a date filter defined by a fixed date range, a relative date range, or a matching date part. Alternatively, clear content from matching cells rather than filter the rows. \n\n# Options\n\n**Action**\n\nSelect the action to perform on matching (in range) rows or cells: \n\n* Keep matching rows only\n\n* Remove matching rows\n\n* Clear content of matching cells\n\n* Clear content of non-matching cells\n\n**Date column**\n\nColumn containing data in ISO-8601 format. Use a Prepare step to parse the data into this format if it isn\u2019t already. If the column does not contain a valid date for a row, this row is considered out of range. \n\n**Filter on** \n\nChoose how to define the date filter:\n\n* **Date range:** Use a fixed date range. The lower/upper boundaries are inclusive. If the lower bound is empty, all dates before the upper bound will match, and vice versa.\n\n* **Relative range:** Use a relative date range and time window (last N, next N, until now). The range is calculated relative to the current date and chosen date part. It will update itself over time. \n\n* **Date part:** Filter on date part falling within values in a list.");
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withCustomForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnDate.FILTER.DESCRIPTION", 1.actionVerb("Filter") + " rows/cells on date")).withParam(ParamDesc.advancedSelect("filterType", this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnDate.DESCRIPTION.FILTER_TYPE", "Filter on"), "", DateFilterType.class).withDefaultValue("RANGE")).withParam(ParamDesc.advancedSelect("part", this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnDate.DESCRIPTION.PART", "Date part"), "", DatePart.class).withMandatory(false).withDefaultValue("YEAR")).withHiddenDescription("date").withParam(ParamDesc.advancedSelect("timezone_id", this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnDate.DESCRIPTION.TIMEZONE", "Timezone"), this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnDate.DESCRIPTION.TIMEZONE", "Timezone"), timezoneIDs, timezoneNames).withDefaultValue("UTC").withCanBeEmpty(false)).withFilterAndFlagMode("FILTER");
        }

        @Override
        public FilterAndFlagOnDate build(Parameter parameter) {
            return new FilterAndFlagOnDate(parameter);
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams params, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            return new ProcessorMeta.ProcessorCapabilitiesSummary().withCan(ProcessorCapabilities.SQL_TRANSLATABLE);
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) {
            return new SQLTranslator((Parameter)parameter);
        }
    };
    public static final ProcessorMeta<FilterAndFlagOnDate, Parameter> META_FLAG = new FilterAndFlagProcessor.FlagProcessorMeta<FilterAndFlagOnDate, Parameter>(){

        @Override
        public String getName() {
            return "FlagOnDate";
        }

        @Override
        public String getDocPage() {
            return "flag-on-date";
        }

        @Override
        public Category getCategory() {
            return Category.FILTER;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.FILTER, ProcessorTag.DATE});
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnDate.FLAG.HELP", "This processor flags rows for which a date is within a date range, a relative range, or matching a date part.\n\nThe boundaries are inclusive. If the lower bound is left empty, all dates before the upper bound are filtered, and vice-versa. If the column does not contain a valid date for a row, this row is considered as being out of the range. The provided timezone will be used to filter dates.\n\n\n\nShould only be used on columns with meaning 'Date', ie. parsed dates.\n\nThis processor creates a new column, containing '1' when date matches, nothing else.\n\n# Columns selection\n\nThis processor can check its matching condition on multiple columns:\n\n* A single colum\n* An explicit list of columns\n* All columns matching a given pattern\n* All columns\n\nYou can select whether the row will be considered as matching if:\n\n* All columns are matching\n* Or, at least one column is matching\n\n");
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withCustomForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnDate.FLAG.DESCRIPTION", 2.actionVerb("Flag") + " rows/cells on date")).withParam(ParamDesc.advancedSelect("filterType", this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnDate.DESCRIPTION.FILTER_TYPE", "Filter on"), "", DateFilterType.class).withDefaultValue("RANGE")).withParam(ParamDesc.advancedSelect("part", this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnDate.DESCRIPTION.PART", "Date part"), "", DatePart.class).withMandatory(false).withDefaultValue("YEAR")).withHiddenDescription("date").withParam(ParamDesc.advancedSelect("timezone_id", this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnDate.DESCRIPTION.TIMEZONE", "Timezone"), this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnDate.DESCRIPTION.TIMEZONE", "Timezone"), timezoneIDs, timezoneNames).withDefaultValue("UTC").withCanBeEmpty(false)).withFilterAndFlagMode("FLAG");
        }

        @Override
        public FilterAndFlagOnDate build(Parameter parameter) {
            return new FilterAndFlagOnDate(parameter);
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams params, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            return new ProcessorMeta.ProcessorCapabilitiesSummary().withCan(ProcessorCapabilities.SQL_TRANSLATABLE);
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) {
            return new SQLTranslator((Parameter)parameter);
        }
    };
    protected static final String[] timezoneIDs = ShortTimezoneList.concatTo("UTC");
    protected static final String[] timezoneNames = ShortTimezoneList.concatTo("UTC");

    @Override
    public void init() throws Exception {
        super.init();
        this.isoFormatter = ISODateTimeFormat.dateTimeParser().withZone(DateTimeZone.UTC);
        if (this.parameters.filterType == DateFilterType.RANGE) {
            try {
                this.min = FilterAndFlagOnDate.parseTimestamp(this.parameters.min, this.parameters.timezone_id);
                this.max = FilterAndFlagOnDate.parseTimestamp(this.parameters.max, this.parameters.timezone_id);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Specified date bounds could not be parsed.", e);
            }
        } else if (this.parameters.filterType == DateFilterType.PART) {
            for (String str : this.parameters.values) {
                if (!StringUtils.isNotBlank((String)str)) continue;
                this.hasPartValues = true;
                try {
                    if (this.parameters.part == ChartFilter.DateFilterPart.INDIVIDUAL) {
                        this.partValues.add(new DateTime((Object)(str + "T00:00:00.000Z")).getMillis());
                        continue;
                    }
                    this.partValues.add(Long.valueOf(Integer.parseInt(str)));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            Collections.sort(this.partValues);
        } else if (this.parameters.filterType == DateFilterType.RELATIVE && this.parameters.option != null && this.parameters.option.isEffective()) {
            ReadableInterval interval = DateRelativeFilterHelper.computeInterval(this.parameters.part, this.parameters.option, (ReadableInstant)DateTime.now());
            this.min = interval.getStart();
            this.max = interval.getEnd();
        }
    }

    public FilterAndFlagOnDate(Parameter parameters) {
        this.parameters = parameters;
    }

    @Override
    public FilterAndFlagProcessor.FilterAndFlagParams getParams() {
        return this.parameters;
    }

    public void postProcess() throws Exception {
    }

    @Override
    public boolean matchCell(Row row, Column column) {
        boolean dateIsDateOnly;
        DateTime date;
        String val = row.get(column);
        if (StringUtils.isBlank((String)val)) {
            return this.parameters.includeEmptyValues;
        }
        try {
            long ts = this.temporalMeaning.msSinceEpoch(val);
            if (ts == Long.MAX_VALUE) {
                return false;
            }
            date = new DateTime(ts).withZone(DateTimeZone.UTC);
            dateIsDateOnly = this.dateOnlyMeaning.msSinceEpoch(val) != Long.MAX_VALUE;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        switch (this.parameters.filterType) {
            case RANGE: 
            case RELATIVE: {
                return this.matchCellRange(date);
            }
            case PART: {
                return this.matchCellPart(date, dateIsDateOnly);
            }
        }
        throw new IllegalArgumentException("The filter type is not valid");
    }

    private boolean matchCellRange(DateTime date) {
        if (this.min == null && this.max == null) {
            return true;
        }
        if (this.min == null) {
            return date.isBefore((ReadableInstant)this.max) || date.isEqual((ReadableInstant)this.max);
        }
        if (this.max == null) {
            return date.isAfter((ReadableInstant)this.min) || date.isEqual((ReadableInstant)this.min);
        }
        return date.isEqual((ReadableInstant)this.max) || date.isEqual((ReadableInstant)this.min) || date.isBefore((ReadableInstant)this.max) && date.isAfter((ReadableInstant)this.min);
    }

    private boolean matchCellPart(DateTime date, boolean dateIsDateOnly) {
        if (!this.hasPartValues) {
            return true;
        }
        switch (this.parameters.part) {
            case YEAR: {
                return FilterAndFlagOnDate.binarySearchContains(this.partValues, date.getYear());
            }
            case DAY_OF_MONTH: {
                return FilterAndFlagOnDate.binarySearchContains(this.partValues, date.getDayOfMonth());
            }
            case DAY_OF_WEEK: {
                return FilterAndFlagOnDate.binarySearchContains(this.partValues, date.getDayOfWeek());
            }
            case HOUR_OF_DAY: {
                if (dateIsDateOnly) {
                    return false;
                }
                return FilterAndFlagOnDate.binarySearchContains(this.partValues, date.getHourOfDay());
            }
            case MONTH_OF_YEAR: {
                return FilterAndFlagOnDate.binarySearchContains(this.partValues, date.getMonthOfYear());
            }
            case QUARTER_OF_YEAR: {
                return FilterAndFlagOnDate.binarySearchContains(this.partValues, 1 + (date.getMonthOfYear() - 1) / 3);
            }
            case WEEK_OF_YEAR: {
                return FilterAndFlagOnDate.binarySearchContains(this.partValues, date.getWeekOfWeekyear());
            }
            case INDIVIDUAL: {
                date = date.withHourOfDay(0).withMinuteOfHour(0).withSecondOfMinute(0).withMillisOfSecond(0);
                return FilterAndFlagOnDate.binarySearchContains(this.partValues, date.getMillis());
            }
        }
        return true;
    }

    private static DateTime parseTimestamp(String timestamp, String timezoneId) {
        if (StringUtils.isBlank((String)timestamp)) {
            return null;
        }
        DateTimeZone tz = StringUtils.isBlank((String)timezoneId) ? DateTimeZone.UTC : DateTimeZone.forID((String)timezoneId);
        DateTimeFormatter tzFormatter = ISODateTimeFormat.dateTimeParser().withZone(tz);
        return tzFormatter.parseDateTime(timestamp);
    }

    private static boolean binarySearchContains(List<Long> collection, long value) {
        return Collections.binarySearch(collection, value) >= 0;
    }

    public static class Parameter
    extends FilterAndFlagProcessor.FilterAndFlagParams
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public DateFilterType filterType;
        public String min;
        public String max;
        public String timezone_id;
        public boolean includeEmptyValues;
        public ChartFilter.DateFilterPart part;
        public List<String> values = new ArrayList<String>();
        public ChartFilter.DateRelativeOption option;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum DateFilterType implements Labelled
    {
        RANGE{

            @Override
            public String getLabel() {
                return "Date Range";
            }
        }
        ,
        RELATIVE{

            @Override
            public String getLabel() {
                return "Relative Range";
            }
        }
        ,
        PART{

            @Override
            public String getLabel() {
                return "Date Part";
            }
        };

    }

    private static class SQLTranslator
    implements ProcessorSQLTranslator {
        private final Parameter parameter;

        private SQLTranslator(Parameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public SQLQueryWithSchema translate(SQLQueryWithSchema input) {
            return new SqlFilterAndFlagOnDate(input, this.parameter).apply();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum DatePart implements Labelled
    {
        YEAR{

            @Override
            public String getLabel() {
                return "Year";
            }
        }
        ,
        QUARTER_OF_YEAR{

            @Override
            public String getLabel() {
                return "Quarter of year";
            }
        }
        ,
        WEEK_OF_YEAR{

            @Override
            public String getLabel() {
                return "Week of year";
            }
        }
        ,
        MONTH_OF_YEAR{

            @Override
            public String getLabel() {
                return "Month of year";
            }
        }
        ,
        DAY_OF_MONTH{

            @Override
            public String getLabel() {
                return "Day of month";
            }
        }
        ,
        DAY_OF_WEEK{

            @Override
            public String getLabel() {
                return "Day of week";
            }
        }
        ,
        HOUR_OF_DAY{

            @Override
            public String getLabel() {
                return "Hour of day";
            }
        }
        ,
        INDIVIDUAL{

            @Override
            public String getLabel() {
                return "Individual";
            }
        };

    }
}

