/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.resources;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.code.CodeEnvResolutionService;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.remoterun.ProjectLibsBundler;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.mrimpl.ShakerJobConfigurator;
import com.dataiku.dip.shaker.processors.BaseProcessorsFactory;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.udf.CustomJythonProcessorMeta;
import com.dataiku.dip.shaker.processors.udf.CustomJythonProcessorsService;
import com.dataiku.dip.shaker.processors.udf.MetaWithRemoteCodeEnv;
import com.dataiku.dip.shaker.processors.udf.ParamsWithRemoteCodeEnv;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.PythonResourceUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class YarnPythonBinResourcesGatherer {
    private CodeEnvResolutionService codeEnvResolutionService;
    static final String TMP_FILE_PATH = "shaker-mr";
    public static final String[] PYTHON_PACKAGES_TO_SEND = new String[]{"dataiku", "dataikuapi", "dataikuscoring"};

    YarnPythonBinResourcesGatherer(CodeEnvResolutionService codeEnvResolutionService) {
        this.codeEnvResolutionService = codeEnvResolutionService;
    }

    File getTmpFile(String zipName) throws IOException {
        return FlowJobUtils.getJobTempFile(TMP_FILE_PATH, zipName);
    }

    public Map<String, File> dumpAndGather(List<ScriptStep> steps, String projectKey, AuthCtx authCtx, Logger logger) throws IOException, DKUSecurityException {
        HashMap<String, File> result = new HashMap<String, File>();
        File pythonFolder = "1".equals(System.getenv("DSS_DEV")) ? DKUApp.getInstallFile((String[])new String[]{"src", "main", "python"}) : DKUApp.getInstallFile((String[])new String[]{"python"});
        HashMap pythonPachageZips = Maps.newHashMap();
        for (String packageName : PYTHON_PACKAGES_TO_SEND) {
            File zipFile = this.zipResourceFolder(new File(pythonFolder, packageName));
            result.put(PythonResourceUtils.getPackageKey(packageName), zipFile);
            pythonPachageZips.put(zipFile.getName(), packageName);
        }
        this.handlePythonResource(result, PythonResourceUtils.getInstanceLibPythonFile(), "instance-python-lib", logger);
        try (AutoDelete bundledProjectLibsFolder = FlowJobUtils.getTmpFolder(TMP_FILE_PATH, "project-libs-remoterun");){
            logger.info((Object)"Bundling required project libs");
            if (JobContext.getCurrentJobContext() != null) {
                ProjectLibsBundler.prepareProjectLibsBundleForJob(projectKey, (File)bundledProjectLibsFolder);
            } else {
                ProjectLibsBundler.prepareProjectLibsBundleForNonJob(projectKey, authCtx, (File)bundledProjectLibsFolder);
            }
            this.handlePythonResource(result, (File)bundledProjectLibsFolder, "project-python-lib", logger);
        }
        for (ScriptStep step : steps) {
            if (!(step instanceof ProcessorScriptStep)) continue;
            ProcessorScriptStep pss = (ProcessorScriptStep)step;
            try {
                ProcessorMeta<?, ?> meta = BaseProcessorsFactory.getMeta(pss);
                if (!(meta instanceof CustomJythonProcessorMeta)) continue;
                CustomJythonProcessorsService service = (CustomJythonProcessorsService)SpringUtils.getBean(CustomJythonProcessorsService.class);
                this.handlePythonResource(result, new File(service.getLibFolder(meta.getName())), PythonResourceUtils.getLibPluginKey(meta.getName()), logger);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to add step's plugin python-lib if necessary (type " + pss.type + ")"), (Throwable)e);
            }
        }
        String builtinYarnPythonBin = StringUtils.defaultIfBlank((String)this.codeEnvResolutionService.getYarnPythonBin(null, projectKey), (String)"python");
        HashMap<String, String> yarnPythonBinsMap = new HashMap<String, String>();
        List<Pair<MetaWithRemoteCodeEnv, ParamsWithRemoteCodeEnv>> stepWithRemoteCodeEnvs = SerializedShakerScript.collectRemoteCodeEnvs(steps);
        for (Pair<MetaWithRemoteCodeEnv, ParamsWithRemoteCodeEnv> stepWithRemoteCodeEnv : stepWithRemoteCodeEnvs) {
            ParamsWithRemoteCodeEnv stepParams = (ParamsWithRemoteCodeEnv)stepWithRemoteCodeEnv.second;
            MetaWithRemoteCodeEnv stepMeta = (MetaWithRemoteCodeEnv)stepWithRemoteCodeEnv.first;
            String envName = StringUtils.defaultIfBlank((String)stepParams.getCodeEnvName(stepMeta, projectKey), (String)"__BUILTIN_ENV__");
            logger.info((Object)("Fixing code env for " + JSON.log(stepWithRemoteCodeEnv) + " to " + envName));
            stepParams.setCodeEnvName(envName);
            String yarnPythonBin = StringUtils.defaultIfBlank((String)this.codeEnvResolutionService.getYarnPythonBin(envName, projectKey), (String)"python");
            yarnPythonBinsMap.put(envName, yarnPythonBin);
        }
        ShakerJobConfigurator.YarnPythonBinsDefinition yarnPythonBins = new ShakerJobConfigurator.YarnPythonBinsDefinition(builtinYarnPythonBin, yarnPythonBinsMap, pythonPachageZips);
        AutoDelete tempPythonBinsfile = FlowJobUtils.getJobTempFile(TMP_FILE_PATH, "yarn-python-bins", "json");
        JSON.prettyToFile((Object)yarnPythonBins, (File)tempPythonBinsfile);
        result.put("dku.shaker.yarn.python.bins", (File)tempPythonBinsfile);
        return result;
    }

    private File zipResourceFolder(File resourceFolder) throws IOException {
        File zipFile = this.getTmpFile("rec-" + SecretKeyGenerator.generate((int)8) + ".zip.nodecompression");
        ZipUnzipDir.zipDirectory(resourceFolder, zipFile);
        return zipFile;
    }

    private void handlePythonResource(Map<String, File> result, File resourceFolder, String resourceName, Logger logger) throws IOException {
        if (!resourceFolder.exists()) {
            return;
        }
        logger.info((Object)String.format("Adding python lib for %s to resources", resourceName));
        result.put(resourceName, this.zipResourceFolder(resourceFolder));
    }
}

