/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.sql;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.utils.GraphUtils;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.model.GroupScriptStep;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.sql.ShakerSQLTranslator;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractSqlQueryWithSchemaBuilder {
    @Autowired
    protected DatasetsDAO datasetsDAO;
    @Autowired
    protected JobAuthCtxService authCtxService;
    @Autowired
    private VariablesService variablesService;
    protected final JobActivity activity;
    protected final FlowRecipe recipe;
    protected RecipeRunnableSubgraph subgraph;
    private SerializedShakerScript rawShakerScript;
    private SerializedShakerScript expandedView;
    protected Partition targetPartition = null;
    protected PartitioningScheme targetPartitionScheme = null;
    protected Dataset inputDataset;
    protected SQLDialect dialect;

    AbstractSqlQueryWithSchemaBuilder(JobActivity activity) {
        SpringUtils.getInstance().autowire((Object)this);
        this.subgraph = (RecipeRunnableSubgraph)activity.getSubgraph();
        this.activity = activity;
        this.recipe = this.subgraph.getRecipe();
        this.activity.initStatus();
    }

    public AbstractSqlQueryWithSchemaBuilder setDialect(SQLDialect dialect) {
        this.dialect = dialect;
        return this;
    }

    public SQLDialect getDialect() throws IOException, SQLException, DKUSecurityException {
        if (this.dialect != null) {
            return this.dialect;
        }
        return this.computeDialect();
    }

    public abstract AbstractSQLConnection getDSSConnection() throws IOException, SQLException, DKUSecurityException;

    protected abstract SQLDialect computeDialect() throws IOException, SQLException, DKUSecurityException;

    public AbstractSqlQueryWithSchemaBuilder setPayload(String payload) {
        this.rawShakerScript = (SerializedShakerScript)JSON.parse((String)payload, SerializedShakerScript.class);
        assert (this.rawShakerScript != null);
        return this;
    }

    public AbstractSqlQueryWithSchemaBuilder init() throws Exception {
        this.expandedView = this.rawShakerScript.expandedDeepCopy(this.variablesService.getForProject(this.recipe.getProjectKey()));
        FlowDataset outputFDS = GraphUtils.getSingleTarget(this.subgraph.getRecipe());
        Dataset outputDataset = outputFDS.getMandatory(this.datasetsDAO);
        SerializedRecipe serializedRecipe = this.recipe.getModel();
        SerializedRecipe.RecipeInput ri = serializedRecipe.getSingleInput("main");
        this.inputDataset = Dataset.fromSerialized((SerializedDataset)this.datasetsDAO.getMandatory(ri.getLoc(this.recipe.getProjectKey())));
        Output.WriteMode writeMode = serializedRecipe.getSingleOutput("main").getWriteMode();
        try (DatasetHandler outputDatasetHandler = DatasetHandlerFactory.build(this.authCtxService.getAuthCtx(), outputDataset);){
            if (this.activity.getSubgraph().isAllTargetPartitions()) {
                if (writeMode == Output.WriteMode.OVERWRITE) {
                    outputDatasetHandler.clearAllData();
                }
            } else if (writeMode == Output.WriteMode.OVERWRITE && !outputDatasetHandler.outputHandlesClear()) {
                if (outputDatasetHandler.getMeta().handlesClearForOverwriteMode()) {
                    outputDatasetHandler.clearPartitions(Lists.newArrayList((Object[])new Partition[]{this.activity.getSubgraph().getTargetPartition(outputFDS)}));
                }
                writeMode = Output.WriteMode.APPEND;
            }
        }
        return this;
    }

    public ShakerSQLTranslator.TranslatorResult build() throws Exception {
        SQLUtils.SQLTable table = DatasetUtils.getResolvedTableWithSparkSQLFallback(this.inputDataset, this.getDialect(), null);
        FlowDataset outputFDS = GraphUtils.getSingleTarget(this.subgraph.getRecipe());
        Dataset outputDataset = outputFDS.getMandatory(this.datasetsDAO);
        List<Partition> sourcePartitions = null;
        List<Partition> parts = this.activity.getSubgraph().getSourcePartitions(this.activity.getSubgraph().getSourceDataset(this.inputDataset.getFullName()));
        if (this.isSourcePartitioned(parts)) {
            sourcePartitions = parts;
        }
        this.computeTargetPartitionVariables();
        return new ShakerSQLTranslator().translateAndCast(this.authCtxService.getAuthCtx(), this.recipe.getProjectKey(), AbstractSqlQueryWithSchemaBuilder.getFlattenedEnabledProcessorsList(this.expandedView), this.inputDataset.getSchema(), table, this.getDSSConnection(), ShakerSQLTranslator.ShakerSQLTranslatorContext.RECIPE_RUN, outputDataset, this.targetPartitionScheme, this.targetPartition, this.inputDataset, sourcePartitions, this.inputDataset.getParams());
    }

    protected void computeTargetPartitionVariables() throws IOException {
        this.targetPartition = null;
        this.targetPartitionScheme = null;
    }

    private boolean isSourcePartitioned(List<Partition> parts) {
        if (parts == null || parts.isEmpty()) {
            return false;
        }
        Partition partition = parts.get(0);
        return this.isPartitioned(this.inputDataset, partition);
    }

    private boolean isPartitioned(Dataset dataset, @Nullable Partition partition) {
        return partition != null && !partition.isNP() && !partition.isAll() && dataset.getPartitioningSchema().isPartitioned();
    }

    public static List<ProcessorScriptStep> getFlattenedEnabledProcessorsList(SerializedShakerScript sss) {
        return AbstractSqlQueryWithSchemaBuilder.getFlattenedEnabledProcessorsList(sss.steps);
    }

    public static List<ProcessorScriptStep> getFlattenedEnabledProcessorsList(List<ScriptStep> rawSteps) {
        ArrayList<ProcessorScriptStep> ret = new ArrayList<ProcessorScriptStep>();
        for (ScriptStep ss : rawSteps) {
            if (ss.metaType == ScriptStep.MetaType.GROUP && !ss.disabled) {
                for (ProcessorScriptStep pss : ((GroupScriptStep)ss).steps) {
                    if (pss.disabled) continue;
                    ret.add(pss);
                }
                continue;
            }
            if (ss.disabled) continue;
            ret.add((ProcessorScriptStep)ss);
        }
        return ret;
    }

    static {
        ScriptStep.loadClass();
    }
}

